var page_function = {
	components: {
		"data-table": httpVueLoader("components/layout/data_table.vue"),
	},
	data () {
		return {
			"VarMenuPage": "search_station_indicatros_daily",
			"VarMenu": "area",
			"VarPageContainerCss" : "padding:20px",

			"search": {
				"start_date": moment().startOf('month').format('YYYY-MM-DD'),
				"end_date": moment().format('YYYY-MM-DD'),
			},

			"tableData" : [],
			
			
		}
	},
	computed :{
		columns () { // 為了配合多國語系, columns 需使用 computed
			var cols = [
				{
					name: "date_stamp",
					required: true,
					label: "日期",
					align: "left",
					field: "date_stamp",
					sortable: true,
					style: "font-size: 20px; width: 200px;",
					$$is_num_format: false,
				}
			];
			_.each(meter_index, (mi)=> {
				cols.push({
					name: mi.key,
					required: true,
					label: mi.name,
					align: "center",
					field: mi.key,
					sortable: true,
					style: "font-size: 20px; width: 100px;",
					$$is_num_format: true,
					format : (data) => {
						var invName = 0	
						if (!_.isNil(data)) {
							invName = data
						}
						return invName 
					}
					
				});
			});
			return cols;
		},
	},
	watch : {},
	mounted () {
		this.$set(this.WebSetup, "caption", '全廠每日指標查詢');
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.searchData();
	},
	methods: {
		searchData() {
			var dataList = _.map(meter_index, (mi)=> {
				return {
					key: mi.key, 
					name: mi.name, 
					id: mi.ID, 
					table: mi.tableName,
					pid: mi.ProductionID.join()
				}
			});

			var params = {
				Action: "MeterIndex",
				menu_page: "data_analysis_station_indicatros",
				Datas: {
				  id_list: dataList,
				  date: this.search.start_date, //查當天不用帶date
				  date_to: this.search.end_date, //查當天不用帶date
				},
			};

			this.FnWebAPIGet(params)
			.then((res) => {
			  	var resData = res.data.data;
			  	var resDataTemp = {};
			  	_.each(resData, (dr,key)=> {
			  		resDataTemp[key] = _.keyBy(dr,'day_date'); // 整理日期為key
		  		});
			  	
			  	var dateList = _.map(_.values(resData)[0],'day_date'); // 取得日期清單
			  	var tbData = [];

			  	_.each(dateList, (day)=> {
			  		var dataObj = {};
			  		dataObj['date_stamp'] = day;
			  		_.each(resDataTemp, (val,key)=> {
			  			var usedVal = Number(val[day]['dosage']);
			  			var dayWeight = Number(val[day]['day_weight']);
			  			var pointerVal = usedVal / dayWeight;
			  			if (!_.isFinite(pointerVal) || isNaN(pointerVal)) {
							pointerVal = 0;
						}
			  			dataObj[key] = this.FnRoundToDecimal(pointerVal,2);
			  		});
			  		tbData.push(dataObj);
			  	});
			  	this.tableData = tbData;
			})
			.catch((err) => {
			  console.log(err);
			});
	    },
		
		
	}
}