var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "system_power",
      VarMenu: "area",
      VarPageContainerCss: "padding:0px",

      deviceKey: "冷凍空調", //	Var_Config 設定檔 對應的key
      fromPage: "system_power.php", //	從哪個頁面來的
      data_group: "電力", //  隸屬於device_item 內的哪一個群組
      previousPage: true,
      previousPageName: "電力系統",

      billboard: {
        item01: {
          show: true, //	要不要顯示此區塊
          title: "冷凍空調", //	標題
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",
          showButton: true,
          button: {
            //	標題同一列的按鈕功能
            item01: {
              show: true, //	要不要顯示此按鈕
              label: "長條圖", //	標題 (標示定義名稱)
              icon: "leaderboard", //	按鈕圖樣
              linkto: "chart_bar.php", //	轉跳頁面 定義為 null 不會觸發
              params: { options: "冷凍空調" , item_type: "電力"}, //	轉跳頁面後面帶參數
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "冷凍空調" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "5",
          left: "41.5",
          width: "340",
        },
        "17": {
          show: true,
          title: "BIP空調專用-地下室冰水泵",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 17",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "BIP空調專用-地下室冰水泵" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "BIP空調專用-地下室冰水泵" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "19",
          left: "4.5",
          width: "340",
        },
        "61": {
          show: true,
          title: "GRAM主機-頂樓肉乾胚冷凍庫",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 61",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "GRAM主機-頂樓肉乾胚冷凍庫", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "GRAM主機-頂樓肉乾胚冷凍庫", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "30.5",
          left: "4.5",
          width: "340",
        },
        "38": {
          show: true,
          title: "EPA一期冷凍庫控制盤",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 38",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "EPA一期冷凍庫控制盤" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "EPA一期冷凍庫控制盤" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "42",
          left: "4.5",
          width: "340",
        },
        "18": {
          show: true,
          title: "蒸發冷凝器",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 18",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "蒸發冷凝器" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "蒸發冷凝器" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "53.5",
          left: "4.5",
          width: "340",
        },
        "55": {
          show: true,
          title: "1PI糕餅冷凍庫",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 55",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "1PI糕餅冷凍庫" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "1PI糕餅冷凍庫" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "65",
          left: "4.5",
          width: "340",
        },
        "9": {
          show: true,
          title: "2°C冷凍主機包裝冷凍庫",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 9",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "2°C冷凍主機包裝冷凍庫" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "2°C冷凍主機包裝冷凍庫" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "76.5",
          left: "4.5",
          width: "340",
        },
        "68": {
          show: true,
          title: "物資冷凍庫RFMPC",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 68",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "空調主機" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "空調主機" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "88",
          left: "4.5",
          width: "340",
        },
        "65": {
          show: true,
          title: "空調冷藏系統ACMP",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 65",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "空調冷藏系統ACMP", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "空調冷藏系統ACMP", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "19",
          left: "28",
          width: "340",
        },
        "66": {
          show: true,
          title: "空調主機RFMPP",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 66",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "空調主機RFMPP", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "空調主機RFMPP", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "30.5",
          left: "28",
          width: "340",
        },
        "67": {
          show: true,
          title: "大冷藏庫RFMPB",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 67",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "大冷藏庫RFMPB", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "大冷藏庫RFMPB", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "42",
          left: "28",
          width: "340",
        },
        "656667": {
          show: true,
          title: "低溫空調APMP-1",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "空調冷藏系統ACMP - ( 空調主機RFMPP + 大冷藏庫RFMPB)",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "低溫空調APMP-1", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "低溫空調APMP-1", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "53.5",
          left: "28",
          width: "340",
        },
        "16": {
          show: true,
          title: "MCC",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 16",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "MCC" , item_type: "電力"},
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "MCC" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "19",
          left: "53",
          width: "340",
        },
        "3": {
          show: true,
          title: "空調主機#1",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 3",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "空調主機#1" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "空調主機#1" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "30.5",
          left: "53",
          width: "340",
        },
        "4": {
          show: true,
          title: "空調主機#2",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 4",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "空調主機#2" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "空調主機#2" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "42",
          left: "53",
          width: "340",
        },
        "5": {
          show: true,
          title: "空調主機#3",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 5",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "空調主機#3" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "空調主機#3" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "53.5",
          left: "53",
          width: "340",
        },
        "6": {
          show: true,
          title: "空調主機#4",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 6",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "空調主機#4" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "空調主機#4" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "65",
          left: "53",
          width: "340",
        },
        "10": {
          show: true,
          title: "A倉冷凍庫總用電",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 10",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "A倉冷凍庫總用電", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "A倉冷凍庫總用電", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "19",
          left: "76",
          width: "340",
        },
        "11": {
          show: true,
          title: "冷凍主機#1",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 11",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "冷凍主機#1", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "冷凍主機#1", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "30.5",
          left: "76",
          width: "340",
        },
        "12": {
          show: true,
          title: "冷凍主機#2",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 12",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "冷凍主機#2", item_type: "電力" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "冷凍主機#2" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "42",
          left: "76",
          width: "340",
        },
        "13": {
          show: true,
          title: "冷凍主機#3",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 13",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "冷凍主機#3" , item_type: "電力"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "冷凍主機#3" , item_type: "電力"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "53.5",
          left: "76",
          width: "340",
        },
      },

      //	線條 => 定義 class 如果是line_h要設定height的長度(px)，width設為0，反之是line_w要設定width的長度(px)，height設為0
      line: [
        {
          show: true,
          class: "line_h",
          top: "16",
          left: "50.50",
          width: "0",
          height: "25",
          contect: "冷凍空調到其他設備", //	註解這條線是什麼意思
          showArrow: false, //	要不要顯示箭頭
          arrow: { class: "", top: "0", left: "0" }, //	箭頭微調 (px) 方向設定 arrow right、left、up、down
        },
        {
          show: true,
          class: "line_w",
          top: "17.5",
          left: "24.5",
          width: "1210",
          height: "0",
          showArrow: false,
          arrow: { class: "", top: "0", left: "0" },
          contect: "冷凍空調到其他設備",
        },
        {
          show: true,
          class: "line_h",
          top: "17.5",
          left: "24.5",
          width: "0",
          height: "1179",
          showArrow: false,
          arrow: { class: "", top: "0", left: "0" },
          contect: "冷凍空調到其他設備",
        },
        {
          show: true,
          class: "line_w",
          top: "24.5",
          left: "20.5",
          width: "80",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "冷凍空調到BIP空調專用-地下室冰水泵",
        },
        {
          show: true,
          class: "line_w",
          top: "36.5",
          left: "20.5",
          width: "80",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "冷凍空調到GRAM主機-頂樓肉乾胚冷凍庫",
        },
        {
          show: true,
          class: "line_w",
          top: "47.5",
          left: "20.5",
          width: "80",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "冷凍空調到EPA一期冷凍庫控制盤",
        },
        {
          show: true,
          class: "line_w",
          top: "59",
          left: "20.5",
          width: "80",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "冷凍空調到蒸發冷凝器",
        },
        {
          show: true,
          class: "line_w",
          top: "72.5",
          left: "20.5",
          width: "80",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "冷凍空調1PI糕餅冷凍庫",
        },
        {
          show: true,
          class: "line_w",
          top: "82",
          left: "20.5",
          width: "80",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "冷凍空調到2°C冷凍主機包裝冷凍庫",
        },
        {
          show: true,
          class: "line_w",
          top: "93.5",
          left: "20.5",
          width: "80",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "冷凍空調到物資冷凍庫RFMPC",
        },
        {
          show: true,
          class: "line_h",
          top: "17.5",
          left: "37.5",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "17", left: "-6" },
          contect: "冷凍空調到空調冷藏系統ACMP",
        },
        {
          show: true,
           class: "line_h",
          top: "17.5",
          left: "62",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "17", left: "-6" },
          contect: "冷凍空調到MCC",
        },
        {
          show: true,
           class: "line_h",
          top: "17.5",
          left: "87.5",
          width: "0",
          height: "25",
          showArrow: false,
          arrow: { class: "arrow down", top: "17", left: "-6" },
          contect: "冷凍空調到A倉冷凍庫總用電",
        },
        {
          show: true,
          class: "line_w",
          top: "24.5",
          left: "45.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "空調冷藏系統ACMP到其他設備",
        },
        {
          show: true,
          class: "line_h",
          top: "24.5",
          left: "48",
          width: "0",
          height: "545",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "空調冷藏系統ACMP到其他設備",
        },{
          show: true,
          class: "line_w",
          top: "24.5",
          left: "70.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "MCC到其他設備",
        },
        {
          show: true,
          class: "line_h",
          top: "24.5",
          left: "73",
          width: "0",
          height: "724",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "MCC到其他設備",
        },
        {
          show: true,
          class: "line_w",
          top: "24.5",
          left: "93.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "A倉冷凍庫總用電到其他設備",
        },
        {
          show: true,
          class: "line_h",
          top: "24.5",
          left: "96",
          width: "0",
          height: "545",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "A倉冷凍庫總用電到其他設備",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_w",
          top: "36.5",
          left: "45.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "空調冷藏系統ACMP => 空調主機RFMPP",
        },
        {
          show: true,
          class: "line_w",
          top: "47.5",
          left: "45.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "空調冷藏系統ACMP => 大冷藏庫RFMPB",
        },
        {
          show: true,
          class: "line_w",
          top: "59.55",
          left: "45.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "空調冷藏系統ACMP => 低溫空調APMP-1",
        },
        {
          show: true,
          class: "line_w",
          top: "36.5",
          left: "70.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "MCC => 空調主機#1",
        },
        {
          show: true,
          class: "line_w",
          top: "47.5",
          left: "70.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "MCC => 空調主機#2",
        },
        {
          show: true,
          class: "line_w",
          top: "59",
          left: "70.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "MCC => 空調主機#3",
        },
        {
          show: true,
          class: "line_w",
          top: "71.15",
          left: "70.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "MCC => 空調主機#4",
        },
        {
          show: true,
          class: "line_w",
          top: "36.5",
          left: "93.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "A倉冷凍庫總用電 => 冷凍空調#1",
        },
        {
          show: true,
          class: "line_w",
          top: "47.5",
          left: "93.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "A倉冷凍庫總用電 => 冷凍空調#2",
        },
        {
          show: true,
          class: "line_w",
          top: "59.55",
          left: "93.5",
          width: "50",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "3" },
          contect: "A倉冷凍庫總用電 => 冷凍空調#3",
        },
      ],
    };
  },

  computed: {},
  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "電力系統 - 冷凍空調");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = false;
    // this.deviceKey = new URLSearchParams(window.location.search).get("options");
    // this.fromPage = new URLSearchParams(window.location.search).get("from_page");
    this.loadPageData();
    this.sysNowTime();
  },
  methods: {
    //  刷新頁面
    sysNowTime () {
      let that = this;
      setInterval(function () {
        that.loadPageData();
      }, 60000);
    },
    loadPageData() {
      _.each(this.billboard, (item, key) => {
        _.each(item['data'], (data, data_key) => {
          data['DBvalue'] = 0
        })
      })
      var tempData = [];
      this.get_options_id(tempData, this.deviceKey, this.data_group);
      var params = {
        Action: "LoadPageData",
        Datas: { id_list: _.join(tempData) },
        menu_page: "system_power",
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData , 'ID')
          //  基本內容塞值
          _.each(this.billboard , (item , key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'] , (data ,data_key) => {
                //  今日用電
                if ( data_key == "item01" && data['isDBValue']  ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_kwh']) ? groupByIdData[key][0]['today_kwh'] : 0, 2) 
                }
                //  本月用電
                if ( data_key == "item02" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['month_kwh']) ? groupByIdData[key][0]['month_kwh'] : 0, 2) 
                }
                //  即時功率
                if ( data_key == "item03" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['now_max_kw']) ? groupByIdData[key][0]['now_max_kw'] : 0, 2)  
                }
              })
            }
          })
          //  客製內容
          //  MCC
          this.mccData()
          //  A倉冷凍庫總用電
          this.warehouseColdStroage();
          //  空調冷藏系統ACMP
          this.acmp();
          //  加總
          var SumToday_kwh = _.sumBy(resData, (item) => { return !_.isNil(item['today_kwh']) ? parseFloat(item['today_kwh']) : 0 } )
          var SumMonth_kwh = _.sumBy(resData, (item) => { return !_.isNil(item['month_kwh']) ? parseFloat(item['month_kwh']) : 0 } )
          var SumNowMaxKw = _.sumBy(resData, (item) => { return !_.isNil(item['now_max_kw']) ? parseFloat(item['now_max_kw']) : 0 } )
          //  冷凍空調加總
          this.billboard['item01']['data']['item01']['DBvalue'] = this.FnRoundToDecimal(SumToday_kwh, 2)
          this.billboard['item01']['data']['item02']['DBvalue'] = this.FnRoundToDecimal(SumMonth_kwh, 2)
          this.billboard['item01']['data']['item03']['DBvalue'] = this.FnRoundToDecimal(SumNowMaxKw, 2)
          //  數據格式化
          _.each(this.billboard , (detail) => {
            _.each(detail['data'] , (item)=> {
              item['DBvalue'] = this.FnFormatNumber(item['DBvalue'], 1 )
            })
          })
        })
        .catch((err) => {
          console.log(err);
        });
    },
    //  MCC 設備塞值
    mccData () {
      var tempData = [];
      this.get_options_id(tempData, 'MCC', this.data_group);
      var params = {
        Action: "LoadPageData",
        Datas: { id_list: _.join(tempData) },
        menu_page: "system_power",
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData , 'ID')
          //  基本內容塞值
          _.each(this.billboard , (item , key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'] , (data ,data_key) => {
                //  今日用電
                if ( data_key == "item01" && data['isDBValue']  ){
                  data['DBvalue'] = this.FnFormatNumber(!_.isNil(groupByIdData[key][0]['today_kwh']) ? groupByIdData[key][0]['today_kwh'] : 0, 1) 
                }
                //  本月用電
                if ( data_key == "item02" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnFormatNumber(!_.isNil(groupByIdData[key][0]['month_kwh']) ? groupByIdData[key][0]['month_kwh'] : 0, 1) 
                }
                //  即時功率
                if ( data_key == "item03" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnFormatNumber(!_.isNil(groupByIdData[key][0]['now_max_kw']) ? groupByIdData[key][0]['now_max_kw'] : 0, 1)  
                }
              })
            }
          })
          
        })
        .catch((err) => {
          console.log(err);
        });
    },
    //  A倉冷凍庫總用電
    warehouseColdStroage(){
      var tempData = [];
      this.get_options_id(tempData, 'A倉冷凍庫總用電', this.data_group);
      var params = {
        Action: "LoadPageData",
        Datas: { id_list: _.join(tempData) },
        menu_page: "system_power",
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData , 'ID')
          //  基本內容塞值
          _.each(this.billboard , (item , key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'] , (data ,data_key) => {
                //  今日用電
                if ( data_key == "item01" && data['isDBValue']  ){
                  data['DBvalue'] = this.FnFormatNumber(!_.isNil(groupByIdData[key][0]['today_kwh']) ? groupByIdData[key][0]['today_kwh'] : 0, 1) 
                }
                //  本月用電
                if ( data_key == "item02" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnFormatNumber(!_.isNil(groupByIdData[key][0]['month_kwh']) ? groupByIdData[key][0]['month_kwh'] : 0, 1) 
                }
                //  即時功率
                if ( data_key == "item03" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnFormatNumber(!_.isNil(groupByIdData[key][0]['now_max_kw']) ? groupByIdData[key][0]['now_max_kw'] : 0, 1)  
                }
              })
            }
          })
          
        })
        .catch((err) => {
          console.log(err);
        });
    },
    //  空調冷藏系統ACMP
    acmp(){
      var tempData = [];
      this.get_options_id(tempData, '空調冷藏系統ACMP', this.data_group);
      var params = {
        Action: "LoadPageData",
        Datas: { id_list: _.join(tempData) },
        menu_page: "system_power",
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData , 'ID')
          //  基本內容塞值
          _.each(this.billboard , (item , key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'] , (data ,data_key) => {
                //  今日用電
                if ( data_key == "item01" && data['isDBValue']  ){
                  data['DBvalue'] = this.FnFormatNumber(!_.isNil(groupByIdData[key][0]['today_kwh']) ? groupByIdData[key][0]['today_kwh'] : 0, 1) 
                }
                //  本月用電
                if ( data_key == "item02" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnFormatNumber(!_.isNil(groupByIdData[key][0]['month_kwh']) ? groupByIdData[key][0]['month_kwh'] : 0, 1) 
                }
                //  即時功率
                if ( data_key == "item03" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnFormatNumber(!_.isNil(groupByIdData[key][0]['now_max_kw']) ? groupByIdData[key][0]['now_max_kw'] : 0, 1)  
                }
              })
            }
          })
          
        })
        .catch((err) => {
          console.log(err);
        });
    },
    //樹狀陣列平扁化
    get_options_id(array, key, group) {
      var that = this;
      device_item[group][key]["options"].forEach((el) => {
        if (!isNaN(Number(el.value, 10))) {
          array.push(el.value);
        }
        if (device_item.hasOwnProperty(el.label)) {
          return that.get_options_id(array, el.label, group);
        }
      });
    },
  },
};
