var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "system_gas",
      VarMenu: "area",
      VarPageContainerCss: "padding:0px",

      billboard: {
        item01: {
          show: true,
          title: "天燃氣瓦斯",
          title_style: "background: linear-gradient(to right, rgb(36 181 126) 5%, rgb(21 192 89) 50%, rgb(19 171 123) 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "天燃氣瓦斯", item_type: "瓦斯" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "天燃氣瓦斯" , item_type: "瓦斯"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "22.5",
          left: "80",
          width: "340",
        },
        "12": {
          show: true,
          title: "燃氣發電機",
          title_style: "background: linear-gradient(to right, rgb(36 181 126) 5%, rgb(21 192 89) 50%, rgb(19 171 123) 95%);",  //  標體底色
          caption: "ID = 12",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "燃氣發電機" , item_type: "瓦斯"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "燃氣發電機", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "36",
          left: "80",
          width: "340",
        },
        "1": {
          show: true,
          title: "瓦斯LPG總管",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 1",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "瓦斯LPG總管", item_type: "瓦斯" },
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "瓦斯LPG總管", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "7.5",
          left: "40.5",
          width: "340",
        },
        item02: {
          show: true,
          title: "肉品烘烤室",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "肉品烘烤室", item_type: "瓦斯" },
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "肉品烘烤室", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "22.5",
          left: "1.5",
          width: "340",
        },
        "2": {
          show: true,
          title: "炒肉鬆機",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 2",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "炒肉鬆機" , item_type: "瓦斯"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "炒肉鬆機", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "36",
          left: "1.5",
          width: "340",
        },
        "3": {
          show: true,
          title: "肉乾隧道烤爐",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 3",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "肉乾隧道烤爐" , item_type: "瓦斯"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "肉乾隧道烤爐", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "49.5",
          left: "1.5",
          width: "340",
        },
        "4": {
          show: true,
          title: "肉乾乾燥爐NO.1",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 4",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "肉乾乾燥爐NO.1" , item_type: "瓦斯"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "肉乾乾燥爐NO.1" , item_type: "瓦斯"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "63",
          left: "1.5",
          width: "340",
        },
        "5": {
          show: true,
          title: "肉乾乾燥爐NO.2",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 5",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "肉乾乾燥爐NO.2", item_type: "瓦斯" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "肉乾乾燥爐NO.2", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "76.5",
          left: "1.5",
          width: "340",
        },
        item03: {
          show: true,
          title: "蒸煮室",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "蒸煮室", item_type: "瓦斯" },
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "蒸煮室", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "22.5",
          left: "21",
          width: "340",
        },
        "6": {
          show: true,
          title: "炒牛肉",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 6",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "炒牛肉", item_type: "瓦斯" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "炒牛肉", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "36",
          left: "21",
          width: "340",
        },
        item04: {
          show: true,
          title: "炸豬油鍋",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "炸豬油鍋", item_type: "瓦斯" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "炸豬油鍋", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "49.5",
          left: "21",
          width: "340",
        },
        item05: {
          show: true,
          title: "西點烘培室",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "西點烘培室", item_type: "瓦斯" },
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "西點烘培室", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "22.5",
          left: "40.5",
          width: "340",
        },
        "7": {
          show: true,
          title: "瓦斯隧道爐(舊)",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 7",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "瓦斯隧道爐(舊)", item_type: "瓦斯" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "瓦斯隧道爐(舊)" , item_type: "瓦斯"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "36",
          left: "40.5",
          width: "340",
        },
        "8": {
          show: true,
          title: "瓦斯隧道爐(新)",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 8",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "瓦斯隧道爐(新)" , item_type: "瓦斯"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "瓦斯隧道爐(新)" , item_type: "瓦斯"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "49.5",
          left: "40.5",
          width: "340",
        },
        "9": {
          show: true,
          title: "旋風烤爐",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 9",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "旋風烤爐", item_type: "瓦斯" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "旋風烤爐", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "63",
          left: "40.5",
          width: "340",
        },
        item06: {
          show: true,
          title: "廚房",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "廚房", item_type: "瓦斯" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "廚房", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "22.5",
          left: "60",
          width: "340",
        },
        "10": {
          show: true,
          title: "燒臘區",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 10",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "燒臘區", item_type: "瓦斯" },
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "燒臘區" , item_type: "瓦斯"},
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "36",
          left: "60",
          width: "340",
        },
        item07: {
          show: true,
          title: "中點調理室",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "中點調理室" , item_type: "瓦斯"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "中點調理室", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "49.5",
          left: "60",
          width: "340",
        },
        "11": {
          show: true,
          title: "炒焰鍋",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption: "ID = 11",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "炒焰鍋" , item_type: "瓦斯"},
            },
            item02: {
              show: false,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "炒焰鍋", item_type: "瓦斯" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "即時值",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "日用量",
              isDBValue: true,
              DBvalue: 0,
              isSoft: false,
              SoftValue: "",
              unit: "m³/hr",
              icon: "bolt",
            },
          },
          top: "63",
          left: "60",
          width: "340",
        },
      },

      //	線條 => 定義 class 如果是line_h要設定height的長度(px)，width設為0，反之是line_w要設定width的長度(px)，height設為0
      line: [
        {
          show: true,
          class: "line_h",
          top: "18",
          left: "49.5",
          width: "0",
          height: "77",
          contect: "瓦斯LPG總管到各設備", //	註解這條線是什麼意思
          showArrow: false, //	要不要顯示箭頭
          arrow: {
            //	箭頭微調 (px) 方向設定 arrow right、left、up、down
            class: "arrow",
            top: "0",
            left: "0",
          },
        },
        {
          show: true,
          class: "line_w",
          top: "20.5",
          left: "10.5",
          width: "1310",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "瓦斯LPG總管到各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "20.5",
          left: "78.55",
          width: "0",
          height: "399",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "天然氣瓦斯到燃氣發電機",
        },
        {
          show: true,
          class: "line_h",
          top: "38",
          left: "89",
          width: "0",
          height: "60",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "0" },
          contect: "天然氣瓦斯到燃氣發電機",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_h",
          top: "20.5",
          left: "10.5",
          width: "0",
          height: "65",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "瓦斯LPG總管 => 肉品烘烤室",
        },
        {
          show: true,
          class: "line_h",
          top: "20.5",
          left: "30",
          width: "0",
          height: "65",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "瓦斯LPG總管 => 蒸煮室",
        },
        {
          show: true,
          class: "line_h",
          top: "20.5",
          left: "49.5",
          width: "0",
          height: "65",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "瓦斯LPG總管 =>西點烘烤室",
        },
        {
          show: true,
          class: "line_w",
          top: "28",
          left: "76.5",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "" },
          contect: "瓦斯LPG總管 => 廚房",
        },
        {
          show: true,
          class: "line_w",
          top: "42",
          left: "76.5",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "" },
          contect: "瓦斯LPG總管 => 燒臘區",
        },
        {
          show: true,
          class: "line_w",
          top: "55",
          left: "76.5",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "" },
          contect: "瓦斯LPG總管 => 中點調理室",
        },
        
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_w",
          top: "28",
          left: "37.5",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "" },
          contect: "蒸煮室 => 子各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "28",
          left: "39.5",
          width: "0",
          height: "313",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "" },
          contect: "蒸煮室 => 子各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "42",
          left: "36",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "蒸煮室 => 炒牛肉",
        },
        {
          show: true,
          class: "line_w",
          top: "55",
          left: "36",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "蒸煮室 => 炸豬油鍋",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_h",
          top: "28",
          left: "59",
          width: "0",
          height: "467",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "" },
          contect: "西點烘烤室 => 子各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "28",
          left: "57",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "" },
          contect: "西點烘烤室 => 子各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "42",
          left: "55.5",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "西點烘烤室 => 瓦斯隧道爐(舊)",
        },
        {
          show: true,
          class: "line_w",
          top: "55",
          left: "55.5",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "西點烘烤室 => 瓦斯隧道爐(新)",
        },
        {
          show: true,
          class: "line_w",
          top: "68.5",
          left: "55.5",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "西點烘烤室 => 旋風烤爐",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_w",
          top: "28",
          left: "18",
          width: "40",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "" },
          contect: "肉品烘烤室 => 子各設備",
        },
        {
          show: true,
          class: "line_h",
          top: "28",
          left: "20",
          width: "0",
          height: "622",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "" },
          contect: "肉品烘烤室 => 子各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "42",
          left: "16.5",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "肉品烘烤室 => 炒肉鬆機",
        },
        {
          show: true,
          class: "line_w",
          top: "55",
          left: "16.5",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "肉品烘烤室 => 肉乾隧道烤爐",
        },
        {
          show: true,
          class: "line_w",
          top: "68.5",
          left: "16.5",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "肉品烘烤室 => 肉乾乾燥爐NO.1",
        },
        {
          show: true,
          class: "line_w",
          top: "82",
          left: "16.5",
          width: "70",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow left", top: "-6", left: "0" },
          contect: "肉品烘烤室 => 肉乾乾燥爐NO.2",
        },
        /*----------------------------------------------------------------------------------------------------------------------------------------------------------------*/
        {
          show: true,
          class: "line_h",
          top: "67",
          left: "68",
          width: "0",
          height: "48",
          showArrow: false,
          arrow: { class: "arrow", top: "0", left: "" },
          contect: "中點調理室 => 炒焰鍋",
        },
      ],
    };
  },

  computed: {},
  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "瓦斯系統");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = false;
    this.loadPageData();
    this.sysNowTime();
  },
  methods: {
    //  刷新頁面
    sysNowTime () {
      let that = this;
      setInterval(function () {
        that.loadPageData();
      }, 600000);
    },
    loadPageData() {
      _.each(this.billboard, (item, key) => {
        _.each(item['data'], (data, data_key) => {
          data['DBvalue'] = 0
        })
      })
      var params = {
        Action: "LoadPageData",
        Datas: {},
      };

      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData, 'ID')
          //  基本內容塞值
          _.each(this.billboard, (item, key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'], (data , data_key) => {
                if (data_key == "item01" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['MAX_Flow']) ? groupByIdData[key][0]['MAX_Flow'] : 0, 2) 
                }
                if (data_key == "item02" && data['isDBValue'] ) {
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_Acc']) ? groupByIdData[key][0]['today_Acc'] : 0, 2) 
                }
              })
            }
            else {
              //  客制內容
              _.each(item['data'], (data , data_key) => {
                //  肉品烘烤室
                if ( key == "item02" && data['isDBValue'] ) {
                  _.each(this.treeMap('瓦斯', '肉品烘烤室') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                //  蒸煮室
                if ( key == "item03" && data['isDBValue'] ) {
                  _.each(this.treeMap('瓦斯', '蒸煮室') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    }  
                  }) 
                }
                //  西點烘培室
                if ( key == "item05" && data['isDBValue'] ) {
                  _.each(this.treeMap('瓦斯', '西點烘培室') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                //  燒臘區
                // if ( key == "item17" && data['isDBValue'] ) {
                //   _.each(this.treeMap('瓦斯', '燒臘區') , (id) => {
                //     if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                //       data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                //     }
                //     if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                //       data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                //     } 
                //   }) 
                // }
                //  中點調理室
                if ( key == "item07" && data['isDBValue'] ) {
                  _.each(this.treeMap('瓦斯', '中點調理室') , (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                    } 
                  }) 
                }
                //  發電機
                // if ( key == "item03" && data['isDBValue'] ) {
                //   _.each(this.treeMap('瓦斯', '發電機') , (id) => {
                //     if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                //       data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['MAX_Flow']) ? groupByIdData[id['value']][0]['MAX_Flow'] : 0 , 2) 
                //     }
                //     if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                //       data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_Acc']) ? groupByIdData[id['value']][0]['today_Acc'] : 0 , 2) 
                //     } 
                //   }) 
                // }
              })
            }
          })
          //  例外客制內容
          //  加總
          var SumMAXFlow = _.sumBy(resData, (item) => { return !_.isNil(item['MAX_Flow']) ? parseFloat(item['MAX_Flow']) : 0 } )
          var SumTodayAcc = _.sumBy(resData, (item) => { return !_.isNil(item['today_Acc']) ? parseFloat(item['today_Acc']) : 0 } )

          //  數據格式化
          _.each(this.billboard , (detail) => {
            _.each(detail['data'] , (item)=> {
              item['DBvalue'] = this.FnFormatNumber(item['DBvalue'], 1 )
            })
          })
        })
        .catch((err) => {
          console.log(err);
        });
    },

    //  樹狀爸爸
    treeMap (item_type, keyWord) {
      return _.map(device_item[item_type][keyWord]['options'] , (item ) => {
        return {  "value" : item['value'] } 
      })
    }



  },
};
