var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "system_power",
      VarMenu: "area",
      VarPageContainerCss: "padding:0px",

      billboard: {
        "1": {
          show: true, //  要不要顯示此區塊
          title: "電力總表MCB", //  標題
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "ID = 1", //  游標註解說明
          showButton: true, //  顯示所有按鈕
          button: {
            //  標題同一列的按鈕功能
            item01: {
              show: true, //  要不要顯示此按鈕
              label: "長條圖", //  標題 (標示定義名稱)
              icon: "leaderboard", // 按鈕圖樣  
              linkto: "chart_bar.php", // 轉跳頁面 定義為 null 不會觸發
              params: { options: "電力系統", item_type: "電力" }, //  轉跳頁面後面帶參數
            },
            item02: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "電力系統", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度" ,
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "10",
          left: "41.25",
          width: "340",
        },
        item05: {
          show: true,
          title: "照明",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "照明樹狀結構",
              icon: "account_tree",
              linkto: "sub_system_power_illumination.php",
              // params: { options: "照明", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "照明", item_type: "電力" },
            },
            item03: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "照明", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "48",
          left: "9",
          width: "340",
        },
        item06: {
          show: true,
          title: "冷凍空調",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "冷凍空調樹狀結構",
              icon: "account_tree",
              linkto: "sub_system_power_refrigeration_air_conditioner.php",
              // params: { options: "冷凍空調", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "冷凍空調", item_type: "電力" },
            },
            item03: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "冷凍空調", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "48",
          left: "29",
          width: "340",
        },
        item07: {
          show: true,
          title: "製程動力",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "製程動力樹狀結構",
              icon: "account_tree",
              linkto: "sub_system_power_process_power.php",
              // params: { options: "製程動力", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "製程動力", item_type: "電力" },
            },
            item03: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "製程動力", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "48",
          left: "53.7",
          width: "340",
        },
        item08: {
          show: true,
          title: "通風",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "通風樹狀結構",
              icon: "account_tree",
              linkto: "sub_system_power_ventilation.php",
              // params: { options: "通風", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "通風", item_type: "電力" },
            },
            item03: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "通風", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "48",
          left: "73.7",
          width: "340",
        },
        "37": {
          show: true,
          title: "空壓",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "空壓樹狀結構",
              icon: "account_tree",
              linkto: "sub_system_power_air_pressure.php",
              // params: { options: "空壓", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "空壓", item_type: "電力" },
            },
            item03: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "空壓", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "72",
          left: "9",
          width: "340",
        },
        item10: {
          show: true,
          title: "公用設備",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "公用設備樹狀結構",
              icon: "account_tree",
              linkto: "sub_system_power_public_equipment.php",
              // params: { options: "公用設備", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "公用設備", item_type: "電力" },
            },
            item03: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "公用設備", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "72",
          left: "29",
          width: "340",
        },
        item11: {
          show: true,
          title: "其他",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",
          showButton: true,
          button: {
            item01: {
              show: true,
              label: "其他樹狀結構",
              icon: "account_tree",
              linkto: "sub_system_power_other.php",
              // params: { options: "其他", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "其他", item_type: "電力" },
            },
            item03: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "其他", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "72",
          left: "53.7",
          width: "340",
        },
        item12: {
          show: true,
          title: "發電機",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",
          showButton: false,
          button: {
            item01: {
              show: true,
              label: "其他樹狀結構",
              icon: "account_tree",
              linkto: "sub_system_power_other.php",
              // params: { options: "其他", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "其他", item_type: "電力" },
            },
            item03: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "其他", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "27",
          left: "19.5",
          width: "340",
        },
        item13: {
          show: true,
          title: "儲能設備",
          title_style: "background: linear-gradient(to right, #246ab5 5% , #1565c0 50% , #115eaa 95%);",  //  標體底色
          caption : "",
          showButton: false,
          button: {
            item01: {
              show: true,
              label: "其他樹狀結構",
              icon: "account_tree",
              linkto: "sub_system_power_other.php",
              // params: { options: "其他", item_type: "電力" },
            },
            item02: {
              show: true,
              label: "長條圖",
              icon: "leaderboard",
              linkto: "chart_bar.php",
              params: { options: "其他", item_type: "電力" },
            },
            item03: {
              show: true,
              label: "圓餅圖",
              icon: "pie_chart",
              linkto: "chart_pie.php",
              params: { options: "其他", item_type: "電力" },
            },
          },
          data: {
            item01: {
              show: true,
              label: "今日用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item02: {
              show: true,
              label: "本月用電",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "度",
              icon: "bolt",
            },
            item03: {
              show: true,
              label: "即時功率",
              isDBValue: true,
              DBvalue: 0,
              isSoft: true,
              SoftValue: "",
              unit: "kW",
              icon: "bolt",
            },
          },
          top: "27",
          left: "63",
          width: "340",
        },
      },

      //	線條 => 定義 class 如果是line_h要設定height的長度(px)，width設為0，反之是line_w要設定width的長度(px)，height設為0
      line: [
        {
          show: true,
          class: "line_h",
          top: "24",
          left: "50",
          width: "0",
          height: "525",
          showArrow: false,
          arrow: { class: "arrow right", top: "0", left: "0" },
          contect: "電力系統連接各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "34.5",
          left: "36.5",
          width: "525",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "0", left: "0" },
          contect: "儲能設備 <=> 電機",
        },
        {
          show: true,
          class: "line_w",
          top: "45.2",
          left: "17.5",
          width: "1252",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "0", left: "0" },
          contect: "電力系統連接各設備",
        },
        {
          show: true,
          class: "line_w",
          top: "69.5",
          left: "17.5",
          width: "868",
          height: "0",
          showArrow: false,
          arrow: { class: "arrow right", top: "0", left: "0" },
          contect: "電力系統連接各設備",
        },
        
        {
          show: true,
          class: "line_h",
          top: "45.5",
          left: "17.5",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "電力系統 => 照明",
        },
        {
          show: true,
          class: "line_h",
          top: "45.5",
          left: "38",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "電力系統 => 冷凍空調",
        },
        {
          show: true,
          class: "line_h",
          top: "45.5",
          left: "62.5",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "電力系統 => 製程動力",
        },
        {
          show: true,
          class: "line_h",
          top: "45.5",
          left: "82.5",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "14", left: "-6" },
          contect: "電力系統 => 通風",
        },
        {
          show: true,
          class: "line_h",
          top: "69.5",
          left: "17.5",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "10", left: "-6" },
          contect: "電力系統 => 空壓",
        },
        {
          show: true,
          class: "line_h",
          top: "69.5",
          left: "38",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "10", left: "-6" },
          contect: "電力系統 => 公用設備",
        },
        {
          show: true,
          class: "line_h",
          top: "69.5",
          left: "62.5",
          width: "0",
          height: "30",
          showArrow: false,
          arrow: { class: "arrow down", top: "10", left: "-6" },
          contect: "電力系統 => 其他",
        },
      ],
    };
  },

  computed: {},
  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "電力系統");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = false;
    this.loadPageData();
    this.sysNowTime();
  },
  methods: {
    //  刷新頁面
    sysNowTime() {
      let that = this;
      setInterval(function () {
        that.loadPageData();
      }, 60000);
    },
    loadPageData() {
      _.each(this.billboard, (item, key) => {
        _.each(item['data'], (data, data_key) => {
          data['DBvalue'] = 0
        })
      })
      var params = {
        Action: "LoadPageData",
        Datas: {},
      };

      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          var groupByIdData = _.groupBy(resData, 'ID')
          //  基本內容塞值
          _.each(this.billboard, (item, key) => {
            if (!_.isNil(groupByIdData[key])) {
              _.each(item['data'], (data, data_key) => {
                //  今日用電
                if ( data_key == "item01" && data['isDBValue']  ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['today_kwh']) ? groupByIdData[key][0]['today_kwh'] : 0, 2) 
                }
                //  本月用電
                if ( data_key == "item02" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['month_kwh']) ? groupByIdData[key][0]['month_kwh'] : 0, 2) 
                }
                //  即時功率
                if ( data_key == "item03" && data['isDBValue'] ){
                  data['DBvalue'] = this.FnRoundToDecimal(!_.isNil(groupByIdData[key][0]['now_max_kw']) ? groupByIdData[key][0]['now_max_kw'] : 0, 2)  
                }
              })
            } else {
              //  客製內容
              _.each(item['data'], (data , data_key) => {
                //  照明
                if ( key == "item05" && data['isDBValue'] ){
                  _.each(this.treeMap('電力', '照明'), (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_kwh']) ? groupByIdData[id['value']][0]['today_kwh'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['month_kwh']) ? groupByIdData[id['value']][0]['month_kwh'] : 0 , 2) 
                    } 
                    if (data_key == "item03" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['now_max_kw']) ? groupByIdData[id['value']][0]['now_max_kw'] : 0 , 2)  
                    } 
                  })
                }
                //  冷凍空調
                if ( key == "item06" && data['isDBValue'] ){
                  _.each(this.treeMap('電力', '冷凍空調'), (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_kwh']) ? groupByIdData[id['value']][0]['today_kwh'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['month_kwh']) ? groupByIdData[id['value']][0]['month_kwh'] : 0 , 2) 
                    } 
                    if (data_key == "item03" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['now_max_kw']) ? groupByIdData[id['value']][0]['now_max_kw'] : 0 , 2)  
                    }
                  })
                }
                //  製程動力
                if ( key == "item07" && data['isDBValue'] ){
                  _.each(this.treeMap('電力', '製程動力detail'), (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_kwh']) ? groupByIdData[id['value']][0]['today_kwh'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['month_kwh']) ? groupByIdData[id['value']][0]['month_kwh'] : 0 , 2) 
                    } 
                    if (data_key == "item03" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['now_max_kw']) ? groupByIdData[id['value']][0]['now_max_kw'] : 0 , 2)  
                    }
                  })
                }
                //  通風
                if ( key == "item08" && data['isDBValue'] ){
                  _.each(this.treeMap('電力', '通風'), (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_kwh']) ? groupByIdData[id['value']][0]['today_kwh'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['month_kwh']) ? groupByIdData[id['value']][0]['month_kwh'] : 0 , 2) 
                    } 
                    if (data_key == "item03" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['now_max_kw']) ? groupByIdData[id['value']][0]['now_max_kw'] : 0 , 2)  
                    }
                  })
                }
                //  空壓
                if ( key == "item09" && data['isDBValue'] ){
                  _.each(this.treeMap('電力', '空壓'), (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_kwh']) ? groupByIdData[id['value']][0]['today_kwh'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['month_kwh']) ? groupByIdData[id['value']][0]['month_kwh'] : 0 , 2) 
                    } 
                    if (data_key == "item03" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['now_max_kw']) ? groupByIdData[id['value']][0]['now_max_kw'] : 0 , 2)  
                    } 
                  })
                }
                //  公用設備
                if ( key == "item10" && data['isDBValue'] ){
                  _.each(this.treeMap('電力', '公用設備'), (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_kwh']) ? groupByIdData[id['value']][0]['today_kwh'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['month_kwh']) ? groupByIdData[id['value']][0]['month_kwh'] : 0 , 2) 
                    } 
                    if (data_key == "item03" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['now_max_kw']) ? groupByIdData[id['value']][0]['now_max_kw'] : 0 , 2)  
                    }
                  })
                }
                //  其他
                if ( key == "item11" && data['isDBValue'] ){
                  _.each(this.treeMap('電力', '其他'), (id) => {
                    if (data_key == "item01" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['today_kwh']) ? groupByIdData[id['value']][0]['today_kwh'] : 0 , 2) 
                    }
                    if (data_key == "item02" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['month_kwh']) ? groupByIdData[id['value']][0]['month_kwh'] : 0 , 2) 
                    } 
                    if (data_key == "item03" && data['isDBValue'] && !_.isNil(groupByIdData[id['value']]) ) {
                      data['DBvalue'] += this.FnRoundToDecimal(!_.isNil(groupByIdData[id['value']][0]['now_max_kw']) ? groupByIdData[id['value']][0]['now_max_kw'] : 0 , 2)  
                    }
                  })
                }
              })
            }
          })
          //  客製內容
          //  新東陽能源系統
          // this.billboard['item01']['data']['item01']['DBvalue'] =  this.billboard['1']['data']['item01']['DBvalue']
          // this.billboard['item01']['data']['item02']['DBvalue'] =  this.billboard['1']['data']['item02']['DBvalue']
          // this.billboard['item01']['data']['item03']['DBvalue'] =  this.billboard['1']['data']['item03']['DBvalue']
          //  數據格式化
          _.each(this.billboard , (detail) => {
            _.each(detail['data'] , (item)=> {
              item['DBvalue'] = this.FnFormatNumber(item['DBvalue'], 1 )
            })
          })

        })
        .catch((err) => {
          console.log(err);
        });
    },

    //  樹狀爸爸
    treeMap (item_type, keyWord) {
      return _.map(device_item[item_type][keyWord]['options'] , (item ) => {
        return {  "value" : item['value'] } 
      })
    }
    
  },
};
