var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "system_power_demand",
      VarMenu: "area",
      VarPageContainerCss: "padding:20px; background: #0c2249;",

      info: {
        item01: {
          show: false, //	使否顯示
          label: "控制模式", //	標題
          value: "同步式", //	數值
          unit: null, //	單位
          isShowChart: false, //	是否顯示在趨勢圖上方
          class: "w3-center", //	數值顯示 左 / 中 / 右
        },
        ContractDemand: {
          show: true,
          label: "契約容量",
          value: 0,
          unit: "kW",
          isShowChart: true,
          class: "w3-right-align text-light-blue-7",
        },
        DemandShutdownSV: {
          show: true,
          label: "卸載值",
          value: 0,
          unit: "kW",
          isShowChart: true,
          class: "w3-right-align text-light-blue-7",
        },
        DemandTarget: {
          show: true,
          label: "目標需量",
          value: 0,
          unit: "kW",
          isShowChart: true,
          class: "w3-right-align text-light-blue-7",
        },
        CurrentDemand: {
          show: true,
          label: "目前需量",
          value: 0,
          unit: "kW",
          isShowChart: true,
          class: "w3-right-align text-light-blue-7",
        },
        PredictedDemand: {
          show: true,
          label: "預測需量",
          value: 0,
          unit: "kW",
          isShowChart: true,
          class: "w3-right-align text-light-blue-7",
        },
        InstantDemand: {
          show: true,
          label: "瞬時負載",
          value: 0,
          unit: "kW",
          isShowChart: false,
          class: "w3-right-align text-light-blue-7",
        },
        CurrentDemandTarget: {
          show: true,
          label: "現在目標值",
          value: 0,
          unit: "kW",
          isShowChart: true,
          class: "w3-right-align text-light-blue-7",
        },
        AdjustedDemand: {
          show: true,
          label: "需量調整值",
          value: 0,
          unit: "kW",
          isShowChart: false,
          class: "w3-right-align text-light-blue-7",
        },
        DemandAlarmSV: {
          show: true,
          label: "警報值",
          value: 0,
          unit: "kW",
          isShowChart: false,
          class: "w3-right-align text-light-blue-7",
        },
        ResidualTime: {
          show: true,
          label: "殘餘時間",
          value: 0,
          unit: "Sec",
          isShowChart: false,
          class: "w3-right-align text-light-blue-7",
        },
      },
      mcb: {
        show: true,
        title: "台電總表MCB",
        data: {
          Vrs: {
            show: true, //	使否顯示
            label: "Vrs", //	標題
            value: 0, //	數值
            unit: null, //	單位
            RowNo: "1", //	控制一些條件用途
            class: "w3-right-align text-light-blue-7", //	數值顯示 左 / 中 / 右
          },
          
          Vst: {
            show: true,
            label: "Vst",
            value: 0,
            unit: null,
            RowNo: "3",
            class: "w3-right-align text-light-blue-7",
          },
         
          Vtr: {
            show: true,
            label: "Vtr",
            value: 0,
            unit: null,
            RowNo: "5",
            class: "w3-right-align text-light-blue-7",
          },
          Ir: {
            show: true,
            label: "Ir",
            value: 0,
            unit: null,
            RowNo: "2",
            class: "w3-right-align text-light-blue-7",
          },
          Is: {
            show: true,
            label: "Is",
            value: 0,
            unit: null,
            RowNo: "4",
            class: "w3-right-align text-light-blue-7",
          },
          It: {
            show: true,
            label: "It",
            value: 0,
            unit: null,
            RowNo: "6",
            class: "w3-right-align text-light-blue-7",
          },
          Kw: {
            show: true,
            label: "kW",
            value: 0,
            unit: null,
            RowNo: "7",
            class: "w3-right-align text-light-blue-7",
          },
          Kva: {
            show: true,
            label: "kVA",
            value: 0,
            unit: null,
            RowNo: "8",
            class: "w3-right-align text-light-blue-7",
          },
          Kvar: {
            show: true,
            label: "kVar",
            value: 0,
            unit: null,
            RowNo: "9",
            class: "w3-right-align text-light-blue-7",
          },
          PF: {
            show: true,
            label: "PF",
            value: 0,
            unit: null,
            RowNo: "10",
            class: "w3-right-align text-light-blue-7",
          },
          KWH: {
            show: true,
            label: "KWH",
            value: 0,
            unit: null,
            RowNo: "11",
            class: "w3-right-align text-light-blue-7",
          },
        },
      },
      other: {
        show: true,
        title: "外氣溫濕度",
        data: {
          "P1": {
            show: true,
            label: "外氣溫度",
            value: 0,
            unit: "°C",
            RowNo: "1",
            class: "w3-right-align text-light-blue-7",
          },
          "P2": {
            show: true,
            label: "外氣濕度",
            value: 0,
            unit: "%",
            RowNo: "2",
            class: "w3-right-align text-light-blue-7",
          },
        },
      },
      chart: {
        tooltip: {
          trigger: "axis",
        },
        grid: {
          left: "3%",
          right: "3%",
          bottom: "10%",
          containLabel: true,
        },
        xAxis: {
          type: "category",
          axisLabel: {
            fontSize: 16,
          },
          data: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
        },
        yAxis: {
          type: "value",
          axisLabel: {
            fontSize: 16,
          },
        },
        dataZoom: [
          {
            type: "inside",
            start: 75,
            end: 100,
          },
          {
            start: 0,
            end: 100,
          },
        ],
        series: [
          {
            name: "契約容量",
            type: "line",
            symbolSize: 10,
            symbol: "circle",
            data: [
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
            ],
            itemStyle: {
              color: "rgba(0,0,0,1)",
            },
            lineStyle: {
              type: "solid",
              width: 3,
            },
          },
          {
            name: "卸載值",
            type: "line",
            symbolSize: 10,
            symbol: "circle",
            data: [
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
            ],
            itemStyle: {
              color: "rgba(250,0,1,1)",
            },
            lineStyle: {
              type: "solid",
              width: 3,
            },
          },
          {
            name: "目標需量",
            type: "line",
            symbolSize: 10,
            symbol: "circle",
            data: [
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
            ],
            itemStyle: {
              color: "rgba(0,252,1,1)",
            },
            lineStyle: {
              type: "solid",
              width: 3,
            },
          },
          {
            name: "目前需量",
            type: "line",
            symbolSize: 10,
            symbol: "circle",
            data: [
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
            ],
            itemStyle: {
              color: "rgba(252,255,0,1)",
            },
            lineStyle: {
              type: "solid",
              width: 3,
            },
          },
          {
            name: "預測需量",
            type: "line",
            symbolSize: 10,
            symbol: "circle",
            data: [
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
            ],
            itemStyle: {
              color: "rgba(254,1,250,1)",
            },
            lineStyle: {
              type: "solid",
              width: 3,
            },
          },
          {
            name: "現在目標值",
            type: "line",
            symbolSize: 10,
            symbol: "circle",
            data: [
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
              Math.random() * 1000,
            ],
            itemStyle: {
              color: "rgba(1,255,254,1)",
            },
            lineStyle: {
              type: "solid",
              width: 3,
            },
          },
        ],
      },
    };
  },

  computed: {},
  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "電力需量系統");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    this.loadPageData();
    this.sysNowTime();
  },
  methods: {
    //  刷新頁面
    sysNowTime () {
      let that = this;
      setInterval(function () {
        that.loadPageData();
      }, 600000);
    },

    loadPageData() {
      this.chart['xAxis']['data'] = []	
      this.chart['series'][0]['data'] = []
      this.chart['series'][1]['data'] = []
      this.chart['series'][2]['data'] = []
      this.chart['series'][3]['data'] = []
      this.chart['series'][4]['data'] = []
      this.chart['series'][5]['data'] = []
      var params = {
        Action: "LoadPageData",
        Datas: {},
      };

      this.FnWebAPIGet(params)
        .then((res) => {
          var resData = res.data.data;
          //當前資訊顯示
          if (resData.info != undefined && _.size(resData.info) > 0) {
          	_.each(this.info , (item , key) => {
          		if (!_.isNil(resData.info[key])) {
          			item['value'] = this.FnFormatNumber(resData.info[key])
          		}
          	})
          	_.each(this.mcb['data'] , (item , key) => {
          		if (!_.isNil(resData.info[key])) {
          			item['value'] = this.FnFormatNumber(resData.info[key])
          		}
          	})
          	_.each(this.other['data'] , (item , key) => {
          		if (!_.isNil(resData.info[key])) {
          			item['value'] = this.FnFormatNumber(resData.info[key])
          		}
          	})
          }
          //chart資料
          if (resData.chart_data != undefined && _.size(resData.chart_data) > 0) {
          	_.each(resData.chart_data , (item , key) => {
          		this.chart['xAxis']['data'].push( moment(item['DATE_TIME']).format('HH:mm') )
          		this.chart['series'][0]['data'].push(item['ContractDemand'])
          		this.chart['series'][1]['data'].push(item['DemandShutdownSV'])
          		this.chart['series'][2]['data'].push(item['DemandTarget'])
          		this.chart['series'][3]['data'].push(item['CurrentDemand'])
          		this.chart['series'][4]['data'].push(item['PredictedDemand'])
          		this.chart['series'][5]['data'].push(item['CurrentDemandTarget'])
          	})
          }
        })
        .catch((err) => {
          console.log(err);
        });
    },
  },
};
