<!DOCTYPE html>
<html lang="zh-tw">

<head><?php
      // 引用 head.inc
      include_once "html_head.inc";
      ?></head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
    <?php
    // include_once "html_menu.inc";
    include_once "html_layout_header.inc";
    ?>
    <!-- 內容區域 //-->

    <div class="container">
      <!-- 查詢列 -->
      <div class="row justify-end">
        <div class="row items-center" style="padding:10px">
          <q-btn glossy color="secondary" class="id-btn" label="新增" @click="open_dialog()" />
        </div>
      </div>
      <!-- 資料表單 -->
      <div class="custom-table bg-color-White">
        <ve-table max-height="calc(100vh - 200px)" style="width:100%" :scroll-width="0" :border-around="false" border-y :columns="tableColumns" :cell-style-option="easy_table.cellStyleOption" :table-data="tableData">
        </ve-table>
        <div class="custom-table-pagination row justify-end">
          <ve-pagination :total="totalCount" :page-index="easy_table.pageIndex" :page-size="easy_table.pageSize" @on-page-number-change="pageNumberChange" @on-page-size-change="pageSizeChange" />
        </div>
      </div>

      <!-- 新增、修改 -->
      <q-modal v-model="dialog.show" class="dialogs" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss style="z-index:2000" :content-css="{minWidth: '20vw', maxHeight: '100vh'}">
        <q-modal-layout header-class="modal-theme modal-themes" footer-class="modal-theme">
          <div slot="header">
            <div class="bg-primary text-white" style="display:flex; justify-content: space-between;">
              <div style="padding-left: 40%;">
                <h6 class="layout-header">{{dialog.isNew? '新增' : '修改'}}使用者</h6>
              </div>
              <div style="display:flex; align-items: center;">
                <span class="material-icons dialog-close" style="padding: 0px 10px;" @click="close_dialog()">close</span>
              </div>
            </div>
          </div>
          <div style="min-width:25Vw; max-width: 600px;">
            <div class="columns" style="padding:10px;">
              <div class="row items-center" style="min-height:50px; padding:5px">
                <label :class="dialog.isNew? 'required_input':''">員工代號：</label>
                <q-input v-model="dialog.user_id" class="col" align="center" :readonly="dialog.isNew == false"></q-input>
              </div>
              <div class="row items-center" style="min-height:50px; padding:5px">
                <label :class="dialog.isNew? 'required_input':''">密碼：</label>
                <q-input v-model="dialog.password" class="col" align="center" type="password"></q-input>
              </div>
              <div class="row items-center" style="min-height:50px; padding:5px">
                <label :class="dialog.isNew? 'required_input':''">確認密碼：</label>
                <q-input v-model="dialog.check_password" class="col" align="center" type="password"></q-input>
              </div>
              <div class="row items-center" style="min-height:50px; padding:5px">
                <label class="required_input">權限：</label>
                <q-select v-model="dialog.role_id" placeholder="請選擇" class="col" align="center" :options="dialog_option_role_id"></q-select>
              </div>

              <div class="row items-center" style="min-height:50px; padding:5px">
                <label class="required_input">員工姓名：</label>
                <q-input v-model="dialog.name" class="col" align="center"></q-input>
              </div>
              <div class="row items-center" style="min-height:50px; padding:5px">
                <label class="required_input">停用：</label>
                <q-radio style="margin:0px 10px;" v-model="dialog.enabled" val="1" label="No" />
                <q-radio style="margin:0px 10px;" v-model="dialog.enabled" val="0" label="Yes" />
              </div>
            </div>
          </div>
          <div class="row" style="margin: 10px; display: flex; justify-content: flex-end;">
            <q-btn style="margin: 0px 6%;" glossy color="green" :label="dialog.isNew?'新增':'儲存'" class="id-btn" @click="save_user()"></q-btn>
            <q-btn glossy color="light" label="取消" class="id-btn" @click="close_dialog()"></q-btn>
          </div>
        </q-modal-layout>
      </q-modal>


      <!-- QR code列印 -->
      <q-modal v-model="dialog_print.show" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss style="z-index:2000" :content-css="{minWidth: '20vw', maxHeight: '100vh'}">
        <q-modal-layout header-class="modal-theme modal-themes" footer-class="modal-theme">
          <div slot="header">
            <div style="display:flex; justify-content: space-between;">
              <div style="padding: 0px 10px;">
                <h6>QRcode 列印</h6>
              </div>
              <div style="display:flex; align-items: center;">
                <span class="material-icons dialog-close" style="padding: 10px;" @click="close_dialog_print()">close</span>
              </div>
            </div>
          </div>
          <div ref="qr_print" class="row items-center justify-around" style="margin: 10px;">
            <div class="column">
              <div class="row"><label>員工代號：</label><span>{{dialog_print.user_id}}</span></div>
              <div class="row"><label>員工名稱：</label><span>{{dialog_print.user_name}}</span></div>
            </div>
            <div ref="qr_code"></div>
          </div>
          <div class="row justify-around" style="margin: 10px;">
            <q-btn style="margin: 0px 10px;" glossy color="faded" label="列印" class="id-btn" @click="print_qrcode()"></q-btn>
          </div>
        </q-modal-layout>
      </q-modal>

    </div>
    <!-- /內容區域 //-->
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  // loading.inc
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_report_download = true;
        // 引用 down.inc
        include_once "html_down.inc";
        ?>

</html>