var deviceGroupOptions = [
	{ label: "13MT 溶解爐", value: "G1", other: "Other_08" },
	{ label: "4MT溶解爐", value: "G2", other: "Other_11" },
	{ label: "8MT保溫爐", value: "G3", other: "Other_10" },
	{ label: "2MT保溫爐", value: "G4", other: "Other_09" },
	{ label: "圓形鐘罩式退火爐", value: "G5", other: "Other_01" },
	{ label: "隧道式退火爐", value: "G6", other: "Other_02" },
	{ label: "380V電錶(發電室)", value: "G7", other: "Other_04" },
	{ label: "銅錠加熱功頻爐", value: "G8", other: "Other_07" },
	{ label: "擠型機", value: "G9", other: "Other_06" },
	{ label: "集塵變頻", value: "G10", other: "Other_05" },
	{ label: "", value: "G11" },
	{ label: "", value: "G12" },
	{ label: "", value: "G13" },
];


var deviceLimitOptions = {
	"G1": [
		{ label: "電錶", value: "G1_1", type: "meter", upper: "" },
		{ label: "左線圈溫度", value: "G1_2", type: "temp", upper: "" },
		{ label: "左白鐵套溫度", value: "G1_3", type: "temp", upper: "" },
		{ label: "右線圈溫度", value: "G1_4", type: "temp", upper: "" },
		{ label: "右白鐵套溫度", value: "G1_5", type: "temp", upper: "" },
		{ label: "變壓器溫度", value: "G1_6", type: "temp", upper: "" },
		{ label: "未知項目1溫度", value: "G1_7", type: "temp", upper: "" },
		{ label: "未知項目2溫度", value: "G1_8", type: "temp", upper: "" },
		{ label: "未知項目3溫度", value: "G1_9", type: "temp", upper: "" },
	],
	"G2": [
		{ label: "電錶", value: "G2_1", type: "meter", upper: "" },
		{ label: "融湯溫度", value: "G2_2", type: "temp", upper: "" },
		{ label: "內循環模進水溫度", value: "G2_3", type: "temp", upper: "" },
		{ label: "內循環模出水溫度", value: "G2_4", type: "temp", upper: "" },
		{ label: "變壓器溫度", value: "G2_5", type: "temp", upper: "" },
		{ label: "白鐵套溫度", value: "G2_6", type: "temp", upper: "" },
		{ label: "銅錠表面溫度", value: "G2_7", type: "temp", upper: "" },
		{ label: "模進水流量", value: "G2_8", type: "flow", upper: "", lower: "" },
	],
	"G3": [
		{ label: "電錶", value: "G3_1", type: "meter", upper: "" },
		{ label: "融湯溫度", value: "G3_2", type: "temp", upper: "" },
		{ label: "內循環模進水溫度", value: "G3_3", type: "temp", upper: "" },
		{ label: "內循環模出水溫度", value: "G3_4", type: "temp", upper: "" },
		{ label: "變壓器溫度", value: "G3_5", type: "temp", upper: "" },
		{ label: "白鐵套溫度", value: "G3_6", type: "temp", upper: "" },
		{ label: "銅錠表面溫度", value: "G3_7", type: "temp", upper: "" },
		{ label: "模進水流量", value: "G3_8", type: "flow", upper: "", lower: "" },
	],
	"G4": [
		{ label: "電錶", value: "G4_1", type: "meter", upper: "" },
		{ label: "內循環線圈出水溫度(1上)", value: "G4_2", type: "temp", upper: "" },
		{ label: "內循環線圈出水溫度(1下)", value: "G4_3", type: "temp", upper: "" },
		{ label: "內循環線圈出水溫度(2上)", value: "G4_4", type: "temp", upper: "" },
		{ label: "內循環線圈出水溫度(2下)", value: "G4_5", type: "temp", upper: "" },
		{ label: "內循環線圈出水溫度(3上)", value: "G4_6", type: "temp", upper: "" },
		{ label: "內循環線圈出水溫度(3下)", value: "G4_7", type: "temp", upper: "" },
		{ label: "電纜線出水溫度", value: "G4_8", type: "temp", upper: "" },
		{ label: "變壓器溫度", value: "G4_9", type: "temp", upper: "" },
	],
	"G5": [
		{ label: "上段電錶", value: "G5_1", type: "meter", upper: "" },
		{ label: "中段電錶", value: "G5_2", type: "meter", upper: "" },
		{ label: "下段電錶", value: "G5_3", type: "meter", upper: "" },
		{ label: "總電錶", value: "G5_4", type: "meter", upper: "" },
		{ label: "超溫保護溫度控制器", value: "G5_5", type: "temp", upper: "" },
		{ label: "上段溫度溫度控制器", value: "G5_6", type: "temp", upper: "" },
		{ label: "中段溫度溫度控制器", value: "G5_7", type: "temp", upper: "" },
		{ label: "下段溫度溫度控制器", value: "G5_8", type: "temp", upper: "" },
	],
	"G6": [
		{ label: "電錶1", value: "G6_1", type: "meter", upper: "" },
		{ label: "電錶2", value: "G6_2", type: "meter", upper: "" },
		{ label: "總電錶", value: "G6_3", type: "meter", upper: "" },
		{ label: "溫度溫度控制器1", value: "G6_4", type: "temp", upper: "" },
		{ label: "溫度溫度控制器2", value: "G6_5", type: "temp", upper: "" },
	],
	"G7": [
		{ label: "電錶", value: "G7_1", type: "meter", upper: "" },
	],
	"G8": [
		{ label: "電錶", value: "G8_1", type: "meter", upper: "" },
		{ label: "內循環熱水入水溫度(熱)", value: "G8_2", type: "temp", upper: "" },
		{ label: "內循環冷水出水溫度(冷)", value: "G8_3", type: "temp", upper: "" },
		{ label: "外循環熱水出水溫度(熱)", value: "G8_4", type: "temp", upper: "" },
		{ label: "外循環冷水入水溫度(冷)", value: "G8_5", type: "temp", upper: "" },
		{ label: "內循環水壓力", value: "G8_6", type: "pressure", upper: "", lower: "" },
		{ label: "外循環冷卻水壓力", value: "G8_7", type: "pressure", upper: "", lower: "" },
	],
	"G9": [
		{ label: "電錶", value: "G9_1", type: "meter", upper: "" },
		{ label: "內循環熱油入油溫度(熱)", value: "G9_2", type: "temp", upper: "" },
		{ label: "內循環冷油出油溫度(冷)", value: "G9_3", type: "temp", upper: "" },
		{ label: "外循環熱水出水溫度(熱)", value: "G9_4", type: "temp", upper: "" },
		{ label: "外循環冷水入水溫度(冷)", value: "G9_5", type: "temp", upper: "" },
		{ label: "內循環油壓力", value: "G9_6", type: "pressure", upper: "", lower: "" },
		{ label: "外循環冷卻水壓力", value: "G9_7", type: "pressure", upper: "", lower: "" },
	],
	"G10": [
		{ label: "電錶", value: "G10_1", type: "meter", upper: "" },
	],
};
//區域資訊資料
var deviceindexinfo = [
	{
		"label": "13MT 溶解爐",
		"value": "G1",
		"item": [
			{
				"label": "今日用電量",
				"value": "G1_1",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_12",
				"table_column": "Today_KWH"
			},
			{
				"label": "本月用電量",
				"value": "G1_2",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_12",
				"table_column": "ThisMonth_KWH"
			},
			{
				"label": "即時電壓",
				"value": "G1_3",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_12",
				"table_column": "VLL_avg"
			},
			{
				"label": "即時電流",
				"value": "G1_4",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_12",
				"table_column": "I_avg"
			},
			{
				"label": "即時功率",
				"value": "G1_5",
				"unit": "kW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_12",
				"table_column": "KVA_tot"
			},
			{
				"label": "功率因素",
				"value": "G1_6",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_12",
				"table_column": "Coin"
			},
			{
				"label": "即時爐電壓",
				"value": "G1_7",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_12",
				"table_column": "VLL_avg"
			},
			{
				"label": "即時爐電流",
				"value": "G1_8",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_12",
				"table_column": "I_avg"
			},
			{
				"label": "即時爐功率",
				"value": "G1_9",
				"unit": "KW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_12",
				"table_column": "KVA_tot"
			},
			{
				"label": "左線圈",
				"value": "G1_10",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_08",
				"table_column": "D00502",
				"other_field": "D00502"
			},
			{
				"label": "左白鐵套",
				"value": "G1_11",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_08",
				"table_column": "D00602",
				"other_field": "D00602"
			},
			{
				"label": "右線圈",
				"value": "G1_12",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_08",
				"table_column": "D00702",
				"other_field": "D00702"
			},
			{
				"label": "右白鐵套",
				"value": "G1_13",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_08",
				"table_column": "D00802",
				"other_field": "D00802"
			},
			{
				"label": "變壓器",
				"value": "G1_14",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_08",
				"table_column": "D00902",
				"other_field": "D00902"
			},
			{
				"label": "未知項目1",
				"value": "G1_15",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_08",
				"table_column": "D01002",
				"other_field": "D01002"
			},
			{
				"label": "未知項目2",
				"value": "G1_16",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_08",
				"table_column": "D01102",
				"other_field": "D01102"
			},
			{
				"label": "未知項目3",
				"value": "G1_17",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_08",
				"table_column": "D01202",
				"other_field": "D01202"
			}
		],
		"alarm_tag_list": [
			"R00030",
			"R00031",
			"R00032",
			"R00033",
			"R00034",
			"R00035",
			"R00036",
			"R00037",
			"R00038",
			"R00039",
			"R00040",
			"R00041",
			"R00303",
			"R00305",
			"R00307",
			"R00309",
			"R00311",
			"R00313",
			"R00315",
			"R00317",
			"R00319"
		]
	},
	{
		"label": "4MT溶解爐",
		"value": "G2",
		"item": [
			{
				"label": "今日用電量",
				"value": "G2_1",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_15",
				"table_column": "Today_KWH"
			},
			{
				"label": "本月用電量",
				"value": "G2_2",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_15",
				"table_column": "ThisMonth_KWH"
			},
			{
				"label": "即時電壓",
				"value": "G2_3",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_15",
				"table_column": "VLL_avg"
			},
			{
				"label": "即時電流",
				"value": "G2_4",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_15",
				"table_column": "I_avg"
			},
			{
				"label": "即時功率",
				"value": "G2_5",
				"unit": "kW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_15",
				"table_column": "KVA_tot"
			},
			{
				"label": "功率因素",
				"value": "G2_6",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_15",
				"table_column": "Coin"
			},
			{
				"label": "即時爐電壓",
				"value": "G2_7",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_15",
				"table_column": "VLL_avg"
			},
			{
				"label": "即時爐電流",
				"value": "G2_8",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_15",
				"table_column": "I_avg"
			},
			{
				"label": "即時爐功率",
				"value": "G2_9",
				"unit": "KW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_15",
				"table_column": "KVA_tot"
			},
			{
				"label": "融湯",
				"value": "G2_10",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_11",
				"table_column": "D01602",
				"other_field": "D01602"
			},
			{
				"label": "模進水(溫度)",
				"value": "G2_11",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_11",
				"table_column": "D01702",
				"other_field": "D01702"
			},
			{
				"label": "模出水(溫度)",
				"value": "G2_12",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_11",
				"table_column": "D01802",
				"other_field": "D01802"
			},
			{
				"label": "變壓器",
				"value": "G2_13",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_11",
				"table_column": "D01902",
				"other_field": "D01902"
			},
			{
				"label": "白鐵套",
				"value": "G2_14",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_11",
				"table_column": "D02002",
				"other_field": "D02002"
			},
			{
				"label": "銅錠表面",
				"value": "G2_15",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_11",
				"table_column": "D02101",
				"other_field": "D02101"
			},
			{
				"label": "模進水(流量)",
				"value": "G2_16",
				"unit": "m2/h",
				"icon": "💧",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_11",
				"table_column": "D02201",
				"other_field": "D02201"
			}
		],
		"alarm_tag_list": [
			"R00065",
			"R00066",
			"R00067",
			"R00068",
			"R00069",
			"R00070",
			"R00071",
			"R00072",
			"R00073",
			"R00074",
			"R00075",
			"R00602",
			"R00604",
			"R00606",
			"R00608",
			"R00610",
			"R00612",
			"R00614",
			"R00616",
			"R00617"
		]
	},
	{
		"label": "8MT保溫爐",
		"value": "G3",
		"item": [
			{
				"label": "今日用電量",
				"value": "G3_1",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_14",
				"table_column": "Today_KWH"
			},
			{
				"label": "本月用電量",
				"value": "G3_2",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_14",
				"table_column": "ThisMonth_KWH"
			},
			{
				"label": "即時電壓",
				"value": "G3_3",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_14",
				"table_column": "VLL_avg"
			},
			{
				"label": "即時電流",
				"value": "G3_4",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_14",
				"table_column": "I_avg"
			},
			{
				"label": "即時功率",
				"value": "G3_5",
				"unit": "kW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_14",
				"table_column": "KVA_tot"
			},
			{
				"label": "功率因素",
				"value": "G3_6",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_14",
				"table_column": "Coin"
			},
			{
				"label": "即時爐電壓",
				"value": "G3_7",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_14",
				"table_column": "VLL_avg"
			},
			{
				"label": "即時爐電流",
				"value": "G3_8",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_14",
				"table_column": "I_avg"
			},
			{
				"label": "即時爐功率",
				"value": "G3_9",
				"unit": "KW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_14",
				"table_column": "KVA_tot"
			},
			{
				"label": "融湯",
				"value": "G3_10",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_10",
				"table_column": "D00502",
				"other_field": "D00502"
			},
			{
				"label": "內循環模進水",
				"value": "G3_11",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_10",
				"table_column": "D00602",
				"other_field": "D00602"
			},
			{
				"label": "內循環模出水",
				"value": "G3_12",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_10",
				"table_column": "D00702",
				"other_field": "D00702"
			},
			{
				"label": "變壓器",
				"value": "G3_13",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_10",
				"table_column": "D00802",
				"other_field": "D00802"
			},
			{
				"label": "白鐵套",
				"value": "G3_14",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_10",
				"table_column": "D00902",
				"other_field": "D00902"
			},
			{
				"label": "銅錠表面",
				"value": "G3_15",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_10",
				"table_column": "D01001",
				"other_field": "D01001"
			},
			{
				"label": "模進水",
				"value": "G3_16",
				"unit": "m2/h",
				"icon": "💧",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_10",
				"table_column": "D01101",
				"other_field": "D01101"
			}
		],
		"alarm_tag_list": [
			"R00054",
			"R00055",
			"R00056",
			"R00057",
			"R00058",
			"R00059",
			"R00060",
			"R00061",
			"R00062",
			"R00063",
			"R00064",
			"R00503",
			"R00505",
			"R00507",
			"R00509",
			"R00511",
			"R00513",
			"R00515",
			"R00517",
			"R00518"
		]
	},
	{
		"label": "2MT保溫爐",
		"value": "G4",
		"item": [
			{
				"label": "今日用電量",
				"value": "G4_1",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_13",
				"table_column": "Today_KWH"
			},
			{
				"label": "本月用電量",
				"value": "G4_2",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_13",
				"table_column": "ThisMonth_KWH"
			},
			{
				"label": "即時電壓",
				"value": "G4_3",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_13",
				"table_column": "VLL_avg"
			},
			{
				"label": "即時電流",
				"value": "G4_4",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_13",
				"table_column": "I_avg"
			},
			{
				"label": "即時功率",
				"value": "G4_5",
				"unit": "kW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_13",
				"table_column": "KVA_tot"
			},
			{
				"label": "功率因素",
				"value": "G4_6",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_name": "ACM_13",
				"table_column": "Coin"
			},
			{
				"label": "即時爐電壓",
				"value": "G4_7",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_13",
				"table_column": "VLL_avg"
			},
			{
				"label": "即時爐電流",
				"value": "G4_8",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_13",
				"table_column": "I_avg"
			},
			{
				"label": "即時爐功率",
				"value": "G4_9",
				"unit": "KW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_name": "ACM_13",
				"table_column": "KVA_tot"
			},
			{
				"label": "內循環線圈出水(1上)",
				"value": "G4_10",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_09",
				"table_column": "D01702",
				"other_field": "D01702"
			},
			{
				"label": "內循環線圈出水(1下)",
				"value": "G4_11",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_09",
				"table_column": "D01802",
				"other_field": "D01802"
			},
			{
				"label": "內循環線圈出水(2上)",
				"value": "G4_12",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_09",
				"table_column": "D01902",
				"other_field": "D01902"
			},
			{
				"label": "內循環線圈出水(2下)",
				"value": "G4_13",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_09",
				"table_column": "D02002",
				"other_field": "D02002"
			},
			{
				"label": "內循環線圈出水(3上)",
				"value": "G4_14",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_09",
				"table_column": "D02102",
				"other_field": "D02102"
			},
			{
				"label": "內循環線圈出水(3下)",
				"value": "G4_15",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_09",
				"table_column": "D02202",
				"other_field": "D02202"
			},
			{
				"label": "電纜線出水",
				"value": "G4_16",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_09",
				"table_column": "D02302",
				"other_field": "D02302"
			},
			{
				"label": "變壓器",
				"value": "G4_17",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_name": "Other_09",
				"table_column": "D02402",
				"other_field": "D02402"
			}
		],
		"alarm_tag_list": [
			"R00042",
			"R00043",
			"R00044",
			"R00045",
			"R00046",
			"R00047",
			"R00048",
			"R00049",
			"R00050",
			"R00051",
			"R00052",
			"R00053",
			"R00403",
			"R00405",
			"R00407",
			"R00409",
			"R00411",
			"R00413",
			"R00415",
			"R00417",
			"R00419"
		]
	},
	{
		"label": "圓形鐘罩式退火爐",
		"value": "G5",
		"item": [
			{
				"label": "今日總用電量",
				"value": "G5_1",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "Today_KWH",
				"table_name": "ACM_04"
			},
			{
				"label": "本月總用電量",
				"value": "G5_2",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "ThisMonth_KWH",
				"table_name": "ACM_04"
			},
			{
				"label": "即時總功率",
				"value": "G5_3",
				"unit": "kW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "KVA_tot",
				"table_name": "ACM_04"
			},
			{
				"label": "上段即時電壓",
				"value": "G5_4",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "VLL_avg",
				"table_name": "ACM_01"
			},
			{
				"label": "上段即時電流",
				"value": "G5_5",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "I_avg",
				"table_name": "ACM_01"
			},
			{
				"label": "上段功率因素",
				"value": "G5_6",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "Coin",
				"table_name": "ACM_01"
			},
			{
				"label": "中段即時電壓",
				"value": "G5_7",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "VLL_avg",
				"table_name": "ACM_02"
			},
			{
				"label": "中段即時電流",
				"value": "G5_8",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "I_avg",
				"table_name": "ACM_02"
			},
			{
				"label": "中段功率因素",
				"value": "G5_9",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "Coin",
				"table_name": "ACM_02"
			},
			{
				"label": "下段即時電壓",
				"value": "G5_10",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "VLL_avg",
				"table_name": "ACM_03"
			},
			{
				"label": "下段即時電流",
				"value": "G5_11",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "I_avg",
				"table_name": "ACM_03"
			},
			{
				"label": "下段功率因素",
				"value": "G5_12",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "Coin",
				"table_name": "ACM_03"
			},
			{
				"label": "超溫保護控制器",
				"value": "G5_13",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00452",
				"other_field": "D00452",
				"table_name": "Other_01"
			},
			{
				"label": "上段控制器",
				"value": "G5_14",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00502",
				"other_field": "D00502",
				"table_name": "Other_01"
			},
			{
				"label": "中段控制器",
				"value": "G5_15",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00602",
				"other_field": "D00602",
				"table_name": "Other_01"
			},
			{
				"label": "下段控制器",
				"value": "G5_16",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00702",
				"other_field": "D00702",
				"table_name": "Other_01"
			}
		],
		"alarm_tag_list": [
			"R00001",
			"R00002",
			"R00003",
			"R00004",
			"R00005",
			"R00006",
			"R00007",
			"R00103",
			"R00106",
			"R00109",
			"R00111",
			"R00113",
			"R00115",
			"R00117"
		]
	},
	{
		"label": "隧道式退火爐",
		"value": "G6",
		"item": [
			{
				"label": "今日總用電量",
				"value": "G6_1",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "Today_KWH",
				"table_name": "ACM_07"
			},
			{
				"label": "本月總用電量",
				"value": "G6_2",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "ThisMonth_KWH",
				"table_name": "ACM_07"
			},
			{
				"label": "即時總功率",
				"value": "G6_3",
				"unit": "kW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "KVA_tot",
				"table_name": "ACM_07"
			},
			{
				"label": "1號即時電壓",
				"value": "G6_4",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "VLL_avg",
				"table_name": "ACM_05"
			},
			{
				"label": "1號即時電流",
				"value": "G6_5",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "I_avg",
				"table_name": "ACM_05"
			},
			{
				"label": "1號功率因素",
				"value": "G6_6",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "Coin",
				"table_name": "ACM_05"
			},
			{
				"label": "2號即時電壓",
				"value": "G6_7",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "VLL_avg",
				"table_name": "ACM_06"
			},
			{
				"label": "2號即時電流",
				"value": "G6_8",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "I_avg",
				"table_name": "ACM_06"
			},
			{
				"label": "2號功率因素",
				"value": "G6_9",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "Coin",
				"table_name": "ACM_06"
			},
			{
				"label": "控制器1",
				"value": "G6_10",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D01052",
				"other_field": "D01052",
				"table_name": "Other_02"
			},
			{
				"label": "控制器2",
				"value": "G6_11",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D01102",
				"other_field": "D01102",
				"table_name": "Other_02"
			}
		],
		"alarm_tag_list": [
			"R00008",
			"R00009",
			"R00010",
			"R00011",
			"R00121",
			"R00124",
			"R00126",
			"R00128"
		]
	},
	{
		"label": "380V電錶(發電室)",
		"value": "G7",
		"item": [
			{
				"label": "今日用電量",
				"value": "G7_1",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "Today_KWH",
				"table_name": "ACM_09"
			},
			{
				"label": "本月用電量",
				"value": "G7_2",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "ThisMonth_KWH",
				"table_name": "ACM_09"
			},
			{
				"label": "即時電壓",
				"value": "G7_3",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "VLL_avg",
				"table_name": "ACM_09"
			},
			{
				"label": "即時電流",
				"value": "G7_4",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "I_avg",
				"table_name": "ACM_09"
			},
			{
				"label": "即時功率",
				"value": "G7_5",
				"unit": "kW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "KVA_tot",
				"table_name": "ACM_09"
			},
			{
				"label": "功率因素",
				"value": "G7_6",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "Coin",
				"table_name": "ACM_09"
			}
		],
		"alarm_tag_list": ["R00019", "R00153"]
	},
	{
		"label": "銅錠加熱功頻爐",
		"value": "G8",
		"item": [
			{
				"label": "今日用電量",
				"value": "G8_1",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "Today_KWH",
				"table_name": "ACM_08"
			},
			{
				"label": "本月用電量",
				"value": "G8_2",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "ThisMonth_KWH",
				"table_name": "ACM_08"
			},
			{
				"label": "即時電壓",
				"value": "G8_3",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "VLL_avg",
				"table_name": "ACM_08"
			},
			{
				"label": "即時電流",
				"value": "G8_4",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "I_avg",
				"table_name": "ACM_08"
			},
			{
				"label": "即時功率",
				"value": "G8_5",
				"unit": "kW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "KVA_tot",
				"table_name": "ACM_08"
			},
			{
				"label": "功率因素",
				"value": "G8_6",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "Coin",
				"table_name": "ACM_08"
			},
			{
				"label": "內循環熱水入水(熱)",
				"value": "G8_7",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D01001",
				"other_field": "D01001",
				"table_name": "Other_07"
			},
			{
				"label": "內循環冷水出水(冷)",
				"value": "G8_8",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D01101",
				"other_field": "D01101",
				"table_name": "Other_07"
			},
			{
				"label": "外循環熱水出水(熱)",
				"value": "G8_9",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D01201",
				"other_field": "D01201",
				"table_name": "Other_07"
			},
			{
				"label": "外循環冷水入水(冷)",
				"value": "G8_10",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D01301",
				"other_field": "D01301",
				"table_name": "Other_07"
			},
			{
				"label": "內循環水壓力",
				"value": "G8_11",
				"unit": "kg/cm2",
				"icon": "🌬️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00902",
				"other_field": "D00902",
				"table_name": "Other_07"
			},
			{
				"label": "外循環冷卻水壓力",
				"value": "G8_12",
				"unit": "kg/cm2",
				"icon": "🌬️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00202",
				"other_field": "D00202",
				"table_name": "Other_07"
			}
		],
		"alarm_tag_list": [
			"R00012",
			"R00013",
			"R00014",
			"R00015",
			"R00016",
			"R00017",
			"R00018",
			"R00132",
			"R00134",
			"R00135",
			"R00137",
			"R00138",
			"R00140",
			"R00142",
			"R00144",
			"R00146"
		]
	},
	{
		"label": "擠型機",
		"value": "G9",
		"item": [
			{
				"label": "今日用電量",
				"value": "G9_1",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "Today_KWH",
				"table_name": "ACM_11"
			},
			{
				"label": "本月用電量",
				"value": "G9_2",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "ThisMonth_KWH",
				"table_name": "ACM_11"
			},
			{
				"label": "即時電壓",
				"value": "G9_3",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "VLL_avg",
				"table_name": "ACM_11"
			},
			{
				"label": "即時電流",
				"value": "G9_4",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "I_avg",
				"table_name": "ACM_11"
			},
			{
				"label": "即時功率",
				"value": "G9_5",
				"unit": "kW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "KVA_tot",
				"table_name": "ACM_11"
			},
			{
				"label": "功率因素",
				"value": "G9_6",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "Coin",
				"table_name": "ACM_11"
			},
			{
				"label": "內循環熱油入油(熱)",
				"value": "G9_7",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00401",
				"other_field": "D00401",
				"table_name": "Other_06"
			},
			{
				"label": "內循環冷油出油(冷)",
				"value": "G9_8",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00501",
				"other_field": "D00501",
				"table_name": "Other_06"
			},
			{
				"label": "外循環熱水出水(熱)",
				"value": "G9_9",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00601",
				"other_field": "D00601",
				"table_name": "Other_06"
			},
			{
				"label": "外循環冷水入水(冷)",
				"value": "G9_10",
				"unit": "°C",
				"icon": "🌡️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00701",
				"other_field": "D00701",
				"table_name": "Other_06"
			},
			{
				"label": "內循環油壓力",
				"value": "G9_11",
				"unit": "kg/cm2",
				"icon": "🌬️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00801",
				"other_field": "D00801",
				"table_name": "Other_06"
			},
			{
				"label": "外循環冷卻水壓力",
				"value": "G9_12",
				"unit": "kg/cm2",
				"icon": "🌬️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00302",
				"other_field": "D00302",
				"table_name": "Other_06"
			}
		],
		"alarm_tag_list": [
			"R00023",
			"R00024",
			"R00025",
			"R00026",
			"R00027",
			"R00028",
			"R00029",
			"R00203",
			"R00205",
			"R00206",
			"R00208",
			"R00210",
			"R00212",
			"R00214",
			"R00216",
			"R00217"
		]
	},
	{
		"label": "集塵變頻",
		"value": "G10",
		"item": [
			{
				"label": "今日用電量",
				"value": "G10_1",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "Today_KWH",
				"table_name": "ACM_10"
			},
			{
				"label": "本月用電量",
				"value": "G10_2",
				"unit": "kWh",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "ThisMonth_KWH",
				"table_name": "ACM_10"
			},
			{
				"label": "即時電壓",
				"value": "G10_3",
				"unit": "V",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "VLL_avg",
				"table_name": "ACM_10"
			},
			{
				"label": "即時電流",
				"value": "G10_4",
				"unit": "A",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "I_avg",
				"table_name": "ACM_10"
			},
			{
				"label": "即時功率",
				"value": "G10_5",
				"unit": "kW",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 1,
				"table_column": "KVA_tot",
				"table_name": "ACM_10"
			},
			{
				"label": "功率因素",
				"value": "G10_6",
				"unit": "",
				"icon": "⚡️",
				"is_electricity": 1,
				"index_show": 0,
				"table_column": "Coin",
				"table_name": "ACM_10"
			},
			{
				"label": "即時頻率",
				"value": "G10_7",
				"unit": "HZ",
				"icon": "🌪️",
				"is_electricity": 0,
				"index_show": 0,
				"table_column": "D00302",
				"other_field": "D00302",
				"table_name": "Other_05"
			},
			{
				"label": "即時風速",
				"value": "G10_8",
				"unit": "m²/s",
				"icon": "🌪️",
				"is_electricity": 0,
				"index_show": 1,
				"table_column": "D00402",
				"other_field": "D00402",
				"table_name": "Other_05"
			}
		],
		"alarm_tag_list": ["R00020", "R00021", "R00022", "R00157"]
	}
]



