/*
  FILE: i18n_messages.js
  在 html_down.inc 引入
  usage:
    <div>{{ $t("lbl.hello") }}</div>
    this.$t("lbl.hello")
*/
if ($$i18n_messages == undefined) {
  var $$i18n_messages = {}
}
$$i18n_messages["zh-hant"] = { // zh-hant 繁中
  "language": "中文",
  "sys": {
    "version": "版本",
    "loading_wait": "正在載入資料，請稍候",
    "plz_try_again": "請稍後再試",
    "user": "使用者",
    "ok": "確定",
    "cancel": "取消",
    "edit": "編輯",
    "view": "檢視",
    "export": "匯出",
    "search": "查詢",
    "setting": "設定",
    "save": "儲存",
    "update": "更新",
    "delete": "刪除",
    "void": "作廢",
    "close": "關閉",
    "recovery": "還原",
    "default": "預設",
    "column": "欄位",
    "phase": {
      "draft": "草稿",
      "execute": "進行",
      "completed": "完工",
      "complete": "完工",
      "end": "結案",
      "void": "作廢",
    },
    "message": {
      "info": "訊息",
      "confirm": "確認",
      "download_error": "檔案下載出錯",
      "are_sure_to_execute": "確定要執行嗎？",
      "execute_success": "執行成功",
    },
    "weather_location": { // 可再此加其它縣市
      "city": {
        "彰化縣": "彰化縣",
        "臺南市": "臺南市",
        "臺中市": "臺中市",
      },
      "town": {
        "伸港鄉": "伸港鄉",
        "仁德區": "仁德區",
        "大里區": "大里區",
        "社頭鄉": "社頭鄉",
        "秀水鄉": "秀水鄉",
        "永康區": "永康區",
      },
    },
  },
  "options": {
    "time": {
      "all_time": "所有時間",
      "ten_min": "十分鐘",
      "thirty_min": "三十分鐘",
      "one_hour": "一小時",
      "one_day": "一日",
    },
  },
  "layout": {
    "system_name": "太陽能系統",
    "menu": "選單",
    "collapse_menu": "收合選單",
    "expand_menu": "展開選單",
    "right_menu": "右側選單",
    "nav_menu": {
      "home": "首頁",
      "station_list": "案場清單",
      "back": "上一頁",
    },
    "change_password": {
      "title": "變更密碼",
      "label": {
        "user_id": "使用者帳號",
        "user_name": "使用者名稱",
        "old_pwd": "舊密碼",
        "new_pwd1": "新密碼",
        "new_pwd2": "確認新密碼",
      },
      "msg": {
        "new_pwd_empty": "新密碼不可為空白",
        "new_pwd_not_same": "新密碼與確認新密碼不相同",
        "old_pwd_error": "舊密碼錯誤",
        "other_error": "其他錯誤",
        "change_pwd_success": "密碼變更成功",
      },
    },
  },
  "page": {
    "login": {
      "system_login": "系統登入",
      "account": "帳號",
      "password": "密碼",
      "login": "登入",
      "logout": "登出",
      "plz_login_again": "請重新登入",
      "login_expire": "登入資料已過期",
      "login_failed": "登入失敗",
      "verify_failed": "驗證失敗",
    },
  },
  "menu": {
    "index": "電子看板",
    "machine_status":"機台狀態",
    "machine_list":"機台清單",
    "alarm":"警報清單",
    "admin_users":"使用者管理",
    "system_power_area" : "電力系統",
    "system_power" :  "電力看板",
    "system_power_surface" :  "電力電錶",
    "system_power_trend" :  "電力趨勢圖",
    "admin": "管理",
    "admin_users":"使用者管理",
    "admin_page_permission_setting":"角色頁面權限設定",
    "basic":"電錶資訊",
    "parameter_settings":"參數設定",
  },
  "taiwan_place": {
    "keelung_city": "基隆市",
    "new_taipei_city": "新北市",
    "taipei_city": "臺北市",
    "taoyuan_city": "桃園市",
    "hsinchu_county": "新竹縣",
    "hsinchu_city": "新竹市",
    "miaoli_city": "苗栗市",
    "miaoli_county": "苗栗縣",
    "taichung_city": "臺中市",
    "changhua_county": "彰化縣",
    "changhua_city": "彰化市",
    "nantou_city": "南投市",
    "nantou_county": "南投縣",
    "yunlin_county": "雲林縣",
    "chiayi_county": "嘉義縣",
    "chiayi_city": "嘉義市",
    "tainan_city": "臺南市",
    "kaohsiung_city": "高雄市",
    "pingtung_county": "屏東縣",
    "pingtung_city": "屏東市",
    "yilan_county": "宜蘭縣",
    "yilan_city": "宜蘭市",
    "hualien_county": "花蓮縣",
    "hualien_city": "花蓮市",
    "taitung_city": "臺東市",
    "taitung_county": "臺東縣",
    "penghu_county": "澎湖縣",
    "green_island": "綠島",
    "orchid_island": "蘭嶼",
    "kinmen_county": "金門縣",
    "matsu": "馬祖",
    "lienchiang_county": "連江縣",
  },
  "api_msg": { // 後端的 message 訊息
    "menu": {
      "test": "測試選單",
    },
  },
};