var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "alarm",
      VarMenu: "area",
      VarPageContainerCss: "height:calc(100vh - 65px);",

      search: {
        start_at: new Date(),
        end_at: new Date(),
        machine: "all",
      },
      // machine_option: [
      //   { label: "全選", value: "" }
      // ],


      //表單表頭樣式設定
      cellStyleOption: {
        headerCellClass: ({ column, rowIndex }) => {
          return "bg-primary text-white custom-table-header";
        },
      },
      //表單分頁
      pageIndex: 1,
      pageSize: 10,
      //表單資料陣列
      table_data: [
        // {
        //   Al_Start_Time: "2024-01-01 00:00:00",
        //   Al_Norm_Time: "2024-01-01 00:00:00",
        //   Al_Tag_Value: "123",
        //   Message: "測試信息",
        // },
      ],
    };
  },

  computed: {
    //表單欄位
    tableColumns() {
      let arr = [
        {
          field: "index",
          label: "項目",
          key: "index",
          title: "#",
          width: 50,
          align: "center",
          align: "center",
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let inx = (this.pageSize * (this.pageIndex - 1)) + rowIndex + 1;
            return inx;
          },
        },
        {
          field: "Al_Start_Time",
          label: "發生時間",
          key: "Al_Start_Time",
          title: "發生時間",
          align: "center",
          width: 150,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            return column.format(row[column.field]);
          },
          format: (data) => {
            return data == null ? "" : moment(data).format("YYYY-MM-DD HH:mm:ss");
          },
        },
        {
          field: "Al_Norm_Time",
          label: "復歸時間",
          key: "Al_Norm_Time",
          title: "復歸時間",
          align: "center",
          width: 150,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            return column.format(row[column.field]);
          },
          format: (data) => {
            return data == null ? "" : moment(data).format("YYYY-MM-DD HH:mm:ss");
          },
        },
        {
          field: "Message",
          label: "訊息",
          key: "Message",
          title: "訊息",
          align: "center",
          width: 150,
        },
      ];
      return arr;
    },
    //表單資料總數
    totalCount() {
      return this.table_data.length;
    },
    //表單資料分頁邏輯
    tableData() {
      const { pageIndex, pageSize } = this;
      return this.table_data.slice(
        (pageIndex - 1) * pageSize,
        pageIndex * pageSize
      );
    },
    //設備項目清單
    machine_option() {
      let arr = [],
        that = this;
      arr.push({
        label: "全選",
        value: "all",
      });
      //deviceindexinfo 內容 詳見 cfg/Var_config
      deviceindexinfo.forEach((el, inx) => {

        arr.push({
          label: el.label,
          value: el.value
        });
      })
      return arr;
    },
    //設備警報點清單-查詢用
    machine_alarm_list() {
      let str = "",
        that = this;
      if (that.search.machine == "all") {
        str = "all"
      } else {
        deviceindexinfo.forEach((el, inx) => {
          if (el.value == that.search.machine) {
            str = el.alarm_tag_list.map(item => `'${item}'`).join(",");
          }
        })
      }
      return str
    }
  },

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "警報資訊");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    this.searchData();
    // this.loadMachineOptions()
  },

  methods: {
    async searchData() {
      let that = this;
      that.$q.loading.show();
      if (this.machine_alarm_list != "") {

        var params = {
          Action: "Alarm",
          Datas: {
            start_at: this.search.start_at,
            end_at: this.search.end_at,
            machine_alarm_list: this.machine_alarm_list
          },
        }
        await this.FnWebAPIGet(params).then((res) => {
          if (res.data.result) {
            let resData = res.data.data;
            this.table_data = resData
            this.$q.loading.hide();

          } else {
            this.FnNotify(res.data.message, 'warning')
            this.$q.loading.hide();
          }
        }).catch(function (err) {
          console.log(err);
        });
      }

    },

    // page number change
    pageNumberChange(pageIndex) {
      this.pageIndex = pageIndex;
    },

    // page size change
    pageSizeChange(pageSize) {
      this.pageIndex = 1;
      this.pageSize = pageSize;
    },
  },
};
