var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "index",
      VarMenu: "area",
      VarPageContainerCss: "height:calc(100vh - 65px);",
      //各設備項目清單
      // device_list: [
      // 內容範例 詳見 cfg/Var_config
      // {
      //   "label": "13MT 溶解爐",
      //   "value": "G1",
      //   "item":
      //     [
      //       { "label": "今日用電量", "value": "G1_1", "unit": "kWh" },
      //       { "label": "本月用電量", "value": "G1_3", "unit": "kWh" },
      //       { "label": "即時電壓", "value": "G1_3", "unit": "V" },
      //       { "label": "即時電流", "value": "G1_3", "unit": "A" },
      //       { "label": "即時功率", "value": "G1_3", "unit": "kW" },
      //       { "label": "功率因素", "value": "G1_3", "unit": "" },
      //       { "label": "即時爐電壓", "value": "G1_3", "unit": "V" },
      //       { "label": "即時爐電流", "value": "G1_3", "unit": "A" },
      //       { "label": "即時爐功率", "value": "G1_3", "unit": "KW" },
      //       { "label": "左線圈", "value": "G1_3", "unit": "°C" },
      //       { "label": "左白鐵套", "value": "G1_3", "unit": "°C" },
      //       { "label": "右線圈", "value": "G1_3", "unit": "°C" },
      //       { "label": "右白鐵套", "value": "G1_3", "unit": "°C" },
      //       { "label": "變壓器", "value": "G1_3", "unit": "°C" },
      //       { "label": "未知項目1", "value": "G1_3", "unit": "°C" },
      //       { "label": "未知項目2", "value": "G1_3", "unit": "°C" },
      //       { "label": "未知項目3", "value": "G1_3", "unit": "°C" },
      //     ],
      // },
      // ],

    };
  },

  computed: {
    device_list() {
      let arr = [],
        new_item = [];

      //deviceindexinfo 各設備項目清單
      // 內容範例 詳見 cfg/Var_config
      // {
      //   "label": "13MT 溶解爐",
      //   "value": "G1",
      //   "item":
      //     [
      //         {
      //           "label": "今日用電量",
      //           "value": "G1_1",
      //           "unit": "kWh",
      //           "icon": "⚡️",
      //           "is_electricity": 1,
      //           "index_show": 1,
      //           "table_name": "ACM1",
      //           "table_column": "Today_KWH"
      //         },
      //         {
      //           "label": "本月用電量",
      //           "value": "G1_2",
      //           "unit": "kWh",
      //           "icon": "⚡️",
      //           "is_electricity": 1,
      //           "index_show": 0,
      //           "table_name": "ACM1",
      //           "table_column": "ThisMonth_KWH"
      //         },
      //     ],
      // },
      // ],
      deviceindexinfo.forEach(el => {
        //設定定位class名稱 例device-G1-position
        el.position_class = `device-${el.value}-position`;
        new_item = el.item.filter((el_2) => {
          return el_2.index_show != 0
        })
        el.item = new_item

        arr.push(el);
      });
      return arr
    },
  },

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "智慧戰情室");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    // this.$q.loading.show();
    // this.loop();
  },
  methods: {
    fnInitial(cfg) {
      this.IsSoftStartup = true; // cfg載入完成時執行第一次
    },
    //首頁輪巡
    loop() {
      this.loadData();
      setTimeout(() => {
        this.loop();
      }, 1000 * 10);
    },
    loadData() {
      let that = this;
      var params = {
        Action: "LoadData",
        Datas: {},
      };
      return that.FnWebAPIGet(params).then((res) => {
        if (res.data.result) {
          var resData = res.data.data;
          if (resData.length != 0) {
            //車、洗床工單總資訊處理
            that.machine_info.wo_qty_total = resData["work_order_wo_qty_total"]
            that.machine_info.real_qty_total = resData["work_order_real_qty_total"]
            that.machine_info.work_availability = resData["work_availability"]
            that.machine_info.total_unwork_time_month = resData["total_unwork_time_month"]
            this.easy_table.data.table_1 = [];
            this.easy_table.data.table_2 = [];
            if (resData["table"].length > 0) {
              resData["table"].forEach((el, inx) => {
                if (inx >= (resData["table"].length / 2)) {
                  this.easy_table.data.table_2.push(el);
                } else {
                  this.easy_table.data.table_1.push(el);
                }
              });
            }
          }
          this.$q.loading.hide();

        } else {
          that.FnNotify(res.data.message, "error");
        }
      });
    },
  },
};
