var $ramda = R;
/*
 氣象資料開發平台 http://opendata.cwb.gov.tw/usages
 依賴 jquery 套件 (https://jquery.com/), 需宣告 $ 變數為 jquery 實際
 UDN:     $ (設定公用變數, CDN可參考: https://code.jquery.com/jquery-1.12.4.min.js)
 WEBPACK: import $ from 'jquery' or var $ = require('jquery')
 依賴 ramda 套件 (https://ramdajs.com/), 需宣告 $ramda 變數為 ramda 實體
 UDN:     var $ramda = R (設定公用變數, CDN可參考: https://cdnjs.cloudflare.com/ajax/libs/ramda/0.25.0/ramda.js)
 WEBPACK: const $ramda = require('ramda')
 如何使用:
  import $weather from 'src/libs/weather'
  var w = $weather('http://localhost:8019/proxy/weather/')
  w.Get(function (data) {
    console.log(data)
  })
  結果:
  {
    "嘉義縣": {
      "Wx": {
        "startTime": "2018-09-20 12:00:00",
        "endTime": "2018-09-20 18:00:00",
        "text": "多雲",
        "value": "2",
        "codeKey": 2,
        "codeText": "多雲"
      },
      "PoP": {
        "startTime": "2018-09-20 12:00:00",
        "endTime": "2018-09-20 18:00:00",
        "value": "10",
        "unit": "百分比"
      },
      "MinT": {
        "startTime": "2018-09-20 12:00:00",
        "endTime": "2018-09-20 18:00:00",
        "value": "29",
        "unit": "C"
      },
      "CI": {
        "startTime": "2018-09-20 12:00:00",
        "endTime": "2018-09-20 18:00:00",
        "text": "悶熱"
      },
      "MaxT": {
        "startTime": "2018-09-20 12:00:00",
        "endTime": "2018-09-20 18:00:00",
        "value": "32",
        "unit": "C"
      }
    }, ...
  }
*/
// =========================================================================
function WeatherAPI (sUrl) {
  var apiUrl = location.protocol + '//' + location.hostname + ':8019/proxy/weather/'
  var dataApi = 'F-C0032-001' // 一般天氣預報-今明36小時天氣預報
  /*
    中央氣象局編號 http://opendata.cwb.gov.tw/opendatadoc/MFC/A0012-001.pdf
    晴天 => 1
    多雲 => 2
    陰天 => 3, 4, 5, 6, 7, 8
    下雨 => 12, 13, 17, 18, 24, 26, 31, 34, 36
    有霧 => 43, 44, 45, 46, 49, 57, 58, 59, 60
  */
  var wxCodeMap = [
    {'code': 1, 'min': 1, 'max': 1, text: '晴天'},
    {'code': 2, 'min': 2, 'max': 2, text: '多雲'},
    {'code': 3, 'min': 3, 'max': 10, text: '陰天'},
    {'code': 4, 'min': 11, 'max': 40, text: '下雨'},
    {'code': 5, 'min': 41, 'max': 60, text: '有霧'}
  ]

  var srcData = {} // opendata的資料格式
  var rstData = {} // 整理後的資料格式
  if (!$ramda.isNil(sUrl) && !$ramda.isEmpty(sUrl) && $ramda.is(String, sUrl) && sUrl !== '') {
    apiUrl = sUrl
  }
  var settings = {
    'async': true,
    'crossDomain': true,
    'url': '',
    'dataType': 'json',
    'method': 'GET',
    'cache': false
  }
  function getAjax (dataapi) {
    settings['url'] = apiUrl + dataapi
    return $.ajax(settings)
  }
  var procData = $ramda.pipe($ramda.map(function (itm) {
    return itm
  }),
  $ramda.reduce(function (cityMap, city) {
    cityMap[city['locationName']] = $ramda.reduce(function (itmMap, itm) {
      var v
      switch (itm['elementName']) {
        case 'Wx': // 天氣
          var wxValue = itm['time'][0]['parameter']['parameterValue']
          var wxCodeObj = $ramda.filter(function (c) {
            if (wxValue >= c['min'] && wxValue <= c['max']) {
              return true
            }
            return false
          }, wxCodeMap)
          v = {
            'startTime': itm['time'][0]['startTime'],
            'endTime': itm['time'][0]['endTime'],
            'text': itm['time'][0]['parameter']['parameterName'],
            'value': itm['time'][0]['parameter']['parameterValue'],
            'codeKey': wxCodeObj[0]['code'],
            'codeText': wxCodeObj[0]['text']
          }
          break
        case 'MaxT': // 最高溫
          v = {
            'startTime': itm['time'][0]['startTime'],
            'endTime': itm['time'][0]['endTime'],
            'value': itm['time'][0]['parameter']['parameterName'],
            'unit': itm['time'][0]['parameter']['parameterUnit']
          }
          break
        case 'MinT': // 最低溫
          v = {
            'startTime': itm['time'][0]['startTime'],
            'endTime': itm['time'][0]['endTime'],
            'value': itm['time'][0]['parameter']['parameterName'],
            'unit': itm['time'][0]['parameter']['parameterUnit']
          }
          break
        case 'PoP': // 降雨機率
          v = {
            'startTime': itm['time'][0]['startTime'],
            'endTime': itm['time'][0]['endTime'],
            'value': itm['time'][0]['parameter']['parameterName'],
            'unit': itm['time'][0]['parameter']['parameterUnit']
          }
          break
        case 'CI': // 體感
          v = {
            'startTime': itm['time'][0]['startTime'],
            'endTime': itm['time'][0]['endTime'],
            'text': itm['time'][0]['parameter']['parameterName']
          }
          break
        default:
          v = itm['time'][0]
      }
      itmMap[itm['elementName']] = v
      return itmMap
    }, {}, city['weatherElement'])
    return cityMap
  }, {}))
  return {
    Get: function (callback) {
      getAjax(dataApi).then(function (response) {
        srcData = response
        rstData = procData(srcData['records']['location'])
        if (!$ramda.isNil(callback) && !$ramda.isEmpty(callback) && typeof callback === 'function') {
          callback(rstData)
        }
      })
    },
    GetSrcData: function () {
      return srcData
    },
    GetRstData: function () {
      return rstData
    }
  }
}
// =========================================================================