<?php

// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{

	//=====================================================================================
	// 取得電錶設定檔清單
	//=====================================================================================
	public function SelectMeterDetailsList($input)
	{
		$rtn = array(
			"selects" => array(),
			"meters"  => array(),
			"floors"  => array()
		);
		$selects = array();
		if ($file_meters = glob("./../cfg/AC_Meter/*.csv")) {
			foreach ($file_meters as $fpath) {
				## 檔案解析
				$tmp = explode('__', pathinfo($fpath, PATHINFO_FILENAME));
				## 宣告陣列
				if (!isset($selects[$tmp[0]]))
					$selects[$tmp[0]] = array();
				## 下拉選單資訊
				$selects[$tmp[0]][] = array("value" => str_replace("-", "_", $tmp[1]), "tagDef" => sprintf("AC_Meter/%s", pathinfo($fpath, PATHINFO_FILENAME)));
			}
		}
		$rtn["selects"] = $selects;
		$rtn["meters"] = $this->SelectMeterName();
		$rtn["floors"] = $this->SelectFloorName();
		return $rtn;
	}

	//=====================================================================================
	// 取得電錶名稱 (TableOrder)
	//=====================================================================================
	public function SelectMeterName()
	{
		$condition = "";
		if (isset($input["Meters"]) && strlen($input["Meters"])) {
			$condition .= sprintf(" AND ColumnTable IN ('%s')", implode("', '", explode(",", $input["Meters"])));
		}

		if (isset($input["IsExtra"]) && in_array(strtolower($input["IsExtra"]), array("t"))) {
			$condition .= " AND IsExtra = 1";
		}

		$sql = sprintf("SELECT ColumnTable, ColumnName FROM %s.dbo.TableOrder WHERE 1 = 1 %s", $this->database_trend, $condition);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		return $sth->fetchAll(PDO::FETCH_ASSOC);
	}

	//=====================================================================================
	// 取得樓層名稱
	//=====================================================================================
	public function SelectFloorName()
	{
		$condition = "";
		if (isset($input["Floors"]) && strlen($input["Floors"])) {
			$condition .= sprintf(" AND Floor_Name like ('%%%s')", implode("', '", explode(",", $input["Floors"])));
		}

		$sql = sprintf("SELECT 
							RTRIM(Floor_Code) AS Floor_Code,
							Floor_Name,
							ColumnTable,
							FORMAT(Floor_Area, '0.00') AS Floor_Area
						FROM 
							%s.dbo.Floor 
						WHERE 1 = 1 %s
						ORDER BY Display_Order ASC", $this->database_trend, $condition);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		$rtn = $sth->fetchAll(PDO::FETCH_ASSOC);
		if (isset($input["Formula"]) && in_array(strtolower($input["Formula"]), array("t"))) {
			$rtn["Formula"] = $this->GetFormulaByFloorCode();
		}
		return $rtn;
	}

	//=====================================================================================
	// 取得指定樓層的計算式 (這邊或許用不到)
	//=====================================================================================
	private function GetFormulaByFloorCode($code = "*")
	{
		$setup = getIniFile("../cfg/System", "Floor_Formulas");
		$rtns = array(
			"light"  => "",
			"socket" => "",
			"motion" => ""
		);
		if (isset($setup["Floor_Formulas"]) && $setup["Floor_Formulas"]) {
			if ($code == "*") {
				$rtns = array(
					"light"  => array(),
					"socket" => array(),
					"motion" => array()
				);
				return array_merge($rtns, $setup["Floor_Formulas"]);
			}
			foreach (array_keys($rtns) as $k) {
				if (isset($setup["Floor_Formulas"][$k][$code]) && strlen(trim($setup["Floor_Formulas"][$k][$code]))) {
					$rtns[$k] = $setup["Floor_Formulas"][$k][$code];
				}
			}
		}
		return $rtns;
	}

}
