<!DOCTYPE html>
<html lang="zh-tw">

<head><?php
      // 引用 head.inc
      include_once "html_head.inc";
      ?></head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
    <?php
    // include_once "html_menu.inc";
    include_once "html_layout_header.inc";
    ?>
    <div class="container">
      <!-- 內容區域 //-->

      <div class="custom-table bg-color-White">
        <ve-table max-height="calc(100vh - 200px)" style="width:100%" :scroll-width="0" :border-around="false" border-y :columns="tableColumns" :cell-style-option="easy_table.cellStyleOption" :table-data="tableData">
        </ve-table>
        <div class="custom-table-pagination row justify-end">
          <ve-pagination :total="totalCount" :page-index="easy_table.pageIndex" :page-size="easy_table.pageSize" @on-page-number-change="pageNumberChange" @on-page-size-change="pageSizeChange" />
        </div>
      </div>

      <!--表單-->

      <q-modal v-model="formPageSet['view']" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss :content-css="{ maxHeight: '80vh'}">

        <q-modal-layout header-class="modal-theme modal-themes" footer-class="modal-theme">


          <div slot="header">
            <div class="bg-primary text-white row" style="justify-content: space-between;">
              <div class="row col items-center justify-center">
                <h6 class="layout-header">頁面權限設定</h6>
              </div>
              <div style="display:flex; align-items: center;">
                <span class="material-icons dialog-close" style="padding: 0px 10px;" @click="formPageSet['view'] = false">close</span>
              </div>
            </div>
          </div>
          <div class="modal-scroll-box">
            <div v-for="(item ,idx) in formPageSet['tempPageName']">
              <span v-if="item['children'] == undefined || item['children'] != []">
                <q-checkbox v-if="item['show_check']" @input="checkbox_link(`${idx}`)" v-model="formPageSet['tempSelectUse']" :disable="formPageSet['edit']" :val="item['menu_id']" class="q-mr-sm">
                </q-checkbox>
                <!-- <span class="material-icons">{{ item['icon'] }}</span> -->
                {{ $t('menu.'+item['menu_id']) }}
              </span>
              <div v-if="item['function'] != undefined || item['function'] != []" class="row q-ml-lg">
                <span v-for="(func_item ,func_idx) in item['function']">
                  <q-checkbox v-model="formPageSet['tempSelectUse']" @input="checkbox_link(`${idx}.${func_idx}`)" :disable="formPageSet['edit']" :val="item['menu_id']+'.'+func_item" class="q-mr-sm">
                    {{ $t('sys.'+func_item) }}
                  </q-checkbox>
                </span>
              </div>
              <div v-if="item['children'] != undefined" style="display: flex;flex-flow: column wrap;">
                <div v-for="(item2 ,idx2) in item['children']" class="column q-ml-lg">
                  <span>
                    <q-checkbox v-model="formPageSet['tempSelectUse']" @input="checkbox_link(`${idx}-${idx2}`)" :disable="formPageSet['edit']" :val="item2['menu_id']" class="q-mr-sm"></q-checkbox>
                    {{ $t('menu.'+item2['menu_id']) }}
                  </span>
                  <div v-if="item2['function'] != undefined" class="row q-ml-lg">
                    <span v-for="(item3 ,idx3) in item2['function']">
                      <q-checkbox v-model="formPageSet['tempSelectUse']" @input="checkbox_link(`${idx}-${idx2}.${idx3}`)" :disable="formPageSet['edit']" :val="item2['menu_id']+'.'+item3" class="q-mr-sm">
                        {{ $t('sys.'+item3) }}
                      </q-checkbox>
                    </span>
                  </div>
                </div>
              </div>

            </div>
          </div>
          <div class="row" style="margin: 10px; display: flex; justify-content: flex-end;">
            <q-btn glossy color="primary" style="margin: 0px 6%;" :label="$t('sys.edit')" class="id-btn" @click="btnSwitch()" v-if="formPageSet['edit']"></q-btn>
            <q-btn glossy color="green" style="margin: 0px 6%;" :label="$t('sys.update')" class="id-btn" @click="updateRoleMenu()" v-if="formPageSet['update']"></q-btn>
            <q-btn glossy color="red" :label="$t('sys.close')" class="id-btn" @click="formPageSet['view'] = false"></q-btn>
          </div>
        </q-modal-layout>

        <!-- <div class="modal-title">
          <span>頁面權限設定</span>
        </div> -->

        <!-- <div style="display:flex; flex-grow: row; justify-content: center;margin: 20px;">
        </div> -->

      </q-modal>

    </div>






    <!-- <data-table :show-search-field="true" :show-search-btn="false" :show-search-panel="false" :title="$t('menu.admin_page_permission_setting')" :columns="columns" :data="tableData" row-key="name"> -->

    <!-- <template v-slot:row-control="props">
        <q-btn color="primary" :label="$t('sys.view')" @click.native="editUser(props.row_data)"></q-btn>
      </template> -->

    <!-- <template v-slot:row_col_view_page="props">
        <q-btn class="id-btn" glossy color="primary" :label="$t('sys.view')" @click.native="viewRoleId(props.row_data.row)" v-if="pageEditBtn"></q-btn>
      </template> -->


    <!-- </data-table> -->








    <!-- /內容區域 //-->
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  // loading.inc
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_report_download = true;
        // 引用 down.inc
        include_once "html_down.inc";
        ?>

</html>