<header>
  <div class="logo" @click="FnPageSwitch(WebSetup.homeHref)" title="首頁">
    <img :src="WebSetup.logoImg" border="0" /> {{WebSetup.company}}
  </div>
  <div class="h4" v-if="WebSetup.caption">{{WebSetup.caption}}</div>
  <div
    class="menu-btn"
    :title="MenuSetup.opened ? $t('layout.collapse_menu') : $t('layout.expand_menu')"
  >
    <i class="material-icons" @click="MenuSetup.opened = !MenuSetup.opened"
      >{{menuStatus}}</i
    >
  </div>
</header>
<nav :class="['container', 'menu', { 'opened' : MenuSetup.opened }]">
  <div v-if="LoginSetup.required == true">
    <i class="material-icons">person</i>{{LoginSetup.uid}}<br />
    <i class="material-icons">access_time</i
    ><span class="sys-time">{{SystemTime}}</span>
  </div>
  <ul>
    <li
      v-for="(page, i) in MenuSetup.pages"
      v-if="page.visibled == true"
      :class="{ 'opened': page.opened, 'active': menuMain == i }"
      @click="page.subs.length > 0 ? page.opened = !page.opened : FnPageSwitch(page.href)"
    >
      <i v-if="page.icon" class="material-icons">{{page.icon}}</i>{{page.name}}
      <ul v-if="page.subs">
        <li
          v-for="(sub, j) in page.subs"
          :class="{ 'active': menuActives[0] == i && menuActives[0] == j }"
          @click="FnPageSwitch(sub.href)"
        >
          <i v-if="sub.icon" class="material-icons">{{sub.icon}}</i>{{sub.name}}
        </li>
      </ul>
    </li>
    <li v-if="LoginSetup.required == true" @click="FnLogout('user')">
      <i class="material-icons">exit_to_app</i>登出
    </li>
  </ul>
</nav>
<div
  v-if="RealAlarm.Enable == true"
  :class="['RealAlarmIcon', { AlarmActive : RealAlarm.Datas.length > 0 }]"
  @click="RealAlarm.ManuShow = true;"
>
  <i class="material-icons"
    >{{RealAlarm.Datas.length > 0 ? 'notification_important' : 'notifications'
    }}</i
  >
</div>
<q-dialog
  v-if="RealAlarm.Enable == true"
  v-model="realAlarmShow"
  class="RealAlarm"
  prevent-close
>
  <div slot="body">
    <q-table
      :data="RealAlarm.Datas"
      :columns="RealAlarm.Columns"
      :selection="RealAlarm.Selection"
      :selected.sync="RealAlarm.Selected"
      :rows-per-page-options="RealAlarm.RowsPerPageOptions"
      :pagination.sync="RealAlarm.Pagination"
      :class="{ 'Fixed_Row_Num' : RealAlarm.Datas.length > 0 }"
      :row-key="RealAlarm.RowKey"
      no-data-label="目前沒有警報"
    >
      <q-tr slot="header" slot-scope="props">
        <q-th auto-width v-if="localConnected">
          <q-checkbox
            v-if="props.multipleSelect"
            v-model="props.selected"
            indeterminate-value="some"
          ></q-checkbox>
        </q-th>
        <q-th v-for="col in props.cols" :key="col.name" :props="props"
          >{{ col.label }}</q-th
        >
      </q-tr>
      <template slot="body" slot-scope="props">
        <q-tr :props="props">
          <q-td auto-width v-if="localConnected">
            <q-checkbox
              color="primary"
              v-model="props.selected"
              v-if="!props.row.Al_ACK_Time"
            ></q-checkbox>
          </q-td>
          <q-td key="Al_Tag" :props="props">{{ props.row.Al_Tag }}</q-td>
          <q-td key="start_time" :props="props"
            >{{ typeof props.row.Al_Start_Time == "string" ?
            props.row.Al_Start_Time.substr(0, 19) : "" }}</q-td
          >
          <q-td key="ack_time" :props="props"
            >{{ typeof props.row.Al_ACK_Time == "string" ?
            props.row.Al_ACK_Time.substr(0, 19) : "" }}</q-td
          >
          <q-td key="message" :props="props">{{ props.row.Message }}</q-td>
        </q-tr>
      </template>
    </q-table>
  </div>
  <div slot="buttons">
    <q-btn
      v-if="localConnected"
      color="primary"
      label="確 認"
      @click="RealAlarmAck"
    ></q-btn>
    <q-btn
      color="negative"
      label="關 閉"
      @click="RealAlarmTrigger(false)"
    ></q-btn>
  </div>
</q-dialog>
