<!DOCTYPE html>
<html lang="zh-tw">

<head>
  <?php
  include_once "html_head.inc";
  ?>
  <style>
    .index-background {
      position: relative;
      width: 100%;
      height: 100%;
      background-image: url('img/index_background_0.6.png');
      background-size: 100% 100%;
      background-position: center;
      background-repeat: no-repeat;
    }
  </style>
</head>

<body>
  <div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
    <?php
    include_once "html_layout_header.inc";
    ?>
    <div class="container column">
      <div class="index-background">
        <div v-for="device in device_list" class="factory_block" :class="device.position_class">
          <div class="row justify-center items-center bg-blue-6 text-white">
            <div style="margin:0px 5px">
              <span>{{device.label}}</span>
            </div>
          </div>
          <div class="factory_item_block">
            <div v-for="item_data in device.item" class="row items-center factory_item">
              <span class="text-black" style="white-space: nowrap; padding-left: 10px;">{{item_data.label}}</span>
              <div class="row items-center justify-end no-wrap col">
                <span class="text-blue-5" align="right" style="min-width: 90px;">{{SoftTagName[item_data.value]?SoftTagName[item_data.value].value:0}}</span>
                <span class="text-grey-7 bottle-array" align="left" style="min-width: 66px; padding-left: 10px;">{{item_data.unit}}</span>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
    <?php
    include_once "html_layout_footer.inc";
    ?>
  </div>
  <?php
  include_once "html_loading.inc";
  ?>
</body><?php
        $is_report_download = true;
        $is_googlemap = true;
        $is_echarts = true;
        include_once "html_down.inc";
        ?>

</html>