var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "alarm",
      VarMenu: "area",
      VarPageContainerCss: "height:calc(100vh - 65px);",

      search: {
        start_at: new Date(),
        end_at: new Date(),
        machine: "",
      },
      machine_option: [
        { label: "全選", value: "" }
      ],


      //表單表頭樣式設定
      cellStyleOption: {
        headerCellClass: ({ column, rowIndex }) => {
          return "bg-primary text-white custom-table-header";
        },
      },
      //表單分頁
      pageIndex: 1,
      pageSize: 10,
      //表單資料陣列
      table_data: [
        // {
        //   Al_Start_Time: "2024-01-01 00:00:00",
        //   Al_Norm_Time: "2024-01-01 00:00:00",
        //   Al_Tag_Value: "123",
        //   Message: "測試信息",
        // },
      ],
    };
  },

  computed: {
    //表單欄位
    tableColumns() {
      let arr = [
        {
          field: "index",
          label: "項目",
          key: "index",
          title: "#",
          width: 50,
          align: "center",
          align: "center",
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let inx = (this.pageSize * (this.pageIndex - 1)) + rowIndex + 1;
            return inx;
          },
        },
        {
          field: "Al_Start_Time",
          label: "發生時間",
          key: "Al_Start_Time",
          title: "發生時間",
          align: "center",
          width: 150,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            return column.format(column, row);
          },
          format: (column, row) => {
            return moment(row[column.field]).format("YYYY-MM-DD HH:mm:ss");
          },
        },
        {
          field: "Al_Norm_Time",
          label: "復歸時間",
          key: "Al_Norm_Time",
          title: "復歸時間",
          align: "center",
          width: 150,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            return column.format(column, row);
          },
          format: (column, row) => {
            return moment(row[column.field]).format("YYYY-MM-DD HH:mm:ss");
          },
        },
        {
          field: "Message",
          label: "訊息",
          key: "Message",
          title: "訊息",
          align: "center",
          width: 150,
        },
      ];
      return arr;
    },
    //表單資料總數
    totalCount() {
      return this.table_data.length;
    },
    //表單資料分頁邏輯
    tableData() {
      const { pageIndex, pageSize } = this;
      return this.table_data.slice(
        (pageIndex - 1) * pageSize,
        pageIndex * pageSize
      );
    },
  },

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "警報資訊");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    this.loadMachineOptions()
  },

  methods: {
    //  載入各機台下拉選單
    async loadMachineOptions() {
      let that = this;
      var params = {
        Action: "LoadMachineOptions",
        Datas: {},
      }
      that.$q.loading.show();
      await this.FnWebAPIGet(params).then((res) => {
        res.data.data.forEach(el => {
          this.machine_option.push({
            "value": el['vmx_machine_id'],
            "label": el['machine_name']
          })
        })
        this.searchData();
      }).catch(function (err) {
        that.$q.loading.hide();
        console.log(err);
      });
    },

    async searchData() {
      let that = this;
      that.$q.loading.show();
      var params = {
        Action: "Alarm",
        Datas: {
          start_at: this.search.start_at,
          end_at: this.search.end_at,
          machine: this.search.machine
        },
      }
      await this.FnWebAPIGet(params).then((res) => {
        if (res.data.result) {
          let resData = res.data.data;
          this.table_data = resData
          this.$q.loading.hide();

        } else {
          this.FnNotify(res.data.message, 'warning')
          this.$q.loading.hide();
        }
      }).catch(function (err) {
        console.log(err);
      });

    },

    // page number change
    pageNumberChange(pageIndex) {
      this.pageIndex = pageIndex;
    },

    // page size change
    pageSizeChange(pageSize) {
      this.pageIndex = 1;
      this.pageSize = pageSize;
    },
  },
};
