var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "machine_list",
      VarMenu: "area",
      VarPageContainerCss: "height:calc(100vh - 65px);",

      search: {
        start_at: moment().format("YYYY-MM-DD"),
        end_at: moment().format("YYYY-MM-DD"),
        date_type: 1,
      },
      date_type_option: [
        { label: "依工單建立日期", value: 1 },
        { label: "依工單交期", value: 2 }
      ],


      //表單表頭樣式設定
      cellStyleOption: {
        headerCellClass: ({ column, rowIndex }) => {
          return "bg-primary text-white custom-table-header";
        },
      },
      //表單分頁
      pageIndex: 1,
      pageSize: 10,
      //從原版取得資料
      table_data: [],
      //表單資料陣列
      table_data_origin: [
        { table: 1, machine_name: "伸拉機 #0", time_info: "2024-08-20 08:49", operation_rate: 89, immediate_1: 13, immediate_2: 890, unit_1: 'm/min', unit_2: 'pcs' },
        { table: 1, machine_name: "伸拉機 #1 靠牆", time_info: "2024-08-20 08:49", operation_rate: 41, immediate_1: 10, immediate_2: 1020, unit_1: 'm/min', unit_2: 'pcs' },
        { table: 1, machine_name: "伸拉機 #1 中線", time_info: "2024-08-20 08:49", operation_rate: 84, immediate_1: 19, immediate_2: 120, unit_1: 'm/min', unit_2: 'pcs' },
        { table: 1, machine_name: "六坎盤線機", time_info: "2024-08-20 08:49", operation_rate: 48, immediate_1: 20, immediate_2: 49, unit_1: 'm/min', unit_2: 'kg' },
        { table: 1, machine_name: "伸拉機 #1 靠路", time_info: "2024-08-20 08:49", operation_rate: 26, immediate_1: 19, immediate_2: 630, unit_1: 'm/min', unit_2: 'pcs' },
        { table: 1, machine_name: "盤線機 #1", time_info: "2024-08-20 08:49", operation_rate: 17, immediate_1: 22, immediate_2: 51, unit_1: 'm/min', unit_2: 'kg' },
        { table: 1, machine_name: "盤線機 #2", time_info: "2024-08-20 08:49", operation_rate: 24, immediate_1: 19, immediate_2: 26, unit_1: 'm/min', unit_2: 'kg' },
        { table: 1, machine_name: "盤線機 #3", time_info: "2024-08-20 08:49", operation_rate: 69, immediate_1: 18, immediate_2: 47, unit_1: 'm/min', unit_2: 'kg' },
        { table: 1, machine_name: "盤線機 #4", time_info: "2024-08-20 08:49", operation_rate: 78, immediate_1: 21, immediate_2: 23, unit_1: 'm/min', unit_2: 'kg' },
        { table: 1, machine_name: "盤線機 #5", time_info: "2024-08-20 08:49", operation_rate: 82, immediate_1: 15, immediate_2: 19, unit_1: 'm/min', unit_2: 'kg' },
        { table: 2, machine_name: "舊導角機", time_info: "2024-08-20 08:49", operation_rate: 88, immediate_2: 890, unit_2: 'pcs' },
        { table: 2, machine_name: "新導角機", time_info: "2024-08-20 08:49", operation_rate: 41, immediate_2: 1020, unit_2: 'pcs' },
        { table: 2, machine_name: "2號伸拉機", time_info: "2024-08-20 08:49", operation_rate: 81, immediate_1: 19, immediate_2: 120, unit_1: 'm/min', unit_2: 'pcs' },
        { table: 2, machine_name: "兩輥矯直機", time_info: "2024-08-20 08:49", operation_rate: 48, immediate_1: 20, immediate_2: 49, unit_1: 'm/min', unit_2: 'kg' },
        { table: 2, machine_name: "兩輥矯直機", time_info: "2024-08-20 08:49", operation_rate: 26, immediate_1: 19, immediate_2: 630, unit_1: 'm/min', unit_2: 'pcs' },
        { table: 2, machine_name: "鍊拉機(含切台)", time_info: "2024-08-20 08:49", operation_rate: 17, immediate_2: 51, unit_2: 'kg' },
        { table: 2, machine_name: "鍊拉機(含切台)", time_info: "2024-08-20 08:49", operation_rate: 24, immediate_2: 26, unit_2: 'kg' },
        { table: 2, machine_name: "公頻爐", time_info: "2024-08-20 08:49", operation_rate: 69, soft_1: 'im1_1', soft_2: 'im2_1', unit_1: 'kWh', unit_2: '\u2103' },
        { table: 2, machine_name: "擠台", time_info: "2024-08-20 08:49", operation_rate: 78, soft_1: 'im1_2', soft_2: 'im2_2', unit_1: 'kWh', unit_2: '\u2103' },
        { table: 2, machine_name: "13MT 高週波溶解", time_info: "2024-08-20 08:49", operation_rate: 82, soft_1: 'im1_3', soft_2: 'im2_3', unit_1: 'kWh', unit_2: '\u2103' },
        { table: 2, machine_name: "2MT 低周波溶解", time_info: "2024-08-20 08:49", operation_rate: 82, soft_1: 'im1_4', soft_2: 'im2_4', unit_1: 'kWh', unit_2: '\u2103' },
      ],

      //累積數值 
      //_o 對應operation_rate
      //_i 對應immediate_2
      //immediate_1 為浮動

      sec_count: 0,

      check_sec_o: 5, //檢驗間隔
      numbers_o: Array(21).fill(0),  // 初始化20個數字，每個數字初始值為0
      increments_left_o: Array(21).fill(10),  // 每個數字最多增加10次

      check_sec_i: 7, //檢驗間隔
      numbers_i: Array(17).fill(0),  // 初始化20個數字，每個數字初始值為0
      increments_left_i: Array(17).fill(10),  // 每個數字最多增加10次

    };
  },

  computed: {
    tableColumns() {
      let arr = [
        {
          field: "no",
          key: "no",
          title: "No.",
          align: "center",
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let temp = row.table == 1 ? rowIndex + 1 : this.tableData.part_2.length + rowIndex;
            return temp;
          }
        },
        {
          field: "machine_name",
          key: "machine_name",
          title: "機台名稱",
          align: "center",
        },
        {
          field: "time_info",
          key: "time_info",
          title: "時間資訊",
          align: "center",
        },
        {
          field: "operation_rate",
          key: "operation_rate",
          title: "稼動率",
          align: "center",
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let temp = row.operation_rate ? row.operation_rate + " %" : "";
            return temp;
          }
        },
        {
          field: "immediate_1",
          key: "immediate_1",
          title: "即時值",
          align: "center",
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let temp = row.immediate_1 ? row.immediate_1 + " " + row.unit_1 : "";
            if (this.SoftTagName[row.soft_1]) {
              temp = this.SoftTagName[row.soft_1].value + " " + row.unit_1;
            }
            return temp;
          },
        },
        {
          field: "immediate_2",
          key: "immediate_2",
          title: "即時值",
          align: "center",
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let temp = row.immediate_2 ? row.immediate_2 + " " + row.unit_2 : "";
            if (this.SoftTagName[row.soft_2]) {
              temp = this.SoftTagName[row.soft_2].value + " " + row.unit_2;
            }
            return temp;
          },
        },
      ];
      return arr;
    },
    tableData() {
      this.table_data = _.cloneDeep(this.table_data_origin);
      let temp = {
        part_1: [],
        part_2: [],
      };
      let sec = this.sec_count;

      _.each(this.table_data, (item, key) => {

        item.operation_rate += this.numbers_o[key] || 0;

        if (item.immediate_1) {
          item.immediate_1 += Math.floor(Math.random() * 10);
        }
        // if (item.immediate_2) {
        //   item.immediate_2 += Math.floor(Math.random() * 20);
        // }
        item.immediate_2 += this.numbers_i[key] || 0;

        if (item.table == 1) {
          temp.part_1.push(item);
        } else if (item.table == 2) {
          temp.part_2.push(item);
        }
      })
      return temp;
    },

  },

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", this.$t("menu.machine_list"));
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    this.fn_acc_sec();
  },

  methods: {
    fnInitial(cfg) {
			this.IsSoftStartup = true; // cfg載入完成時執行第一次
		},
    fn_acc_sec() {
      setTimeout(() => {
        this.sec_count++;

        // 兩項檢驗間隔 必須檢查是否錯開

        // 每段檢驗間隔 檢查是否需要進行數字加1的操作
        if (this.sec_count % this.check_sec_o == 0) {
          this.try_increment_numbers_o();
        }

        // 每段檢驗間隔 檢查是否需要進行數字加1的操作
        if (this.sec_count % this.check_sec_i == 0) {
          this.try_increment_numbers_i();
        }

        this.fn_acc_sec();
      }, 1000);
    },

    try_increment_numbers_o() {
      // 隨機選擇要增長的索引
      const index = Math.floor(Math.random() * this.numbers_o.length);

      // 確保該索引還有增量可以使用
      if (this.increments_left_o[index] > 0) {
        this.numbers_o[index]++;  // 將該數字增加1
        this.increments_left_o[index]--;  // 減少該數字剩餘可增量次數
      }
      console.log(this.sec_count + '秒 o增加陣列:');
      console.log(this.numbers_o);
    },

    try_increment_numbers_i() {
      // 隨機選擇要增長的索引
      const index = Math.floor(Math.random() * this.numbers_i.length);

      // 確保該索引還有增量可以使用
      if (this.increments_left_i[index] > 0) {
        this.numbers_i[index]++;  // 將該數字增加1
        this.increments_left_i[index]--;  // 減少該數字剩餘可增量次數
      }
      console.log(this.sec_count + '秒 i增加陣列:');
      console.log(this.numbers_i);
    }


  },
};
