<!DOCTYPE html>
<html lang="zh-tw">

<head><?php
		// 引用 head.inc
		include_once "html_head.inc";
		?></head>

<body>
	<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
		<?php
		// include_once "html_menu.inc";
		include_once "html_layout_header.inc";
		?>
		<!-- 內容區域 //-->

		<div class="container">
			<div class="SwitchPage">
				<div :style="tab == 'meter' ? {borderBottom:'5px solid #244BC3'}: {paddingBottom:'5px'}">
					<q-btn flat :text-color="tab == 'meter' ? 'black': 'grey-5'" label="上限設定-電錶" @click="changeTab('meter')" class="tab-btn"></q-btn>
				</div>
				<div :style="tab == 'device' ? {borderBottom:'5px solid #244BC3'}: {paddingBottom:'5px'}">
					<q-btn flat :text-color="tab == 'device' ? 'black': 'grey-5'" label="限值設定-設備" @click="changeTab('device')" class="tab-btn"></q-btn>
				</div>
				<div :style="tab == 'carbon' ? {borderBottom:'5px solid #244BC3'}: {paddingBottom:'5px'}">
					<q-btn flat :text-color="tab == 'carbon' ? 'black': 'grey-5'" label="碳排係數-碳排" @click="changeTab('carbon')" class="tab-btn"></q-btn>
				</div>
			</div>
			<div v-show="tab == 'meter'">
				<div id="electricity_area_header" class="row justify-start">
					<div class="header_right_border">
						<div class="header_right_block row items-center">
							<div class="row items-center">
								<span class="material-icons">
									grid_view
								</span>
								顯示區域：
							</div>
							<div>
								<q-select v-model="area_select" chips-bg-color="#028fd5" placeholder="請選擇區域" hide-underline :options="selectOptions"  />
							</div>
						</div>
					</div>
				</div>
				<div class="w3-row" style="margin: 1%;">
					<div class="w3-col l3 s3 m3" v-for="(v,k) in deviceLimitOptions[area_select]" v-if="SoftTagName[`${v.value}_on`]">
						<div id="page2-meter" class="demand-card">
							<div style="display: flex; justify-content:space-between; align-items:center;">
								<div>
									<span class="meter-title">
										{{v.label}}
									</span>
								</div>
								<div>
									<div class="model-switch" v-if="SoftTagName[`${v.value}_on`]">
										<div data-str="關閉" class="checkbox" @click="fnOnOff(`${v.value}_on`)">
											<input type="checkbox" v-model="SoftTagName[`${v.value}_on`].value">
											<label data-str="提醒"></label>
										</div>
									</div>
								</div>
							</div>
							<div class="card-input">
								<div style="width:43%;">
									<span class="demand-label">警示值</span>
								</div>
								<soft-item v-if="pageSoftTag[`${v.value}_H`]" @soft_modify="fnSoftMeter" :data-array="[pageSoftTag[`${v.value}_H`]]" :soft-values="SoftPoints" style="width: 100%; height:100%;"></soft-item>
								<span style="width:14%;">kWh</span>
							</div>
							<div class="card-input">
								<div style="width:43%; ">
									<span class="demand-label">延遲時間</span>
								</div>
								<soft-item v-if="pageSoftTag[`${v.value}_sec`]" @soft_modify="fnSoftMeter" :data-array="[pageSoftTag[`${v.value}_sec`]]" :soft-values="SoftPoints" style="width: 100%; height:100%;"></soft-item>
								<span style="width:14%;">sec</span>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div v-show="tab == 'device'">
				<div>
					<div class="col custom-table " style="box-shadow: unset; ">
						<ve-table :fixed-header="true" class="full-width" :border-around="false" border-y :columns="tableColumns" :cell-style-option="cellStyleOption" :table-data="table_data">
						</ve-table>
					</div>
				</div>

			</div>
			<div v-show="tab == 'carbon'" class="demand-border">
				<div id="page3-Carbon" class="demand-card">
					<div class="demand-title">
						<span class="material-icons demand-icon">
							public
						</span>
						<span style="font-weight:800;font-size:20px;">
							碳排係數設定
						</span>
					</div>
					<div style="display:flex; justify-content: center; align-items:center;" class="card-input">
						<div id="plant1" @click="set_data()" class="area-block-t">
							<div class="custom-input">
								<div title="plant1" style="cursor: pointer;">
									<span data-type="data" :data-value="carbon_conversion" data-unit=""></span>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<!-- 新增、修改 -->

			<q-modal v-model="dialog.show" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss :content-css="{minWidth: '60vw', maxheight: '80vh'}">
				<q-modal-layout class="custom-modal column" footer-class="log_history_footer">
					<!-- header -->
					<div class="bg-primary text-white modal-title" slot="header">
						<div class="row">
							<div class="row col items-center justify-center q-pa-sm" style="padding-left:5%;">
								<span> 設備限值-參數設定 </span>
							</div>
							<div class="row items-center">
								<span class="material-icons dialog-close q-px-sm cursor-pointer" @click="close_dialog('cancel')">close</span>
							</div>
						</div>
					</div>
					<!-- footer -->
					<div class="row justify-end q-ma-sm" slot="footer">
						<q-btn glossy color="light" label="取消" class="q-mx-sm" @click="close_dialog('cancel')"></q-btn>
						<q-btn glossy color="green" :label="'儲存'" class="q-mx-sm" @click="save_dialog()"></q-btn>
					</div>
					<!-- content -->
					<div class="column items-center">
						<div class="row full-width">
							<div class="w3-half row justify-end">
								<div class="search-block">
									<div class="search-block-label">
										<label class="text-center" style="width: 140px;">設備名稱</label>
									</div>
									<q-input v-model="dialog.data.device_name" align="center" style="width: 250px;" class="col search-block-input" hide-underline readonly></q-input>
									<!-- <q-select v-model="dialog.data.device_name" hide-underline align="center" :options="options.device" style="width: 250px;" class="col search-block-input"></q-select> -->
								</div>
							</div>
							<div class="w3-half row justify-start">
								<div class="search-block">
									<div class="search-block-label">
										<label class="text-center" style="width: 140px;">模式</label>
									</div>
									<q-select v-model="dialog.data.mode" hide-underline align="center" :options="options.mode" style="width: 250px;" class="col search-block-input"></q-select>
								</div>
							</div>
						</div>
						<div class="row full-width">
							<div class="w3-half row justify-end">
								<div :class="[dialog.data.mode == '0' ? 'pointer-events-none' : '']">
									<div class="search-block">
										<div class="search-block-label">
											<label class="text-center" style="width: 140px;">自動排程(起)</label>
										</div>
										<date-picker style="width: 250px;" class="col search-block-input" v-model="dialog.data.start_time" format="HH:mm" type="time" value-type="format" @change="handleChange" :open.sync="date_picker_open[0]" :editable = "false" :clearable="false"></date-picker>
									</div>
								</div>
							</div>
							<div class="w3-half row justify-start">
								<div :class="[dialog.data.mode == '0' ? 'pointer-events-none' : '']">
									<div class="search-block">
										<div class="search-block-label">
											<label class="text-center" style="width: 140px;">自動排程(迄)</label>
										</div>
										<date-picker style="width: 250px;" class="col search-block-input" v-model="dialog.data.end_time" format="HH:mm" type="time" value-type="format" @change="handleChange" :open.sync="date_picker_open[1]" :editable = "false" :clearable="false"></date-picker>
									</div>
								</div>
							</div>
						</div>
						<div class="full-width q-pa-sm w3-border">
							<div :class="[dialog.data.mode == '1' ? 'pointer-events-none' : '']">
								<div class="row justify-start items-center q-px-sm">
									<div class="q-pb-xs">
										<span>全部啟停：</span>
									</div>
									<div class="model-switch q-pt-sm relative-position cursor-pointer" @click="switch_confirm(dialog.data)">
										<div class="hidden-input"></div>
										<div data-str="啟動" class="checkbox">
											<input type="checkbox" :checked="all_switch_list[dialog.data.device_key]">
											<label data-str="啟動"></label>
										</div>
									</div>
								</div>
							</div>
							<div class="full-width col custom-table " style="box-shadow: unset; ">
								<ve-table :fixed-header="true" max-height="400px" class="full-width" :border-around="false" border-y :columns="tableColumns_dialog" :cell-style-option="cellStyleOption" :table-data="table_data_dialog">
								</ve-table>
							</div>
						</div>
					</div>
				</q-modal-layout>

			</q-modal>

		</div>
		<!-- /內容區域 //-->
		<?php
		include_once "html_layout_footer.inc";
		?>
	</div>
	<?php
	// loading.inc
	include_once "html_loading.inc";
	?>
</body><?php
		$is_report_download = true;
		// 引用 down.inc
		include_once "html_down.inc";
		?>

</html>