<?php


date_default_timezone_set('Asia/Taipei');
require_once "Parameters.php";

$dsn_trend = sprintf("sqlsrv:Server=%s; Database=%s;", $DataSource, $DataBase_Trend);
$pdo_trend = new PDO($dsn_trend, $UserID, $Password);

try {
    $dsn_trend = sprintf("sqlsrv:Server=%s;Database=%s;", $DataSource, $DataBase_Trend);
    $pdo_trend = new PDO($dsn_trend, $UserID, $Password);
    // 設定錯誤模式為異常模式
    $pdo_trend->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "good";
} catch (PDOException $e) {
    // 捕捉並顯示錯誤訊息
    echo "bad: " . $e->getMessage();
}

$sql_use_db = "USE [jicond_Trend];";
$pdo_trend->exec($sql_use_db);

$sql = sprintf(
	"
	Declare @Factory Nvarchar(20) = '1'			-- 一廠
	Declare @TimeRangeId Tinyint = 1			-- 每日
	Declare @StartDate Date = GETDATE()
	Declare @EndDate Date = GETDATE()
	Declare @myDate Date
	Set @myDate = @StartDate
	While @myDate <= @EndDate
	Begin
		Exec usp_FactoryPowerAmt @Factory, @TimeRangeId, @myDate
		Set @myDate = Dateadd(Day, 1, @myDate)
	End
	DECLARE @startTime datetime = CONVERT(datetime, CONVERT(date, GETDATE())); -- 今日的 00:00:00
	DECLARE @endTime datetime = DATEADD(SECOND, -1, DATEADD(DAY, 1, @startTime)); -- 今日的 23:59:59
	EXEC udf_InsertOrUpdateACM_Daily_KWH @startTime, @endTime;
	"
);

$sth = $pdo_trend->prepare($sql);
$sth->execute();

