<?php

// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	//撈取空壓機設備清單
	public function Selectair_compressor_device_list($params)
	{

		// 區域
		$s_region = (string) $params["region"];
		$s_region = trim($s_region);
		// 資產編號
		$s_asset_number = (string) $params["asset_number"];
		$s_asset_number = trim($s_asset_number);
		// 設備名稱
		$s_device_name = (string) $params["device_name"];
		$s_device_name = trim($s_device_name);

		$a_where_arr = []; //sql條件陣列 
		$a_where_arr_val = [];
		$s_where_arr = ""; //sql條件字串，用$a_where_arr條件陣列轉換而來

		// 去除已刪除的設備
		$a_where_arr[] =  "_acd.deleted_at IS NULL";


		// 區域 - 查詢條件
		if ($s_region != "") {
			$a_where_arr[] =  "_acd.region LIKE '%$s_region%'";
		}
		// 資產編號 - 查詢條件
		if ($s_asset_number != "") {
			$a_where_arr[] =  "_acd.asset_number LIKE '%$s_asset_number%'";
		}
		// 設備名稱 - 查詢條件
		if ($s_device_name != "") {
			$a_where_arr[] =  "_acd.device_name LIKE '%$s_device_name%'";
		}

		//sql條件陣列轉換
		if (!empty($a_where_arr)) {
			$s_where_arr = " WHERE " . implode(" AND ", $a_where_arr);
		}

		$res = [];

		$sql = sprintf(
			"SELECT	
				_acd.id
				,_acd.region
				,_acd.asset_number
				,_acd.device_category
				,_acd.device_name
				,_acd.brand
				,_acd.model_type
				,_acd.model_number
				,_acd.horsepower
				,_acd.quantity
				,_acd.created_at
				,_acd.created_by
				,_acd.updated_at
				,_acd.updated_by
			FROM
				[%s].[dbo].[air_compressor_device] AS _acd
			%s
			",
			$this->database_alarm,
			$s_where_arr
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute($a_where_arr_val);
		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		foreach ($rows as $k => $v) {
			$v["updated_at"] = empty($v["updated_at"]) ? "" : date("Y-m-d H:i:s", strtotime($v["updated_at"]));
			//數值資料整理
			$v["horsepower"] = (float) number_format($v["horsepower"], 2, ".", "");
			$v["quantity"] = (float) number_format($v["quantity"], 2, ".", "");
			$res[] = $v;
		}
		return $res;
	}

	//撈取空壓機設備資料(修改空壓機設備資料用)
	public function Selectget_air_compressor_device_info($params)
	{
		//空壓機設備表主鍵
		$s_air_compressor_device_id = $params["air_compressor_device_id"];
		$s_air_compressor_device_id = trim($s_air_compressor_device_id);

		if ($s_air_compressor_device_id == "") {
			throw new Exception("空壓機設備資料異常", 1);
		}

		$sql = sprintf(
			"SELECT
				_acd.id
				,_acd.region
				,_acd.asset_number
				,_acd.device_category
				,_acd.device_name
				,_acd.brand
				,_acd.model_type
				,_acd.model_number
				,_acd.horsepower
				,_acd.quantity
				,_acd.created_at
				,_acd.created_by
				,_acd.updated_at
				,_acd.updated_by
			FROM
				[%s].[dbo].[air_compressor_device] AS _acd
			WHERE
				_acd.id = :id AND
				_acd.deleted_at IS NULL
			",
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			"id" => $s_air_compressor_device_id
		]);
		$row = $sth->fetch(PDO::FETCH_ASSOC);
		//數值資料整理
		$row["horsepower"] = (float) number_format($row["horsepower"], 2, ".", "");
		$row["quantity"] = (float) number_format($row["quantity"], 2, ".", "");

		return $row;
	}

	//儲存空壓機設備資料
	public function Changesave_air_compressor_device($params)
	{
		//空壓機設備表主鍵 (新增的話為 null)
		$s_air_compressor_device_id = (string) $params["air_compressor_device_id"];
		$s_air_compressor_device_id = trim($s_air_compressor_device_id);

		// 區域
		$s_region = (string) $params["region"];
		$s_region = trim($s_region);
		// 資產編號
		$s_asset_number = (string) $params["asset_number"];
		$s_asset_number = trim($s_asset_number);
		// 設備類別
		$s_device_category = (string) $params["device_category"];
		$s_device_category = trim($s_device_category);
		// 設備名稱
		$s_device_name = (string) $params["device_name"];
		$s_device_name = trim($s_device_name);
		// 廠牌
		$s_brand = (string) $params["brand"];
		$s_brand = trim($s_brand);
		// 型式
		$s_model_type = (string) $params["model_type"];
		$s_model_type = trim($s_model_type);
		// 型號
		$s_model_number = (string) $params["model_number"];
		$s_model_number = trim($s_model_number);
		// 馬力
		$f_horsepower = (float) $params["horsepower"];
		// 台數
		$f_quantity = (float) $params["quantity"];

		//交期驗證
		// if (trim($s_delivery_date) == "") {
		// 	throw new Exception("請設定交期日期", 1);
		// }

		//開始資料庫交易 beginTransaction
		$this->pdo_sql->beginTransaction();
		//空壓機設備-新增流程
		try {
			if ($s_air_compressor_device_id == "") {
				//air_compressor_device 新增
				$sql_air_compressor_device = sprintf(
					"INSERT INTO [%s].[dbo].[air_compressor_device] (
							[region],
							[asset_number],
							[device_category],
							[device_name],
							[brand],
							[model_type],
							[model_number],
							[horsepower],
							[quantity],
							[created_by],
							[updated_by]
						)
						VALUES
						(
							:region,
							:asset_number,
							:device_category,
							:device_name,
							:brand,
							:model_type,
							:model_number,
							:horsepower,
							:quantity,
							:created_by,
							:updated_by
						);",
					$this->database_alarm
				);
				$sql_air_compressor_device_val = [
					"region" => $s_region,
					"asset_number" => $s_asset_number,
					"device_category" => $s_device_category,
					"device_name" => $s_device_name,
					"brand" => $s_brand,
					"model_type" => $s_model_type,
					"model_number" => $s_model_number,
					"horsepower" => $f_horsepower,
					"quantity" => $f_quantity,
					"created_by" => $this->user_id,
					"updated_by" => $this->user_id,
				];

				$sth = $this->pdo_sql->prepare($sql_air_compressor_device);
				$sth->execute($sql_air_compressor_device_val);
				if ($sth->rowCount() == 0) {
					throw new Exception("空壓機設備寫入失敗", 1);
				}
			} else {
				//air_compressor_device 更新
				$sql_air_compressor_device = sprintf(
					"UPDATE [%s].[dbo].[air_compressor_device] 
						SET
							[region] = :region,
							[asset_number] = :asset_number,
							[device_category] = :device_category,
							[device_name] = :device_name,
							[brand] = :brand,
							[model_type] = :model_type,
							[model_number] = :model_number,
							[horsepower] = :horsepower,
							[quantity] = :quantity,
							[updated_at] = :updated_at,
							[updated_by] = :updated_by 
						WHERE
							[id] = :id;
						",
					$this->database_alarm
				);
				$sql_air_compressor_device_val = [
					"region" => $s_region,
					"asset_number" => $s_asset_number,
					"device_category" => $s_device_category,
					"device_name" => $s_device_name,
					"brand" => $s_brand,
					"model_type" => $s_model_type,
					"model_number" => $s_model_number,
					"horsepower" => $f_horsepower,
					"quantity" => $f_quantity,
					"updated_at" => date("Y-m-d H:i:s"),
					"updated_by" => $this->user_id,
					"id" => $s_air_compressor_device_id,
				];

				$sth = $this->pdo_sql->prepare($sql_air_compressor_device);
				$sth->execute($sql_air_compressor_device_val);
				if ($sth->rowCount() == 0) {
					throw new Exception("空壓機設備更新失敗", 1);
				}
			}
			// throw new Exception("測試中", 1);
			$this->pdo_sql->commit();
		} catch (Exception $e) {
			$this->pdo_sql->rollBack();
			throw new Exception($e->getMessage(), 1);
		}

		return "Ok";
	}

	//刪除空壓機設備資料
	public function Changedel_air_compressor_device($params)
	{
		//空壓機設備表主鍵
		$s_air_compressor_device_id = (string) $params["air_compressor_device_id"];
		$s_air_compressor_device_id = trim($s_air_compressor_device_id);


		//空壓機設備表主鍵驗證
		if ($s_air_compressor_device_id == "") {
			throw new Exception("空壓機設備資料異常", 1);
		} else {
			$sql_check = sprintf(
				"SELECT 
					id
				FROM
					[%s].[dbo].[air_compressor_device]
				WHERE
					id = :id
				",
				$this->database_alarm
			);
			$sth = $this->pdo_sql->prepare($sql_check);
			$sth->execute(["id" => $s_air_compressor_device_id]);
			$row = $sth->fetch(PDO::FETCH_ASSOC);
			if (empty($row["id"])) {
				throw new Exception("空壓機設備資料異常", 1);
			}
		}

		//開始資料庫交易 beginTransaction
		$this->pdo_sql->beginTransaction();
		//空壓機設備-新增流程
		try {
			//air_compressor_device 更新
			$sql_air_compressor_device = sprintf(
				"UPDATE [%s].[dbo].[air_compressor_device] 
				SET
					[deleted_at] = :deleted_at,
					[deleted_by] = :deleted_by 
				WHERE
					[id] = :id;
				",
				$this->database_alarm
			);
			$sql_air_compressor_device_val = [
				"deleted_at" => date("Y-m-d H:i:s"),
				"deleted_by" => $this->user_id,
				"id" => $s_air_compressor_device_id,
			];

			$sth = $this->pdo_sql->prepare($sql_air_compressor_device);
			$sth->execute($sql_air_compressor_device_val);
			if ($sth->rowCount() == 0) {
				throw new Exception("空壓機設備刪除失敗", 1);
			}

			$this->pdo_sql->commit();
		} catch (Exception $e) {
			$this->pdo_sql->rollBack();
			throw new Exception($e->getMessage(), 1);
		}

		return "Ok";
	}
}
