<?php

// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	public function SelectLoadOptions($params)
	{
		$sql = sprintf(
			"SELECT
				STUFF( MIN ( ColumnTable ), 1, 3, '' ) AS AreaName_inx,
				[AreaName] 
			FROM
				[%s].[dbo].[TableOrder] 
			GROUP BY
				AreaName",
			$this->database_trend
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		$rows =  $sth->fetchAll(PDO::FETCH_ASSOC);
		$res_temp = [];
		foreach ($rows as $k => $v) {
			$area_inx = explode("-", $v["AreaName"])[0];
			$res_temp[$area_inx][$v["AreaName_inx"]] = [
				"AreaName" => $v["AreaName"],
				"AreaName_inx" => $v["AreaName_inx"],
			];
		}

		$res = [];
		foreach ($res_temp as $k => $v) {
			usort($v, function ($a, $b) {
				return abs($a["AreaName_inx"]) - abs($b["AreaName_inx"]);
			});
			foreach ($v as $k_2 => $v_2) {
				$res[] = [
					"value" => $v_2["AreaName"],
					"label" => $v_2["AreaName"],
				];
			}
		}
		return $res;
	}

	public function SelectLoadData($params)
	{
		$input = $params['input'];

		if ($input == "二、三廠-複伸區群組") {
			$sql = sprintf(
				"SELECT 
					 CASE 
					    WHEN [ColumnName] = '1F' THEN '1F總用電'
					    WHEN [ColumnName] = '1G' THEN '1G總用電'
					    WHEN [ColumnName] = 'MP2(E11柱)' THEN '2B總用電'
					 ELSE [ColumnName]
					 END AS [ColumnName]
				 	,[ColumnTable]
				 	,[IsTotal]
				  FROM [%s].[dbo].[TableOrder]
				  WHERE [AreaName] = :AreaName OR [ColumnName] = '1F' OR [ColumnName] = '1G' OR [ColumnName] = 'MP2(E11柱)'
				  ORDER BY [IsTotal] DESC,[AreaIndex] ASC
					;",
				$this->database_trend
			);
			$sth = $this->pdo_sql->prepare($sql);
			$sth->execute([
				"AreaName" => $input,
			]);
		} else {
			$sql = sprintf(
				"SELECT 
					 [ColumnName]
					,[ColumnTable]
					,[IsTotal]
				FROM [%s].[dbo].[TableOrder]
				WHERE [AreaName] = :AreaName
				;",
				$this->database_trend
			);
			$sth = $this->pdo_sql->prepare($sql);
			$sth->execute([
				"AreaName" => $input,
			]);
		}

		return $sth->fetchAll(PDO::FETCH_ASSOC);
	}
}
