<?php

// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	//撈取台電資料清單
	public function Selectenergy_usage_electricity_list($params)
	{

		// 年份
		$s_year = (string) $params["year"];
		$s_year = trim($s_year);

		$a_where_arr = []; //sql條件陣列 
		$a_where_arr_val = [];
		$s_where_arr = ""; //sql條件字串，用$a_where_arr條件陣列轉換而來

		// 去除已刪除的資料
		$a_where_arr[] =  "_eue.deleted_at IS NULL";


		// 年份範圍條件
		if ($s_year != "") {
			$a_where_arr[] =  sprintf("_eue.data_at BETWEEN :start_at AND :end_at");
			$a_where_arr_val["start_at"] = date("Y-01-01", strtotime($s_year));
			$a_where_arr_val["end_at"] = date("Y-12-t", strtotime($s_year));
		}

		//sql條件陣列轉換
		if (!empty($a_where_arr)) {
			$s_where_arr = " WHERE " . implode(" AND ", $a_where_arr);
		}

		$res = [];

		$sql = sprintf(
			"SELECT	
				_eue.id
				,_eue.data_at
				,ISNULL(_eue.purchased_power_peak,0) AS purchased_power_peak
				,ISNULL(_eue.purchased_power_mid_peak,0) AS purchased_power_mid_peak
				,ISNULL(_eue.purchased_power_off_peak,0) AS purchased_power_off_peak
				,ISNULL(_eue.purchased_power_sat_mid_peak,0) AS purchased_power_sat_mid_peak
				,_eue.total_amount_due
				,_eue.fuel_coal
				,_eue.fuel_oil
				,_eue.liquefied_petroleum_gas
				,_eue.created_at
				,_eue.created_by
				,_eue.updated_at
				,_eue.updated_by
			FROM
				[%s].[dbo].[energy_usage_electricity] AS _eue
			%s
			ORDER BY
				data_at DESC
			",
			$this->database_alarm,
			$s_where_arr
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute($a_where_arr_val);
		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		foreach ($rows as $k => $v) {
			//年份 資料處理
			$v["data_at_year"] = empty($v["data_at"]) ? "" : date("Y", strtotime($v["data_at"]));
			//月份 資料處理
			$v["data_at_month"] = empty($v["data_at"]) ? "" : date("m", strtotime($v["data_at"]));
			//購入電力-合計 資料處理
			$v["purchased_power_total"] =
				$v["purchased_power_peak"] +
				$v["purchased_power_mid_peak"] +
				$v["purchased_power_off_peak"] +
				$v["purchased_power_sat_mid_peak"];

			//數值資料整理	
			$v["purchased_power_peak"] = (float) number_format($v["purchased_power_peak"], 2, ".", "");
			$v["purchased_power_mid_peak"] = (float) number_format($v["purchased_power_mid_peak"], 2, ".", "");
			$v["purchased_power_off_peak"] = (float) number_format($v["purchased_power_off_peak"], 2, ".", "");
			$v["purchased_power_sat_mid_peak"] = (float) number_format($v["purchased_power_sat_mid_peak"], 2, ".", "");
			$v["purchased_power_total"]  = (float) number_format($v["purchased_power_total"], 2, ".", "");
			$v["total_amount_due"] = (float) number_format($v["total_amount_due"], 2, ".", "");
			$v["fuel_coal"] = (float) number_format($v["fuel_coal"], 2, ".", "");
			$v["fuel_oil"] = (float) number_format($v["fuel_oil"], 2, ".", "");
			$v["liquefied_petroleum_gas"] = (float) number_format($v["liquefied_petroleum_gas"], 2, ".", "");

			$v["updated_at"] = empty($v["updated_at"]) ? "" : date("Y-m-d H:i:s", strtotime($v["updated_at"]));
			$res[] = $v;
		}
		return $res;
	}

	//撈取台電資料(修改台電資料用)
	public function Selectget_energy_usage_electricity_info($params)
	{
		//台電資料表主鍵
		$s_energy_usage_electricity_id = $params["energy_usage_electricity_id"];
		$s_energy_usage_electricity_id = trim($s_energy_usage_electricity_id);

		if ($s_energy_usage_electricity_id == "") {
			throw new Exception("台電資料異常", 1);
		}

		$sql = sprintf(
			"SELECT
				_eue.id
				,_eue.data_at
				,_eue.purchased_power_peak
				,_eue.purchased_power_mid_peak
				,_eue.purchased_power_off_peak
				,_eue.purchased_power_sat_mid_peak
				,_eue.total_amount_due
				,_eue.fuel_coal
				,_eue.fuel_oil
				,_eue.liquefied_petroleum_gas
				,_eue.created_at
				,_eue.created_by
				,_eue.updated_at
				,_eue.updated_by

			FROM
				[%s].[dbo].[energy_usage_electricity] AS _eue
			WHERE
				_eue.id = :id AND
				_eue.deleted_at IS NULL
			",
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			"id" => $s_energy_usage_electricity_id
		]);
		$row = $sth->fetch(PDO::FETCH_ASSOC);
		$row["month"] = date("m", strtotime($row["data_at"]));
		$row["year"] = date("Y", strtotime($row["data_at"]));

		//數值資料整理	
		$row["purchased_power_peak"] = (float) number_format($row["purchased_power_peak"], 2, ".", "");
		$row["purchased_power_mid_peak"] = (float) number_format($row["purchased_power_mid_peak"], 2, ".", "");
		$row["purchased_power_off_peak"] = (float) number_format($row["purchased_power_off_peak"], 2, ".", "");
		$row["purchased_power_sat_mid_peak"] = (float) number_format($row["purchased_power_sat_mid_peak"], 2, ".", "");
		$row["purchased_power_total"]  = (float) number_format($row["purchased_power_total"], 2, ".", "");
		$row["total_amount_due"] = (float) number_format($row["total_amount_due"], 2, ".", "");
		$row["fuel_coal"] = (float) number_format($row["fuel_coal"], 2, ".", "");
		$row["fuel_oil"] = (float) number_format($row["fuel_oil"], 2, ".", "");
		$row["liquefied_petroleum_gas"] = (float) number_format($row["liquefied_petroleum_gas"], 2, ".", "");

		return $row;
	}

	//儲存台電資料
	public function Changesave_energy_usage_electricity($params)
	{

		//能源用量(台電)表id 不為null的話代表修改
		$s_energy_usage_electricity_id = (string) $params["energy_usage_electricity_id"];
		$s_energy_usage_electricity_id = trim($s_energy_usage_electricity_id);
		// 月份
		$s_month = (string) $params["month"];
		$s_month = trim($s_month);
		// 年份
		$s_year = (string) $params["year"];
		$s_year = trim($s_year);
		// 購入電力-尖峰
		$f_purchased_power_peak = (float) $params["purchased_power_peak"];
		// 購入電力-半尖峰
		$f_purchased_power_mid_peak = (float) $params["purchased_power_mid_peak"];
		// 購入電力-離峰
		$f_purchased_power_off_peak = (float) $params["purchased_power_off_peak"];
		// 購入電力-周六半尖峰
		$f_purchased_power_sat_mid_peak = (float) $params["purchased_power_sat_mid_peak"];
		// 應繳總金額
		$f_total_amount_due = (float) $params["total_amount_due"];
		// 燃料煤
		$f_fuel_coal = (float) $params["fuel_coal"];
		// 燃料油
		$f_fuel_oil = (float) $params["fuel_oil"];
		// 液化石油氣
		$f_liquefied_petroleum_gas = (float) $params["liquefied_petroleum_gas"];


		//年月份資料驗證
		if (
			$s_month == "" ||
			$s_year == ""
		) {
			throw new Exception("年月份資料不可為空", 1);
		}



		//年月份整理
		$s_data_at = date("Y-m-01", strtotime("$s_year-$s_month-01"));


		//檢查相同年月份是否已有資料
		$sql_check = sprintf(
			"SELECT
				id
			FROM
				[%s].[dbo].[energy_usage_electricity]
			WHERE
				data_at = :data_at AND
				deleted_at IS NULL",
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql_check);
		$sth->execute([
			"data_at" => $s_data_at
		]);
		$row = $sth->fetch(PDO::FETCH_ASSOC);
		//若有查到相同月份資料 再進行處理
		if (!empty($row["id"])) {
			//當操作為新增時 則回傳已有相同年月份資料
			if ($s_energy_usage_electricity_id == "") {
				throw new Exception("已有相同年月份資料", 1);
			}
			//當操作為修改時 若找出來的資料id 與要修改的資料id 不相同 則回傳已有相同年月份資料
			if ($s_energy_usage_electricity_id != $row["id"]) {
				throw new Exception("已有相同年月份資料", 1);
			}
		}



		//開始資料庫交易 beginTransaction
		$this->pdo_sql->beginTransaction();
		try {
			//台電資料-新增流程
			if ($s_energy_usage_electricity_id == "") {
				//process_device 新增
				$sql_energy_usage_electricity = sprintf(
					"INSERT INTO [%s].[dbo].[energy_usage_electricity] (
							[data_at],
							[purchased_power_peak],
							[purchased_power_mid_peak],
							[purchased_power_off_peak],
							[purchased_power_sat_mid_peak],
							[total_amount_due],
							[fuel_coal],
							[fuel_oil],
							[liquefied_petroleum_gas],
							[created_by],
							[updated_by]
						)
						VALUES
						(
							:data_at,
							:purchased_power_peak,
							:purchased_power_mid_peak,
							:purchased_power_off_peak,
							:purchased_power_sat_mid_peak,
							:total_amount_due,
							:fuel_coal,
							:fuel_oil,
							:liquefied_petroleum_gas,
							:created_by,
							:updated_by
						);",
					$this->database_alarm
				);
				$sql_energy_usage_electricity_val = [
					"data_at" => $s_data_at,
					"purchased_power_peak" => $f_purchased_power_peak,
					"purchased_power_mid_peak" => $f_purchased_power_mid_peak,
					"purchased_power_off_peak" => $f_purchased_power_off_peak,
					"purchased_power_sat_mid_peak" => $f_purchased_power_sat_mid_peak,
					"total_amount_due" => $f_total_amount_due,
					"fuel_coal" => $f_fuel_coal,
					"fuel_oil" => $f_fuel_oil,
					"liquefied_petroleum_gas" => $f_liquefied_petroleum_gas,
					"created_by" => $this->user_id,
					"updated_by" => $this->user_id,
				];

				$sth = $this->pdo_sql->prepare($sql_energy_usage_electricity);
				$sth->execute($sql_energy_usage_electricity_val);
				if ($sth->rowCount() == 0) {
					throw new Exception("台電資料寫入失敗", 1);
				}
			}
			//台電資料-更新流程 
			else {
				//energy_usage_electricity 更新
				$sql_energy_usage_electricity = sprintf(
					"UPDATE [%s].[dbo].[energy_usage_electricity] 
						SET
							[data_at] = :data_at,
							[purchased_power_peak] = :purchased_power_peak,
							[purchased_power_mid_peak] = :purchased_power_mid_peak,
							[purchased_power_off_peak] = :purchased_power_off_peak,
							[purchased_power_sat_mid_peak] = :purchased_power_sat_mid_peak,
							[total_amount_due] = :total_amount_due,
							[fuel_coal] = :fuel_coal,
							[fuel_oil] = :fuel_oil,
							[liquefied_petroleum_gas] = :liquefied_petroleum_gas,
							[updated_at] = :updated_at,
							[updated_by] = :updated_by 
						WHERE
							[id] = :id;
						",
					$this->database_alarm
				);
				$sql_energy_usage_electricity_val = [
					"data_at" => $s_data_at,
					"purchased_power_peak" => $f_purchased_power_peak,
					"purchased_power_mid_peak" => $f_purchased_power_mid_peak,
					"purchased_power_off_peak" => $f_purchased_power_off_peak,
					"purchased_power_sat_mid_peak" => $f_purchased_power_sat_mid_peak,
					"total_amount_due" => $f_total_amount_due,
					"fuel_coal" => $f_fuel_coal,
					"fuel_oil" => $f_fuel_oil,
					"liquefied_petroleum_gas" => $f_liquefied_petroleum_gas,
					"updated_at" => date("Y-m-d H:i:s"),
					"updated_by" => $this->user_id,
					"id" => $s_energy_usage_electricity_id,
				];

				$sth = $this->pdo_sql->prepare($sql_energy_usage_electricity);
				$sth->execute($sql_energy_usage_electricity_val);
				if ($sth->rowCount() == 0) {
					throw new Exception("台電資料更新失敗", 1);
				}
			}
			$this->pdo_sql->commit();
		} catch (Exception $e) {
			$this->pdo_sql->rollBack();
			throw new Exception($e->getMessage(), 1);
		}

		return "Ok";
	}

	//刪除台電資料
	public function Changedel_energy_usage_electricity($params)
	{
		//能源用量-台電資料表主鍵
		$s_energy_usage_electricity_id = (string) $params["energy_usage_electricity_id"];
		$s_energy_usage_electricity_id = trim($s_energy_usage_electricity_id);


		//能源用量-台電資料表主鍵驗證
		if ($s_energy_usage_electricity_id == "") {
			throw new Exception("能源用量-台電資料異常", 1);
		} else {
			$sql_check = sprintf(
				"SELECT 
					id
				FROM
					[%s].[dbo].[energy_usage_electricity]
				WHERE
					id = :id
				",
				$this->database_alarm
			);
			$sth = $this->pdo_sql->prepare($sql_check);
			$sth->execute(["id" => $s_energy_usage_electricity_id]);
			$row = $sth->fetch(PDO::FETCH_ASSOC);
			if (empty($row["id"])) {
				throw new Exception("能源用量-台電資料異常", 1);
			}
		}

		//開始資料庫交易 beginTransaction
		$this->pdo_sql->beginTransaction();
		//能源用量-台電資料-新增流程
		try {
			//energy_usage_electricity 更新
			$sql_energy_usage_electricity = sprintf(
				"UPDATE [%s].[dbo].[energy_usage_electricity] 
				SET
					[deleted_at] = :deleted_at,
					[deleted_by] = :deleted_by 
				WHERE
					[id] = :id;
				",
				$this->database_alarm
			);
			$sql_energy_usage_electricity_val = [
				"deleted_at" => date("Y-m-d H:i:s"),
				"deleted_by" => $this->user_id,
				"id" => $s_energy_usage_electricity_id,
			];

			$sth = $this->pdo_sql->prepare($sql_energy_usage_electricity);
			$sth->execute($sql_energy_usage_electricity_val);
			if ($sth->rowCount() == 0) {
				throw new Exception("能源用量-台電資料刪除失敗", 1);
			}

			$this->pdo_sql->commit();
		} catch (Exception $e) {
			$this->pdo_sql->rollBack();
			throw new Exception($e->getMessage(), 1);
		}

		return "Ok";
	}

	//撈取其他資料清單
	public function Selectenergy_usage_other_list($params)
	{

		// 年份
		$s_year = (string) $params["year"];
		$s_year = trim($s_year);

		$a_where_arr = []; //sql條件陣列 
		$a_where_arr_val = [];
		$s_where_arr = ""; //sql條件字串，用$a_where_arr條件陣列轉換而來

		// 去除已刪除的資料
		$a_where_arr[] =  "_euo.deleted_at IS NULL";


		// 年份範圍條件
		if ($s_year != "") {
			$a_where_arr[] =  sprintf("_euo.data_at BETWEEN :start_at AND :end_at");
			$a_where_arr_val["start_at"] = date("Y-01-01", strtotime($s_year));
			$a_where_arr_val["end_at"] = date("Y-12-t", strtotime($s_year));
		}

		//sql條件陣列轉換
		if (!empty($a_where_arr)) {
			$s_where_arr = " WHERE " . implode(" AND ", $a_where_arr);
		}

		$res = [];

		$sql = sprintf(
			"SELECT	
				_euo.id
				,_euo.data_at
				,_euo.natural_gas
				,_euo.diesel
				,_euo.steam_purchased
				,_euo.steam_self_used
				,_euo.steam_self_sold
				,_euo.cogeneration_gross_power
				,_euo.cogeneration_sold_power
				,_euo.cogeneration_self_used_plant
				,_euo.cogeneration_self_used_private
				,_euo.renewable_energy_transferred_units
				,_euo.renewable_energy_generated_sold
				,_euo.renewable_energy_generated_self_used
				,_euo.waste_heat_generation
				,_euo.emergency_power_generation
				,_euo.created_at
				,_euo.created_by
				,_euo.updated_at
				,_euo.updated_by
			FROM
				[%s].[dbo].[energy_usage_other] AS _euo
			%s
			ORDER BY
				_euo.data_at DESC
			",
			$this->database_alarm,
			$s_where_arr
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute($a_where_arr_val);
		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		foreach ($rows as $k => $v) {
			$v["data_at_year"] = empty($v["data_at"]) ? "" : date("Y", strtotime($v["data_at"]));
			$v["data_at_month"] = empty($v["data_at"]) ? "" : date("m", strtotime($v["data_at"]));
			$v["updated_at"] = empty($v["updated_at"]) ? "" : date("Y-m-d H:i:s", strtotime($v["updated_at"]));
			//數值資料整理
			$v["natural_gas"] = (float) number_format($v["natural_gas"], 2, ".", "");
			$v["diesel"] = (float) number_format($v["diesel"], 2, ".", "");
			$v["steam_purchased"] = (float) number_format($v["steam_purchased"], 2, ".", "");
			$v["steam_self_used"] = (float) number_format($v["steam_self_used"], 2, ".", "");
			$v["steam_self_sold"] = (float) number_format($v["steam_self_sold"], 2, ".", "");
			$v["cogeneration_gross_power"] = (float) number_format($v["cogeneration_gross_power"], 2, ".", "");
			$v["cogeneration_sold_power"] = (float) number_format($v["cogeneration_sold_power"], 2, ".", "");
			$v["cogeneration_self_used_plant"] = (float) number_format($v["cogeneration_self_used_plant"], 2, ".", "");
			$v["cogeneration_self_used_private"] = (float) number_format($v["cogeneration_self_used_private"], 2, ".", "");
			$v["renewable_energy_transferred_units"] = (float) number_format($v["renewable_energy_transferred_units"], 2, ".", "");
			$v["renewable_energy_generated_sold"] = (float) number_format($v["renewable_energy_generated_sold"], 2, ".", "");
			$v["renewable_energy_generated_self_used"] = (float) number_format($v["renewable_energy_generated_self_used"], 2, ".", "");
			$v["waste_heat_generation"] = (float) number_format($v["waste_heat_generation"], 2, ".", "");
			$v["emergency_power_generation"] = (float) number_format($v["emergency_power_generation"], 2, ".", "");
			$res[] = $v;
		}
		return $res;
	}

	//撈取其他資料(修改其他資料用)
	public function Selectget_energy_usage_other_info($params)
	{
		//其他資料表主鍵
		$s_energy_usage_other_id = $params["energy_usage_other_id"];
		$s_energy_usage_other_id = trim($s_energy_usage_other_id);

		if ($s_energy_usage_other_id == "") {
			throw new Exception("其他資料異常", 1);
		}

		$sql = sprintf(
			"SELECT
				_euo.id
				,_euo.data_at
				,_euo.natural_gas
				,_euo.diesel
				,_euo.steam_purchased
				,_euo.steam_self_used
				,_euo.steam_self_sold
				,_euo.cogeneration_gross_power
				,_euo.cogeneration_sold_power
				,_euo.cogeneration_self_used_plant
				,_euo.cogeneration_self_used_private
				,_euo.renewable_energy_transferred_units
				,_euo.renewable_energy_generated_sold
				,_euo.renewable_energy_generated_self_used
				,_euo.waste_heat_generation
				,_euo.emergency_power_generation
				,_euo.created_at
				,_euo.created_by
				,_euo.updated_at
				,_euo.updated_by
			FROM
				[%s].[dbo].[energy_usage_other] AS _euo
			WHERE
				_euo.id = :id AND
				_euo.deleted_at IS NULL
			",
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			"id" => $s_energy_usage_other_id
		]);
		$row = $sth->fetch(PDO::FETCH_ASSOC);
		$row["month"] = date("m", strtotime($row["data_at"]));
		$row["year"] = date("Y", strtotime($row["data_at"]));
		//數值資料整理
		$row["natural_gas"] = (float) number_format($row["natural_gas"], 2, ".", "");
		$row["diesel"] = (float) number_format($row["diesel"], 2, ".", "");
		$row["steam_purchased"] = (float) number_format($row["steam_purchased"], 2, ".", "");
		$row["steam_self_used"] = (float) number_format($row["steam_self_used"], 2, ".", "");
		$row["steam_self_sold"] = (float) number_format($row["steam_self_sold"], 2, ".", "");
		$row["cogeneration_gross_power"] = (float) number_format($row["cogeneration_gross_power"], 2, ".", "");
		$row["cogeneration_sold_power"] = (float) number_format($row["cogeneration_sold_power"], 2, ".", "");
		$row["cogeneration_self_used_plant"] = (float) number_format($row["cogeneration_self_used_plant"], 2, ".", "");
		$row["cogeneration_self_used_private"] = (float) number_format($row["cogeneration_self_used_private"], 2, ".", "");
		$row["renewable_energy_transferred_units"] = (float) number_format($row["renewable_energy_transferred_units"], 2, ".", "");
		$row["renewable_energy_generated_sold"] = (float) number_format($row["renewable_energy_generated_sold"], 2, ".", "");
		$row["renewable_energy_generated_self_used"] = (float) number_format($row["renewable_energy_generated_self_used"], 2, ".", "");
		$row["waste_heat_generation"] = (float) number_format($row["waste_heat_generation"], 2, ".", "");
		$row["emergency_power_generation"] = (float) number_format($row["emergency_power_generation"], 2, ".", "");
		
		return $row;
	}

	//儲存其他資料
	public function Changesave_energy_usage_other($params)
	{

		//能源用量(其他)表id 不為null的話代表修改
		$s_energy_usage_other_id = (string) $params["energy_usage_other_id"];
		$s_energy_usage_other_id = trim($s_energy_usage_other_id);
		// 月份
		$s_month = (string) $params["month"];
		$s_month = trim($s_month);
		// 年份
		$s_year = (string) $params["year"];
		$s_year = trim($s_year);
		// 天然氣
		$f_natural_gas = (float) $params["natural_gas"];
		// 柴油
		$f_diesel = (float) $params["diesel"];
		// 蒸氣量-購入
		$f_steam_purchased = (float) $params["steam_purchased"];
		// 蒸氣量-自產自用
		$f_steam_self_used = (float) $params["steam_self_used"];
		// 蒸氣量-自產售出
		$f_steam_self_sold = (float) $params["steam_self_sold"];
		// 汽電共生-毛發電量
		$f_cogeneration_gross_power = (float) $params["cogeneration_gross_power"];
		// 汽電共生-售電量
		$f_cogeneration_sold_power = (float) $params["cogeneration_sold_power"];
		// 汽電共生-自發自用-廠用電量
		$f_cogeneration_self_used_plant = (float) $params["cogeneration_self_used_plant"];
		// 汽電共生-自發自用-自用電量
		$f_cogeneration_self_used_private = (float) $params["cogeneration_self_used_private"];
		// 再生能源-轉供度數
		$f_renewable_energy_transferred_units = (float) $params["renewable_energy_transferred_units"];
		// 再生能源-發電量-售電量
		$f_renewable_energy_generated_sold = (float) $params["renewable_energy_generated_sold"];
		// 再生能源-發電量-自用電量
		$f_renewable_energy_generated_self_used = (float) $params["renewable_energy_generated_self_used"];
		// 廢熱發電
		$f_waste_heat_generation = (float) $params["waste_heat_generation"];
		// 緊急發電
		$f_emergency_power_generation = (float) $params["emergency_power_generation"];


		//年月份資料驗證
		if (
			$s_month == "" ||
			$s_year == ""
		) {
			throw new Exception("年月份資料不可為空", 1);
		}



		//年月份整理
		$s_data_at = date("Y-m-01", strtotime("$s_year-$s_month-01"));


		//檢查相同年月份是否已有資料
		$sql_check = sprintf(
			"SELECT
				id
			FROM
				[%s].[dbo].[energy_usage_other]
			WHERE
				data_at = :data_at AND
				deleted_at IS NULL",
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql_check);
		$sth->execute([
			"data_at" => $s_data_at
		]);
		$row = $sth->fetch(PDO::FETCH_ASSOC);
		//若有查到相同月份資料 再進行處理
		if (!empty($row["id"])) {
			//當操作為新增時 則回傳已有相同年月份資料
			if ($s_energy_usage_other_id == "") {
				throw new Exception("已有相同年月份資料", 1);
			}
			//當操作為修改時 若找出來的資料id 與要修改的資料id 不相同 則回傳已有相同年月份資料
			if ($s_energy_usage_other_id != $row["id"]) {
				throw new Exception("已有相同年月份資料", 1);
			}
		}



		//開始資料庫交易 beginTransaction
		$this->pdo_sql->beginTransaction();
		try {
			//其他資料-新增流程
			if ($s_energy_usage_other_id == "") {
				//process_device 新增
				$sql_energy_usage_other = sprintf(
					"INSERT INTO [%s].[dbo].[energy_usage_other] (
							[data_at],
							[natural_gas],
							[diesel],
							[steam_purchased],
							[steam_self_used],
							[steam_self_sold],
							[cogeneration_gross_power],
							[cogeneration_sold_power],
							[cogeneration_self_used_plant],
							[cogeneration_self_used_private],
							[renewable_energy_transferred_units],
							[renewable_energy_generated_sold],
							[renewable_energy_generated_self_used],
							[waste_heat_generation],
							[emergency_power_generation],
							[created_by],
							[updated_by]
						)
						VALUES
						(
							:data_at,
							:natural_gas,
							:diesel,
							:steam_purchased,
							:steam_self_used,
							:steam_self_sold,
							:cogeneration_gross_power,
							:cogeneration_sold_power,
							:cogeneration_self_used_plant,
							:cogeneration_self_used_private,
							:renewable_energy_transferred_units,
							:renewable_energy_generated_sold,
							:renewable_energy_generated_self_used,
							:waste_heat_generation,
							:emergency_power_generation,
							:created_by,
							:updated_by
						);",
					$this->database_alarm
				);
				$sql_energy_usage_other_val = [
					"data_at" => $s_data_at,
					"natural_gas" => $f_natural_gas,
					"diesel" => $f_diesel,
					"steam_purchased" => $f_steam_purchased,
					"steam_self_used" => $f_steam_self_used,
					"steam_self_sold" => $f_steam_self_sold,
					"cogeneration_gross_power" => $f_cogeneration_gross_power,
					"cogeneration_sold_power" => $f_cogeneration_sold_power,
					"cogeneration_self_used_plant" => $f_cogeneration_self_used_plant,
					"cogeneration_self_used_private" => $f_cogeneration_self_used_private,
					"renewable_energy_transferred_units" => $f_renewable_energy_transferred_units,
					"renewable_energy_generated_sold" => $f_renewable_energy_generated_sold,
					"renewable_energy_generated_self_used" => $f_renewable_energy_generated_self_used,
					"waste_heat_generation" => $f_waste_heat_generation,
					"emergency_power_generation" => $f_emergency_power_generation,
					"created_by" => $this->user_id,
					"updated_by" => $this->user_id,
				];

				$sth = $this->pdo_sql->prepare($sql_energy_usage_other);
				$sth->execute($sql_energy_usage_other_val);
				if ($sth->rowCount() == 0) {
					throw new Exception("其他資料寫入失敗", 1);
				}
			}
			//其他資料-更新流程 
			else {
				//energy_usage_other 更新
				$sql_energy_usage_other = sprintf(
					"UPDATE [%s].[dbo].[energy_usage_other] 
						SET
							[data_at] = :data_at,
							[natural_gas] = :natural_gas,
							[diesel] = :diesel,
							[steam_purchased] = :steam_purchased,
							[steam_self_used] = :steam_self_used,
							[steam_self_sold] = :steam_self_sold,
							[cogeneration_gross_power] = :cogeneration_gross_power,
							[cogeneration_sold_power] = :cogeneration_sold_power,
							[cogeneration_self_used_plant] = :cogeneration_self_used_plant,
							[cogeneration_self_used_private] = :cogeneration_self_used_private,
							[renewable_energy_transferred_units] = :renewable_energy_transferred_units,
							[renewable_energy_generated_sold] = :renewable_energy_generated_sold,
							[renewable_energy_generated_self_used] = :renewable_energy_generated_self_used,
							[waste_heat_generation] = :waste_heat_generation,
							[emergency_power_generation] = :emergency_power_generation,
							[updated_at] = :updated_at,
							[updated_by] = :updated_by 
						WHERE
							[id] = :id;
						",
					$this->database_alarm
				);
				$sql_energy_usage_other_val = [
					"data_at" => $s_data_at,
					"natural_gas" => $f_natural_gas,
					"diesel" => $f_diesel,
					"steam_purchased" => $f_steam_purchased,
					"steam_self_used" => $f_steam_self_used,
					"steam_self_sold" => $f_steam_self_sold,
					"cogeneration_gross_power" => $f_cogeneration_gross_power,
					"cogeneration_sold_power" => $f_cogeneration_sold_power,
					"cogeneration_self_used_plant" => $f_cogeneration_self_used_plant,
					"cogeneration_self_used_private" => $f_cogeneration_self_used_private,
					"renewable_energy_transferred_units" => $f_renewable_energy_transferred_units,
					"renewable_energy_generated_sold" => $f_renewable_energy_generated_sold,
					"renewable_energy_generated_self_used" => $f_renewable_energy_generated_self_used,
					"waste_heat_generation" => $f_waste_heat_generation,
					"emergency_power_generation" => $f_emergency_power_generation,
					"updated_at" => date("Y-m-d H:i:s"),
					"updated_by" => $this->user_id,
					"id" => $s_energy_usage_other_id,
				];

				$sth = $this->pdo_sql->prepare($sql_energy_usage_other);
				$sth->execute($sql_energy_usage_other_val);
				if ($sth->rowCount() == 0) {
					throw new Exception("其他資料更新失敗", 1);
				}
			}
			$this->pdo_sql->commit();
		} catch (Exception $e) {
			$this->pdo_sql->rollBack();
			throw new Exception($e->getMessage(), 1);
		}

		return "Ok";
	}

	//刪除其他資料
	public function Changedel_energy_usage_other($params)
	{
		//能源用量-其他資料表主鍵
		$s_energy_usage_other_id = (string) $params["energy_usage_other_id"];
		$s_energy_usage_other_id = trim($s_energy_usage_other_id);


		//能源用量-其他資料表主鍵驗證
		if ($s_energy_usage_other_id == "") {
			throw new Exception("能源用量-其他資料異常", 1);
		} else {
			$sql_check = sprintf(
				"SELECT 
					id
				FROM
					[%s].[dbo].[energy_usage_other]
				WHERE
					id = :id
				",
				$this->database_alarm
			);
			$sth = $this->pdo_sql->prepare($sql_check);
			$sth->execute(["id" => $s_energy_usage_other_id]);
			$row = $sth->fetch(PDO::FETCH_ASSOC);
			if (empty($row["id"])) {
				throw new Exception("能源用量-其他資料異常", 1);
			}
		}

		//開始資料庫交易 beginTransaction
		$this->pdo_sql->beginTransaction();
		//能源用量-其他資料-新增流程
		try {
			//energy_usage_other 更新
			$sql_energy_usage_other = sprintf(
				"UPDATE [%s].[dbo].[energy_usage_other] 
				SET
					[deleted_at] = :deleted_at,
					[deleted_by] = :deleted_by 
				WHERE
					[id] = :id;
				",
				$this->database_alarm
			);
			$sql_energy_usage_other_val = [
				"deleted_at" => date("Y-m-d H:i:s"),
				"deleted_by" => $this->user_id,
				"id" => $s_energy_usage_other_id,
			];

			$sth = $this->pdo_sql->prepare($sql_energy_usage_other);
			$sth->execute($sql_energy_usage_other_val);
			if ($sth->rowCount() == 0) {
				throw new Exception("能源用量-其他資料刪除失敗", 1);
			}

			$this->pdo_sql->commit();
		} catch (Exception $e) {
			$this->pdo_sql->rollBack();
			throw new Exception($e->getMessage(), 1);
		}

		return "Ok";
	}
}
