<?php

// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	//撈取製程設備清單
	public function Selectprocess_device_list($params)
	{

		// 製程類別
		$s_process_category = (string) $params["process_category"];
		$s_process_category = trim($s_process_category);
		// 設備名稱
		$s_device_name = (string) $params["device_name"];
		$s_device_name = trim($s_device_name);
		// 廠牌
		$s_brand = (string) $params["brand"];
		$s_brand = trim($s_brand);
		// 型式
		$s_model_type = (string) $params["model_type"];
		$s_model_type = trim($s_model_type);

		$a_where_arr = []; //sql條件陣列 
		$a_where_arr_val = [];
		$s_where_arr = ""; //sql條件字串，用$a_where_arr條件陣列轉換而來

		// 去除已刪除的設備
		$a_where_arr[] =  "_pd.deleted_at IS NULL";


		// 製程類別 - 查詢條件
		if ($s_process_category != "") {
			$a_where_arr[] =  "_pd.process_category LIKE '%$s_process_category%'";
		}
		// 設備名稱 - 查詢條件
		if ($s_device_name != "") {
			$a_where_arr[] =  "_pd.device_name LIKE '%$s_device_name%'";
		}
		// 廠牌 - 查詢條件
		if ($s_brand != "") {
			$a_where_arr[] =  "_pd.brand LIKE '%$s_brand%'";
		}
		// 型式 - 查詢條件
		if ($s_model_type != "") {
			$a_where_arr[] =  "_pd.model_type LIKE '%$s_model_type%'";
		}

		//sql條件陣列轉換
		if (!empty($a_where_arr)) {
			$s_where_arr = " WHERE " . implode(" AND ", $a_where_arr);
		}

		$res = [];

		$sql = sprintf(
			"SELECT	
				_pd.id
				,_pd.process_category
				,_pd.device_name
				,_pd.brand
				,_pd.model_type
				,_pd.motor_horsepower
				,_pd.motor_pole
				,_pd.motor_efficiency_grade
				,_pd.heater_power
				,_pd.rated_power
				,_pd.manufacture_year
				,_pd.investment_cost
				,_pd.capacity_value
				,_pd.capacity_unit
				,_pd.created_at
				,_pd.created_by
				,_pd.updated_at
				,_pd.updated_by
			FROM
				[%s].[dbo].[process_device] AS _pd
			%s
			",
			$this->database_alarm,
			$s_where_arr
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute($a_where_arr_val);
		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		foreach ($rows as $k => $v) {
			$v["updated_at"] = empty($v["updated_at"]) ? "" : date("Y-m-d H:i:s", strtotime($v["updated_at"]));
			$res[] = $v;
		}
		return $res;
	}

	//撈取製程設備資料(修改製程設備資料用)
	public function Selectget_process_device_info($params)
	{
		//製程設備表主鍵
		$s_process_device_id = $params["process_device_id"];
		$s_process_device_id = trim($s_process_device_id);

		if ($s_process_device_id == "") {
			throw new Exception("製程設備資料異常", 1);
		}

		$sql = sprintf(
			"SELECT
				_pd.id
				,_pd.process_category
				,_pd.device_name
				,_pd.brand
				,_pd.model_type
				,_pd.motor_horsepower
				,_pd.motor_pole
				,_pd.motor_efficiency_grade
				,_pd.heater_power
				,_pd.rated_power
				,_pd.manufacture_year
				,_pd.investment_cost
				,_pd.capacity_value
				,_pd.capacity_unit
				,_pd.created_at
				,_pd.created_by
				,_pd.updated_at
				,_pd.updated_by
			FROM
				[%s].[dbo].[process_device] AS _pd
			WHERE
				_pd.id = :id AND
				_pd.deleted_at IS NULL
			",
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			"id" => $s_process_device_id
		]);
		$row = $sth->fetch(PDO::FETCH_ASSOC);

		return $row;
	}

	//儲存製程設備資料
	public function Changesave_process_device($params)
	{
		//製程設備表主鍵 (新增的話為 null)
		$s_process_device_id = (string) $params["process_device_id"];
		$s_process_device_id = trim($s_process_device_id);

		//製程類別
		$s_process_category = (string) $params["process_category"];
		$s_process_category =  trim($s_process_category);
		//設備名稱
		$s_device_name = (string) $params["device_name"];
		$s_device_name =  trim($s_device_name);
		//廠牌
		$s_brand = (string) $params["brand"];
		$s_brand =  trim($s_brand);
		//型式
		$s_model_type = (string) $params["model_type"];
		$s_model_type =  trim($s_model_type);
		//馬達-馬力
		$f_motor_horsepower = (float) $params["motor_horsepower"];
		//馬達-極數
		$f_motor_pole = (float) $params["motor_pole"];
		//馬達-效率等級
		$s_motor_efficiency_grade = (string) $params["motor_efficiency_grade"];
		$s_motor_efficiency_grade =  trim($s_motor_efficiency_grade);
		//電熱功率
		$f_heater_power = (float) $params["heater_power"];
		//額定功率
		$f_rated_power = (float) $params["rated_power"];
		//西元製造年份
		$f_manufacture_year = (float) $params["manufacture_year"];
		//新增或汰換設備平均投資金額
		$f_investment_cost = (float) $params["investment_cost"];
		//設備容量-容量
		$f_capacity_value = (float) $params["capacity_value"];
		//設備容量-單位
		$s_capacity_unit = (string) $params["capacity_unit"];
		$s_capacity_unit =  trim($s_capacity_unit);

		//交期驗證
		// if (trim($s_delivery_date) == "") {
		// 	throw new Exception("請設定交期日期", 1);
		// }

		//開始資料庫交易 beginTransaction
		$this->pdo_sql->beginTransaction();
		//製程設備-新增流程
		try {
			if ($s_process_device_id == "") {
				//process_device 新增
				$sql_process_device = sprintf(
					"INSERT INTO [%s].[dbo].[process_device] (
							[process_category],
							[device_name],
							[brand],
							[model_type],
							[motor_horsepower],
							[motor_pole],
							[motor_efficiency_grade],
							[heater_power],
							[rated_power],
							[manufacture_year],
							[investment_cost],
							[capacity_value],
							[capacity_unit],
							[created_by],
							[updated_by]
						)
						VALUES
						(
							:process_category,
							:device_name,
							:brand,
							:model_type,
							:motor_horsepower,
							:motor_pole,
							:motor_efficiency_grade,
							:heater_power,
							:rated_power,
							:manufacture_year,
							:investment_cost,
							:capacity_value,
							:capacity_unit,
							:created_by,
							:updated_by
						);",
					$this->database_alarm
				);
				$sql_process_device_val = [
					"process_category" => $s_process_category,
					"device_name" => $s_device_name,
					"brand" => $s_brand,
					"model_type" => $s_model_type,
					"motor_horsepower" => $f_motor_horsepower,
					"motor_pole" => $f_motor_pole,
					"motor_efficiency_grade" => $s_motor_efficiency_grade,
					"heater_power" => $f_heater_power,
					"rated_power" => $f_rated_power,
					"manufacture_year" => $f_manufacture_year,
					"investment_cost" => $f_investment_cost,
					"capacity_value" => $f_capacity_value,
					"capacity_unit" => $s_capacity_unit,
					"created_by" => $this->user_id,
					"updated_by" => $this->user_id,
				];

				$sth = $this->pdo_sql->prepare($sql_process_device);
				$sth->execute($sql_process_device_val);
				if ($sth->rowCount() == 0) {
					throw new Exception("製程設備寫入失敗", 1);
				}
			} else {
				//process_device 更新
				$sql_process_device = sprintf(
					"UPDATE [%s].[dbo].[process_device] 
						SET
							[process_category] = :process_category,
							[device_name] = :device_name,
							[brand] = :brand,
							[model_type] = :model_type,
							[motor_horsepower] = :motor_horsepower,
							[motor_pole] = :motor_pole,
							[motor_efficiency_grade] = :motor_efficiency_grade,
							[heater_power] = :heater_power,
							[rated_power] = :rated_power,
							[manufacture_year] = :manufacture_year,
							[investment_cost] = :investment_cost,
							[capacity_value] = :capacity_value,
							[capacity_unit] = :capacity_unit,
							[updated_at] = :updated_at,
							[updated_by] = :updated_by 
						WHERE
							[id] = :id;
						",
					$this->database_alarm
				);
				$sql_process_device_val = [
					"process_category" => $s_process_category,
					"device_name" => $s_device_name,
					"brand" => $s_brand,
					"model_type" => $s_model_type,
					"motor_horsepower" => $f_motor_horsepower,
					"motor_pole" => $f_motor_pole,
					"motor_efficiency_grade" => $s_motor_efficiency_grade,
					"heater_power" => $f_heater_power,
					"rated_power" => $f_rated_power,
					"manufacture_year" => $f_manufacture_year,
					"investment_cost" => $f_investment_cost,
					"capacity_value" => $f_capacity_value,
					"capacity_unit" => $s_capacity_unit,
					"updated_at" => date("Y-m-d H:i:s"),
					"updated_by" => $this->user_id,
					"id" => $s_process_device_id,
				];

				$sth = $this->pdo_sql->prepare($sql_process_device);
				$sth->execute($sql_process_device_val);
				if ($sth->rowCount() == 0) {
					throw new Exception("製程設備更新失敗", 1);
				}
			}
			// throw new Exception("測試中", 1);
			$this->pdo_sql->commit();
		} catch (Exception $e) {
			$this->pdo_sql->rollBack();
			throw new Exception($e->getMessage(), 1);
		}

		return "Ok";
	}

	//刪除製程設備資料
	public function Changedel_process_device($params)
	{
		//製程設備表主鍵
		$s_process_device_id = (string) $params["process_device_id"];
		$s_process_device_id = trim($s_process_device_id);


		//製程設備表主鍵驗證
		if ($s_process_device_id == "") {
			throw new Exception("製程設備資料異常", 1);
		} else {
			$sql_check = sprintf(
				"SELECT 
					id
				FROM
					[%s].[dbo].[process_device]
				WHERE
					id = :id
				",
				$this->database_alarm
			);
			$sth = $this->pdo_sql->prepare($sql_check);
			$sth->execute(["id" => $s_process_device_id]);
			$row = $sth->fetch(PDO::FETCH_ASSOC);
			if (empty($row["id"])) {
				throw new Exception("製程設備資料異常", 1);
			}
		}

		//開始資料庫交易 beginTransaction
		$this->pdo_sql->beginTransaction();
		//製程設備-新增流程
		try {
			//process_device 更新
			$sql_process_device = sprintf(
				"UPDATE [%s].[dbo].[process_device] 
				SET
					[deleted_at] = :deleted_at,
					[deleted_by] = :deleted_by 
				WHERE
					[id] = :id;
				",
				$this->database_alarm
			);
			$sql_process_device_val = [
				"deleted_at" => date("Y-m-d H:i:s"),
				"deleted_by" => $this->user_id,
				"id" => $s_process_device_id,
			];

			$sth = $this->pdo_sql->prepare($sql_process_device);
			$sth->execute($sql_process_device_val);
			if ($sth->rowCount() == 0) {
				throw new Exception("製程設備刪除失敗", 1);
			}

			$this->pdo_sql->commit();
		} catch (Exception $e) {
			$this->pdo_sql->rollBack();
			throw new Exception($e->getMessage(), 1);
		}

		return "Ok";
	}
}
