<?php

// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
    //取得電價資本資料
    public function Selectget_base_electricity_bill($params)
    {
        //取得基本電費資料 區分兩段式與三段式 
        //Cfg_Factory 表先鎖定 Factory = 1 一廠 晉椿此案暫時兩廠的契約容量都是一致的 因此抓其中一個就好
        $sql = sprintf(
            "WITH max_date AS (
                SELECT MAX
                ( EnableDate ) AS EnableDate 
                FROM
                    [%s].[dbo].[Cfg_BasePrice]
            )
            SELECT
                _md.EnableDate,
                _cbp.RangeSection,
                _cbp.PerKwSummer,
                _cbp.PerKwNonSummer,
                _cft.ContractCapacity
            FROM
                max_date AS _md
                LEFT JOIN [%s].[dbo].[Cfg_BasePrice] AS _cbp ON _cbp.EnableDate = _md.EnableDate
                LEFT JOIN [%s].[dbo].[Cfg_Factory] As _cft ON _cft.VoltageId = _cbp.VoltageId AND _cft.Factory = 1
            WHERE
                _cbp.VoltageId IN (2)
                ",
            $this->database_alarm,
            $this->database_alarm,
            $this->database_alarm
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([]);
        $row = $sth->fetchAll(PDO::FETCH_ASSOC);
        $a_base_title = [
            "2_stage" => [],
            "3_stage" => []
        ];
        foreach ($row as $k => $v) {
            $temp_inx = "";
            if ($v["RangeSection"] == 2) {
                $temp_inx = "2_stage";
            } else if ($v["RangeSection"] == 3) {
                $temp_inx = "3_stage";
            }
            //夏月每瓩每月
            $a_base_title[$temp_inx]["PerKwSummer"] = [
                "update_key" => "stage_2_PerKwSummer",
                "value" => number_format($v["PerKwSummer"], 2, ".", "")
            ];
            //非夏月每瓩每月
            $a_base_title[$temp_inx]["PerKwNonSummer"] = [
                "update_key" => "stage_2_PerKwNonSummer",
                "value" => number_format($v["PerKwNonSummer"], 2, ".", "")
            ];
            //契約容量
            $a_base_title[$temp_inx]["ContractCapacity"] = [
                "update_key" => "stage_2_ContractCapacity",
                "value" => number_format($v["ContractCapacity"], 2, ".", "")
            ];
        }
        //取得基本電費細部資料 區分兩段式與三段式
        $sql = sprintf(
            "WITH max_date AS (
                SELECT MAX
                ( EnableDate ) AS EnableDate 
                FROM
                    [%s].[dbo].[Cfg_BasePrice]
            )SELECT
                _cfp.FluidPrice_sno,
                _cfp.VoltageId,
                _cfp.RangeSection,
                _cfp.WeekdayId,
                _cfp.StartHourMinute,
                _cfp.EndHourMinute,
                _cfp.IsSummer,
                _cfp.PeakId,
                _cfp.Price,
                _cfp.Comment,
                _cfp.EnableDate 
            FROM
                max_date AS _md
                LEFT JOIN [%s].[dbo].[Cfg_FluidPrice] AS _cfp ON _cfp.EnableDate = _md.EnableDate
            WHERE
                _cfp.VoltageId IN (2)",
            $this->database_alarm,
            $this->database_alarm
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([]);
        $row = $sth->fetchAll(PDO::FETCH_ASSOC);
        foreach ($row as $k => $v) {
            $temp_inx = "";
            if ($v["RangeSection"] == 2) {
                $temp_inx = "2_stage";
            } else if ($v["RangeSection"] == 3) {
                $temp_inx = "3_stage";
            }
            //條件判斷用 周別_夏季判斷_尖峰判斷
            $s_check_type = sprintf(
                "%s_%s_%s",
                $v["WeekdayId"],
                $v["IsSummer"],
                $v["PeakId"]
            );
            //資料序號 用來更新用
            $a_base_title[$temp_inx]["info"][$s_check_type]["id"][] = $v["FluidPrice_sno"];
            //時間
            $a_base_title[$temp_inx]["info"][$s_check_type]["time"][] = $v["StartHourMinute"] . "~" . $v["EndHourMinute"];
            //電價
            $a_base_title[$temp_inx]["info"][$s_check_type]["value"] = number_format($v["Price"], 2, ".", "");
        }

        //整理資料序號
        foreach ($a_base_title as $k_1 => &$v_1) {
            $n_stage = explode("_", $k_1)[0];
            foreach ($v_1["info"] as $k_2 => &$v_2) {
                $v_2["update_key"] = "info_" . $n_stage . "_" . implode(",", $v_2["id"]);
                unset($v_2["id"]);
            }
        }



        return $a_base_title;
    }
    //更新電價基本資料
    public function Changeupdate_base_electricity_bill($params)
    {
        $s_update_key = (string) $params["update_key"];
        $s_update_key = trim($s_update_key);
        $s_update_value = (string) $params["value"];
        $s_update_value = trim($s_update_value);

        if (
            $s_update_key == "" ||
            $s_update_value == ""
        ) {
            throw new Exception("更新資料有誤，請重新整理頁面後在更新", 1);
        }
        if (floatval($s_update_value) < 0) {
            throw new Exception("數值不可小於0", 1);
        }

        //先查出當前最近一次電價生效的日期


        //拆解update_key
        $a_update_key = explode("_", $s_update_key);
        //更新基本電價部分
        if ($a_update_key[0] == "stage") {
            $s_RangeSection = (int) $a_update_key[1];
            $s_column = (string) trim($a_update_key[2]);
            $sql = sprintf(
                "WITH max_date AS (
                    SELECT MAX
                    ( EnableDate ) AS EnableDate 
                    FROM
                        [%s].[dbo].[Cfg_BasePrice]
                )
                SELECT
                    _md.EnableDate,
                    _cbp.RangeSection,
                    _cbp.PerKwSummer,
                    _cbp.PerKwNonSummer,
                    _cft.ContractCapacity
                FROM
                    max_date AS _md
                    LEFT JOIN [%s].[dbo].[Cfg_BasePrice] AS _cbp ON _cbp.EnableDate = _md.EnableDate
                    LEFT JOIN [%s].[dbo].[Cfg_Factory] As _cft ON _cft.VoltageId = _cbp.VoltageId AND _cft.Factory = 1
                WHERE
                    _cbp.VoltageId IN (2)
                    ",
                $this->database_alarm,
                $this->database_alarm,
                $this->database_alarm
            );
        }
        //更新流動電價部分
        elseif ($a_update_key[0] == "info") {
            $s_RangeSection = (int) $a_update_key[1];
            $s_column = (string) trim($a_update_key[2]);
            $s_id_list = (string) trim($a_update_key[3]);
        }


        //取得基本電費資料 區分兩段式與三段式 
        //Cfg_Factory 表先鎖定 Factory = 1 一廠 晉椿此案暫時兩廠的契約容量都是一致的 因此抓其中一個就好
        $sql = sprintf(
            "WITH max_date AS (
                SELECT MAX
                ( EnableDate ) AS EnableDate 
                FROM
                    [%s].[dbo].[Cfg_BasePrice]
            )
            SELECT
                _md.EnableDate,
                _cbp.RangeSection,
                _cbp.PerKwSummer,
                _cbp.PerKwNonSummer,
                _cft.ContractCapacity
            FROM
                max_date AS _md
                LEFT JOIN [%s].[dbo].[Cfg_BasePrice] AS _cbp ON _cbp.EnableDate = _md.EnableDate
                LEFT JOIN [%s].[dbo].[Cfg_Factory] As _cft ON _cft.VoltageId = _cbp.VoltageId AND _cft.Factory = 1
            WHERE
                _cbp.VoltageId IN (2)
                ",
            $this->database_alarm,
            $this->database_alarm,
            $this->database_alarm
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([]);
        $row = $sth->fetchAll(PDO::FETCH_ASSOC);
        $a_base_title = [
            "2_stage" => [],
            "3_stage" => []
        ];
        foreach ($row as $k => $v) {
            $temp_inx = "";
            if ($v["RangeSection"] == 2) {
                $temp_inx = "2_stage";
            } else if ($v["RangeSection"] == 3) {
                $temp_inx = "3_stage";
            }
            //夏月每瓩每月
            $a_base_title[$temp_inx]["PerKwSummer"] = number_format($v["PerKwSummer"], 2, ".", "");
            //非夏月每瓩每月
            $a_base_title[$temp_inx]["PerKwNonSummer"] = number_format($v["PerKwNonSummer"], 2, ".", "");
            //契約容量
            $a_base_title[$temp_inx]["ContractCapacity"] = number_format($v["ContractCapacity"], 2, ".", "");
        }
        //取得基本電費細部資料 區分兩段式與三段式
        $sql = sprintf(
            "WITH max_date AS (
                SELECT MAX
                ( EnableDate ) AS EnableDate 
                FROM
                    [%s].[dbo].[Cfg_BasePrice]
            )SELECT
                _cfp.FluidPrice_sno,
                _cfp.VoltageId,
                _cfp.RangeSection,
                _cfp.WeekdayId,
                _cfp.StartHourMinute,
                _cfp.EndHourMinute,
                _cfp.IsSummer,
                _cfp.PeakId,
                _cfp.Price,
                _cfp.Comment,
                _cfp.EnableDate 
            FROM
                max_date AS _md
                LEFT JOIN [%s].[dbo].[Cfg_FluidPrice] AS _cfp ON _cfp.EnableDate = _md.EnableDate
            WHERE
                _cfp.VoltageId IN (2)",
            $this->database_alarm,
            $this->database_alarm
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([]);
        $row = $sth->fetchAll(PDO::FETCH_ASSOC);
        foreach ($row as $k => $v) {
            $temp_inx = "";
            if ($v["RangeSection"] == 2) {
                $temp_inx = "2_stage";
            } else if ($v["RangeSection"] == 3) {
                $temp_inx = "3_stage";
            }
            //條件判斷用 周別_夏季判斷_尖峰判斷
            $s_check_type = sprintf(
                "%s_%s_%s",
                $v["WeekdayId"],
                $v["IsSummer"],
                $v["PeakId"]
            );
            //資料序號 用來更新用
            if (is_array($a_base_title[$temp_inx]["info"][$s_check_type]["id"])) {
                $a_base_title[$temp_inx]["info"][$s_check_type]["id"] = explode(",", $a_base_title[$temp_inx]["info"][$s_check_type]["id"]);
            }
            $a_base_title[$temp_inx]["info"][$s_check_type]["id"][] = $v["FluidPrice_sno"];
            $a_base_title[$temp_inx]["info"][$s_check_type]["id"] = implode(",", $a_base_title[$temp_inx]["info"][$s_check_type]["id"]);
            //時間
            $a_base_title[$temp_inx]["info"][$s_check_type]["time"][] = $v["StartHourMinute"] . "~" . $v["EndHourMinute"];
            //電價
            $a_base_title[$temp_inx]["info"][$s_check_type]["price"] = number_format($v["Price"], 2, ".", "");
        }
        //整理更新資料序號
        foreach ($a_base_title as $k_1 => &$v_1) {
            if ($k_1 == "info") {
                foreach ($v_1["info"] as $k_2 => &$v_2) {
                    $v_2["update_key"] = implode(",", $v_2["id"]);
                }
            }
        }


        return $a_base_title;
    }
    //	電價當前版本
    public function SelectPriceVersionOptions($params)
    {
        $sql = sprintf(
            "SELECT DISTINCT [EnableDate]
						FROM [%s].[dbo].[Cfg_FluidPrice]
						ORDER BY [EnableDate] DESC",
            $this->database_trend
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([]);
        return $sth->fetchAll(PDO::FETCH_ASSOC);
    }
    //	電價資訊 detail
    public function SelectGetCfgFactoryInfo($params)
    {
        // -- 取得二/三段式基本電費電價資訊
        // Select * from udt_FactoryBasePriceInfo({VoltageId}, '{myStartTime}', {run23})

        // -- 取得二/三段式流動電費電價資訊
        // Select WeekdayName, IsSummerName, TimeRange, PeakName, Price From udt_FactoryFluidPriceInfo({Factory}, '{myStartTime}', {run23}) Order By WeekdayId, IsSummer Desc, TimeRange

        $sql = sprintf(
            "SELECT * 
						FROM [%s].[dbo].[udt_FactoryBasePriceInfo](%s, :YearVersion, %s)",
            $this->database_trend,
            $params['Factory'],
            $params['RangeSection']
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "YearVersion" => date('Y-m-d', strtotime($params['YearVersion']))
        ]);
        $title = $sth->fetch(PDO::FETCH_ASSOC);

        $sql = sprintf(
            "SELECT * 
						FROM [%s].[dbo].[udt_FactoryFluidPriceInfo](%s, :YearVersion, %s)
						ORDER BY WeekdayId, IsSummer DESC, TimeRange",
            $this->database_trend,
            $params['Factory'],
            $params['RangeSection']
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "YearVersion" => date('Y-m-d', strtotime($params['YearVersion']))
        ]);
        $detail = $sth->fetchAll(PDO::FETCH_ASSOC);

        return compact('title', 'detail');
    }
    //	載入離峰日設定 => 選擇年份 => 查詢
    public function SelectLoadPeakDay($params)
    {
        $sql = sprintf(
            "SELECT [NonPeekDate],[Comment]
						FROM [%s].[dbo].[Cfg_NonPeekCalendar]
						WHERE DATEPART(YEAR, [NonPeekDate]) = :nowYear
						ORDER BY [NonPeekDate] ASC",
            $this->database_trend,
            $params['year']
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "nowYear" => $params['year'],
        ]);
        return $sth->fetchAll(PDO::FETCH_ASSOC);
    }

    //	載入離峰日設定 => 更新設定
    public function ChangeUpdatePeakDay($params)
    {
        $i = 0;
        foreach ($params['peakDayArr'] as $data) {
            $sql = sprintf(
                "MERGE %s.dbo.Cfg_NonPeekCalendar AS orgDate USING ( 
								SELECT :peakDay AS NonPeekDate, :comment AS Comment 
							) AS cover ON orgDate.NonPeekDate = cover.NonPeekDate
							WHEN MATCHED THEN
								UPDATE SET Comment = cover.Comment
							WHEN NOT MATCHED THEN
								INSERT (NonPeekDate, Comment) VALUES (cover.NonPeekDate, cover.Comment);",
                $this->database_trend
            );
            // print_r($sql);
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                'peakDay' => date('Y-m-d', strtotime($data['date'])),
                'comment' => $data['comment'],
            ]);
            if ($sth->rowCount() > 0) {
                $i = +1;
            } else {
            }
        }
        if ($i > 0) {
            $result = ['status' => true, 'msg' => '更新離峰日成功'];
        } else {
            $result = ['status' => false, 'msg' => '更新離峰日失敗'];
        }
        return $result;
    }

    //	載入離峰日設定 => 刪除設定
    public function ChangeDeletePeakDay($params)
    {
        $sql = sprintf(
            "DELETE 
						FROM [%s].[dbo].[Cfg_NonPeekCalendar] 
						WHERE [NonPeekDate] = :peakDay;",
            $this->database_trend
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            'peakDay' => date('Y-m-d', strtotime($params['date'])),
        ]);
        return $sth->rowCount() > 0;
    }
    //	新增電價資訊 資料表：[Cfg_BasePrice] / [Cfg_SummerRange] / [Cfg_FluidPrice]
    public function ChangeInsertBasic($params)
    {
        $RangeSectionArr =  ["2" => "高壓二段式需量契約-經常契約", "3" => "高壓三段式需量契約-經常契約"];


        //	[Cfg_BasePrice]
        $sql = sprintf(
            "SELECT *
						FROM [%s].[dbo].[Cfg_BasePrice]
						WHERE 	[EnableDate] = :EnableDate AND [VoltageId] = :VoltageId AND [RangeSection] = :RangeSection",
            $this->database_trend
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "EnableDate" => $params['EnableDate'],
            "VoltageId" => $params['VoltageId'],
            "RangeSection" => $params['RangeSection'],
        ]);
        if ($sth->fetch(PDO::FETCH_BOUND) == 1) {
            $result = ['status' => false, 'msg' => '已有此資料，不得新增'];
        } else {
            foreach ($RangeSectionArr as $key => $value) {
                $sql = sprintf("INSERT INTO [%s].[dbo].[Cfg_BasePrice] (
								 [EnableDate]
								,[VoltageId]
								,[RangeSection]
								,[PerHousehold]
								,[PerKwSummer]
								,[PerKwNonSummer]
								,[PriceComment]
							) VALUES (
								:EnableDate,
								:VoltageId,
								:RangeSection,
								:PerHousehold,
								:PerKwSummer,
								:PerKwNonSummer,
								:PriceComment
							);", $this->database_trend);
                $sth = $this->pdo_sql->prepare($sql);
                $sth->execute([
                    "EnableDate" => date('Y-m-d', strtotime($params['EnableDate'])),
                    "VoltageId" => $params['VoltageId'],
                    "RangeSection" => $key,
                    "PerHousehold" => $params['PerHousehold'],
                    "PerKwSummer" => $params['PerKwSummer'],
                    "PerKwNonSummer" => $params['PerKwNonSummer'],
                    "PriceComment" => $value,
                ]);
                if ($sth->rowCount() > 0) {
                    $result = ['status' => true, 'msg' => '新增Cfg_BasePrice成功'];
                } else {
                    $result = ['status' => false, 'msg' => '新增Cfg_BasePrice失敗'];
                }
            }
        }
        //	[Cfg_SummerRange]
        $sql = sprintf(
            "SELECT *
						FROM [%s].[dbo].[Cfg_SummerRange]
						WHERE 	[EnableDate] = :EnableDate AND [VoltageId] = :VoltageId ",
            $this->database_trend
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "EnableDate" => $params['EnableDate'],
            "VoltageId" => $params['VoltageId'],
        ]);
        if ($sth->fetch(PDO::FETCH_BOUND) == 1) {
            $result = ['status' => false, 'msg' => '已有此資料，不得新增'];
        } else {
            $sql = sprintf("INSERT INTO [%s].[dbo].[Cfg_SummerRange] (
								 [EnableDate]
								,[VoltageId]
								,[SummerStartMonth]
								,[SummerStartDay]
								,[SummerEndMonth]
								,[SummerEndDay]
							) VALUES (
								:EnableDate,
								:VoltageId,
								:SummerStartMonth,
								:SummerStartDay,
								:SummerEndMonth,
								:SummerEndDay
							);", $this->database_trend);
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "EnableDate" => $params['EnableDate'],
                "VoltageId" => $params['VoltageId'],
                "SummerStartMonth" => $params['SummerStartMonth'],
                "SummerStartDay" => $params['SummerStartDay'],
                "SummerEndMonth" => $params['SummerEndMonth'],
                "SummerEndDay" => $params['SummerEndDay'],
            ]);
            if ($sth->rowCount() > 0) {
                $result = ['status' => true, 'msg' => '新增Cfg_SummerRange成功'];
            } else {
                $result = ['status' => false, 'msg' => '新增Cfg_SummerRange失敗'];
            }
        }
        //	[Cfg_FluidPrice]
        $sql = sprintf(
            "SELECT *
						FROM [%s].[dbo].[Cfg_FluidPrice]
						WHERE 	[EnableDate] = :EnableDate",
            $this->database_trend
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "EnableDate" => $params['EnableDate'],
        ]);
        if ($sth->fetch(PDO::FETCH_BOUND) == 1) {
            $result = ['status' => false, 'msg' => '新增電價生效日成功'];
        } else {
            //	Step.1 [Cfg_FluidPrice]找最後生效日的EnableDate
            $sql = sprintf(
                "SELECT DISTINCT  TOP (1) [EnableDate]
							FROM [%s].[dbo].[Cfg_FluidPrice]
							ORDER BY [EnableDate] DESC",
                $this->database_trend
            );
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([]);
            $getLastEnableDate = $sth->fetch(PDO::FETCH_ASSOC);
            //	Step.2 [Cfg_FluidPrice]找最後生效日$getLastEnableDate所有資料
            $sql = sprintf(
                "SELECT *
							FROM [%s].[dbo].[Cfg_FluidPrice]
							WHERE [EnableDate] = :EnableDate",
                $this->database_trend
            );
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "EnableDate" => $getLastEnableDate['EnableDate']
            ]);
            $getLastEnableDateArray = $sth->fetchAll(PDO::FETCH_ASSOC);

            $i = 0;
            foreach ($getLastEnableDateArray as $item) {

                $sql = sprintf("INSERT INTO [%s].[dbo].[Cfg_FluidPrice] (
									 [EnableDate]
									,[VoltageId]
									,[RangeSection]
									,[WeekdayId]
									,[StartHourMinute]
									,[EndHourMinute]
									,[IsSummer]
									,[PeakId]
									,[Price]
									,[Comment]
								) VALUES (
									 :EnableDate
									,:VoltageId
									,:RangeSection
									,:WeekdayId
									,:StartHourMinute
									,:EndHourMinute
									,:IsSummer
									,:PeakId
									,:Price
									,:Comment
								);", $this->database_trend);
                $sth = $this->pdo_sql->prepare($sql);
                $sth->execute([
                    "EnableDate" => date('Y-m-d', strtotime($params['EnableDate'])),
                    "VoltageId" => $item['VoltageId'],
                    "RangeSection" => $item['RangeSection'],
                    "WeekdayId" => $item['WeekdayId'],
                    "StartHourMinute" => $item['StartHourMinute'],
                    "EndHourMinute" => $item['EndHourMinute'],
                    "IsSummer" => $item['IsSummer'],
                    "PeakId" => $item['PeakId'],
                    "Price" => $item['Price'],
                    "Comment" => $item['Comment'],
                ]);
                if ($sth->rowCount() > 0) {
                    $i += 1;
                    $result = ['status' => true, 'msg' => '新增Cfg_FluidPrice成功'];
                } else {
                    $result = ['status' => false, 'msg' => '新增Cfg_FluidPrice失敗'];
                }
            }
            if ($i > 0) {
                $result = ['status' => true, 'msg' => '新增電價生效日成功'];
            } else {
                $result = ['status' => false, 'msg' => '新增電價生效日失敗'];
            }
        }

        return $result;
    }
    //	新增電價資訊
    public function ChangeAddPrice($params)
    {
        $sql = sprintf(
            "SELECT *
						FROM [%s].[dbo].[Cfg_FluidPrice]
						WHERE 	[EnableDate] = :EnableDate 
							AND [VoltageId] = :VoltageId 
							AND [RangeSection] = :RangeSection
							AND [WeekdayId] = :WeekdayId 
							AND [StartHourMinute] = :StartHourMinute 
							AND [IsSummer] = :IsSummer ",
            $this->database_trend
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "EnableDate" => $params['EnableDate'],
            "VoltageId" => $params['VoltageId'],
            "RangeSection" => $params['RangeSection'],
            "WeekdayId" => $params['WeekdayId'],
            "StartHourMinute" => $params['StartHourMinute'],
            "IsSummer" => $params['IsSummer'],
        ]);
        if ($sth->fetch(PDO::FETCH_BOUND) == 1) {
            $result = ['status' => false, 'msg' => '已有此資料，不得新增'];
        } else {
            $sql = sprintf("INSERT INTO [%s].[dbo].[Cfg_FluidPrice] (
								[EnableDate],
								[VoltageId],
								[RangeSection],
								[WeekdayId],
								[StartHourMinute],
								[EndHourMinute],
								[IsSummer],
								[PeakId],
								[Price],
								[Comment]
							) VALUES (
								:EnableDate,
								:VoltageId,
								:RangeSection,
								:WeekdayId,
								:StartHourMinute,
								:EndHourMinute,
								:IsSummer,
								:PeakId,
								:Price,
								:Comment
							);", $this->database_trend);
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "EnableDate" => $params['EnableDate'],
                "VoltageId" => $params['VoltageId'],
                "RangeSection" => $params['RangeSection'],
                "WeekdayId" => $params['WeekdayId'],
                "StartHourMinute" => $params['StartHourMinute'],
                "EndHourMinute" => $params['EndHourMinute'],
                "IsSummer" => $params['IsSummer'],
                "PeakId" => $params['PeakId'],
                "Price" => $params['Price'],
                "Comment" => $params['Comment'],
            ]);
            if ($sth->rowCount() > 0) {
                $result = ['status' => true, 'msg' => '新增電價成功'];
            } else {
                $result = ['status' => false, 'msg' => '新增電價失敗'];
            }
        }
        return $result;
    }
    //	更新電價資訊
    public function ChangeUpdatePrice($params)
    {
        $condition = "	[EnableDate] = :EnableDate AND 
						[VoltageId] = :VoltageId AND 
						[RangeSection] = :RangeSection AND 
						[WeekdayId] = :WeekdayId AND 
						[StartHourMinute] = :StartHourMinute AND 
						[IsSummer] = :IsSummer AND 
						[PeakId] = :PeakId
					";
        $sql = sprintf(
            "UPDATE [%s].[dbo].[Cfg_FluidPrice] 
						SET  
							 [WeekdayId] = :WeekdayName,
							 [IsSummer] = :IsSummerName,
							 [PeakId] = :PeakName,
							 [Price] = :Price
						WHERE %s",
            $this->database_trend,
            $condition
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            'EnableDate' => $params['EnableDate'],
            'VoltageId' => $params['VoltageId'],
            'RangeSection' => $params['RangeSection'],
            'WeekdayId' => $params['WeekdayId'],
            'StartHourMinute' => $params['StartHourMinute'],
            'IsSummer' => $params['IsSummer'],
            'PeakId' => $params['PeakId'],
            'WeekdayName' => $params['WeekdayName'],
            'IsSummerName' => $params['IsSummerName'],
            'PeakName' => $params['PeakName'],
            'Price' => $params['Price'],
        ]);
        if ($sth->rowCount() > 0) {
            $result = ['status' => true, 'msg' => '更新電價成功'];
        } else {
            $result = ['status' => false, 'msg' => '更新電價失敗 / 已有此資料，不得修改'];
        }
        return $result;
    }
    //	刪除電價資訊
    public function ChangeDeletePrice($params)
    {
        $condition = "	[EnableDate] = :EnableDate AND 
						[VoltageId] = :VoltageId AND 
						[RangeSection] = :RangeSection AND 
						[WeekdayId] = :WeekdayId AND 
						[StartHourMinute] = :StartHourMinute AND 
						[IsSummer] = :IsSummer AND 
						[PeakId] = :PeakId
					";
        $sql = sprintf(
            "DELETE 
						FROM [%s].[dbo].[Cfg_FluidPrice] 
						WHERE %s",
            $this->database_trend,
            $condition
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            'EnableDate' => $params['EnableDate'],
            'VoltageId' => $params['VoltageId'],
            'RangeSection' => $params['RangeSection'],
            'WeekdayId' => $params['WeekdayId'],
            'StartHourMinute' => $params['StartHourMinute'],
            'IsSummer' => $params['IsSummer'],
            'PeakId' => $params['PeakId'],
        ]);
        if ($sth->rowCount() > 0) {
            $result = ['status' => true, 'msg' => '刪除電價成功'];
        } else {
            $result = ['status' => false, 'msg' => '刪除電價失敗'];
        }
        return $result;
    }
    //	刪除電價生效日所有資訊 資料表：[Cfg_BasePrice] / [Cfg_SummerRange] / [Cfg_FluidPrice]
    public function ChangeDeleteEnableDay($params)
    {
        $sql = sprintf(
            "SELECT *
						FROM [%s].[dbo].[Cfg_BasePrice]
						WHERE 	[EnableDate] = :EnableDate ",
            $this->database_trend
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "EnableDate" => $params['EnableDate'],
        ]);
        if ($sth->fetch(PDO::FETCH_BOUND) == 1) {
            $sql = sprintf(
                "DELETE 
							FROM [%s].[dbo].[Cfg_BasePrice] 
							WHERE [EnableDate] = :EnableDate ",
                $this->database_trend
            );
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "EnableDate" => $params['EnableDate'],
            ]);
            if ($sth->rowCount() > 0) {
                $result = ['status' => true, 'msg' => '刪除Cfg_BasePrice成功'];
            } else {
                $result = ['status' => false, 'msg' => '刪除Cfg_BasePrice失敗'];
            }
        } else {
        }

        $sql = sprintf(
            "SELECT *
						FROM [%s].[dbo].[Cfg_SummerRange]
						WHERE 	[EnableDate] = :EnableDate ",
            $this->database_trend
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "EnableDate" => $params['EnableDate'],
        ]);
        if ($sth->fetch(PDO::FETCH_BOUND) == 1) {
            $sql = sprintf(
                "DELETE 
							FROM [%s].[dbo].[Cfg_SummerRange] 
							WHERE [EnableDate] = :EnableDate ",
                $this->database_trend
            );
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "EnableDate" => $params['EnableDate'],
            ]);
            if ($sth->rowCount() > 0) {
                $result = ['status' => true, 'msg' => '刪除Cfg_SummerRange成功'];
            } else {
                $result = ['status' => false, 'msg' => '刪除Cfg_SummerRange失敗'];
            }
        } else {
        }

        $sql = sprintf(
            "SELECT *
						FROM [%s].[dbo].[Cfg_FluidPrice]
						WHERE 	[EnableDate] = :EnableDate ",
            $this->database_trend
        );
        $sth = $this->pdo_sql->prepare($sql);
        $sth->execute([
            "EnableDate" => $params['EnableDate'],
        ]);
        if ($sth->fetch(PDO::FETCH_BOUND) == 1) {
            $sql = sprintf(
                "DELETE 
							FROM [%s].[dbo].[Cfg_FluidPrice] 
							WHERE [EnableDate] = :EnableDate ",
                $this->database_trend
            );
            $sth = $this->pdo_sql->prepare($sql);
            $sth->execute([
                "EnableDate" => $params['EnableDate'],
            ]);
            if ($sth->rowCount() > 0) {
                $result = ['status' => true, 'msg' => '刪除電價生效日設定成功'];
            } else {
                $result = ['status' => false, 'msg' => '刪除電價生效日設定失敗'];
            }
        } else {
        }

        return $result;
    }
    //下載報表
    public function Downloadget_daliy_report($params)
    {

        //下載類型
        $s_type = (string) trim($params["type"]);
        //下載日期
        $s_date = (string) trim($params["date"]);

        switch ($s_type) {
            case "Day":
            case "Day_TGPF":
                $date = date("Y-m-d", strtotime($s_date));
                break;
            case "Week":
                $date = date("Y-m-d", strtotime($s_date . " last day this week"));
                break;
            case "Month":
            case "Month_TGPF":
                $date = date("Y-m-01", strtotime($s_date));
                break;
            case "Season":
                $date = date(sprintf("Y-%02d-01", floor(((int)date("m", strtotime($s_date)) - 1 ) / 3) * 3 + 1), strtotime($s_date));
                break;
            case "Year":
                $date = date("Y-01-01", strtotime($s_date));
                break;
            default:
                throw new Exception("報表格式未定義", 1);
        }
        //設定取檔路徑
        $_Report_FilePath_Format = dirname(dirname(dirname(__FILE__))) . "/template/output/%s/%s/Total%sReport_%s.xlsx";
        $file = sprintf($_Report_FilePath_Format, $s_type, $date, $s_type, $date);
        if (file_exists($file)) {
            header('Content-Disposition: attachment; filename=' . pathinfo($file, PATHINFO_BASENAME));
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Length: ' . filesize($file));
            header('Content-Transfer-Encoding: binary');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            readfile($file);
            exit;
        } else {
            throw new Exception("報表不存在", 1);
        }
    }
}
