<?php

// 頁面專用WebAPI, 不管任何的頁面, class名稱固定為 [WebAPIForMenuPage], 不可變更
class WebAPIForMenuPage extends base_class
{
	//獲取電力架構樹狀圖資料
	public function Selectget_node_tree()
	{
		$res = [];
		$sql = sprintf(
			"SELECT
				_pan.id,
				_pan.node_name,
				_pan.node_type,
				_pan.parent_id 
			FROM
				[dbo].[power_architecture_node] AS _pan 
			WHERE
				_pan.deleted_at IS NULL",
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		$res_temp = [];
		foreach ($rows as $k => $v) {
			$v["name"] = $v["node_name"];
			$res_temp[] = $v;
		}
		//建立樹狀結構物件
		if (!empty($res_temp)) {
			$temp_res = self::get_childs_tree($res_temp, null);
			$res = $temp_res[0];
		}


		return $res;
	}
	//獲取節點類型資訊
	public function Selectget_node_base($params)
	{
		$res = [
			"base_type" => [],
			"base_info" => []
		];
		$sql = sprintf(
			"SELECT 
				_pab.id AS base_id
				,_pabi.id AS base_info_id
				,_pab.base_name
				,_pab.ctrl_child_list
				,_pabi.info_name
			FROM 
				[%s].[dbo].[power_architecture_base] AS _pab
				LEFT JOIN [%s].[dbo].[power_architecture_base_info] AS _pabi ON _pabi.base_id = _pab.id
			ORDER BY
				_pabi.base_id , _pabi.sort_inx
			;",
			$this->database_alarm,
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		foreach ($rows as $k => $v) {
			if (!isset($res["base_type"][$v["base_id"]])) {
				$res["base_type"][$v["base_id"]] = [
					"base_id" => $v["base_id"],
					"base_name" => $v["base_name"],
					"ctrl_child_list" => $v["ctrl_child_list"],
				];
			}
			$res["base_info"][$v["base_id"]][] = [
				"base_info_id" => $v["base_info_id"],
				"info_name" => $v["info_name"],
			];
		}
		$res["base_type"] = array_values($res["base_type"]);
		return $res;
	}

	//獲取節點清單
	public function Selectget_node_list($params)
	{
		$res = [];
		$sql = sprintf(
			"WITH recursive_power_architecture_node AS (
				SELECT 
					id, 
					node_name, 
					node_type, 
					parent_id, 
					created_at, 
					created_by, 
					updated_at, 
					updated_by, 
					deleted_at, 
					deleted_by
				FROM 
					[%s].[dbo].[power_architecture_node]
				WHERE 
					parent_id IS NULL
					AND deleted_at IS NULL 
				UNION ALL    
				SELECT 
					t.id, 
					t.node_name, 
					t.node_type, 
					t.parent_id, 
					t.created_at, 
					t.created_by, 
					t.updated_at, 
					t.updated_by, 
					t.deleted_at, 
					t.deleted_by
				FROM 
					[%s].[dbo].[power_architecture_node] AS t
				INNER JOIN 
					recursive_power_architecture_node AS rh ON t.parent_id = rh.id
				WHERE 
					t.deleted_at IS NULL 
			)
			SELECT
				id,
				node_name,
				node_type,
				parent_id
			FROM 
				recursive_power_architecture_node
			ORDER BY
				node_type
			;",
			$this->database_alarm,
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute();
		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		foreach ($rows as $k => $v) {
			$res[] = $v;
		}
		return $res;
	}

	//儲存節點資訊
	public function Changesave_node_info($params)
	{
		//父節點ID
		$s_parent_node_id = (string) $params["parent_node_id"];
		$s_parent_node_id = trim($s_parent_node_id);
		//節點ID
		$s_node_id = (string) $params["node_id"];
		$s_node_id = trim($s_node_id);
		//節點名稱
		$s_node_name = (string) $params["node_name"];
		$s_node_name = trim($s_node_name);
		//節點類型
		$n_node_type = (int) $params["node_type"];
		//節點資訊
		$a_info_list = (array) $params["info_list"];

		if ($s_node_name == "") {
			throw new Exception("節點名稱不可為空", 1);
		}

		if ($n_node_type <= 0) {
			throw new Exception("節點類型異常", 1);
		}

		if (empty($a_info_list)) {
			throw new Exception("節點資訊異常", 1);
		}

		//若有父節點 則先檢查父節點ID是否正確
		if ($s_parent_node_id != "") {
			$sql_check = sprintf(
				"SELECT
					id
				FROM 
					power_architecture_node
				WHERE
					id = :id AND
					deleted_at IS NULL",
				$this->database_alarm
			);
			$sth = $this->pdo_sql->prepare($sql_check);
			$sth->execute([
				"id" => $s_parent_node_id,
			]);
			$row = $sth->fetch(PDO::FETCH_ASSOC);
			if (empty($row["id"])) {
				throw new Exception("父節點資訊異常", 1);
			}
		}


		//開始資料庫交易 beginTransaction
		$this->pdo_sql->beginTransaction();
		try {
			//若節點ID為空 則為新增
			if ($s_node_id == "") {
				//power_architecture_node 表處理
				$sql_insert_node = sprintf(
					"INSERT INTO [%s].[dbo].[power_architecture_node] (
						[node_name],
						[node_type],
						[parent_id],
						[created_by],
						[updated_by]
					)
					OUTPUT INSERTED.[id] 
					VALUES
					(
						:node_name,
						:node_type,
						%s,
						:created_by,
						:updated_by
					);",
					$this->database_alarm,
					$s_parent_node_id == "" ? 'null' : "'" . $s_parent_node_id . "'"
				);
				$sql_insert_node_val = [
					"created_by" => $this->user_id,
					"updated_by" => $this->user_id,
					"node_name" => $s_node_name,
					"node_type" => $n_node_type,
				];

				$sth = $this->pdo_sql->prepare($sql_insert_node);
				$sth->execute($sql_insert_node_val);
				if ($sth->rowCount() == 0) {
					throw new Exception("節點寫入失敗", 1);
				}
				//取得節點主鍵
				$s_node_id = $sth->fetch(PDO::FETCH_ASSOC)['id'];

				//power_architecture_node_info 表處理
				$a_sql_node_info = [];
				foreach ($a_info_list as $k => $v) {
					//數值順序需與insert 語句的欄位名稱順序一致
					$a_sql_node_info[] = sprintf(
						"(
							'%s',
							'%s',
							'%s',
							'%s',
							'%s'
						)",
						$s_node_id,
						$v["base_info_id"],
						$v["value"],
						$this->user_id,
						$this->user_id
					);
				}
				$sql_insert_node_info = sprintf(
					"INSERT INTO [%s].[dbo].[power_architecture_node_info] (
						[node_id],
						[base_info_id],
						[info_value],
						[created_by],
						[updated_by] 
					) VALUES %s
					",
					$this->database_alarm,
					implode(",", $a_sql_node_info)
				);
				$sth = $this->pdo_sql->prepare($sql_insert_node_info);
				$sth->execute();
				if ($sth->rowCount() == 0) {
					throw new Exception("節點資訊寫入失敗", 1);
				}
				// throw new Exception("測試中", 1);
			} else {
				//power_architecture_node 表處理
				$sql_update_node = sprintf(
					"UPDATE [%s].[dbo].[power_architecture_node] 
					SET 
						[node_name] = :node_name,
						[updated_at] = :updated_at,
						[updated_by] = :updated_by
					WHERE
						[id] = :id;",
					$this->database_alarm
				);
				$sth = $this->pdo_sql->prepare($sql_update_node);
				$sth->execute([
					"node_name" => $s_node_name,
					"updated_at" => date("Y-m-d H:i:d"),
					"updated_by" => $this->user_id,
					"id" => $s_node_id,
				]);
				if ($sth->rowCount() == 0) {
					throw new Exception("節點更新失敗", 1);
				}
				//power_architecture_node_info 表處理
				foreach ($a_info_list as $k => $v) {
					//數值順序需與insert 語句的欄位名稱順序一致
					$a_sql_update_node_info = sprintf(
						"UPDATE [%s].[dbo].[power_architecture_node_info] 
						SET 
							[info_value] = :info_value,
							[updated_at] = :updated_at,
							[updated_by] = :updated_by 
						WHERE
							[id] = :node_info_id;",
						$this->database_alarm
					);
					$sth = $this->pdo_sql->prepare($a_sql_update_node_info);
					$sth->execute([
						"info_value" => $v["value"],
						"updated_at" => date("Y-m-d H:i:d"),
						"updated_by" => $this->user_id,
						"node_info_id" => $v["node_info_id"],
					]);
					if ($sth->rowCount() == 0) {
						throw new Exception("節點更新失敗", 1);
					}
				}
			}

			$this->pdo_sql->commit();
		} catch (Exception $e) {
			$this->pdo_sql->rollBack();
			throw new Exception($e->getMessage(), 1);
		}

		return "OK";
	}

	//刪除節點
	public function Changedelete_node($params)
	{
		//節點ID
		$s_node_id = (string) $params["node_id"];
		$s_node_id = trim($s_node_id);

		if ($s_node_id == "") {
			throw new Exception("節點資料異常", 1);
		}

		//查詢預刪除的節點是否有子節點
		// if ($s_parent_node_id != "") {
		// 	$sql_check = sprintf(
		// 		"SELECT
		// 			id
		// 		FROM 
		// 			power_architecture_node
		// 		WHERE
		// 			id = :id AND
		// 			deleted_at IS NULL",
		// 		$this->database_alarm
		// 	);
		// 	$sth = $this->pdo_sql->prepare($sql_check);
		// 	$sth->execute([
		// 		"id" => $s_parent_node_id,
		// 	]);
		// 	$row = $sth->fetch(PDO::FETCH_ASSOC);
		// 	if (empty($row["id"])) {
		// 		throw new Exception("父節點資訊異常", 1);
		// 	}
		// }


		//開始資料庫交易 beginTransaction
		$this->pdo_sql->beginTransaction();
		try {
			//power_architecture_node 表處理
			$sql_update_node = sprintf(
				"UPDATE 
					[%s].[dbo].[power_architecture_node]
				SET
					deleted_at = :deleted_at,
					deleted_by = :deleted_by
				 WHERE 
				 	id = :id;",
				$this->database_alarm
			);
			$sth = $this->pdo_sql->prepare($sql_update_node);
			$sth->execute([
				"deleted_at" => date("Y-m-d H:i:s"),
				"deleted_by" => $this->user_id,
				"id" => $s_node_id,
			]);
			if ($sth->rowCount() == 0) {
				throw new Exception("節點刪除失敗", 1);
			}
			$this->pdo_sql->commit();
		} catch (Exception $e) {
			$this->pdo_sql->rollBack();
			throw new Exception($e->getMessage(), 1);
		}

		return "OK";
	}
	//取得節點資料
	public function Selectget_node_data($params)
	{
		//節點ID
		$s_node_id = (string) $params["node_id"];
		$s_node_id = trim($s_node_id);

		if ($s_node_id == "") {
			throw new Exception("節點資料異常", 1);
		}


		$res = [
			"node_id" => "", //節點id
			"node_type" => "", //節點類型
			"child_ctrl_list" => [], //子節點選項卡控清單 (有在此陣列內的子節點類型才可建立)
			"node_info" => [], //節點資訊
			"child_node_list" => [] //子節點清單
		];
		//查詢節點資訊
		$sql = sprintf(
			"SELECT 
				_pan.id,
				_pan.node_name,
				_pan.node_type,
				_pab.base_name AS node_type_name,
				_pab.ctrl_child_list,
				_pani.id AS node_info_id,
				_pani.info_value,
				_pabi.info_name,
				_pabi.id AS base_info_id
			FROM 
				[%s].[dbo].[power_architecture_node] AS _pan
				LEFT JOIN [%s].[dbo].[power_architecture_base] AS _pab ON _pab.id = _pan.node_type
				LEFT JOIN [%s].[dbo].[power_architecture_node_info] AS _pani ON _pani.node_id = _pan.id
				LEFT JOIN [%s].[dbo].[power_architecture_base_info] AS _pabi ON _pabi.id = _pani.base_info_id
			WHERE 
				_pan.id = :node_id AND 
				_pan.deleted_at IS NULL
			ORDER BY
				_pabi.sort_inx",
			$this->database_alarm,
			$this->database_alarm,
			$this->database_alarm,
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			"node_id" => $s_node_id,
		]);
		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		foreach ($rows as $k => $v) {
			if ($res["node_id"] == "") {
				$res["node_id"] = $v["id"];
				$res["node_name"] = $v["node_name"];
				$res["node_type"] = $v["node_type"];
				$res["node_type_name"] = $v["node_type_name"];
			}
			if (empty($res["child_ctrl_list"]) && !empty($v["ctrl_child_list"])) {
				$res["child_ctrl_list"] = explode(",", $v["ctrl_child_list"]);
			}
			$res["node_info"][] = [
				"base_info_id" => $v["base_info_id"],
				"node_info_id" => $v["node_info_id"],
				"info_value" => $v["info_value"],
				"info_name" => $v["info_name"],
			];
		}


		//查詢子節點清單
		//查詢節點資訊
		$sql = sprintf(
			"SELECT 
				_pan.id,
				_pan.node_name,
				_pan.node_type,
				_pab.base_name
			FROM 
				[%s].[dbo].[power_architecture_node] AS _pan
				LEFT JOIN [%s].[dbo].[power_architecture_base] AS _pab ON _pab.id = _pan.node_type
			WHERE 
				_pan.parent_id = :node_id AND 
				_pan.deleted_at IS NULL;",
			$this->database_alarm,
			$this->database_alarm
		);
		$sth = $this->pdo_sql->prepare($sql);
		$sth->execute([
			"node_id" => $s_node_id,
		]);
		$rows = $sth->fetchAll(PDO::FETCH_ASSOC);
		foreach ($rows as $k => $v) {
			$res["child_node_list"][] = [
				"child_node_id" => $v["id"],
				"node_name" => $v["node_name"],
				"base_name" => $v["base_name"],
			];
		}

		return $res;
	}
	//樹狀結構函式
	private function get_childs_tree($data = array(), $parent_id = ''): array
	{

		$res = [];
		foreach ($data as $k => $v) {
			if ($v['parent_id'] === $parent_id) {
				$id = $v['id'];
				$v['children'] = self::get_childs_tree($data, $id);
				$res[] = $v;
			}
		}
		return $res;
	}
}
