<!DOCTYPE html>
<html lang="zh-tw">

<head>
	<?php
	include_once "html_head.inc";
	?>
	<style>
	</style>
</head>

<body>
	<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
		<?php
		include_once "html_layout_header.inc";
		?>
		<div style="display: flex;" class="electricity-page">
			<div class="container cal-container">
				<div class="electricity-border">
					<div class="electricity-block">
						<div class="ele_system_frameone">
							<span class="material-icons">home</span>
							<span class="ele_system_frameone_title">全廠用電</span>
						</div>
						<div class="ele_system_frametwo">
							<span class="material-icons">dataset</span>
							<span class="ele_system_frametwo_title">契約容量</span>
							<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_01] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_01].value : 0}}</span>
							<span class="ele_system_frametwo_unit">kW</span>
							<span class="material-icons">signal_cellular_alt</span>
							<span class="ele_system_frametwo_title">移動平均</span>
							<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_02] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_02].value : 0}}</span>
							<span class="ele_system_frametwo_unit">kW</span>
							<span class="material-icons">trending_up</span>
							<span class="ele_system_frametwo_title">即時功率</span>
							<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_03] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_03].value : 0}}</span>
							<span class="ele_system_frametwo_unit">kW</span>
							<span class="material-icons">flash_on</span>
							<span class="ele_system_frametwo_title">今日用電</span>
							<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_04] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_04].value : 'err'}}</span>
							<span class="ele_system_frametwo_unit">kWH</span>
							<span class="material-icons">flash_on</span>
							<span class="ele_system_frametwo_title">本月用電</span>
							<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_05] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_05].value : 0}}</span>
							<span class="ele_system_frametwo_unit">kWH</span>
						</div>
					</div>
				</div>
				<div id="electricity1_background">
					<!-- 底圖 -->
					<img src="./img/electricity1_background.png" alt="">
					<!-- 各區 -->
					<div class="factory_block" v-for="(v,k) in factory_block" :style="v.style">
						<div class="block_title row justify-between items-center">
							<div>
								<span>{{v.name}}
									<q-tooltip v-if="v.tooltip" anchor="bottom middle" self="top left" :offset="[10, 10]">
										{{v.tooltip}}
									</q-tooltip>
								</span>
							</div>
							<div :style="{backgroundColor:fnStatus(k,mqtt_electricity1).color,color:'white',padding:'0 5px',margin:'0 5px',borderRadius:'3px'}">
								<span>{{fnStatus(k,mqtt_electricity1).label}}</span>
							</div>
						</div>
						<div class="row items-center detail">
							<span class="ele_meter_title">今日用電</span>
							<span class="ele_meter_value">{{fnMQTT(k+'_day',mqtt_electricity1)}}</span>
							<span class="ele_meter_unit">度</span>
							<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageBar('B1',k)">
								equalizer
							</span>
						</div>
						<div class="row items-center detail">
							<span class="ele_meter_title">本月用電</span>
							<span class="ele_meter_value">{{fnMQTT(k+'_month',mqtt_electricity1)}}</span>
							<span class="ele_meter_unit">度</span>
							<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPagePie(k)">
								donut_small
							</span>
						</div>
						<div class="row items-center detail">
							<span class="ele_meter_title">即時功率</span>
							<span class="ele_meter_value">{{fnMQTT(k+'_now',mqtt_electricity1)}}</span>
							<span class="ele_meter_unit">kw</span>
							<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageMeter(k)">
								table_chart
							</span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php
		include_once "html_layout_footer.inc";
		?>
	</div>
	<?php
	include_once "html_loading.inc";
	?>
</body><?php
		$is_report_download = true;
		$is_googlemap = true;
		$is_echarts = true;
		include_once "html_down.inc";
		?>

</html>