<!DOCTYPE html>
<html lang="zh-tw">

<head>
	<?php
	include_once "html_head.inc";
	?>
</head>

<body>
	<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
		<?php
		include_once "html_layout_header.inc";
		?>
		<div style="display: flex;" class="electricity-page">
			<div class="container">
				<div class="electricity-border">
					<div class="electricity-block">
						<div class="ele_system_frameone">
							<span class="material-icons">home</span>
							<span class="ele_system_frameone_title">全廠用電</span>
						</div>
						<div class="ele_system_frametwo">
							<span class="material-icons">dataset</span>
							<span class="ele_system_frametwo_title">裝置容量</span>
							<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_01] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_01].value : 0}}</span>
							<span class="ele_system_frametwo_unit">kW</span>
							<span class="material-icons">signal_cellular_alt</span>
							<span class="ele_system_frametwo_title">平均移動</span>
							<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_02] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_02].value : 0}}</span>
							<span class="ele_system_frametwo_unit">kW</span>
							<span class="material-icons">trending_up</span>
							<span class="ele_system_frametwo_title">即時功率</span>
							<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_03] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_03].value : 0}}</span>
							<span class="ele_system_frametwo_unit">kW</span>
							<span class="material-icons">flash_on</span>
							<span class="ele_system_frametwo_title">今日用電</span>
							<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_04] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_04].value : 0}}</span>
							<span class="ele_system_frametwo_unit">kWH</span>
							<span class="material-icons">flash_on</span>
							<span class="ele_system_frametwo_title">本月用電</span>
							<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_05] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_05].value : 0}}</span>
							<span class="ele_system_frametwo_unit">kWH</span>
						</div>
					</div>
				</div>
				<div id="electricity2_background">
					<!-- 底圖 -->
					<img src="./img/electricity2_background.png" alt="">
					<!-- 各區 -->
					<!-- 鏈拉 -->
					<div class="factory_block" v-for="(v,k) in factory_block" :style="v.style">
						<div class="block_title row justify-between items-center" @click="console.log(fnStatus(k))">
							<div>
								<p>{{v.name}}</p>
							</div>
							<div :style="{backgroundColor:fnStatus(k,mqtt_electricity2).color,color:'white',padding:'0 5px',margin:'0 5px',borderRadius:'3px'}">
								<span>{{fnStatus(k,mqtt_electricity2).label}}</span>
							</div>
						</div>
						<div class="row items-center detail">
							<span class="ele_meter_title">今日用電</span>
							<span class="ele_meter_value">{{fnMQTT(k+'_day',mqtt_electricity2)}}</span>
							<span class="ele_meter_unit">度</span>
							<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageBar('1F',k)">
								equalizer
							</span>
						</div>
						<div class="row items-center detail">
							<span class="ele_meter_title">本月用電</span>
							<span class="ele_meter_value">{{fnMQTT(k+'_month',mqtt_electricity2)}}</span>
							<span class="ele_meter_unit">度</span>
							<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPagePie(k)">
								donut_small
							</span>
						</div>
						<div class="row items-center detail">
							<span class="ele_meter_title">即時功率</span>
							<span class="ele_meter_value">{{fnMQTT(k+'_now',mqtt_electricity2)}}</span>
							<span class="ele_meter_unit">kw</span>
							<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageMeter(k)">
								table_chart
							</span>
						</div>
					</div>
					<!-- <div class="factory_block" v-for="(v,k) in factory_block" :style="v.style">
						<div class="block_title row justify-between items-center" @click="console.log(fnStatus(k))">
							<div>
								<p>{{v.name}}</p>
							</div>
							<div :style="{backgroundColor:fnStatus(k).color,color:'white',padding:'0 5px',margin:'0 5px',borderRadius:'3px'}">
								<span>{{fnStatus(k).label}}</span>
							</div>
						</div>
						<div class="block_body column">
							<div class="block_body_info row justify-between items-center">
								<div style="color:#9A9A9A;" class="row items-center">
									今日用電
								</div>
								<div style="width:70px; text-align:center;">
									<span style="color:#3D6ED7;">{{fnSoft(k+'_day')}}</span>
								</div>
								<div style="width:35px; text-align:center;">
									<span>度</span>
								</div>
								<div class="row items-center">
									<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageBar('1F',k)">
										equalizer
									</span>
								</div>
							</div>
							<div class="block_body_info row justify-between items-center">
								<div style="color:#9A9A9A;" class="row items-center">
									本月用電
								</div>
								<div style="width:70px; text-align:center;">
									<span style="color:#3D6ED7;">{{fnSoft(k+'_month')}}</span>
								</div>
								<div style="width:35px; text-align:center;">
									<span>度</span>
								</div>
								<div class="row items-center">
									<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPagePie(k)">
										donut_small
									</span>
								</div>
							</div>
							<div class="block_body_info row justify-between items-center">
								<div style="color:#9A9A9A;" class="row items-center">
									即時功率
								</div>
								<div style="width:70px; text-align:center;">
									<span style="color:#3D6ED7;">{{fnSoft(k+'_now')}}</span>
								</div>
								<div style="width:35px; text-align:center;">
									<span>kw</span>
								</div>
								<div class="row items-center">
									<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageMeter(k)">
										table_chart
									</span>
								</div>
							</div>
						</div>
					</div> -->
				</div>


			</div>
		</div>
		<?php
		include_once "html_layout_footer.inc";
		?>
	</div>
	<?php
	include_once "html_loading.inc";
	?>
</body><?php
		$is_report_download = true;
		$is_googlemap = true;
		$is_echarts = true;
		include_once "html_down.inc";
		?>

</html>