<!DOCTYPE html>
<html lang="zh-tw">

<head><?php
		include_once "html_head.inc";
		?></head>

<body>
	<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
		<?php
		include_once "html_layout_header.inc";
		?>

		<div class="container">
			<div class="row items-center justify-between">
				<div class="row">
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 140px;">設備名稱</label>
						</div>
						<q-input style="width: 200px;" v-model="search.device_name" class="col search-block-input" align="center" clearable></q-input>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 140px;">資產編號</label>
						</div>
						<q-input style="width: 200px;" v-model="search.registration_number" class="col search-block-input" align="center" clearable></q-input>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 140px;">廠牌</label>
						</div>
						<q-input style="width: 200px;" v-model="search.brand" class="col search-block-input" align="center" clearable></q-input>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 140px;">型號</label>
						</div>
						<q-input style="width: 200px;" v-model="search.model_number" class="col search-block-input" align="center" clearable></q-input>
					</div>
					<div class="row items-center">
						<q-btn color="primary" class="id-btn" style="margin:10px;" glossy label="查詢" @click="searchData()" /></q-btn>
						<!-- <q-btn color="secondary" class="id-btn" style="margin:10px;" glossy label="匯出" @click="FnReportDownload('csv', easy_table.table_data, tableColumns, '警報紀錄')" /></q-btn> -->
					</div>
				</div>
				<div>
					<q-btn color="secondary" class="id-btn" glossy label="新增設備" @click="create_factory_device()" /></q-btn>
				</div>
			</div>
			<!-- 資料表單 -->
			<div class="custom-table bg-color-White">
				<ve-table style="width:100%" :scroll-width="0" :border-around="false" border-y :columns="tableColumns" :cell-style-option="easy_table.cellStyleOption" :table-data="tableData">
				</ve-table>
				<div class="custom-table-pagination row justify-end">
					<ve-pagination :total="totalCount" :page-index="easy_table.pageIndex" :page-size="easy_table.pageSize" @on-page-number-change="pageNumberChange" @on-page-size-change="pageSizeChange" />
				</div>
			</div>
			<!-- 新增工單彈窗 -->
			<template>
				<q-modal v-model="device_dialog.dialog_show" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss style="z-index:2000" :content-css="{maxheight: '80vh'}">
					<q-modal-layout class="custom-modal column" footer-style="box-shadow: 0px 10px 20px 0px #878787;">
						<!-- header -->
						<div class="bg-primary text-white modal-title" slot="header">
							<div class="row">
								<div class="row col items-center justify-center" style="padding: 10px 10px 10px 8%;">
									<span v-if="device_dialog.is_create"> 新增設備 </span>
									<span v-else> 修改設備 </span>
								</div>
								<div class="row items-center">
									<span class="material-icons dialog-close" style="padding: 0px 10px; cursor:pointer" @click="close_dialog()">close</span>
								</div>
							</div>
						</div>
						<!-- footer -->
						<div class="row justify-end" style="margin: 10px;" slot="footer">
							<q-btn color="light" glossy label="取消" class="id-btn" style="margin:0px 10px" @click="close_dialog()"></q-btn>
							<q-btn color="green" glossy label="儲存" class="id-btn" style="margin:0px 10px" @click="save_factory_device()"></q-btn>
						</div>
						<!-- content -->
						<div class="row add-system">
							<div class="column q-pa-sm">
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">設備名稱</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.device_name" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">廠牌</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.brand" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">型式</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.model_type" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">型號</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.model_number" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">登錄編號</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.registration_number" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">馬達-馬力</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.motor_horsepower" type="number" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">馬達-極數</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.motor_pole" type="number" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">馬達-效率等級</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.motor_efficiency_grade" class="" align="center" clearable></q-input>
								</div>
							</div>
							<div class="column q-pa-sm">
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">電熱功率</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.heater_power" type="number" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">額定功率</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.rated_power" type="number" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">西元製造年份</label>
									<date-picker style="width: 200px;" class="custom-dialog-datepicker" align="center" v-model="device_dialog.data.manufacture_year" :editable="false" format="YYYY" type="year" value-type="format"></date-picker>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">新增或汰換設備平均投資金額</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.investment_cost" type="number" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">設備容量-容量</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.capacity_value" type="number" class="" align="center" clearable></q-input>
								</div>
								<div class="row items-center q-ma-xs">
									<label style="width:150px" align="left" for="">設備容量-單位</label>
									<q-input style="width: 200px;" v-model="device_dialog.data.capacity_unit" class="" align="center" clearable></q-input>
								</div>
							</div>
						</div>
					</q-modal-layout>

				</q-modal>
			</template>
		</div>
	</div>

	<?php
	include_once "html_layout_footer.inc";
	?>
	</div>
	<?php
	include_once "html_loading.inc";
	?>
</body><?php
		$is_report_download = true;
		$is_googlemap = true;
		$is_echarts = true;
		include_once "html_down.inc";
		?>

</html>