<!DOCTYPE html>
<html lang="zh-tw">

<head>
	<?php
	include_once "html_head.inc";
	?><style>
		.area-title {
			/*background-image: linear-gradient(to right, #244BC3 0%, #2467C9 100%);*/
			padding: 9% 0 9% 0;
			margin: 33% 0%;
			color: #FFF;
			font-weight: 800;
			cursor: pointer;
			border-radius: 8px;
			background: #2d96e5eb;
		}

		.area-title:hover {
			background-image: linear-gradient(to right, #496bd1 0%, #3c76c9 100%);
		}

		.area-title:active {
			background-image: linear-gradient(to right, #1a46c9 0%, #1156ba 100%);
		}
	</style>
</head>

<body style="background-color: #F4F5F7;">
	<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
		<?php
		include_once "html_layout_header.inc";
		?>
		<div class="container ">

			<div class="electricity-border">
				<div class="electricity-block">
					<div class="ele_system_frameone">
						<span class="material-icons">home</span>
						<span class="ele_system_frameone_title">全廠用電</span>
					</div>
					<div class="ele_system_frametwo">
						<span class="material-icons">dataset</span>
						<span class="ele_system_frametwo_title">裝置容量</span>
						<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_01] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_01].value : 0}}</span>
						<span class="ele_system_frametwo_unit">kW</span>
						<span class="material-icons">signal_cellular_alt</span>
						<span class="ele_system_frametwo_title">平均移動</span>
						<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_02] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_02].value : 0}}</span>
						<span class="ele_system_frametwo_unit">kW</span>
						<span class="material-icons">trending_up</span>
						<span class="ele_system_frametwo_title">即時功率</span>
						<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_03] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_03].value : 0}}</span>
						<span class="ele_system_frametwo_unit">kW</span>
						<span class="material-icons">flash_on</span>
						<span class="ele_system_frametwo_title">今日用電</span>
						<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_04] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_04].value : 0}}</span>
						<span class="ele_system_frametwo_unit">kWH</span>
						<span class="material-icons">flash_on</span>
						<span class="ele_system_frametwo_title">本月用電</span>
						<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_05] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_05].value : 0}}</span>
						<span class="ele_system_frametwo_unit">kWH</span>
					</div>
				</div>
			</div>
			<div class="ele_meter_block">
				<div>
					<div class="area-title" @click="FnPageSwitch('electricity1.php')">
						<div style="text-align: center;">
							<span class="material-icons">list</span>
						</div>
						<div>
							<span style=" writing-mode: vertical-lr;">
								<span>Ｂ１</span>
							</span>
						</div>
					</div>
				</div>
				<div>
					<div class="all_factory">
						<!-- vue物件四個一組 -->
						<div>
							<div v-for="(v,k) in factory_b1_1" style="margin: 10px 5px;">
								<div class="factory_block">
									<div class="block_title row justify-between items-center">
										<div>
											<span>{{v.name}}
												<q-tooltip v-if="v.tooltip" anchor="bottom middle" self="top left" :offset="[10, 10]">
													{{v.tooltip}}
												</q-tooltip>
											</span>
										</div>
										<div class="row">
											<div>
												<span>{{last_update[k]}}</span>
											</div>
											<div :style="{backgroundColor:fnStatus(k,mqtt_electricity1).color,color:'white',padding:'0 5px',margin:'0 5px',borderRadius:'3px'}">
												<span>{{fnStatus(k,mqtt_electricity1).label}}</span>
											</div>
										</div>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">今日用電</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_day',mqtt_electricity1)}}</span>
										<span class="ele_meter_unit">度</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageBar('B1',k)">
											equalizer
										</span>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">本月用電</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_month',mqtt_electricity1)}}</span>
										<span class="ele_meter_unit">度</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPagePie(k)">
											donut_small
										</span>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">即時功率</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_now',mqtt_electricity1)}}</span>
										<span class="ele_meter_unit">kw</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageMeter(k)">
											table_chart
										</span>
									</div>
								</div>
							</div>
						</div>
						<div>
							<div v-for="(v,k) in factory_b1_2" style="margin: 10px 5px;">
								<div class="factory_block">
									<div class="block_title row justify-between items-center">
										<!-- <div>
												<p>{{v.name}}</p>
											</div> -->
										<div>
											<span>{{v.name}}
												<q-tooltip v-if="v.tooltip" anchor="bottom middle" self="top left" :offset="[10, 10]">
													{{v.tooltip}}
												</q-tooltip>
											</span>
										</div>
										<div class="row">
											<div>
												<span>{{last_update[k]}}</span>
											</div>
											<div :style="{backgroundColor:fnStatus(k,mqtt_electricity1).color,color:'white',padding:'0 5px',margin:'0 5px',borderRadius:'3px'}">
												<span>{{fnStatus(k,mqtt_electricity1).label}}</span>
											</div>
										</div>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">今日用電</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_day',mqtt_electricity1)}}</span>
										<span class="ele_meter_unit">度</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageBar('B1',k)">
											equalizer
										</span>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">本月用電</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_month',mqtt_electricity1)}}</span>
										<span class="ele_meter_unit">度</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPagePie(k)">
											donut_small
										</span>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">即時功率</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_now',mqtt_electricity1)}}</span>
										<span class="ele_meter_unit">kw</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageMeter(k)">
											table_chart
										</span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div>
					<div class="area-title" @click="FnPageSwitch('electricity2.php')">
						<div style="text-align: center;">
							<span class="material-icons">list</span>
						</div>
						<div>
							<span style=" writing-mode: vertical-lr;">
								<span>１ＡＦ</span>
							</span>
						</div>
					</div>
				</div>
				<div>
					<div class="all_factory">
						<!-- vue物件四個一組 -->
						<div>
							<div v-for="(v,k) in factory_1af" style="margin:10px 5px;">
								<div class="factory_block">
									<div class="block_title row justify-between items-center">
										<div>
											<p>{{v.name}}</p>
										</div>
										<div class="row">
											<div>
												<span>{{last_update[k]}}</span>
											</div>
											<div :style="{backgroundColor:fnStatus(k,mqtt_electricity2).color,color:'white',padding:'0 5px',margin:'0 5px',borderRadius:'3px'}">
												<span>{{fnStatus(k,mqtt_electricity2).label}}</span>
											</div>
										</div>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">今日用電</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_day',mqtt_electricity2)}}</span>
										<span class="ele_meter_unit">度</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageBar('1AF',k)">
											equalizer
										</span>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">本月用電</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_month',mqtt_electricity2)}}</span>
										<span class="ele_meter_unit">度</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPagePie(k)">
											donut_small
										</span>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">即時功率</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_now',mqtt_electricity2)}}</span>
										<span class="ele_meter_unit">kw</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageMeter(k)">
											table_chart
										</span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div>
					<div class="area-title" @click="FnPageSwitch('electricity3.php')">
						<div style="text-align: center;">
							<span class="material-icons">list</span>
						</div>
						<div>
							<span style=" writing-mode: vertical-lr;">
								<span>１Ｆ</span>
							</span>
						</div>
					</div>
				</div>
				<div>
					<div class="all_factory">
						<!-- vue物件四個一組 -->
						<div>
							<div v-for="(v,k) in factory_1f" style="margin:10px 5px;">
								<div class="factory_block">
									<div class="block_title row justify-between items-center">
										<div>
											<p>{{v.name}}</p>
										</div>
										<div class="row">
											<div>
												<span>{{last_update[k]}}</span>
											</div>
											<div :style="{backgroundColor:fnStatus(k,mqtt_electricity3).color,color:'white',padding:'0 5px',margin:'0 5px',borderRadius:'3px'}">
												<span>{{fnStatus(k,mqtt_electricity3).label}}</span>
											</div>
										</div>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">今日用電</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_day',mqtt_electricity3)}}</span>
										<span class="ele_meter_unit">度</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageBar('1F',k)">
											equalizer
										</span>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">本月用電</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_month',mqtt_electricity3)}}</span>
										<span class="ele_meter_unit">度</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPagePie(k)">
											donut_small
										</span>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">即時功率</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_now',mqtt_electricity3)}}</span>
										<span class="ele_meter_unit">kw</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageMeter(k)">
											table_chart
										</span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div>
					<div class="area-title" @click="FnPageSwitch('electricity4.php')">
						<div style="text-align: center;">
							<span class="material-icons">list</span>
						</div>
						<div>
							<span style=" writing-mode: vertical-lr;">
								<span>２Ｆ</span>
							</span>
						</div>
					</div>
				</div>
				<div>
					<div class="all_factory">
						<!-- vue物件五個一組 -->
						<div>
							<div v-for="(v,k) in factory_2f" style="margin:10px 5px;">
								<div class="factory_block">
									<div class="block_title row justify-between items-center">
										<div>
											<p>{{v.name}}</p>
										</div>
										<div class="row">
											<div>
												<span>{{last_update[k]}}</span>
											</div>
											<div :style="{backgroundColor:fnStatus(k,mqtt_electricity4).color,color:'white',padding:'0 5px',margin:'0 5px',borderRadius:'3px'}">
												<span>{{fnStatus(k,mqtt_electricity4).label}}</span>
											</div>
										</div>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">今日用電</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_day',mqtt_electricity4)}}</span>
										<span class="ele_meter_unit">度</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageBar('2F',k)">
											equalizer
										</span>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">本月用電</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_month',mqtt_electricity4)}}</span>
										<span class="ele_meter_unit">度</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPagePie(k)">
											donut_small
										</span>
									</div>
									<div class="row items-center detail">
										<span class="ele_meter_title">即時功率</span>
										<span class="ele_meter_value">{{fnMQTT(k+'_now',mqtt_electricity4)}}</span>
										<span class="ele_meter_unit">kw</span>
										<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageMeter(k)">
											table_chart
										</span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</div>
		<?php
		include_once "html_layout_footer.inc";
		?>
	</div>
	<?php
	include_once "html_loading.inc";
	?>
</body><?php
		$is_report_download = true;
		$is_googlemap = true;
		$is_echarts = true;
		include_once "html_down.inc";
		?>

</html>