/*
  FILE: i18n_messages.js
  在 html_down.inc 引入
  usage:
    <div>{{ $t("lbl.hello") }}</div>
    this.$t("lbl.hello")
*/
if ($$i18n_messages == undefined) {
  var $$i18n_messages = {}
}
$$i18n_messages["en-us"] = { // en-us 英語
  "language": "English",
  "sys": {
    "version": "version",
    "loading_wait": "loading data, please wait",
    "plz_try_again": "please try again",
    "user": "user",
    "ok": "ok",
    "cancel": "cancel",
    "edit": "edit",
    "view": "view",
    "export": "export",
    "search": "search",
    "setting": "setting",
    "save": "save",
    "update": "update",
    "delete": "delete",
    "void": "void",
    "close": "close",
    "recovery": "recovery",
    "default": "default",
    "column": "column",
    "phase": {
      "draft": "Draft",
      "execute": "Execute",
      "complete": "Complete",
      "end": "End",
      "cancel": "Cancel",
      "void": "Void",
    },
    "message": {
      "info": "info",
      "confirm": "confirm",
      "download_error": "download error",
      "are_sure_to_execute": "are you sure to execute?",
      "execute_success": "execute success",
    },
    "weather_location": { // 可再此加其它縣市
      "city": {
        "彰化縣": "Zhanghua",
        "臺南市": "Tainan",
        "臺中市": "Taichung",
      },
      "town": {
        "伸港鄉": "Shengang",
        "仁德區": "Rende",
        "大里區": "Dali",
        "社頭鄉": "Shetou",
        "秀水鄉": "Xiushui",
        "永康區": "Yongkang",
      },

    },
  },
  "options": {
    "time": {
      "all_time": "All Time",
      "ten_min": "10 Minute",
      "thirty_min": "30 Minute",
      "one_hour": "1 Hour",
      "one_day": "1 Day",
    },
  },
  "layout": {
    "system_name": "Solar System",
    "menu": "menu",
    "collapse_menu": "collapse menu",
    "expand_menu": "expand menu",
    "right_menu": "right menu",
    "nav_menu": {
      "home": "home",
      "station_list": "station list",
      "back": "back",
    },
    "change_password": {
      "title": "change password",
      "label": {
        "user_id": "user id",
        "user_name": "user name",
        "old_pwd": "old password",
        "new_pwd1": "new password",
        "new_pwd2": "confirm new password",
      },
      "msg": {
        "new_pwd_empty": "new password can not be empty",
        "new_pwd_not_same": "new password and confirm new password are not the same",
        "old_pwd_error": "old password error",
        "other_error": "other error",
        "change_pwd_success": "change password success",
      },
    },
  },
  "page": {
    "login": {
      "system_login": "System Login",
      "account": "user id",
      "password": "password",
      "login": "login",
      "logout": "logout",
      "plz_login_again": "please login again",
      "login_expire": "login expired",
      "login_failed": "login failed",
      "verify_failed": "verification failed",
    },
    "index": {
      "ac_power": "AC Power",
      "pyanometer": "Pyranometer(Avg)",
      "site_title_info": {
        "project_name": "Project Name",
        "location": "Location",
        "installed_capacity": "Installed Capacity ",
        "system_running_date": "System Running Date",
        "numbers_of_station": "Numbers of Station",
        "system_status": "System Status",
      },
      "month_power_trend": {
        "today_power_generation": "Today Power Generation",
        "pr_value": "PR Value",
        "monthly_power_generation": "Monthly Power Generation",
      },
      "weather_info": {
        "title": {
          "weather": "Weather Report"
        },
        "pyranometer": "Pyranometer(H)",
        "rain_gauge": "Rain Gauge",
        "ambient_temperature": "Ambient Temperature",
        "ambient_humidity": "Ambient Humidity",
        "wind_speed": "Wind Speed",
        "wind_direction": "Wind Direction",
        "weather_short": {
          "clear": "Clear",
          "cloudy": "Cloudy",
          "thunderstorm": "Thunderstorm",
          "cloudy_fog": "Cloudy Fog",
          "fog": "Fog",
          "snowing": "Snowing",
        },
      },
      "all_ac_station_info": {
        "energy": "Energy (MWh)：",
        "total_power": "Total Power：",
        "ambient_temperature": "Ambient Temperature：",
        "pyranometer": "Pyranometer(Tilt Angle)：",
        "status": "Status：",
        "ac_power": "AC POWER：",
        "dc_power": "DC POWER：",
      },
    },
  },
  "menu": {
    "index": "Home",
    "station_map": "Station Map",
    "station_menu": "Station Menu",
    "station_overview": "Station Overview",
    "station_list": "Station List",
    "inverter_list": "Inverter Instant Data",
    "alarm_list": "Device Alarm List",
    "alarm_list_confirm": "Alarm List Confirm",
    "power_history_data": "Power History Data",
    "hv_room": "HV Room",
    "ac_station_history": "AC Station",
    "inverter_history": "Inverter",
    "power_collect_data": "Power Collect Data",
    "insolation_report": "Insolation Report",
    "inverter_report": "Inverter Report",
    "weather_data": "Weather Data",
    "weather_report": "Weather Report",
    "weather_summary": "Weather Summary",
    "trend_report": "Trend/Report",
    "month_year_bar_chart": "Average Power Generation hours",
    "stations_trend_report_power": "Power Generation of day (day/month/year)",
    "test": "TEST",
    "admin": "Management",
    "admin_users": "User Management",
    "sample": "sample",
    "sample_data_table": "sample data table",
    "stn_index": "Station Home",
    "stn_inverter_data": "Inverter Data",
    "stn_alarm_list": "Alarm List",
    "index_chart_base_line": "Index Chart Base Line",
    "check_list": "Inspection Dispatch",
    "22k_system": "22K System",
    "69k_system": "69K System",
    "my_pvsingle": "my PVSingle",
    "inverter_trend": "Inverter Trend",
    "ac_station_trend": "AC Station Trend",
    "check_list_dispatch": "Dispatch Check",
    "alarm_dispatch": "Alarm Dispatch",
    "maintenance_management": "Maintenance",
    "station_setting": "Station Setting",
    "inverter_setting": "Inverter Setting",
    "real_time_monitoring": "Instant Monitoring",
    "station_dashboard": "Station Dashboard",
    "ai_alarm_list": "AI Alarm List",
    "stn_data_alarm_list": "Station Energy Alarm List",
    "alarm_menu" : "Alarm Menu",
    "regional_analysis" : "Regional Analysis",
    "admin_page_permission_setting" : "Page Permission Setting",
  },
  "taiwan_place": {
    "keelung_city": "Keelung City",
    "new_taipei_city": "New Taipei City",
    "taipei_city": "Taipei City",
    "taoyuan_city": "Taoyuan City",
    "hsinchu_county": "Hsinchu County",
    "hsinchu_city": "Hsinchu City",
    "miaoli_city": "Miaoli City",
    "miaoli_county": "Miaoli County",
    "taichung_city": "Taichung City",
    "changhua_county": "Changhua County",
    "changhua_city": "Changhua City",
    "nantou_city": "Nantou City",
    "nantou_county": "Nantou County",
    "yunlin_county": "Yunlin County",
    "chiayi_county": "Chiayi County",
    "chiayi_city": "Chiayi City",
    "tainan_city": "Tainan City",
    "kaohsiung_city": "Kaohsiung City",
    "pingtung_county": "Pingtung County",
    "pingtung_city": "Pingtung City",
    "yilan_county": "Yilan County",
    "yilan_city": "Yilan City",
    "hualien_county": "Hualien County",
    "hualien_city": "Hualien City",
    "taitung_city": "Taitung City",
    "taitung_county": "Taitung County",
    "penghu_county": "Penghu County",
    "green_island": "Green Island",
    "orchid_island": "Orchid Island",
    "kinmen_county": "Kinmen County",
    "matsu": "Matsu",
    "lienchiang_county": "Lienchiang County",
  },
  "api_msg": { // 後端的 message 訊息
    "menu": {
      "test": "test menu",
    }
  },
};