var page_function = {
	components: {
		"data-table": httpVueLoader("components/layout/data_table.vue"),
	},
	data() {
		return {
			"VarMenuPage": "admin_page_permission_setting",
			"VarMenu": "area",
			"VarPageContainerCss": "height:calc(100vh - 65px);",

			"formPageSet": {
				"view": false,
				"edit": true,
				"update": false,
				"role": null,
				"tempPageName": [],
				"tempSelectUse": [],
			},

			easy_table: {
				pageIndex: 1,
				pageSize: 10,
				cellStyleOption: {
					headerCellClass: ({ column, rowIndex }) => {
						return "bg-primary text-white custom-table-header";
					},
				},
				data: [],
			},

		}
	},
	computed: {
		tableColumns() {
			let arr = [
				{
					field: "role_name",
					key: "role_name",
					title: "角色名稱",
					align: "center",
					width: 150,
				},
				{
					field: "_edit",
					key: "_edit",
					title: "權限設定",
					width: 250,
					renderBodyCell: ({ row, column, rowIndex }, h) => {
						let dom = [];
						// if (row.edit_ctrl) {
						dom = [
							h("q-btn", {
								class: "glossy",
								style: "margin:0px 10px; min-height: 1em;",
								attrs: {
									label: "修改",
									color: "blue",
								},
								on: {
									click: () => {
										this.viewRoleId(row);
									},
								},
							}),
						];
						// }
						return dom;
					},
				},
			];
			return arr;
		},
		// table data
		tableData() {
			const { pageIndex, pageSize } = this.easy_table;
			return this.easy_table.data.slice(
				(pageIndex - 1) * pageSize,
				pageIndex * pageSize
			);
		},
		totalCount() {
			return this.easy_table.data.length;
		},

		// columns() { // 為了配合多國語系, columns 需使用 computed
		// 	return [
		// 		{
		// 			name: "role_name",
		// 			required: true,
		// 			label: "角色名稱",
		// 			align: "center",
		// 			field: "role_name",
		// 			sortable: true,
		// 			style: "width: 100px",
		// 		},
		// 		{
		// 			name: "view_page",
		// 			required: true,
		// 			label: "頁面權限設定",
		// 			align: "center",
		// 			field: "view_page",
		// 			sortable: true,
		// 			style: "width: 100px",
		// 			$$is_slot: true,
		// 		},
		// 	]
		// },
		// pageEditBtn() {
		// 	if (_.includes(this.LoginSetup.roles, 'admin')) {
		// 		return true;
		// 	} else {
		// 		return false;
		// 	}
		// }
	},

	watch: {

	},

	mounted() {
		this.$set(this.WebSetup, "caption", '角色頁面權限設定');
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.getData();
	},

	methods: {
		// page number change
		pageNumberChange(pageIndex) {
			this.easy_table.pageIndex = pageIndex;
		},
		// page size change
		pageSizeChange(pageSize) {
			this.easy_table.pageIndex = 1;
			this.easy_table.pageSize = pageSize;
		},

		btnSwitch() {
			let that = this;
			that.formPageSet['edit'] = false;
			that.formPageSet['update'] = true;
		},
		//載入資料
		getData() {
			let that = this;
			that.$q.loading.show();
			var params = {
				Action: "Roles",
				Datas: {},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					resData.forEach(el => {

						that.easy_table.data.push(el);
					})
					that.$q.loading.hide();
				} else {
					that.FnNotify(res.data.message, "error");
					that.$q.loading.hide();
				}
			});
		},

		//	step.1 檢視 撈資料
		viewRoleId(props) {
			this.$q.loading.show();
			let that = this;
			var params = {
				Action: "MenuLoad",
				Datas: {
					menu: "permissions",
				},
				menu_page: "sys_component",
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;

					that.formPageSet["tempSelectUse"] = [];
					that.formPageSet["view"] = true;
					that.formPageSet["edit"] = true;
					that.formPageSet["update"] = false;
					that.formPageSet["role"] = props.role_id;
					that.formPageSet["tempPageName"] = resData;
					that.viewRoleViewPage();
				} else {
					that.$q.loading.hide();
					that.FnNotify(res.data.message, "error");
				}
			});
		},

		//	step.1-2 檢視之前的紀錄
		viewRoleViewPage() {
			let that = this;
			var params = {
				Action: "Menu",
				Datas: {
					role_id: that.formPageSet["role"],
				},
			};
			return that.FnWebAPIGet(params).then((res) => {
				that.$q.loading.hide();
				if (res.data.result) {
					var resData = res.data.data;
					_.each(resData, (item, idx) => {
						that.formPageSet["tempSelectUse"].push(item);
					});
				} else {
					that.$q.loading.hide();
					that.FnNotify(res.data.message, "error");
				}
			});
		},

		//	step.2 更新角色頁面權限設定
		updateRoleMenu(props) {
			this.$q.loading.show();
			let that = this;
			var params = {
				Action: "RoleMenu",
				Datas: {
					role: that.formPageSet["role"],
					page_arr: that.formPageSet["tempSelectUse"],
				},
			};
			return that.FnWebAPIPost(params).then((res) => {
				if (res.data.result) {
					that.FnNotify(res.data.message, "success");
					that.formPageSet["view"] = false;
				} else {
					that.FnNotify(res.data.message, "error");
				}
				this.$q.loading.hide();
			});
		},


		// 表單checkbox狀態連動判斷
		checkbox_link(inx) {
			let that = this;
			inx = inx.toString();
			let inx_split = inx.split("-");
			let inx_1 = null;
			let inx_2 = null;
			let func = null;
			inx_split.forEach((el, i) => {
				if (i == 0) {
					if (el.includes(".")) {
						func = el.split(".")[1];
						inx_1 = el.split(".")[0];
					} else {
						inx_1 = el;
					}
				} else if (i == 1) {
					if (el.includes(".")) {
						func = el.split(".")[1];
						inx_2 = el.split(".")[0];
					} else {
						inx_2 = el;
					}
				}
			});
			let page_name_1 = that.formPageSet.tempPageName[inx_1].menu_id;
			let page_name_2 =
				inx_2 == null
					? ""
					: that.formPageSet.tempPageName[inx_1].children[inx_2].menu_id;
			let func_name = "";
			if (func != null) {
				func_name =
					inx_2 == null
						? that.formPageSet.tempPageName[inx_1].function[func]
						: that.formPageSet.tempPageName[inx_1].children[inx_2].function[
						func
						];
			}
			let check_menu_id = "";
			if (page_name_2 == "") {
				check_menu_id = page_name_1;
				if (func_name != "") {
					check_menu_id = `${check_menu_id}.${func_name}`;
				}
			} else {
				check_menu_id = page_name_2;
				if (func_name != "") {
					check_menu_id = `${check_menu_id}.${func_name}`;
				}
			}
			let checked_type = that.formPageSet.tempSelectUse.includes(check_menu_id);
			//選中
			if (checked_type) {
				if (
					!that.formPageSet.tempSelectUse.includes(page_name_1) &&
					page_name_1 != ""
				) {
					that.formPageSet.tempSelectUse.push(page_name_1);
				}
				if (
					!that.formPageSet.tempSelectUse.includes(page_name_2) &&
					page_name_2 != ""
				) {
					that.formPageSet.tempSelectUse.push(page_name_2);
				}
			}
			//未選
			else {
				//第二層
				if (page_name_2 != "") {
					if (
						that.formPageSet.tempPageName[inx_1].children[inx_2].function !=
						undefined &&
						func_name == ""
					) {
						that.formPageSet.tempPageName[inx_1].children[
							inx_2
						].function.forEach((el_func) => {
							that.formPageSet.tempSelectUse =
								that.formPageSet.tempSelectUse.filter(function (item) {
									return item !== `${page_name_2}.${el_func}`;
								});
						});
					}
				}
				//第一層
				else {
					if (that.formPageSet.tempPageName[inx_1].children != undefined) {
						that.formPageSet.tempPageName[inx_1].children.forEach((el) => {
							if (el.function != undefined) {
								el.function.forEach((el_func) => {
									that.formPageSet.tempSelectUse =
										that.formPageSet.tempSelectUse.filter(function (item) {
											return item !== `${el.menu_id}.${el_func}`;
										});
								});
							}
							that.formPageSet.tempSelectUse =
								that.formPageSet.tempSelectUse.filter(function (item) {
									return item !== `${el.menu_id}`;
								});
						});
					}
					if (
						that.formPageSet.tempPageName[inx_1].function != undefined &&
						func_name == ""
					) {
						that.formPageSet.tempPageName[inx_1].function.forEach((el_func) => {
							that.formPageSet.tempSelectUse =
								that.formPageSet.tempSelectUse.filter(function (item) {
									return item !== `${page_name_1}.${el_func}`;
								});
						});
					}
				}
			}
		},
	}
}