var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "air_compressor_device",
      VarMenu: "area",
      VarPageContainerCss: "height:calc(100vh - 65px);",

      search: {
        region: null,
        asset_number: null,
        device_name: null,
      },

      //表單設定物件
      easy_table: {
        pageIndex: 1,
        pageSize: 10,
        cellStyleOption: {
          headerCellClass: ({ column, rowIndex }) => {
            return "bg-primary text-white custom-table-header";
          },
        },
        table_data: [],
      },

      //彈窗-新增、修改設備
      device_dialog: {
        dialog_show: false, //彈窗控制
        is_create: true, //是否為新增 true:新增 false:修改
        //設備資料
        data: {
          air_compressor_device_id: null,//空壓機設備表id 不為null的話代表修改
          region: null, //區域
          asset_number: null, //資產編號
          device_category: null, //設備類別
          device_name: null, //設備名稱
          brand: null, //廠牌
          model_type: null, //型式
          model_number: null, //型號
          horsepower: null, //馬力
          quantity: null, //台數
        }
      },
    };
  },

  computed: {
    //表單欄位
    tableColumns() {
      let arr = [
        {
          field: "region",
          key: "region",
          title: "區域",
          align: "center",
          width: 150,
        },
        {
          field: "asset_number",
          key: "asset_number",
          title: "資產編號",
          align: "center",
          width: 150,
        },
        {
          field: "device_category",
          key: "device_category",
          title: "設備類別",
          align: "center",
          width: 150,
        },
        {
          field: "device_name",
          key: "device_name",
          title: "設備名稱",
          align: "center",
          width: 150,
        },
        {
          field: "brand",
          key: "brand",
          title: "廠牌",
          align: "center",
          width: 150,
        },
        {
          field: "model_type",
          key: "model_type",
          title: "型式",
          align: "center",
          width: 150,
        },
        {
          field: "model_number",
          key: "model_number",
          title: "型號",
          align: "center",
          width: 150,
        },
        {
          field: "horsepower",
          key: "horsepower",
          title: "馬力",
          align: "center",
          width: 150,
        },
        {
          field: "quantity",
          key: "quantity",
          title: "台數",
          align: "center",
          width: 150,
        },
        {
          field: "_edit",
          key: "_edit",
          title: "-",
          align: "center",
          width: 250,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let dom = [];
            dom = [
              h("q-btn", {
                class: "glossy",
                style: "margin:0px 10px; min-height: 1em; font-size:20px;",
                attrs: {
                  label: "修改",
                  color: "blue",
                },
                on: {
                  click: () => {
                    this.edit_air_compressor_device(row.id);
                  },
                },
              }),
              h("q-btn", {
                class: "glossy",
                style: "margin:0px 10px; min-height: 1em; font-size:20px;",
                attrs: {
                  label: "刪除",
                  color: "red",
                },
                on: {
                  click: () => {
                    this.del_air_compressor_device(row);
                  },
                },
              }),
            ];

            return dom;
          },
        },
      ];
      return arr;
    },
    //表單資料總數
    totalCount() {
      return this.easy_table.table_data.length;
    },
    //表單資料分頁邏輯
    tableData() {
      const { pageIndex, pageSize } = this.easy_table;
      return this.easy_table.table_data.slice(
        (pageIndex - 1) * pageSize,
        pageIndex * pageSize
      );
    },
  },

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", this.$t("menu.air_compressor_device"));
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    this.searchData()
  },

  methods: {

    async searchData() {
      let that = this;
      that.$q.loading.show();
      var params = {
        Action: "air_compressor_device_list",
        Datas: that.search
      }
      await this.FnWebAPIGet(params).then((res) => {
        if (res.data.result) {
          this.easy_table.table_data = []
          this.easy_table.table_data = res.data.data
        } else {
          throw res.data.message
        }
        that.$q.loading.hide();
      }).catch(function (err) {
        that.FnNotify(err, 'error')
        that.$q.loading.hide();
      });
    },

    // page number change
    pageNumberChange(pageIndex) {
      this.easy_table.pageIndex = pageIndex;
    },

    // page size change
    pageSizeChange(pageSize) {
      this.easy_table.pageIndex = 1;
      this.easy_table.pageSize = pageSize;
    },

    //新增空壓機設備
    create_air_compressor_device() {
      this.device_dialog.dialog_show = true
    },

    //修改空壓機設備
    async edit_air_compressor_device(air_compressor_device_id) {
      let that = this;
      this.$q.loading.show();
      if (air_compressor_device_id == undefined || air_compressor_device_id == "") {
        this.FnNotify("空壓機設備資料異常", "error");
      } else {

        var params = {
          Action: "get_air_compressor_device_info",
          Datas: {
            air_compressor_device_id: air_compressor_device_id
          },
        }
        await this.FnWebAPIGet(params).then((res) => {
          if (res.data.result) {
            let resData = res.data.data;

            that.device_dialog.data.air_compressor_device_id = resData.id
            that.device_dialog.data.region = resData.region
            that.device_dialog.data.asset_number = resData.asset_number
            that.device_dialog.data.device_category = resData.device_category
            that.device_dialog.data.device_name = resData.device_name
            that.device_dialog.data.brand = resData.brand
            that.device_dialog.data.model_type = resData.model_type
            that.device_dialog.data.model_number = resData.model_number
            that.device_dialog.data.horsepower = resData.horsepower
            that.device_dialog.data.quantity = resData.quantity

            //顯示彈窗
            that.device_dialog.dialog_show = true
            //修改空壓機設備時 is_create 設定為false
            that.device_dialog.is_create = false
          } else {
            this.FnNotify(res.data.message, 'error')
          }
          this.$q.loading.hide();
        }).catch(function (err) {
          this.FnNotify(err, 'error')
          this.$q.loading.hide();
        });
      }
    },

    //儲存設備資料
    async save_air_compressor_device(is_update = false) {
      var that = this;
      try {
        if (
          this.device_dialog.data.device_name == null ||
          this.device_dialog.data.device_name == ""
        ) {
          throw "設備名稱不可為空";
        }

        that.$q.loading.show();

        var params = {
          Action: "save_air_compressor_device",
          Datas: this.device_dialog.data,
        }
        await this.FnWebAPIPost(params).then((res) => {
          if (!res.data.result) {
            throw `${res.data.message}`
          }
        }).catch(function (err) {
          throw `失敗: ${err}`
        });

        that.FnNotify("儲存成功", "success")
        that.$data.device_dialog = that.$options.data().device_dialog;
        that.searchData()


      } catch (error) {
        this.FnNotify(error, "error");
        that.$q.loading.hide();
      }
    },

    //刪除設備資料
    async del_air_compressor_device(row_data) {
      var that = this;
      // await this.$q
      //   .dialog({
      //     title: "是否刪除資料！？",
      //     message: `即將刪除（${row_data.device_name}）`,
      //     color: "primary",
      //     ok: true,
      //     cancel: true,
      //   })
      //   .then(() => {
        if (
          await that.FnConfirm2("是否刪除資料？")
        ) {
          that.$q.loading.show();
          var params = {
            Action: 'del_air_compressor_device',
            Datas: {
              air_compressor_device_id: row_data.id
            },
          };
          return that.FnWebAPIPost(params).then((res) => {
            if (res.data.result) {
              that.searchData()
              that.FnNotify('刪除成功', 'success')
            } else {
              that.FnNotify(res.data.message, 'error')
            }
          })
          }
        // })
        // .catch(() => {
        // });
    },

    //關閉新增、修改彈窗
    close_dialog() {
      var that = this;
      that.$data.device_dialog = that.$options.data().device_dialog;

    },




  },
};
