var page_function = {
  components: {
    "electricity-sidebar": httpVueLoader.load(
      "./components/electricity_sidebar.vue"
    ),
  },
  data() {
    return {
      VarMenuPage: "electricity1",
      VarMenu: "area",
      VarPageContainerCss: "",
      //各廠區資料
      factory_block: {
        ACM1: {
          name: "1號冰水主機",
          style:{
            top: '8.5%',
            left: '7%',
          },
        },
        ACM2: {
          name: "2號冰水主機",
          style:{
            top: '8.5%',
            left: '23%',
          },
        },
        ACM3: {
          name: "3號冰水主機",
          style:{
            top: '34.5%',
            left: '23%',
          },
        },
        ACM4: {
          name: "中營所凍庫",
          style:{
            top: '43%',
            left: '52%',
          },
        },
        ACM5: {
          name: "原料庫",
          style:{
            top: '72%',
            left: '10%',
          },
        },
        ACM6: {
          name: "解凍室",
          style:{
            top: '72%',
            left: '26%',
          },
        },
        ACM7: {
          name: "肉類半成品庫",
          style:{
            top: '46%',
            left: '0.3%',
          },
        },
        ACM8: {
          name: "蔬菜冷藏庫",
          style:{
            top: '8.5%',
            left: '42%',
          },
        },
      },
    };
  },

  computed: {},

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "B1用電");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
  },
  methods: {
    fnInitial(cfg) {
      this.IsSoftStartup = true; // cfg載入完成時執行第一次
      this.IsMQTTStartup = true;
    },
    //取得點位數值
    fnSoft(v) {
      if (this.SoftTagName[v] != undefined) {
        return this.SoftTagName[v]["value"];
      } else {
        return 0;
      }
    },
    //取得點位數值
    fnMQTT(v,mqtt) {
      if (this.MQTTPoints[mqtt[v]] != undefined) {
        return this.MQTTPoints[mqtt[v]]["value"];
      } else {
        return 'err';
      }
    },
    fnStatus(v,mqtt) {
      v += '_status';
      let temp = {
        color: 'black',
        label: '異常'
      };
      if (Object.keys(this.MQTTPoints).length > 0) {
        if (this.MQTTPoints[mqtt[v]] != undefined) {
          if(this.MQTTPoints[mqtt[v]].value == '0'){
            temp = {
              color: '#61C640',
              label: '連線',
              value:this.MQTTPoints[mqtt[v]].value,
            };
          }else{
            temp = {
              color: '#E35930',
              label: '斷線'
            };
          }
        } else {
          temp = {
            color: '#41ABC4',
            label: '虛擬'
          };
        }
      }
      return temp;
    },

    fnPageBar(plant,meter) {
      sessionStorage.setItem("bar", plant);
      sessionStorage.setItem("bar2", meter);
      this.FnPageSwitch("trend.php");
    },
    fnPagePie(session) {
      sessionStorage.setItem("pie", session);
      this.FnPageSwitch("trend.php");
    },
    fnPageMeter(session) {
      sessionStorage.setItem("meter", session);
      this.FnPageSwitch("electricity_meter.php");
    },
  },
};
