var page_function = {
  components: {
    "electricity-sidebar": httpVueLoader.load(
      "./components/electricity_sidebar.vue"
    ),
  },
  data() {
    return {
      VarMenuPage: "electricity4",
      VarMenu: "area",
      VarPageContainerCss: "",
      //各廠區資料
      factory_block: {
        //鏈拉
        ACM13: {
          name: "新急凍庫",
          style: {
            top: '52%',
            left: '0%',
          },
        },
        //研磨
        ACM14: {
          name: "舊急凍庫",
          style: {
            top: '77%',
            left: '0%',
          },
        },
      },
    };
  },

  computed: {},

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "2F用電");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
  },
  methods: {
    fnInitial(cfg) {
      this.IsSoftStartup = true; // cfg載入完成時執行第一次
      this.IsMQTTStartup = true;
    },
    //取得點位數值
    fnSoft(v) {
      if (this.SoftTagName[v] != undefined) {
        return this.SoftTagName[v]["value"];
      } else {
        return 0;
      }
    },
    //取得點位數值
    fnMQTT(v, mqtt) {
      if (this.MQTTPoints[mqtt[v]] != undefined) {
        return this.MQTTPoints[mqtt[v]]["value"];
      } else {
        return 0;
      }
    },
    fnStatus(v, mqtt) {
      v += '_status';
      let temp = {
        color: 'black',
        label: '異常'
      };
      if (Object.keys(this.MQTTPoints).length > 0) {
        if (this.MQTTPoints[mqtt[v]] != undefined) {
          if (this.MQTTPoints[mqtt[v]].value == '0') {
            temp = {
              color: '#61C640',
              label: '連線',
              value: this.MQTTPoints[mqtt[v]].value,
            };
          } else {
            temp = {
              color: '#E35930',
              label: '斷線'
            };
          }
        } else {
          temp = {
            color: '#41ABC4',
            label: '虛擬'
          };
        }
      }
      return temp;
    },
    fnPageBar(plant, meter) {
      sessionStorage.setItem("bar", plant);
      sessionStorage.setItem("bar2", meter);
      this.FnPageSwitch("trend.php");
    },
    fnPagePie(session) {
      sessionStorage.setItem("pie", session);
      this.FnPageSwitch("trend.php");
    },
    fnPageMeter(session) {
      sessionStorage.setItem("meter", session);
      this.FnPageSwitch("electricity_meter.php");
    },
  },
};
