var page_function = {
	components: {
		"electricity-sidebar": httpVueLoader.load(
			"./components/electricity_sidebar.vue"
		),
	},
	data() {
		return {
			VarMenuPage: "electricity_area",
			VarMenu: "area",
			VarPageContainerCss: "",
			//各區域電表資料 根據 area_select 值來選擇顯示哪個
			electricity_meter_data: {
				total: [],
				single: [],
			},
			//當前選擇區域
			area_select: "1F",
			//區域下拉清單選項
			selectOptions: [],
		};
	},

	computed: {},

	watch: {},

	mounted() {
		this.$set(this.WebSetup, "caption", "區域用電");
		this.MenuSetup.opened = false;
 	   this.VarMenuIsOverlay = true;	
		this.loadOptions().then(() => {
			this.loadData();
		});
	},
	methods: {
		fnInitial(cfg) {
			this.IsSoftStartup = true; // cfg載入完成時執行第一次
			this.IsMQTTStartup = true;
		},
		//取得點位數值
		fnSoft(v) {
			if (this.SoftTagName[v] != undefined) {
				return this.SoftTagName[v]["value"];
			} else {
				return 0;
			}
		},
		//取得點位數值
		fnMQTT(v, mqtt) {
			if (this.MQTTPoints[mqtt[v]] != undefined) {
			  return this.MQTTPoints[mqtt[v]]["value"];
			} else {
			  return 0;
			}
		  },
		// fnStatus(v) {
		// 	v += '_status';
		// 	let temp = {
		// 		color: 'black',
		// 		label: '異常'
		// 	};
		// 	if (Object.keys(this.SoftTagName).length > 0) {
		// 		if (this.SoftTagName[v] != undefined) {
		// 			if (this.SoftTagName[v].value == '0') {
		// 				temp = {
		// 					color: '#61C640',
		// 					label: '連線',
		// 					value: this.SoftTagName[v].value,
		// 				};
		// 			} else {
		// 				temp = {
		// 					color: '#E35930',
		// 					label: '斷線'
		// 				};
		// 			}
		// 		} else {
		// 			temp = {
		// 				color: '#41ABC4',
		// 				label: '虛擬'
		// 			};
		// 		}
		// 	}
		// 	return temp;
		// },
		fnStatus(v,mqtt) {
			v += '_status';
			let temp = {
			  color: 'black',
			  label: '異常'
			};
			if (Object.keys(this.MQTTPoints).length > 0) {
			  if (this.MQTTPoints[mqtt[v]] != undefined) {
				if(this.MQTTPoints[mqtt[v]].value == '0'){
				  temp = {
					color: '#61C640',
					label: '連線',
					value:this.MQTTPoints[mqtt[v]].value,
				  };
				}else{
				  temp = {
					color: '#E35930',
					label: '斷線'
				  };
				}
			  } else {
				console.log(v);
				console.log(mqtt);
				temp = {
				  color: '#41ABC4',
				  label: '虛擬'
				};
			  }
			}
			return temp;
		  },
		loadOptions() {
			let that = this;
			var params = {
				Action: "LoadOptions",
				Datas: {
				},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					this.selectOptions = resData;
				} else {
					that.FnNotify("錯誤", "error");
				}
			});
		},
		loadData() {
			let that = this;
			var params = {
				Action: "LoadData",
				Datas: {
					input: that.area_select
				},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					let total = [];
					let single = [];
					_.each(resData, (v, k) => {
						let temp = {
							name: v.ColumnName,
							table: v.ColumnTable,
							soft_tag: {
								day: v.ColumnTable + "_day",
								month: v.ColumnTable + "_month",
								now: v.ColumnTable + "_now",
							},
						};
						switch (v.ColumnTable) {
							case 'ACM17':
								temp['tooltip'] = '(PPB01總錶)+(PPB02總錶)';
								break;
							case 'ACM18':
								temp['tooltip'] = '(F-3-9總錶)+(P3總錶)+(F-3-14脫蠟機)';
								break;
							case 'ACM19':
								temp['tooltip'] = '(G2冷氣)+(G8冷氣)';
								break;
							case 'ACM16':
								temp['tooltip'] = '(PPB02總表)-(H-1-36空壓機)';
								break;
							default:
								break;
						}

						if (v.IsTotal == '1') {
							total.push(temp);
						} else if (v.IsTotal == '0') {
							single.push(temp);
						}
					})
					this.electricity_meter_data.total = total;
					this.electricity_meter_data.single = single;
				} else {
					that.FnNotify("錯誤", "error");
				}
			});
		},

		fnPageBar(meter) {
			// let words = this.area_select.split("-");
			sessionStorage.setItem("bar", this.area_select);
			sessionStorage.setItem("bar2", meter);
			this.FnPageSwitch("trend.php");
		},
		fnPagePie(session) {
			sessionStorage.setItem("pie", session);
			this.FnPageSwitch("trend.php");
		},
		fnPageMeter(session) {
			sessionStorage.setItem("meter", session);
			this.FnPageSwitch("electricity_meter.php");
		},


	},
};
