var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "energy_usage",
      VarMenu: "area",
      VarPageContainerCss: "height:calc(100vh - 65px);",
      //子頁簽顯示控制 預設台電頁簽
      tab: "energy_usage_electricity",
      //電力查詢項
      search_electricity: {
        year: new Date()
      },
      //能源用量-台電 表單設定物件
      easy_table_electricity: {
        pageIndex: 1,
        pageSize: 10,
        cellStyleOption: {
          headerCellClass: ({ column, rowIndex }) => {
            return "bg-primary text-white custom-table-header";
          },
        },
        table_data: [],
      },
      //能源用量-台電資料 彈窗-新增、修改 
      energy_usage_electricity_dialog: {
        dialog_show: false, //彈窗控制
        is_create: true, //是否為新增 true:新增 false:修改
        //台電資料
        data: {
          energy_usage_electricity_id: null,//能源用量(台電)表id 不為null的話代表修改
          month: null,// 月份
          year: null,// 年份
          purchased_power_peak: null,// 購入電力-尖峰
          purchased_power_mid_peak: null,// 購入電力-半尖峰
          purchased_power_off_peak: null,// 購入電力-離峰
          purchased_power_sat_mid_peak: null,// 購入電力-周六半尖峰
          total_amount_due: null,// 應繳總金額
          fuel_coal: null,// 燃料煤
          fuel_oil: null,// 燃料油
          liquefied_petroleum_gas: null,// 液化石油氣
        }
      },


      //電力查詢項
      search_other: {
        year: new Date()
      },
      //能源用量-其他 表單設定物件
      easy_table_other: {
        pageIndex: 1,
        pageSize: 10,
        cellStyleOption: {
          headerCellClass: ({ column, rowIndex }) => {
            return "bg-primary text-white custom-table-header";
          },
        },
        table_data: [],
      },
      //能源用量-其他 資料 彈窗-新增、修改 
      energy_usage_other_dialog: {
        dialog_show: false, //彈窗控制
        is_create: true, //是否為新增 true:新增 false:修改
        //其他資料
        data: {
          energy_usage_other_id: null,//能源用量(其他)表id 不為null的話代表修改
          month: null, //月份
          year: null, //年份
          natural_gas: null, //天然氣
          diesel: null, //柴油
          steam_purchased: null, //蒸氣量-購入
          steam_self_used: null, //蒸氣量-自產自用
          steam_self_sold: null, //蒸氣量-自產售出
          cogeneration_gross_power: null, //汽電共生-毛發電量
          cogeneration_sold_power: null, //汽電共生-售電量
          cogeneration_self_used_plant: null, //汽電共生-自發自用-廠用電量
          cogeneration_self_used_private: null, //汽電共生-自發自用-自用電量
          renewable_energy_transferred_units: null, //再生能源-轉供度數
          renewable_energy_generated_sold: null, //再生能源-發電量-售電量
          renewable_energy_generated_self_used: null, //再生能源-發電量-自用電量
          waste_heat_generation: null, //廢熱發電
          emergency_power_generation: null, //緊急發電
        }
      },
          };
  },

  computed: {
    //表單欄位 - 台電
    tableColumns_electricity() {
      let arr = [
        {
          field: "data_at_year",
          key: "data_at_year",
          title: "年份",
          align: "center",
          width: 60,
        },
        {
          field: "data_at_month",
          key: "data_at_month",
          title: "月份",
          align: "center",
          width: 60,
        },
        {
          title: "購入電力（度）",
          children: [
            {
              field: "purchased_power_peak",
              key: "purchased_power_peak",
              title: "尖峰",
              width: 100,
            },
            {
              field: "purchased_power_mid_peak",
              key: "purchased_power_mid_peak",
              title: "半尖峰",
              width: 100,
            },
            {
              field: "purchased_power_off_peak",
              key: "purchased_power_off_peak",
              title: "離峰",
              width: 80,
            },
            {
              field: "purchased_power_sat_mid_peak",
              key: "purchased_power_sat_mid_peak",
              title: "周六半尖峰",
              width: 80,
            },
            {
              field: "purchased_power_total",
              key: "purchased_power_total",
              title: "合計",
              width: 80,
            },
            {
              field: "total_amount_due",
              key: "total_amount_due",
              title: "應繳總金額",
              width: 80,
            },
          ],
        },
        {
          field: "fuel_coal",
          key: "fuel_coal",
          title: "燃料煤",
          align: "center",
          width: 150,
        },
        {
          field: "fuel_oil",
          key: "fuel_oil",
          title: "燃料油",
          align: "center",
          width: 150,
        },
        {
          field: "liquefied_petroleum_gas",
          key: "liquefied_petroleum_gas",
          title: "液化石油氣",
          align: "center",
          width: 150,
        },
        {
          field: "_edit",
          key: "_edit",
          title: "-",
          align: "center",
          width: 200,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let dom = [];
            dom = [
              h("q-btn", {
                class: "glossy",
                style: "margin:0px 10px; min-height: 1em; font-size:20px;",
                attrs: {
                  label: "修改",
                  color: "blue",
                },
                on: {
                  click: () => {
                    this.edit_energy_usage_electricity(row.id);
                  },
                },
              }),
              h("q-btn", {
                class: "glossy",
                style: "margin:0px 10px; min-height: 1em; font-size:20px;",
                attrs: {
                  label: "刪除",
                  color: "red",
                },
                on: {
                  click: () => {
                    this.del_energy_usage_electricity(row);
                  },
                },
              }),
            ];

            return dom;
          },
        },
      ];
      return arr;
    },
    //表單資料總數 - 台電
    totalCount_electricity() {
      return this.easy_table_electricity.table_data.length;
    },
    //表單資料分頁邏輯 - 台電
    tableData_electricity() {
      const { pageIndex, pageSize } = this.easy_table_electricity;
      return this.easy_table_electricity.table_data.slice(
        (pageIndex - 1) * pageSize,
        pageIndex * pageSize
      );
    },

    //表單欄位 - 其他
    tableColumns_other() {
      let arr = [
        {
          field: "data_at_year",
          key: "data_at_year",
          title: "年份",
          align: "center",
          width: 60,
        },
        {
          field: "data_at_month",
          key: "data_at_month",
          title: "月份",
          align: "center",
          width: 60,
        },
        {
          field: "natural_gas",
          key: "natural_gas",
          title: "天然氣",
          align: "center",
          width: 100,
        },
        {
          field: "diesel",
          key: "diesel",
          title: "柴油",
          align: "center",
          width: 60,
        },
        {
          title: "蒸氣量",
          children: [
            {
              field: "steam_purchased",
              key: "steam_purchased",
              title: "購入",
              width: 100,
            },
            {
              field: "steam_self_used",
              key: "steam_self_used",
              title: "自產自用",
              width: 100,
            },
            {
              field: "steam_self_sold",
              key: "steam_self_sold",
              title: "自產售出",
              width: 100,
            },
          ],
        },
        {
          title: "汽電共生",
          children: [
            {
              field: "cogeneration_gross_power",
              key: "cogeneration_gross_power",
              title: "毛發電量",
              width: 100,
            },
            {
              field: "cogeneration_sold_power",
              key: "cogeneration_sold_power",
              title: "售電量",
              width: 100,
            },
            {
              title: "自發自用",
              children: [
                {
                  field: "cogeneration_self_used_plant",
                  key: "cogeneration_self_used_plant",
                  title: "廠用電量",
                  width: 100,
                },
                {
                  field: "cogeneration_self_used_private",
                  key: "cogeneration_self_used_private",
                  title: "自用電量",
                  width: 100,
                },
              ]
            }
          ],
        },
        {
          title: "再生能源",
          children: [
            {
              field: "renewable_energy_transferred_units",
              key: "renewable_energy_transferred_units",
              title: "轉供度數",
              width: 100,
            },
            {
              title: "發電量",
              children: [
                {
                  field: "renewable_energy_generated_sold",
                  key: "renewable_energy_generated_sold",
                  title: "售電量",
                  width: 100,
                },
                {
                  field: "renewable_energy_generated_self_used",
                  key: "renewable_energy_generated_self_used",
                  title: "自用電量",
                  width: 100,
                },
              ]
            }
          ],
        },
        {
          field: "waste_heat_generation",
          key: "waste_heat_generation",
          title: "廢熱發電",
          align: "center",
          width: 150,
        },
        {
          field: "emergency_power_generation",
          key: "emergency_power_generation",
          title: "緊急發電",
          align: "center",
          width: 150,
        },
        {
          field: "_edit",
          key: "_edit",
          title: "-",
          align: "center",
          width: 200,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let dom = [];
            dom = [
              h("q-btn", {
                class: "",
                style: "margin:0px 10px; min-height: 1em; font-size:20px;",
                attrs: {
                  label: "修改",
                  color: "blue",
                },
                on: {
                  click: () => {
                    this.edit_energy_usage_other(row.id);
                  },
                },
              }),
              h("q-btn", {
                class: "",
                style: "margin:0px 10px; min-height: 1em; font-size:20px;",
                attrs: {
                  label: "刪除",
                  color: "red",
                },
                on: {
                  click: () => {
                    this.del_energy_usage_other(row);
                  },
                },
              }),
            ];

            return dom;
          },
        },
      ];
      return arr;
    },
    //表單資料總數 - 其他
    totalCount_other() {
      return this.easy_table_other.table_data.length;
    },
    //表單資料分頁邏輯 - 其他
    tableData_other() {
      const { pageIndex, pageSize } = this.easy_table_other;
      return this.easy_table_other.table_data.slice(
        (pageIndex - 1) * pageSize,
        pageIndex * pageSize
      );
    },
  },

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", this.$t("menu.energy_usage"));
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    this.searchData()
  },

  methods: {

    //頁簽切換處理
    changeTab(_tab) {
      let that = this;
      this.$set(this, 'tab', _tab);
      this.searchData()
    },

    async searchData() {
      let that = this;
      //能源用量-台電
      if (this.tab == "energy_usage_electricity") {
        that.$q.loading.show();
        var params = {
          Action: "energy_usage_electricity_list",
          Datas: that.search_electricity
        }
        await this.FnWebAPIGet(params).then((res) => {
          if (res.data.result) {
            this.easy_table_electricity.table_data = []
            this.easy_table_electricity.table_data = res.data.data
          } else {
            throw res.data.message
          }
          that.$q.loading.hide();
        }).catch(function (err) {
          that.FnNotify(err, 'error')
          that.$q.loading.hide();
        });
      }
      //能源用量-其他
      else {

        that.$q.loading.show();
        var params = {
          Action: "energy_usage_other_list",
          Datas: that.search_other
        }
        await this.FnWebAPIGet(params).then((res) => {
          if (res.data.result) {
            this.easy_table_other.table_data = []
            this.easy_table_other.table_data = res.data.data
          } else {
            throw res.data.message
          }
          that.$q.loading.hide();
        }).catch(function (err) {
          that.FnNotify(err, 'error')
          that.$q.loading.hide();
        });

      }
    },

    // page number change - 台電
    pageNumberChange_electricity(pageIndex) {
      this.easy_table_electricity.pageIndex = pageIndex;
    },

    // page size change - 台電
    pageSizeChange_electricity(pageSize) {
      this.easy_table_electricity.pageIndex = 1;
      this.easy_table_electricity.pageSize = pageSize;
    },

    //新增 能源用量-台電資料
    create_energy_usage_electricity() {
      this.energy_usage_electricity_dialog.dialog_show = true
    },

    //修改 能源用量-台電資料
    async edit_energy_usage_electricity(energy_usage_electricity_id) {
      let that = this;
      if (energy_usage_electricity_id == undefined || energy_usage_electricity_id == "") {
        this.FnNotify("製程設備資料異常", "error");
      } else {

        this.$q.loading.show();
        var params = {
          Action: "get_energy_usage_electricity_info",
          Datas: {
            energy_usage_electricity_id: energy_usage_electricity_id
          },
        }
        await this.FnWebAPIGet(params).then((res) => {
          if (res.data.result) {
            let resData = res.data.data;
            that.energy_usage_electricity_dialog.data.energy_usage_electricity_id = resData.id
            that.energy_usage_electricity_dialog.data.month = resData.month
            that.energy_usage_electricity_dialog.data.year = resData.year
            that.energy_usage_electricity_dialog.data.purchased_power_peak = resData.purchased_power_peak
            that.energy_usage_electricity_dialog.data.purchased_power_mid_peak = resData.purchased_power_mid_peak
            that.energy_usage_electricity_dialog.data.purchased_power_off_peak = resData.purchased_power_off_peak
            that.energy_usage_electricity_dialog.data.purchased_power_sat_mid_peak = resData.purchased_power_sat_mid_peak
            that.energy_usage_electricity_dialog.data.total_amount_due = resData.total_amount_due
            that.energy_usage_electricity_dialog.data.fuel_coal = resData.fuel_coal
            that.energy_usage_electricity_dialog.data.fuel_oil = resData.fuel_oil
            that.energy_usage_electricity_dialog.data.liquefied_petroleum_gas = resData.liquefied_petroleum_gas

            //顯示彈窗
            that.energy_usage_electricity_dialog.dialog_show = true
            //修改製程設備時 is_create 設定為false
            that.energy_usage_electricity_dialog.is_create = false
          } else {
            this.FnNotify(res.data.message, 'error')
          }
          this.$q.loading.hide();
        }).catch(function (err) {
          this.FnNotify(err, 'error')
          this.$q.loading.hide();
        });
      }
    },

    //儲存台電資料
    async save_energy_usage_electricity() {
      var that = this;
      try {
        if (
          this.energy_usage_electricity_dialog.data.year == null ||
          this.energy_usage_electricity_dialog.data.year == ""
        ) {
          throw "年份不可為空";
        }

        if (
          this.energy_usage_electricity_dialog.data.month == null ||
          this.energy_usage_electricity_dialog.data.month == ""
        ) {
          throw "月份不可為空";
        }

        that.$q.loading.show();

        var params = {
          Action: "save_energy_usage_electricity",
          Datas: this.energy_usage_electricity_dialog.data,
        }
        await this.FnWebAPIPost(params).then((res) => {
          if (!res.data.result) {
            throw `${res.data.message}`
          }
        }).catch(function (err) {
          throw `失敗: ${err}`
        });

        that.FnNotify("儲存成功", "success")
        that.$data.energy_usage_electricity_dialog = that.$options.data().energy_usage_electricity_dialog;
        that.searchData()


      } catch (error) {
        this.FnNotify(error, "error");
        that.$q.loading.hide();
      }
    },

    //刪除台電資料
    async del_energy_usage_electricity(row_data) {
      var that = this;
      console.log(row_data)
      // await this.$q
      //   .dialog({
      //     title: "是否刪除資料！？",
      //     message: `即將刪除台電資料（${row_data.data_at_year}-${row_data.data_at_month}）`,
      //     color: "primary",
      //     ok: true,
      //     cancel: true,
      //   })
      //   .then(() => {
        if (
          await that.FnConfirm2("是否刪除資料？")
        ) {
          that.$q.loading.show();
          var params = {
            Action: 'del_energy_usage_electricity',
            Datas: {
              energy_usage_electricity_id: row_data.id
            },
          };
          return that.FnWebAPIPost(params).then((res) => {
            if (res.data.result) {
              that.searchData()
              that.FnNotify('刪除成功', 'success')
            } else {
              that.FnNotify(res.data.message, 'error')
            }
          })
        }
        // })
        // .catch(() => {
        // });
    },

    //關閉新增、修改台電資料彈窗
    close_energy_usage_electricity_dialog() {
      var that = this;
      that.$data.energy_usage_electricity_dialog = that.$options.data().energy_usage_electricity_dialog;

    },


    // page number change - 其他
    pageNumberChange_other(pageIndex) {
      this.easy_table_other.pageIndex = pageIndex;
    },

    // page size change - 其他
    pageSizeChange_other(pageSize) {
      this.easy_table_other.pageIndex = 1;
      this.easy_table_other.pageSize = pageSize;
    },

    //新增 能源用量-其他資料
    create_energy_usage_other() {
      this.energy_usage_other_dialog.dialog_show = true
    },

    //修改 能源用量-其他資料
    async edit_energy_usage_other(energy_usage_other_id) {
      let that = this;
      if (energy_usage_other_id == undefined || energy_usage_other_id == "") {
        this.FnNotify("其他資料異常", "error");
      } else {

        this.$q.loading.show();
        var params = {
          Action: "get_energy_usage_other_info",
          Datas: {
            energy_usage_other_id: energy_usage_other_id
          },
        }
        await this.FnWebAPIGet(params).then((res) => {
          if (res.data.result) {
            let resData = res.data.data;
            that.energy_usage_other_dialog.data.energy_usage_other_id = resData.id
            that.energy_usage_other_dialog.data.month = resData.month
            that.energy_usage_other_dialog.data.year = resData.year
            that.energy_usage_other_dialog.data.natural_gas = resData.natural_gas
            that.energy_usage_other_dialog.data.diesel = resData.diesel
            that.energy_usage_other_dialog.data.steam_purchased = resData.steam_purchased
            that.energy_usage_other_dialog.data.steam_self_used = resData.steam_self_used
            that.energy_usage_other_dialog.data.steam_self_sold = resData.steam_self_sold
            that.energy_usage_other_dialog.data.cogeneration_gross_power = resData.cogeneration_gross_power
            that.energy_usage_other_dialog.data.cogeneration_sold_power = resData.cogeneration_sold_power
            that.energy_usage_other_dialog.data.cogeneration_self_used_plant = resData.cogeneration_self_used_plant
            that.energy_usage_other_dialog.data.cogeneration_self_used_private = resData.cogeneration_self_used_private
            that.energy_usage_other_dialog.data.renewable_energy_transferred_units = resData.renewable_energy_transferred_units
            that.energy_usage_other_dialog.data.renewable_energy_generated_sold = resData.renewable_energy_generated_sold
            that.energy_usage_other_dialog.data.renewable_energy_generated_self_used = resData.renewable_energy_generated_self_used
            that.energy_usage_other_dialog.data.waste_heat_generation = resData.waste_heat_generation
            that.energy_usage_other_dialog.data.emergency_power_generation = resData.emergency_power_generation

            //顯示彈窗
            that.energy_usage_other_dialog.dialog_show = true
            //修改其他資料時 is_create 設定為false
            that.energy_usage_other_dialog.is_create = false
          } else {
            this.FnNotify(res.data.message, 'error')
          }
          this.$q.loading.hide();
        }).catch(function (err) {
          this.FnNotify(err, 'error')
          this.$q.loading.hide();
        });
      }
    },

    //儲存其他資料
    async save_energy_usage_other() {
      var that = this;
      try {
        if (
          this.energy_usage_other_dialog.data.year == null ||
          this.energy_usage_other_dialog.data.year == ""
        ) {
          throw "年份不可為空";
        }

        if (
          this.energy_usage_other_dialog.data.month == null ||
          this.energy_usage_other_dialog.data.month == ""
        ) {
          throw "月份不可為空";
        }

        that.$q.loading.show();

        var params = {
          Action: "save_energy_usage_other",
          Datas: this.energy_usage_other_dialog.data,
        }
        await this.FnWebAPIPost(params).then((res) => {
          if (!res.data.result) {
            throw `${res.data.message}`
          }
        }).catch(function (err) {
          throw `失敗: ${err}`
        });

        that.FnNotify("儲存成功", "success")
        that.$data.energy_usage_other_dialog = that.$options.data().energy_usage_other_dialog;
        that.searchData()


      } catch (error) {
        this.FnNotify(error, "error");
        that.$q.loading.hide();
      }
    },

    //刪除其他資料
    async del_energy_usage_other(row_data) {
      var that = this;
      console.log(row_data)
      await this.$q
        .dialog({
          title: "是否刪除資料！？",
          message: `即將刪除其他資料（${row_data.data_at_year}-${row_data.data_at_month}）`,
          color: "primary",
          ok: true,
          cancel: true,
        })
        .then(() => {
          that.$q.loading.show();
          var params = {
            Action: 'del_energy_usage_other',
            Datas: {
              energy_usage_other_id: row_data.id
            },
          };
          return that.FnWebAPIPost(params).then((res) => {
            if (res.data.result) {
              that.searchData()
              that.FnNotify('刪除成功', 'success')
            } else {
              that.FnNotify(res.data.message, 'error')
            }
          })
        })
        .catch(() => {
        });
    },

    //關閉新增、修改其他資料彈窗
    close_energy_usage_other_dialog() {
      var that = this;
      that.$data.energy_usage_other_dialog = that.$options.data().energy_usage_other_dialog;

    },



  },
};
