var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "factory_device",
      VarMenu: "area",
      VarPageContainerCss: "height:calc(100vh - 65px);",

      search: {
        device_name: null,
        brand: null,
        model_number: null,
        registration_number: null,
      },

      //表單設定物件
      easy_table: {
        pageIndex: 1,
        pageSize: 10,
        cellStyleOption: {
          headerCellClass: ({ column, rowIndex }) => {
            return "bg-primary text-white custom-table-header";
          },
        },
        table_data: [],
      },

      //彈窗-新增、修改設備
      device_dialog: {
        dialog_show: false, //彈窗控制
        is_create: true, //是否為新增 true:新增 false:修改
        //設備資料
        data: {
          factory_device_id: null,//廠區設備表id 不為null的話代表修改
          device_name: null, // 設備名稱
          brand: null, // 廠牌
          model_type: null, // 型式
          model_number: null, // 型號
          registration_number: null, // 登錄編號
          motor_horsepower: null, // 馬達-馬力
          motor_pole: null, // 馬達-極數
          motor_efficiency_grade: null, // 馬達-效率等級
          heater_power: null, // 電熱功率
          rated_power: null, // 額定功率
          manufacture_year: null, // 西元製造年份
          investment_cost: null, // 新增或汰換設備平均投資金額
          capacity_value: null, // 設備容量-容量
          capacity_unit: null, // 設備容量 - 單位
        }
      },
    };
  },

  computed: {
    //表單欄位
    tableColumns() {
      let arr = [
        {
          field: "device_name",
          key: "device_name",
          title: "設備名稱",
          align: "center",
          width: 150,
        },
        {
          field: "brand",
          key: "brand",
          title: "廠牌",
          align: "center",
          width: 150,
        },
        {
          field: "model_type",
          key: "model_type",
          title: "型式",
          align: "center",
          width: 150,
        },
        {
          field: "model_number",
          key: "model_number",
          title: "型號",
          align: "center",
          width: 150,
        },
        {
          field: "registration_number",
          key: "registration_number",
          title: "登錄編號",
          align: "center",
          width: 150,
        },
        {
          title: "馬達",
          children: [
            {
              field: "motor_horsepower",
              key: "motor_horsepower",
              title: "馬力",
              width: 100,
            },
            {
              field: "motor_pole",
              key: "motor_pole",
              title: "極數",
              width: 100,
            },
            {
              field: "motor_efficiency_grade",
              key: "motor_efficiency_grade",
              title: "效率等級",
              width: 80,
            },
          ],
        },
        {
          field: "heater_power",
          key: "heater_power",
          title: "電熱功率",
          align: "center",
          width: 150,
        },
        {
          field: "rated_power",
          key: "rated_power",
          title: "額定功率",
          align: "center",
          width: 150,
        },
        {
          field: "manufacture_year",
          key: "manufacture_year",
          title: "西元製造年份",
          align: "center",
          width: 150,
        },
        {
          field: "investment_cost",
          key: "investment_cost",
          title: "新增或汰換設備平均投資金額(千元/台)",
          align: "center",
          width: 150,
        },
        {
          title: "設備容量",
          children: [
            {
              field: "capacity_value",
              key: "capacity_value",
              title: "容量",
              width: 100,
            },
            {
              field: "capacity_unit",
              key: "capacity_unit",
              title: "單位",
              width: 100,
            },
          ],
        },
        {
          field: "_edit",
          key: "_edit",
          title: "-",
          align: "center",
          width: 250,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let dom = [];
            dom = [
              h("q-btn", {
                class: "glossy",
                style: "margin:0px 10px; min-height: 1em; font-size:20px;",
                attrs: {
                  label: "修改",
                  color: "blue",
                },
                on: {
                  click: () => {
                    this.edit_factory_device(row.id);
                  },
                },
              }),
              h("q-btn", {
                class: "glossy",
                style: "margin:0px 10px; min-height: 1em; font-size:20px;",
                attrs: {
                  label: "刪除",
                  color: "red",
                },
                on: {
                  click: () => {
                    this.del_factory_device(row);
                  },
                },
              }),
            ];

            return dom;
          },
        },
      ];
      return arr;
    },
    //表單資料總數
    totalCount() {
      return this.easy_table.table_data.length;
    },
    //表單資料分頁邏輯
    tableData() {
      const { pageIndex, pageSize } = this.easy_table;
      return this.easy_table.table_data.slice(
        (pageIndex - 1) * pageSize,
        pageIndex * pageSize
      );
    },
  },

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", this.$t("menu.factory_device"));
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    this.searchData()
  },

  methods: {

    async searchData() {
      let that = this;
      that.$q.loading.show();
      var params = {
        Action: "factory_device_list",
        Datas: that.search
      }
      await this.FnWebAPIGet(params).then((res) => {
        if (res.data.result) {
          this.easy_table.table_data = []
          this.easy_table.table_data = res.data.data
        } else {
          throw res.data.message
        }
        that.$q.loading.hide();
      }).catch(function (err) {
        that.FnNotify(err, 'error')
        that.$q.loading.hide();
      });
    },

    // page number change
    pageNumberChange(pageIndex) {
      this.easy_table.pageIndex = pageIndex;
    },

    // page size change
    pageSizeChange(pageSize) {
      this.easy_table.pageIndex = 1;
      this.easy_table.pageSize = pageSize;
    },

    //新增廠區設備
    create_factory_device() {
      this.device_dialog.dialog_show = true
    },

    //修改廠區設備
    async edit_factory_device(factory_device_id) {
      let that = this;
      if (factory_device_id == undefined || factory_device_id == "") {
        this.FnNotify("廠區設備資料異常", "error");
      } else {

        var params = {
          Action: "get_factory_device_info",
          Datas: {
            factory_device_id: factory_device_id
          },
        }
        await this.FnWebAPIGet(params).then((res) => {
          if (res.data.result) {
            let resData = res.data.data;
            that.device_dialog.data.factory_device_id = resData.id
            that.device_dialog.data.device_name = resData.device_name
            that.device_dialog.data.brand = resData.brand
            that.device_dialog.data.model_type = resData.model_type
            that.device_dialog.data.model_number = resData.model_number
            that.device_dialog.data.registration_number = resData.registration_number
            that.device_dialog.data.motor_horsepower = resData.motor_horsepower
            that.device_dialog.data.motor_pole = resData.motor_pole
            that.device_dialog.data.motor_efficiency_grade = resData.motor_efficiency_grade
            that.device_dialog.data.heater_power = resData.heater_power
            that.device_dialog.data.rated_power = resData.rated_power
            that.device_dialog.data.manufacture_year = resData.manufacture_year
            that.device_dialog.data.investment_cost = resData.investment_cost
            that.device_dialog.data.capacity_value = resData.capacity_value
            that.device_dialog.data.capacity_unit = resData.capacity_unit
            //顯示彈窗
            that.device_dialog.dialog_show = true
            //修改廠區設備時 is_create 設定為false
            that.device_dialog.is_create = false
          } else {
            this.FnNotify(res.data.message, 'error')
          }
          this.$q.loading.hide();
        }).catch(function (err) {
          this.FnNotify(err, 'error')
          this.$q.loading.hide();
        });
      }
    },

    //儲存設備資料
    async save_factory_device(is_update = false) {
      var that = this;
      try {
        if (
          this.device_dialog.data.device_name == null ||
          this.device_dialog.data.device_name == ""
        ) {
          throw "設備名稱不可為空";
        }

        that.$q.loading.show();

        var params = {
          Action: "save_factory_device",
          Datas: this.device_dialog.data,
        }
        await this.FnWebAPIPost(params).then((res) => {
          if (!res.data.result) {
            throw `${res.data.message}`
          }
        }).catch(function (err) {
          throw `失敗: ${err}`
        });

        that.FnNotify("儲存成功", "success")
        that.$data.device_dialog = that.$options.data().device_dialog;
        that.searchData()


      } catch (error) {
        this.FnNotify(error, "error");
        that.$q.loading.hide();
      }
    },

    //刪除設備資料
    async del_factory_device(row_data) {
      var that = this;
      // await this.$q
      //   .dialog({
      //     title: "是否刪除資料！？",
      //     message: `即將刪除（${row_data.device_name}）`,
      //     color: "primary",
      //     ok: true,
      //     cancel: true,
      //   })
      //   .then(() => {
        if (
          await that.FnConfirm2("是否刪除資料？")
        ) {
          that.$q.loading.show();
          var params = {
            Action: 'del_factory_device',
            Datas: {
              factory_device_id: row_data.id
            },
          };
          return that.FnWebAPIPost(params).then((res) => {
            if (res.data.result) {
              that.searchData()
              that.FnNotify('刪除成功', 'success')
            } else {
              that.FnNotify(res.data.message, 'error')
            }
          })
        }
        // })
        // .catch(() => {
        // });
    },

    //關閉新增、修改彈窗
    close_dialog() {
      var that = this;
      that.$data.device_dialog = that.$options.data().device_dialog;

    },




  },
};
