var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "index",
      VarMenu: "area",
      VarPageContainerCss: "height:calc(100vh - 65px);",
      //各設備項目清單
      //各廠區資料
      factory_b1_1: {
        ACM1: {
          name: "1號冰水主機",
        },
        //3
        ACM2: {
          name: "2號冰水主機",
        },
        //4
        ACM3: {
          name: "3號冰水主機",
        },
        ACM4: {
          name: "中營所凍庫",
        },
      },
      factory_b1_2: {
        ACM5: {
          name: "原料庫",
        },
        //3
        ACM6: {
          name: "解凍室",
        },
        //4
        ACM7: {
          name: "肉類半成品庫",
        },
        ACM8: {
          name: "蔬菜冷藏庫",
        },
      },
      factory_1af: {
        ACM9: {
          name: "研發庫",
        },
      },
      factory_1f: {
        ACM10: {
          name: "燻雞冷卻室",
        },
        ACM11: {
          name: "肉類冷藏庫",
        },
        ACM12: {
          name: "暫存冷藏庫",
        },
      },
      factory_2f: {
        ACM13: {
          name: "新急凍庫",
        },
        ACM14: {
          name: "舊急凍庫",
        },
      },

      last_update: {},
    };
  },

  computed: {
  },

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "全廠用電");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    this.loadData();
    //一分鐘刷一次
    setInterval(() => {
      this.loadData();
    }, 1 * 60 * 1000);
    // this.$q.loading.show();
    // this.loop();
  },
  methods: {
    fnInitial(cfg) {
      this.IsSoftStartup = true; // cfg載入完成時執行第一次
      this.IsMQTTStartup = true;
    },
    //取得點位數值
    fnMQTT(v, mqtt) {
      if (this.MQTTPoints[mqtt[v]] != undefined) {
        return this.MQTTPoints[mqtt[v]]["value"];
      } else {
        return 0;
      }
    },
    fnStatus(v, mqtt) {
      v += '_status';
      let temp = {
        color: 'black',
        label: '異常'
      };
      if (Object.keys(this.MQTTPoints).length > 0) {
        if (this.MQTTPoints[mqtt[v]] != undefined) {
          if (this.MQTTPoints[mqtt[v]].value == '0') {
            temp = {
              color: '#61C640',
              label: '連線',
              value: this.MQTTPoints[mqtt[v]].value,
            };
          } else {
            temp = {
              color: '#E35930',
              label: '斷線'
            };
          }
        } else {
          temp = {
            color: '#41ABC4',
            label: '虛擬'
          };
        }
      }
      return temp;
    },
    fnPageBar(plant, meter) {
      sessionStorage.setItem("bar", plant);
      sessionStorage.setItem("bar2", meter);
      this.FnPageSwitch("trend.php");
    },
    fnPagePie(session) {
      sessionStorage.setItem("pie", session);
      this.FnPageSwitch("trend.php");
    },
    fnPageMeter(session) {
      sessionStorage.setItem("meter", session);
      this.FnPageSwitch("electricity_meter.php");
    },
    async loadData() {
      let that = this;
      var params = {
        Action: "LoadData",
        Datas: {},
      };
      await this.FnWebAPIGet(params).then((res) => {
        if (res.data.result) {
          var resData = res.data.data;
          this.last_update = resData;
          setInterval(() => {
            let temp = moment();
            console.log(temp);
            this.loadData();
          }, 1 * 60 * 1000);
        } else {
          that.FnNotify("錯誤", "error");
          setInterval(() => {
            let temp = moment();
            console.log(temp);
            this.loadData();
          }, 1 * 60 * 1000);
        }
      }).catch(function (err) {
        that.$q.loading.hide();
        console.log(err);
      });

    },
  },
};
