var page_function = {
  components: {},
  data() {
    return {
      VarMenuPage: "machine_status",
      VarMenu: "area",
      VarPageContainerCss: "height:calc(100vh - 65px);",

      device: "",

      //表單設定用
      chart_setting: {
        legend_list: [], //項目陣列
        line_data: [],//各線資料陣列
        xAxis_label: []//x軸label
      },
      //頁面項目選中class控制用
      item_class_ctrl: [],
    };
  },

  computed: {
    chart_gauge() {
      let temp = {
        series: [
          {
            type: 'gauge',
            radius: '98%',
            center: ['50%', '53%'],
            min: 0,
            max: 2500,
            axisLine: {
              lineStyle: {
                width: 15,
                color: [
                  [0.3, '#FFA500'],
                  [0.6, '#008000'],
                  [1, '#FD666D']
                ]
              }
            },
            pointer: {
              length: '60%',
              itemStyle: {
                color: 'auto'
              }
            },
            axisTick: {
              distance: -15,
              length: 8,
              lineStyle: {
                color: '#fff',
                width: 2
              }
            },
            splitLine: {
              distance: -30,
              length: 15,
              lineStyle: {
                color: '#fff',
                width: 4
              }
            },
            axisLabel: {
              // color: 'inherit',
              distance: 10,
              rich: {
                area1: { color: '#FFA500' },
                area2: { color: '#008000' },
                area3: { color: '#FD666D' }
              },
              formatter: function (value) {
                if (value <= 750) {
                  return `{area1|${value}}`;
                } else if (value <= 1500) {
                  return `{area2|${value}}`;
                } else {
                  return `{area3|${value}}`;
                }
              }
            },
            detail: {
              offsetCenter: [0, '80%'],
              rich: {
                area1: { color: '#FFA500', fontSize: '20' },
                area2: { color: '#008000', fontSize: '20' },
                area3: { color: '#FD666D', fontSize: '20' }
              },
              formatter: function (value) {
                if (value <= 750) {
                  return `{area1|${value} km/h}`;
                } else if (value <= 1500) {
                  return `{area2|${value} km/h}`;
                } else {
                  return `{area3|${value} km/h}`;
                }
              }
            },
            data: [
              {
                value: this.SoftPoints['D00001'] ? this.SoftPoints['D00001'].value : 0,
              }
            ]
          }
        ],
      };
      return temp;
    },
    chart_line() {
      let that = this,
        //色碼陣列
        color_list = [
          "#D84040", //線1
          "#2056E1", //線2
          "#2BA846", //線3
          "#FFA500" //線4
        ];
      let series_data = [],
        legend_data = [],
        unit_list = [] //線單位陣列
        ;
      //根據legend_list項目陣列整理series_data
      if (that.chart_setting.legend_list.length != 0) {
        that.chart_setting.legend_list.forEach((el, inx) => {
          legend_data.push(el.label);
          unit_list.push(el.unit)
          series_data.push({
            name: el.label,
            type: "line",
            color: color_list[inx],
            yAxisIndex: inx,
            connectNulls: true,
            data: that.chart_setting.line_data[inx]

          })
        });
      }
      let temp = {
        tooltip: {
          trigger: "axis",
        },
        dataZoom: [
          {
            show: true,
            realtime: true,
          },
          {
            type: "inside",
            realtime: true,
          },
        ],
        legend: {
          data: legend_data,
        },
        grid: {
          borderColor: "#CCCCCC",
          borderWidth: 4,
          show: true,
          left: "9%",
          right: "9%",
          bottom: "3%",
          containLabel: true,
        },
        xAxis: {
          type: "category",
          boundaryGap: false,
          data: that.chart_setting.xAxis_label,
        },
        yAxis: [
          {
            type: "value",
            name: legend_data[0],
            axisLine: {
              lineStyle: {
                color: color_list[0],
              },
            },
            axisLabel: {
              formatter: `{value} ${unit_list[0]}`,
            },
            // splitLine: {
            //   lineStyle: {
            //     color: "#AAAAAA",
            //     type: "dashed",
            //   },
            // },
          },
          {
            type: "value",
            name: legend_data[1],
            show: true,
            axisLine: {
              lineStyle: {
                color: color_list[1],
              },
            },
            axisLabel: {
              formatter: `{value} ${unit_list[1]}`,
            },
            splitLine: {
              show: false,
            },
          },
          {
            type: "value",
            offset: 120,
            position: "left",
            name: legend_data[2],
            show: true,
            axisLine: {
              lineStyle: {
                color: color_list[2],
              },
            },
            axisLabel: {
              formatter: `{value} ${unit_list[2]}`,
            },
            splitLine: {
              show: false,
            },
          },
          {
            type: "value",
            offset: 120,
            name: legend_data[3],
            show: true,
            axisLine: {
              lineStyle: {
                color: color_list[3],
              },
            },
            axisLabel: {
              formatter: `{value} ${unit_list[3]}`,
            },
            splitLine: {
              show: false,
            },
          },
        ],
        series: series_data,
        // [
        //   {
        //     name: "第一段",
        //     type: "line",
        //     color: "#D84040",
        //     yAxisIndex: 0,
        //     connectNulls: true,
        //     data: [
        //       '5', '10'
        //     ],
        //   },
        //   {
        //     name: "冷卻",
        //     type: "line",
        //     color: "#2056E1",
        //     yAxisIndex: 1,
        //     connectNulls: true,
        //     data: [
        //       '15', '20'
        //     ],
        //   },
        //   {
        //     name: "第三段",
        //     type: "line",
        //     color: "#2BA846",
        //     yAxisIndex: 2,
        //     connectNulls: true,
        //     data: [
        //       '18', '25'
        //     ],
        //   },
        // ],
      };
      return temp;
    },
    //機台名稱下拉選單用-清單
    device_select_option() {
      let arr = [];
      //deviceindexinfo 內容 詳見 cfg/Var_config
      deviceindexinfo.forEach((el, inx) => {
        if (inx == 0) {
          this.device = el.value
        }
        arr.push({ label: el.label, value: el.value });
      })
      return arr;
    },
    //設備項目清單
    device_item_list() {
      let arr = [],
        that = this;
      //deviceindexinfo 內容 詳見 cfg/Var_config
      deviceindexinfo.forEach((el, inx) => {
        if (el.value == that.device) {

          el.item.forEach((el_2, inx_2) => {
            arr.push({
              label: el_2.label,
              value: el_2.value,
              unit: el_2.unit,
              icon: el_2.icon,
              table_column: el_2.table_column
            });
          })
        }
      })
      return arr;
    }
  },

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", this.$t("menu.machine_status"));
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    // this.searchData()
  },

  methods: {

    fnInitial(cfg) {
      this.IsSoftStartup = true; // cfg載入完成時執行第一次
    },
    //添加圖表項目
    async add_chart_item(target, item) {
      let that = this,
        legend_list_inx = null;
      that.chart_setting.legend_list.forEach((el, inx) => {
        if (el.label == item.label) {
          legend_list_inx = inx;
        }
      });
      try {
        if (legend_list_inx != null) {
          //移除圖表項目
          that.chart_setting.legend_list.splice(legend_list_inx, 1);
          //移除class控制陣列
          that.item_class_ctrl.splice(that.item_class_ctrl.indexOf(item.label), 1);

        } else {
          if (that.chart_setting.legend_list.length >= 4) {
            throw '圖表資訊最多指定4項！';
          } else {
            that.chart_setting.legend_list.push(item)
            that.item_class_ctrl.push(item.label)
          }
        }
        await that.load_chart_data();
      } catch (error) {
        this.FnNotify(error, 'warning');
      }
    },
    //圖表資料載入 (待資料庫結構清楚後才可製作)
    load_chart_data() {
      let that = this,
        line_obj = {};

      if (that.chart_setting.legend_list.length > 0) {
        this.$q.loading.show();

        //根據圖表項目陣列來設定各線對應讀取的資料庫欄位

        that.chart_setting.legend_list.forEach((el, inx) => {
          line_obj[el.table_column] = inx
        })

        var params = {
          Action: "load_chart_data",
          Datas: {
            device: that.device,
            line: line_obj
          },
        };
        return that.FnWebAPIGet(params).then((res) => {
          if (res.data.result) {
            var resData = res.data.data;


            console.log(resData);
            //設定x軸資料
            that.chart_setting.xAxis_label = resData.label_list;
            //設定各線資料
            that.chart_setting.line_data = [];
            resData.line_data.forEach((el, inx) => {
              that.chart_setting.line_data.push(el);
            });

            // if (resData.length != 0) {
            //   //車、洗床工單總資訊處理
            //   that.machine_info.wo_qty_total = resData["work_order_wo_qty_total"]
            //   that.machine_info.real_qty_total = resData["work_order_real_qty_total"]
            //   that.machine_info.work_availability = resData["work_availability"]
            //   that.machine_info.total_unwork_time_month = resData["total_unwork_time_month"]
            //   this.easy_table.data.table_1 = [];
            //   this.easy_table.data.table_2 = [];
            //   if (resData["table"].length > 0) {
            //     resData["table"].forEach((el, inx) => {
            //       if (inx >= (resData["table"].length / 2)) {
            //         this.easy_table.data.table_2.push(el);
            //       } else {
            //         this.easy_table.data.table_1.push(el);
            //       }
            //     });
            //   }
            // }
            this.$q.loading.hide();

          } else {
            that.FnNotify(res.data.message, "error");
          }
        });
      }
    },
    //機台設備切換時清除用
    clear_legend_list() {
      //清除圖表選中項
      this.chart_setting.legend_list = [];
      //清除頁面選中項class控制陣列
      this.item_class_ctrl = [];

    }
  },
};
