var page_function = {
	components: {
		// "soft-item": httpVueLoader.load("./components/soft_item.vue")
		"soft-item": httpVueLoader.load("./components/soft_item_demand.vue"),
	},
	data() {
		return {
			VarMenuPage: "parameter_settings",
			VarMenu: "area",
			VarPageContainerCss: "",
			//各廠區資料
			pageSoftTag: {},

			tab: 'plant',
			// tab:'meter',

			area_select: "1AF",
			carbon_conversion: "",

			dialog:{
				show:false,
				mqtt:null,
				value:null,
			},


		};
	},

	computed: {
		selectOptions() {
			var temp = _.filter(meterGroupOptions, function (option) {
				return !option.label.endsWith('群組');
			});
			return temp;
		},
		mqtt_buttons(){
			var temp = {};
			_.each(this.MQTTPoints,(v,k)=>{
				if(k.endsWith('_button')){
					if(v.value !='0'){
						temp[k] = true;
					}else{
						temp[k] = false;
					}					
				}
			})
			return temp;
		},
	},

	watch: {},

	mounted() {
		this.$set(this.WebSetup, "caption", "參數設定");
		this.$set(this.WebSetup, "icon", "settings");
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
	},
	methods: {
		fnInitial(cfg) {
			this.IsSoftStartup = true; // cfg載入完成時執行第一次
			this.IsMQTTStartup = true;
			if (cfg.demand_control) {
				// this.$set(this, 'pageSoftTag', cfg.demand_control);
				_.each(cfg.demand_control, (v, k) => {
					this.$set(this.pageSoftTag, v.Name, v);
				})
			}
		},
		//取得點位數值
		fnSoft(v) {
			if (this.SoftTagName[v] != undefined) {
				return this.SoftTagName[v]["value"];
			} else {
				return 0;
			}
		},
		changeTab(_tab) {
			this.$set(this, 'tab', _tab);
			switch (_tab) {
				case 'carbon':
					break;
				default:
					break;
			}
		},
		loadCarbon() {
			let that = this;
			var params = {
				Action: "LoadCarbon",
				Datas: {
					input: that.area_select,
				},
			};
			that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					this.carbon_conversion = parseFloat(resData.carbon_conversion_factor);
				} else {
					that.FnNotify("錯誤", "error");
				}
				that.$q.loading.hide();
			});
		},
		// async set_mqtt(mqtt) {
		// 	var that = this;
		// 	var err = "";
		// 	var title = "";
		// 	var val = "";

		// 	var cancel = false;

		// 	await this.$q
		// 		.dialog({
		// 			title: "請輸入設定數值",
		// 			message: "限定數字",
		// 			prompt: {
		// 				model: "",
		// 				type: "text",
		// 			},
		// 			ok: "確定",
		// 			cancel: "取消",
		// 			preventClose: true,
		// 		})
		// 		.then(function (pn) {
		// 			val = pn.trim();
		// 			if (val == "" || isNaN(Number(pn))) {
		// 				err = "僅可輸入數字";
		// 			} else {
		// 				that.$q.loading.show();
		// 			}
		// 		})
		// 		.catch(() => {
		// 			cancel = true;
		// 		});
		// 	if (!cancel) {
		// 		if (err != "") {
		// 			title = "更新失敗";
		// 		} else {
		// 			this.FnMQTTCommand(mqtt, val);
		// 			that.$q.loading.hide();
		// 		}

		// 		await this.$q.dialog({
		// 			title: title,
		// 			message: err,
		// 			ok: "確定",
		// 			preventClose: true,
		// 		});
		// 	}
		// },
		//設定碳排係數
		async set_data() {
			var that = this;
			var err = "";
			var title = "";
			var val = "";

			var cancel = false;

			await this.$q
				.dialog({
					title: "請輸入設定數值",
					message: "限定數字",
					prompt: {
						model: "",
						type: "text",
					},
					ok: "確定",
					cancel: "取消",
					preventClose: true,
				})
				.then(function (pn) {
					val = pn.trim();
					if (val == "" || isNaN(Number(pn))) {
						err = "僅可輸入數字";
					} else {
						that.$q.loading.show();
					}
				})
				.catch(() => {
					cancel = true;
				});
			if (!cancel) {
				if (err != "") {
					title = "更新失敗";
				} else {
					var params = {
						Action: "add_data",
						Datas: {
							val: val,
						},
					};
					await that.FnWebAPIPost(params).then((res) => {
						if (!res.data.result) {
							err = "資料庫更新失敗";
						}
					});
					if (err == "") {
						that.carbon_conversion = val;
						title = "更新成功";
					} else {
						title = "更新失敗";
					}
					that.$q.loading.hide();
				}

				await this.$q.dialog({
					title: title,
					message: err,
					ok: "確定",
					preventClose: true,
				});
			}
		},
		async fnSoftToAlarm(data) {
			let that = this;
			let info = data.name.split('_');
			console.log(data.points);

			if (info.length > 1) {
				let params = {
					info: info,
					value: data.value,
				};

				var formData = new FormData();
				formData.append("Action", "SaveDemand");
				formData.append("Datas", JSON.stringify(params));

				await that
					.FnWebAPIPost(formData)
					.then(function (res) {
						let resData = res.data.data;
						console.log(resData);
						if (resData.status) {
							// that.FnNotify(resData.msg, "success");

							that.FnSoftValueModify(data.points);
						} else {
							// that.FnNotify(resData.msg, "error");
						}
					})
					.catch(async function (err) {
						console.log(err);
					});
			} else {
				that.FnSoftValueModify(data.points);
			}
		},
		fnSoftMeter(data) {
			console.log(data.points);
			this.FnSoftValueModify(data.points);
		},
		fnOnOff(key) {
			let temp = {};
			temp[this.SoftTagName[key].OPCTag] = {
				demical: '0',
				value: !this.SoftTagName[key].value ? 'on' : 'off',
			};
			this.FnSoftValueModify(temp);
		},
		fnOnOff_mqtt(key) {
			//判斷mqtt值
			let temp = !this.mqtt_buttons[key] ? '1' : '0';
			console.log(this.mqtt_buttons[key]);

			console.log(key);
			console.log(temp);
			//給MQTT值
			this.FnMQTTCommand(temp, key);
		},
		set_mqtt(mqtt) {
			var that = this;
			that.dialog.mqtt = mqtt;
			that.dialog.show = true;
		},

		confirm_mqtt(){
			let mqtt = this.dialog.mqtt;
			let val = parseFloat(this.dialog.value);
			// let val = this.dialog.value;
			
			if(!val && val != 0){
				this.FnNotify("無數值填入","warning");
				return;
			};
			val = this.dialog.value.toString();
			console.log(mqtt);
			console.log(val);

			this.FnMQTTCommand(val, mqtt);
			this.closeQWindow();
		},


		//	關閉視窗
		closeQWindow() {
			var that = this;
			that.$data.dialog = that.$options.data().dialog;

		},
	},
};
