var page_function = {
  components: {
    "search-item": httpVueLoader.load("./components/search_query_report.vue"),
  },
  data() {
    return {
      VarMenuPage: "report",
      VarMenu: "area",
      VarPageContainerCss: "",

      clientWidth: document.documentElement.clientWidth,
      conditions: [
        {
          caption: "查詢日期",
          contents: {
            QueryDate: {
              type: "date",
              value: moment().format("YYYY-MM-DD"),
              style: { width: "10em" },
            },
          },
        },
        {
          caption: "報表類型",
          contents: {
            OutputType: {
              type: "select",
              value: "Day",
              align: "center",
              options: [
                { label: "日報表", value: "Day" },
                { label: "週報表", value: "Week" },
                { label: "月報表", value: "Month" },
                { label: "季報表", value: "Season" },
                { label: "年報表", value: "Year" },
              ],
              style: { width: "10em" },
            },
          },
        },
      ],
      DownloadLink: "",
      // 	顏廷瑜更新已下項目
      priceTable: {
        title: null,
        rowKey: "id",
        pagination: {
          page: 1,
          rowsPerPage: 10,
        },
        columns: [
          {
            name: "WeekdayName",
            label: "星期分類",
            align: "center",
            field: "WeekdayName",
            sortable: false,
          },
          {
            name: "IsSummerName",
            label: "夏月/非夏月",
            align: "center",
            field: "IsSummerName",
            sortable: false,
          },
          {
            name: "TimeRange",
            label: "時間區段",
            align: "center",
            field: "TimeRange",
            sortable: false,
          },
          {
            name: "PeakName",
            label: "尖峰離峰",
            align: "center",
            field: "PeakName",
            sortable: false,
          },
          {
            name: "Price",
            label: "電價",
            align: "center",
            field: "Price",
            sortable: false,
          },
          {
            name: "edit",
            label: "-",
            align: "center",
            field: "edit",
            sortable: false,
          },
        ],
        datas: [], //	資料存放處
        table_origin: [], //	clone資料
      },
      priceVersion: {
        //	電價版本
        value: null,
        options: [],
      },
      factory: {
        //	工廠
        value: "1",
        options: [
          { label: "一廠", value: "1" },
          { label: "二廠", value: "2" },
        ],
      },
      rangeSection: null, //	幾段式
      basic: {
        ContractCapacity: { value: null },
        PerHousehold: { value: null },
        PerKwNonSummer: { value: null },
        PerKwSummer: { value: null },
        PriceComment: { value: null },
        SummerEndDay: { value: null },
        SummerEndMonth: { value: null },
        SummerStartDay: { value: null },
        SummerStartMonth: { value: null },
      },
      newEffective: {
        //	新的生效日
        show: false,
        title: "新增電價生效日",
        label: "生效日期",
        value: null,
      },
      newBasic: {
        ContractCapacity: {
          show: false,
          value: null,
          label: "",
          input_format: "input",
          format_type: "number",
          enable: false,
          options: [],
          placeholder: null,
        },
        PerHousehold: {
          show: false,
          value: 0,
          label: "",
          input_format: "input",
          format_type: "number",
          enable: false,
          options: [],
          placeholder: null,
        },

        PerKwSummer: {
          show: true,
          value: null,
          label: "經常契約(每瓩) - 夏月：",
          input_format: "input",
          format_type: "number",
          enable: false,
          options: [],
          placeholder: null,
        },
        PerKwNonSummer: {
          show: true,
          value: null,
          label: "經常契約(每瓩) - 非夏月：",
          input_format: "input",
          format_type: "number",
          enable: false,
          options: [],
          placeholder: null,
        },
        PriceComment: {
          show: false,
          value: null,
          label: "經常契約分類：",
          input_format: "select",
          format_type: "number",
          enable: false,
          options: [
            {
              value: "高壓二段式需量契約-經常契約",
              label: "高壓二段式需量契約-經常契約",
              subValue: "2",
            },
            {
              value: "高壓三段式需量契約-經常契約",
              label: "高壓三段式需量契約-經常契約",
              subValue: "3",
            },
          ],
          placeholder: null,
        },
        SummerStartMonth: {
          show: true,
          value: null,
          label: "夏月 - 開始月：",
          input_format: "select",
          format_type: "number",
          enable: false,
          options: [
            { label: "1月", value: "1" },
            { label: "2月", value: "2" },
            { label: "3月", value: "3" },
            { label: "4月", value: "4" },
            { label: "5月", value: "5" },
            { label: "6月", value: "6" },
            { label: "7月", value: "7" },
            { label: "8月", value: "8" },
            { label: "9月", value: "9" },
            { label: "10月", value: "10" },
            { label: "11月", value: "11" },
            { label: "12月", value: "12" },
          ],
          placeholder: "請輸入1~12",
        },
        SummerStartDay: {
          show: true,
          value: null,
          label: "夏月 - 開始日：",
          input_format: "select",
          format_type: "number",
          enable: false,
          options: [],
          placeholder: "請輸入1~31",
        },
        SummerEndMonth: {
          show: true,
          value: null,
          label: "夏月 - 結束月：",
          input_format: "select",
          format_type: "number",
          enable: false,
          options: [
            { label: "1月", value: "1" },
            { label: "2月", value: "2" },
            { label: "3月", value: "3" },
            { label: "4月", value: "4" },
            { label: "5月", value: "5" },
            { label: "6月", value: "6" },
            { label: "7月", value: "7" },
            { label: "8月", value: "8" },
            { label: "9月", value: "9" },
            { label: "10月", value: "10" },
            { label: "11月", value: "11" },
            { label: "12月", value: "12" },
          ],
          placeholder: "請輸入1~12",
        },
        SummerEndDay: {
          show: true,
          value: null,
          label: "夏月 - 結束日：",
          input_format: "select",
          format_type: "number",
          enable: false,
          options: [],
          placeholder: "請輸入1~31",
        },
      },
      priceEdit: {
        show: false,
        title: "編輯電價",
        data: {
          WeekdayName: {
            //	王sir 的 [udt_FactoryFluidPriceInfo] 可程序性函數 欄位名稱
            show: true,
            label: "星期分類：",
            value: null,
            input_format: "select",
            format_type: "text",
            enable: false,
            options: [
              { label: "週一～週五", value: "1" },
              { label: "週六", value: "6" },
              { label: "週日及離峰日", value: "7" },
            ],
            placeholder: null,
          },
          IsSummerName: {
            //	王sir 的 [udt_FactoryFluidPriceInfo] 可程序性函數 欄位名稱
            show: true,
            label: "夏月/非夏月：",
            value: null,
            input_format: "select",
            format_type: "text",
            enable: false,
            options: [
              { label: "夏月", value: "1" },
              { label: "非夏月", value: "0" },
            ],
            placeholder: null,
          },
          TimeRange: {
            //	王sir 的 [udt_FactoryFluidPriceInfo] 可程序性函數 欄位名稱
            show: true,
            label: "時段區間：",
            value: null,
            input_format: "input",
            format_type: "text",
            enable: true,
            options: [],
            placeholder: "輸入：00:00~06:00",
          },
          PeakName: {
            //	王sir 的 [udt_FactoryFluidPriceInfo] 可程序性函數 欄位名稱
            show: true,
            label: "尖峰離峰：",
            value: null,
            input_format: "select",
            format_type: "text",
            enable: false,
            options: [
              { label: "尖峰時間", value: "1" },
              { label: "半尖峰時間", value: "2" },
              { label: "離峰時間", value: "3" },
            ],
            placeholder: null,
          },
          EnableDate: {
            //	主key：版本 => this.priceVersion['value']
            show: false,
            label: "版本(依法規電價表更新日)",
            value: null,
            input_format: "input", //	前端 q-input / q-select / q-datetime
            format_type: "number", //	format_type => text / number / date、datetime
            enable: false, //	input_format 是否可以編輯
            options: [], //	input_format => select 才需要
            placeholder: null,
          },
          VoltageId: {
            //	主key：電壓高低別：1 = 低壓、 2 = 高壓、 3 = 特高壓
            show: false,
            label: "供電模式",
            value: null,
            input_format: "input",
            format_type: "number",
            enable: false,
            options: [],
            placeholder: null,
          },
          RangeSection: {
            //	主key：2段式 / 3段式 => this.RangeSection
            show: false,
            label: "幾段式電價",
            value: null,
            input_format: "input",
            format_type: "number",
            enable: false,
            options: [],
            placeholder: null,
          },
          WeekdayId: {
            //	主key：1 => 週一～週五、 2 => 週六、 3 => 週日及離峰日
            show: false,
            label: "流動日",
            value: null,
            input_format: "input",
            format_type: "number",
            enable: false,
            options: [],
            placeholder: null,
          },
          StartHourMinute: {
            //	主key：可能非必要 例：00:00 => 0000
            show: false,
            label: "開始時間",
            value: null,
            input_format: "input",
            format_type: "number",
            enable: false,
            options: [],
            placeholder: null,
          },
          EndHourMinute: {
            show: false,
            label: "結束時間",
            value: null,
            input_format: "input",
            format_type: "number",
            enable: false,
            options: [],
            placeholder: null,
          },
          IsSummer: {
            //	主key：1 => 夏月、 2 => 非夏月
            show: false,
            label: "",
            value: null,
            input_format: "input",
            format_type: "number",
            enable: false,
            options: [],
            placeholder: null,
          },
          PeakId: {
            //	1 => 尖峰、 2 => 半尖峰、 3 => 離峰
            show: false,
            label: "",
            value: null,
            input_format: "input",
            format_type: "number",
            enable: false,
            options: [],
            placeholder: null,
          },
          Price: {
            show: true,
            label: "電價：",
            value: null,
            input_format: "input",
            format_type: "number",
            enable: false,
            options: [],
            placeholder: null,
          },
          Comment: {
            show: false,
            label: "說明",
            value: null,
            input_format: "input",
            format_type: "number",
            enable: false,
            options: [],
            placeholder: null,
          },
        },
      },
      //	離峰日
      peakDay: {
        show: false,
        title: "離峰日設定",
        selectYear: moment().format("YYYY"),
        yearOptions: [],
        data: [{ id: null, date: "2023-10-10", comment: "國慶日" }],
      },
      // 	顏廷瑜更新已上項目

      //表單表頭樣式設定
      cellStyleOption: {
        headerCellClass: ({ column, rowIndex }) => {
          return "text-black custom-table-header";
        },
      },
      //表單分頁
      pageIndex: 1,
      pageSize: 10,
      //表單資料陣列
      table_data: [],
    };
  },

  computed: {
    compareEffective() {
      if (!_.isNull(this.priceVersion["value"])) {
        if (
          new Date(this.priceVersion["value"]).valueOf() > new Date().valueOf()
        ) {
          return true;
        } else {
          return false;
        }
      }
    },
    getWeekdayName() {
      return _.reduce(
        this.priceEdit["data"]["WeekdayName"]["options"],
        (obj, item) => {
          obj[item["value"]] = item["label"];
          return obj;
        },
        {}
      );
    },
    getIsSummerName() {
      return _.reduce(
        this.priceEdit["data"]["IsSummerName"]["options"],
        (obj, item) => {
          obj[item["value"]] = item["label"];
          return obj;
        },
        {}
      );
    },
    getPeakName() {
      return _.reduce(
        this.priceEdit["data"]["PeakName"]["options"],
        (obj, item) => {
          obj[item["value"]] = item["label"];
          return obj;
        },
        {}
      );
    },
    getRangeSection() {
      return _.reduce(
        this.newBasic["PriceComment"]["options"],
        (obj, item) => {
          obj[item["value"]] = item["subValue"];
          return obj;
        },
        {}
      );
    },
    //表單欄位
    tableColumns() {
      let arr = [
        {
          field: "WeekdayName",
          key: "WeekdayName",
          title: "星期分類",
          align: "center",
          width: 150,
        },
        {
          field: "IsSummerName",
          key: "IsSummerName",
          title: "夏月/非夏月",
          align: "center",
          width: 150,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            return [
              h("span", {
                class: "",
                style: row.IsSummerName == '夏月' ? "color:#244BC3;" : "color:#000;",
                on: {
                },
              }, row.IsSummerName),
            ];
          },
        },
        {
          field: "TimeRange",
          key: "TimeRange",
          title: "時間區段",
          align: "center",
          width: 150,
        },
        {
          field: "PeakName",
          key: "PeakName",
          title: "尖峰離峰",
          align: "center",
          width: 150,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let temp = '#777';
            if (row.PeakName == '尖峰時間') {
              temp = '#61C640';
            } else if (row.PeakName == '半尖峰時間') {
              temp = '#41ABC4';
            }
            return [
              h("span", {
                class: "",
                style: `border-radius:1em;color:${temp};border:1px solid ${temp}; padding:1px 10px;`,
                on: {
                },
              }, row.PeakName),
            ];
          },
        },
        {
          field: "Price",
          key: "Price",
          title: "電價",
          align: "center",
          width: 150,
        },
        {
          field: "edit",
          key: "edit",
          title: "-",
          align: "center",
          width: 150,
          renderBodyCell: ({ row, column, rowIndex }, h) => {
            let temp = [
              h("q-btn", {
                class: "id-btn",
                attrs: {
                  label: "編輯",
                  color: "primary",
                  icon:"edit",
                  outline:true,
                  rounded:true,
                },
                on: {
                  click: () => {
                    this.editPrice(row);
                  },
                },
              }),
            ];
            if (this.compareEffective) {
              temp.push(
                h("q-btn", {
                  class: "id-btn",
                  style: "font-weight: 700; margin-left:20px;",
                  attrs: {
                    label: "刪除",
                    color: "negative",
                    icon:"delete",
                    outline:true,
                    rounded:true,
                  },
                  on: {
                    click: () => {
                      this.deletePrice(row);
                    },
                  },
                }),
              );
            }
            return temp;
          },
        },
      ];
      return arr;
    },
    //表單資料總數
    totalCount() {
      return this.priceTable.datas.length;
    },
    //表單資料分頁邏輯
    tableData() {
      const { pageIndex, pageSize } = this;
      return this.priceTable.datas.slice(
        (pageIndex - 1) * pageSize,
        pageIndex * pageSize
      );
    },
  },

  watch: {},

  mounted() {
    this.$set(this.WebSetup, "caption", "報表查詢");
    this.$set(this.WebSetup, "icon", "list");
    this.MenuSetup.opened = false;
    this.VarMenuIsOverlay = true;
    // this.get_base_electricity_bill();
    // this.fnSetConditionVal("QueryDate", {
    //   value: new Date().pattern("yyyy/MM/dd"),
    // });
    if (this.LoginSetup.status === true) {
      this.LoadPriceVersion();
    };
  },
  methods: {
    fnInitial(cfg) {
      console.log(cfg);
      this.IsSoftStartup = true; // cfg載入完成時執行第一次
      this.IsMQTTStartup = true;
    },
    //取得點位數值
    fnSoft(v) {
      if (this.SoftTagName[v] != undefined) {
        return this.SoftTagName[v]["value"];
      } else {
        return 0;
      }
    },
    //取得電價資料
    // get_base_electricity_bill() {
    // 	var that = this;
    // 	that.$q.loading.show();
    // 	var params = {
    // 		Action: "get_base_electricity_bill",
    // 		Datas: {},
    // 	};
    // 	that.FnWebAPIGet(params).then((res) => {
    // 		var resData = res.data;
    // 		console.log(resData);
    // 		if (resData.result) {
    // 			that.data = resData.data;
    // 			that.$q.loading.hide();
    // 		} else {
    // 			that.$q.loading.hide();
    // 			that.FnNotify(res.data.message, "error");
    // 		}
    // 	});
    // },
    // fnGetReportValue(key, main, sub) {
    // 	let output = { key: '', value: '0' };

    // 	if (main != 'info') {
    // 		output = this.data[key][main];
    // 		return output;
    // 	} else if (sub) {
    // 		output = this.data[key][main][sub];
    // 		return output;
    // 	}

    // 	return output;
    // },

    fnSetConditionVal(key, obj) {
      var self = this;
      this.conditions.forEach(function (block, index) {
        if (Object.keys(block.contents).includes(key)) {
          Object.keys(block.contents).forEach(function (tn) {
            if (tn == key && typeof obj == "object") {
              Object.assign(self.conditions[index].contents[key], obj);
            }
          });
        }
      });
    },
    fnGetConditionObj($conditions) {
      var conditionObj = {};
      $conditions.forEach(function (item) {
        Object.keys(item.contents).forEach(function (condition_key) {
          conditionObj[condition_key] = item.contents[condition_key].value;
          if (item.contents[condition_key].type == "datetime") {
            conditionObj[condition_key] = new Date(
              item.contents[condition_key].value
            ).pattern("yyyy-MM-dd");
          }
          if (item.contents[condition_key].type == "date") {
            conditionObj[condition_key] = new Date(
              item.contents[condition_key].value
            ).pattern("yyyy-MM-dd");
          }
        });
      });
      return conditionObj;
    },
    fnQueryConditions() {
      var self = this;
      var obj = this.fnGetConditionObj(this.conditions);
      this.TrendLines.forEach(function (item, index) {
        if (item.selects.columns.value) {
          obj["Line" + index] = { col: item.selects.columns.value };
        }
      });
      return obj;
    },
    fnQueryChanged(result) {
      this.fnSetConditionVal(result.key, { value: result.val });
    },
    //報表下載
    fnReportDownload() {
      var condition = this.fnGetConditionObj(this.conditions);

      if (condition.QueryDate && condition.OutputType) {
        this.DownloadLink = "";
        var that = this;
        var params = {
          Action: "get_daliy_report",
          Datas: {
            date: new Date(condition.QueryDate).pattern("yyyy/MM/dd"),
            type: condition.OutputType,
          },
        };
        //檔案名稱為空時 由後端決定檔案名稱
        that.FnWebAPIDownload(params, "", true).then(function (res) {
          console.log(res);
        });
      }
    },

    //	載入目前電價版本 - by 瑜
    LoadPriceVersion() {
      var todayDate = new Date(); // 目标日期
      var params = {
        Action: "PriceVersionOptions",
        Datas: {},
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          if (res.data.result) {
            this.priceVersion["options"] = _.map(res.data.data, (item) => {
              return {
                label: item["EnableDate"],
                value: item["EnableDate"],
              };
            });

            if (!_.isEmpty(this.priceVersion["options"])) {
              var closestObject = _.minBy(
                this.priceVersion["options"],
                (item) => Math.abs(new Date(item["value"]) - todayDate)
              );
              this.priceVersion["value"] = closestObject["value"];
              // this.priceVersion['value'] = _.first(this.priceVersion['options'])["value"]; // 預選第一筆
            } else {
            }
            if (_.isNull(this.rangeSection)) {
              //	初始預先載入內容
              this.rangeSection = "2";
              this.LoadPageDetail(this.rangeSection);
            } else {
              this.LoadPageDetail(this.rangeSection);
            }
          }
        })
        .catch(async function (err) {
          console.log(err);
        });
    },
    //	載入頁面預先抓取廠區使用的低壓/高壓/特高壓資訊 - detail by 瑜
    LoadPageDetail(RangeSection) {
      if (_.isNull(this.priceVersion["value"])) {
        this.priceVersion["value"] = moment().format("YYYY-MM-DD");
      }
      if (!_.isNull(this.rangeSection)) {
        //	切換保留目前用電段式數值
        this.rangeSection = RangeSection;
      }
      var params = {
        Action: "GetCfgFactoryInfo",
        Datas: {
          Factory: this.factory["value"],
          RangeSection: this.rangeSection,
          YearVersion: this.priceVersion["value"],
        },
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          if (res.data.result) {
            _.map(res.data.data.detail, (item) => {
              item["Price"] = this.FnFormatNumber(item["Price"], 2);
            });
            this.priceTable["datas"] = res.data.data.detail;
            _.each(this.basic, (item, key) => {
              item["value"] = res.data.data.title[key];
            });
          }
        })
        .catch(async function (err) {
          console.log(err);
        });
    },
    //
    getMonthLastDay() {
      this.newBasic["SummerStartDay"]["options"] = [];
      if (!_.isNull(this.newBasic["SummerStartMonth"]["value"])) {
        //	得到當輸入的月份的下一個月的第一天
        var date = new Date(
          new Date().getFullYear(),
          this.newBasic["SummerStartMonth"]["value"],
          1
        );
        //	減去一天取得當月的最後一天
        date.setDate(0);
        //	獲取當月的天數
        var daysInMonth = date.getDate();
        for (var i = 1; i <= daysInMonth; i++) {
          this.newBasic["SummerStartDay"]["options"].push({
            label: `${i}日`,
            value: i,
          });
        }
      }
      this.newBasic["SummerEndDay"]["options"] = [];
      if (!_.isNull(this.newBasic["SummerEndMonth"]["value"])) {
        //	得到當輸入的月份的下一個月的第一天
        var date = new Date(
          new Date().getFullYear(),
          this.newBasic["SummerEndMonth"]["value"],
          1
        );
        //	減去一天取得當月的最後一天
        date.setDate(0);
        //	獲取當月的天數
        var daysInMonth = date.getDate();
        for (var i = 1; i <= daysInMonth; i++) {
          this.newBasic["SummerEndDay"]["options"].push({
            label: `${i}日`,
            value: i,
          });
        }
      }
    },

    //	新增生效日
    addBasic() {
      var todayDate = new Date(); // 目标日期
      var closestObject = _.minBy(this.priceVersion["options"], (item) =>
        Math.abs(new Date(item["value"]) - todayDate)
      );
      this.priceVersion["value"] = closestObject["value"];

      if (_.isEmpty(this.newEffective["value"])) {
        this.FnNotify("請選生效日期", "warning");
        return;
      }
      if (_.isNull(this.newBasic["PerKwSummer"]["value"])) {
        this.FnNotify("請輸入經常契約(每瓩) - 夏月", "warning");
        return;
      }
      if (_.isNull(this.newBasic["PerKwNonSummer"]["value"])) {
        this.FnNotify("請輸入經常契約(每瓩) - 非夏月", "warning");
        return;
      }
      // if ( _.isEmpty(this.newBasic['PriceComment']['value']) ) {
      // 	this.FnNotify("請選擇經常契約分類", 'warning');
      // 	return
      // }
      if (_.isNull(this.newBasic["SummerStartMonth"]["value"])) {
        this.FnNotify("請輸入夏月 - 開始月", "warning");
        return;
      }
      if (_.isNull(this.newBasic["SummerStartDay"]["value"])) {
        this.FnNotify("請輸入夏月 - 開始日", "warning");
        return;
      }
      if (_.isNull(this.newBasic["SummerEndMonth"]["value"])) {
        this.FnNotify("請輸入夏月 - 結束月", "warning");
        return;
      }
      if (_.isNull(this.newBasic["SummerEndDay"]["value"])) {
        this.FnNotify("請輸入夏月 - 結束日", "warning");
        return;
      }
      if (!_.isEmpty(this.newEffective["value"])) {
        if (
          new Date(this.priceVersion["value"]).valueOf() >
          new Date(this.newEffective["value"]).valueOf()
        ) {
          this.FnNotify("請定義之後的生效日", "warning");
          return false;
        }
      }
      if (
        !_.isEmpty(this.newBasic["SummerStartMonth"]["value"]) &&
        !_.isEmpty(this.newBasic["SummerEndMonth"]["value"])
      ) {
        if (
          parseInt(this.newBasic["SummerStartMonth"]["value"]) >
          parseInt(this.newBasic["SummerEndMonth"]["value"])
        ) {
          this.newBasic["SummerStartMonth"]["value"] = null;
          this.newBasic["SummerEndMonth"]["value"] = null;
          this.FnNotify("開始月份不能大於結束月份", "warning");
          return false;
        }
      }
      if (
        parseInt(this.newBasic["SummerStartMonth"]["value"]) ==
        parseInt(this.newBasic["SummerEndMonth"]["value"])
      ) {
        if (
          parseInt(this.newBasic["SummerStartDay"]["value"]) >
          parseInt(this.newBasic["SummerEndDay"]["value"])
        ) {
          this.newBasic["SummerStartDay"]["value"] = null;
          this.newBasic["SummerEndDay"]["value"] = null;
          this.FnNotify("開始日期不能大於結束日期", "warning");
          return false;
        }
      }
      var params = {
        Action: "InsertBasic",
        Datas: {
          EnableDate: moment(this.newEffective["value"]).format("YYYY-MM-DD"),
          VoltageId: "2",
          RangeSection: "2", //this.getRangeSection[this.newBasic['PriceComment']['value']],
          PerHousehold: "0",
          PerKwSummer: this.newBasic["PerKwSummer"]["value"],
          PerKwNonSummer: this.newBasic["PerKwNonSummer"]["value"],
          PriceComment: this.newBasic["PriceComment"]["value"],
          SummerStartMonth: this.newBasic["SummerStartMonth"]["value"],
          SummerStartDay: this.newBasic["SummerStartDay"]["value"],
          SummerEndMonth: this.newBasic["SummerEndMonth"]["value"],
          SummerEndDay: this.newBasic["SummerEndDay"]["value"],
        },
      };
      this.FnWebAPIPost(params)
        .then((res) => {
          if (res.data.result) {
            if (res.data.data.status) {
              this.FnNotify(res.data.data.msg, "success");
              this.LoadPriceVersion();
              this.closeQWindow();
            } else {
              this.FnNotify(res.data.data.msg, "error");
            }
          }
        })
        .catch(async function (err) {
          console.log(err);
        });
    },

    //	新增電價 - by 瑜
    addPrice() {
      this.priceEdit["title"] = "新增電價";
      this.priceEdit["show"] = true;
      this.priceEdit["data"]["TimeRange"]["enable"] = false;
    },
    //	新增電價Step.2 - by 瑜
    insertPrice() {
      var tempStr = this.priceEdit["data"]["TimeRange"]["value"];

      if (_.isEmpty(this.priceEdit["data"]["WeekdayName"]["value"])) {
        this.FnNotify("請選星期分類", "warning");
        return;
      }
      if (_.isEmpty(this.priceEdit["data"]["IsSummerName"]["value"])) {
        this.FnNotify("請選夏月/非夏月", "warning");
        return;
      }
      if (_.isEmpty(this.priceEdit["data"]["TimeRange"]["value"])) {
        this.FnNotify("請輸入時間區間內容", "warning");
        return;
      }
      if (_.isEmpty(this.priceEdit["data"]["PeakName"]["value"])) {
        this.FnNotify("請選尖峰離峰", "warning");
        return;
      }
      if (_.isNull(this.priceEdit["data"]["Price"]["value"])) {
        this.FnNotify("請輸入電價", "warning");
        return;
      }
      if (!_.isEmpty(this.priceEdit["data"]["TimeRange"]["value"])) {
        if (
          tempStr.slice(2, 3) != ":" ||
          tempStr.slice(8, 9) != ":" ||
          tempStr.slice(5, 6) != "~"
        ) {
          this.FnNotify("時間區間輸入格式不正確", "warning");
          return false;
        }
      }

      var params = {
        Action: "AddPrice",
        Datas: {
          EnableDate: this.priceVersion["value"],
          VoltageId: "2", //	固定 2 高壓
          RangeSection: this.rangeSection,
          WeekdayId: this.priceEdit["data"]["WeekdayName"]["value"],
          StartHourMinute: this.priceEdit["data"]["TimeRange"]["value"]
            .replace(/:/g, "")
            .slice(0, 4),
          EndHourMinute: this.priceEdit["data"]["TimeRange"]["value"]
            .replace(/:/g, "")
            .slice(5, 9),
          IsSummer: this.priceEdit["data"]["IsSummerName"]["value"],
          PeakId: this.priceEdit["data"]["PeakName"]["value"],
          Price: this.priceEdit["data"]["Price"]["value"],
          Comment:
            this.getWeekdayName[
            this.priceEdit["data"]["WeekdayName"]["value"]
            ] +
            this.getPeakName[this.priceEdit["data"]["PeakName"]["value"]] +
            "-" +
            this.getIsSummerName[
            this.priceEdit["data"]["IsSummerName"]["value"]
            ],
        },
      };
      this.FnWebAPIPost(params)
        .then((res) => {
          if (res.data.result) {
            if (res.data.data.status) {
              this.FnNotify(res.data.data.msg, "success");
              this.LoadPageDetail(this.rangeSection);
              this.closeQWindow();
            } else {
              this.FnNotify(res.data.data.msg, "error");
            }
          }
        })
        .catch(async function (err) {
          console.log(err);
        });
    },

    //	編輯電價 - by 瑜
    editPrice(prop) {
      this.priceEdit["title"] = "編輯電價";
      _.each(this.priceEdit["data"], (item, key) => {
        item["value"] = prop[key];
        if (prop[key] == "夏月") {
          item["value"] = "1";
        }
        if (prop[key] == "非夏月") {
          item["value"] = "0";
        }
        if (prop[key] == "週一～週五") {
          item["value"] = "1";
        }
        if (prop[key] == "週六") {
          item["value"] = "6";
        }
        if (prop[key] == "週日及離峰日") {
          item["value"] = "7";
        }
        if (prop[key] == "尖峰時間") {
          item["value"] = "1";
        }
        if (prop[key] == "半尖峰時間") {
          item["value"] = "2";
        }
        if (prop[key] == "離峰時間") {
          item["value"] = "3";
        }
      });
      this.priceEdit["show"] = true;
    },

    //	更新電價	- by 瑜
    updatePrice() {
      // console.log(
      // 	"版本",this.priceEdit['data']['EnableDate']['value'] = this.priceVersion['value'],
      // 	"供電模式",this.priceEdit['data']['VoltageId']['value'] = '2',
      // 	"幾段式電價",this.priceEdit['data']['RangeSection']['value'] = this.rangeSection,
      // 	"流動日",this.priceEdit['data']['WeekdayId']['value'],
      // 	"開始時間",this.priceEdit['data']['StartHourMinute']['value'] = this.priceEdit['data']['TimeRange']['value'].replace(':', '').slice(0, 4),
      // 	"夏日/非夏日",this.priceEdit['data']['IsSummer']['value'],
      // 	"電價",this.priceEdit['data']['Price']['value'],
      // );
      var params = {
        Action: "UpdatePrice",
        Datas: {
          EnableDate: this.priceVersion["value"],
          VoltageId: "2", //	固定 2 高壓
          RangeSection: this.rangeSection,
          WeekdayId: this.priceEdit["data"]["WeekdayId"]["value"],
          StartHourMinute: this.priceEdit["data"]["TimeRange"]["value"]
            .replace(":", "")
            .slice(0, 4),
          IsSummer: this.priceEdit["data"]["IsSummer"]["value"],
          PeakId: this.priceEdit["data"]["PeakId"]["value"],
          WeekdayName: this.priceEdit["data"]["WeekdayName"]["value"],
          IsSummerName: this.priceEdit["data"]["IsSummerName"]["value"],
          PeakName: this.priceEdit["data"]["PeakName"]["value"],
          Price: this.priceEdit["data"]["Price"]["value"],
        },
      };
      this.FnWebAPIPost(params)
        .then((res) => {
          if (res.data.result) {
            if (res.data.data.status) {
              this.FnNotify(res.data.data.msg, "success");
              this.LoadPageDetail(this.rangeSection);
              this.closeQWindow();
            } else {
              this.FnNotify(res.data.data.msg, "error");
            }
          } else {
          }
        })
        .catch(async function (err) {
          console.log(err);
        });
    },

    //	刪除電價 - by 瑜
    async deletePrice(prop) {
      if (await this.FnConfirm2("確定要刪除此筆資料嗎？")) {
        _.each(this.priceEdit["data"], (item, key) => {
          item["value"] = prop[key];
          if (prop[key] == "夏月") {
            item["value"] = "1";
          }
          if (prop[key] == "非夏月") {
            item["value"] = "0";
          }
          if (prop[key] == "週一～週五") {
            item["value"] = "1";
          }
          if (prop[key] == "週六") {
            item["value"] = "6";
          }
          if (prop[key] == "週日及離峰日") {
            item["value"] = "7";
          }
          if (prop[key] == "尖峰時間") {
            item["value"] = "1";
          }
          if (prop[key] == "半尖峰時間") {
            item["value"] = "2";
          }
          if (prop[key] == "離峰時間") {
            item["value"] = "3";
          }
        });
        let param = {
          Action: "DeletePrice",
          Datas: {
            EnableDate: this.priceVersion["value"],
            VoltageId: "2", //	固定 2 高壓
            RangeSection: this.rangeSection,
            WeekdayId: this.priceEdit["data"]["WeekdayId"]["value"],
            StartHourMinute: this.priceEdit["data"]["TimeRange"]["value"]
              .replace(":", "")
              .slice(0, 4),
            IsSummer: this.priceEdit["data"]["IsSummer"]["value"],
            PeakId: this.priceEdit["data"]["PeakId"]["value"],
          },
        };
        this.FnWebAPIPost(param)
          .then((res) => {
            if (res.data.result) {
              if (res.data.data.status) {
                this.FnNotify(res.data.data.msg, "success");
                this.LoadPageDetail(this.rangeSection);
                this.closeQWindow();
              } else {
                this.FnNotify(res.data.data.msg, "error");
              }
            } else {
            }
          })
          .catch(async function (err) {
            console.log(err);
          });
      }
    },

    //	新增離峰日 - by 瑜
    addPeakDayOptions() {
      let select_list = _.cloneDeep(this.peakDay["data"]);
      select_list.push({
        id: moment().valueOf(), //	刪除的關鍵 的 ID
        date: moment().format("YYYY-MM-DD"),
        comment: null,
        readonly: false,
        disable: false,
      });
      this.peakDay["data"] = select_list;
    },
    //	新增離峰日 => 選擇年份下拉 - by 瑜
    getYearOptions() {
      var op = [];
      for (var y = moment().year(); y <= moment().year() + 5; y++) {
        op.push({ label: y, value: y });
      }
      this.peakDay["yearOptions"] = op;
      this.peakDay["selectYear"] = _.first(this.peakDay["yearOptions"])[
        "value"
      ];
      this.loadPeakDay();
    },
    // 	載入當年離峰日 - by 瑜
    loadPeakDay() {
      this.peakDay["data"] = [];
      var params = {
        Action: "LoadPeakDay",
        Datas: {
          year: this.peakDay["selectYear"],
        },
      };
      this.FnWebAPIGet(params)
        .then((res) => {
          if (res.data.result) {
            this.peakDay["data"] = _.map(res.data.data, (item, inx) => {
              return {
                id: String(inx),
                date: item["NonPeekDate"],
                comment: item["Comment"],
                readonly: true,
                disable: true,
              };
            });
          }
        })
        .catch(async function (err) {
          console.log(err);
        });
    },
    //	更新離峰日 - by 瑜
    updatePeakDay() {
      //	如果選擇年份有超過選擇的年份目標，該筆刪除
      let select_list = _.cloneDeep(this.peakDay["data"]);
      _.remove(select_list, (item) => {
        return moment(item["date"]).year() != this.peakDay["selectYear"];
      });
      this.peakDay["data"] = select_list;

      var params = {
        Action: "UpdatePeakDay",
        Datas: {
          peakDayArr: this.peakDay["data"],
        },
      };
      this.FnWebAPIPost(params)
        .then((res) => {
          if (res.data.result) {
            if (res.data.data.status) {
              this.FnNotify(res.data.data.msg, "success");
              this.loadPeakDay();
              // this.closeQWindow()
            } else {
              this.FnNotify(res.data.data.msg, "error");
            }
          } else {
          }
        })
        .catch(async function (err) {
          console.log(err);
        });
    },
    //	刪除離峰日 - by 瑜
    async deletePeakDayOptions(item, originalArray) {
      //	查看資料型態長度決定走向
      console.log(_.size(item["id"]));
      if (_.size(item["id"]) == 0) {
        //	單純新增檢查項目 => 刪除
        let select_list = _.cloneDeep(originalArray["data"]);
        var temp_id = item["id"];
        _.remove(select_list, (list_key) => {
          return list_key["id"] == temp_id;
        });
        originalArray["data"] = select_list;
      } else {
        //	刪除現有資料
        if (await this.FnConfirm2("確定要刪除此筆資料嗎？")) {
          let param = {
            Action: "DeletePeakDay",
            Datas: {
              date: item["date"],
            },
          };
          this.FnWebAPIPost(param)
            .then((res) => {
              if (res.data.result) {
                if (res.data.data) {
                  this.FnNotify("刪除離峰日成功", "success");
                  this.loadPeakDay();
                } else {
                  this.FnNotify("刪除離峰日失敗", "error");
                }
              } else {
              }
            })
            .catch(async function (err) {
              console.log(err);
            });
        }
      }
    },

    //	關閉視窗	- by 瑜
    closeQWindow() {
      this.peakDay["data"] = [];
      this.priceEdit["data"]["TimeRange"]["enable"] = true;
      _.each(this.priceEdit["data"], (item) => {
        item["value"] = null;
      });
      _.each(this.newBasic, (item) => {
        item["value"] = null;
      });
      this.peakDay["show"] = false;
      this.priceEdit["show"] = false;
      this.newEffective["show"] = false;
    },

    //	刪除生效日
    async deleteEnableDay() {
      if (
        await this.FnConfirm2(
          "確定要刪除此筆資料嗎？"
        )
      ) {
        if (
          new Date(this.priceVersion["value"]).valueOf() < new Date().valueOf()
        ) {
          this.FnNotify("不能刪除至今之前的紀錄", "warning");
          return;
        }

        let param = {
          Action: "DeleteEnableDay",
          Datas: {
            EnableDate: this.priceVersion["value"],
          },
        };
        this.FnWebAPIPost(param)
          .then((res) => {
            if (res.data.result) {
              if (res.data.data.status) {
                this.FnNotify(res.data.data.msg, "success");
                this.LoadPriceVersion();
                // this.closeQWindow()
              } else {
                this.FnNotify(res.data.data.msg, "error");
              }
            } else {
            }
          })
          .catch(async function (err) {
            console.log(err);
          });
      }
    },

    //	copy - by 瑜
    FnFormatNumber(num, decimalPlaces) {
      // 數字格式化成有千分位與小數點的字串
      // 轉換成數字型態
      num = Number(num);
      // 確認是否有小數點位數，預設為2位
      decimalPlaces = typeof decimalPlaces === "number" ? decimalPlaces : 2;
      // 取得整數部分
      var integerPart = Math.floor(num);
      // 取得小數部分，將小數點後的數字四捨五入到指定位數
      var decimalPart = (num - integerPart).toFixed(decimalPlaces).slice(2);
      // 將整數部分加上千分位逗號
      var formattedIntegerPart = integerPart.toLocaleString();
      // 如果沒有小數點，就補上指定位數的0
      if (decimalPlaces > 0 && decimalPart.length < decimalPlaces) {
        decimalPart =
          decimalPart + "0".repeat(decimalPlaces - decimalPart.length);
      }
      // 回傳格式化後的字串
      return (
        formattedIntegerPart + (decimalPlaces > 0 ? "." + decimalPart : "")
      );
    },

    // page number change
    pageNumberChange(pageIndex) {
      this.pageIndex = pageIndex;
    },

    // page size change
    pageSizeChange(pageSize) {
      this.pageIndex = 1;
      this.pageSize = pageSize;
    },

  },
};
