
var page_function = {
	components: {
		"multi-yaxis-chart": httpVueLoader("components/layout/multi_yaxis_chart.vue"),
	},
	data() {
		return {
			VarMenuPage: "system_power_architecture",
			VarMenu: "area",
			VarPageContainerCss: "height:calc(100vh - 65px);",

			tab: "architecture_tree",

			//節點清單
			select_node_options: [
			],
			//節點資料
			architecture_node_data: {
				node_select: null, //當前選中節點ID
				node_name: null, //當前選中節點名稱
				node_type: null, //當前選中節點類型
				node_type_name: null, //當前選中節點類型
				child_ctrl_list: [],//當前選中節點的子節點卡控清單 (在陣列內的子節點類型才可新增)
				info: [],
				child: [],
			},

			//節點樹狀圖資料
			node_tree_data: {
				//資料範例
				// name: 'flare',
				// value: 3322,
				// children: [
				// 	{
				// 		name: 'data',
				// 		children: [
				// 			{
				// 				name: 'converters',
				// 				children: [
				// 					{ name: 'Converters', value: 721 },
				// 					{ name: 'DelimitedTextConverter', value: 4294 }
				// 				]
				// 			},
				// 			{
				// 				name: 'DataUtil',
				// 				value: 3322
				// 			}
				// 		]
				// 	},
				// ]
			},
			//節點新增、修改 彈窗
			dialog_power_architecture_node: {
				show: false, // 控制彈窗顯示
				is_create: true, //是否為新增
				base_option: {
					type: [],
					info: {},
				},
				parent_node_id: null, // 父節點 ID
				node_id: null, // 節點 ID
				node_name: null,
				node_type: null,
				info_list: [
					// 內容範例
					// {
					// 	node_info_id: null, //節點資訊表主鍵
					//  base_info_id:null, //節點類型資訊表主鍵
					// 	label: "test", //節點資訊名稱
					// 	value: "asdf"
					// }
				]
			},
		};
	},

	computed: {
		//echart 節點樹狀圖  option
		node_tree_option() {
			return {
				tooltip: {
					trigger: 'item',
					triggerOn: 'mousemove',
				},
				series: [
					{
						type: 'tree',
						name: 'tree1',
						data: [this.node_tree_data],
						top: '10%',
						left: '8%',
						bottom: '22%',
						right: '20%',
						symbolSize: 10,
						edgeShape: 'polyline',
						edgeForkPosition: '63%',
						initialTreeDepth: 3,
						lineStyle: {
							width: 2
						},
						label: {
							backgroundColor: '#fff',
							position: 'left',
							verticalAlign: 'middle',
							align: 'right',
							fontSize: 18,
							// formatter: function (params) {
							// 	// 使用 span 包裝標籤，並添加自定義 id 或 class
							// 	return '{label|' + params.name + '}';
							// },
							// rich: {
							// 	label: {
							// 		// 定義 label 樣式
							// 		color: '#000',
							// 		textBorderWidth: 1,
							// 		fontSize: 18,
							// 		cursor: 'pointer' // 標籤的點擊樣式
							// 	}
							// },
							// emphasis: {
							// 	disable: false,
							// 	// focus: 'descendant'
							// },

							// layout: 'radial' // 可以选择不同的布局
						},
						leaves: {
							label: {
								position: 'right',
								verticalAlign: 'middle',
								align: 'left'
							}
						},
						expandAndCollapse: false,
						animationDuration: 550,
						animationDurationUpdate: 750
					}
				],
			};
		},
		//新增子節點按鈕顯示卡控
		btn_add_child_ctrl() {
			let res = true;
			//當有選中節點 但是子節點類型卡控清單沒有任何項目時 代表已到最底層 因此關閉新增子節點按鈕顯示
			if (this.architecture_node_data.node_select != null &&
				this.architecture_node_data.child_ctrl_list.length <= 0
			) {
				res = false;
			}
			//當節點清單有資料 但使用者尚未選擇節點 則 關閉新增子節點按鈕顯示
			if (this.architecture_node_data.node_select == null &&
				this.select_node_options.length > 0
			) {
				res = false;
			}
			return res
		}
	},
	created() {
	},

	watch: {},

	mounted() {
		this.$set(this.WebSetup, "caption", this.$t("menu.system_power_architecture"));
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		//撈取節點樹狀圖資料
		this.get_node_tree();
		//撈取節點清單資料
		this.get_node_list();

	},

	methods: {
		//樹狀圖節點點擊事件處理
		node_tree_click(event_obj) {
			let that = this
			event_obj.event.event.stopPropagation();
			if (event_obj.name) {
				//設定選中的節點
				that.architecture_node_data.node_select = event_obj.data.id;
				//查詢選中節點的頁面資訊
				that.get_node_table_data(event_obj.data.id);
				//點擊標籤就轉跳節點資訊頁面
				that.changeTab("architecture_node")
			}
		},
		//頁簽切換處理
		changeTab(_tab) {
			let that = this;
			//當使用者點擊節點資訊時 先判斷目前有沒有節點 沒有的話先跳請使用者新增節點彈窗
			if (_tab == "architecture_node" && this.select_node_options.length <= 0) {
				this.$q
					.dialog({
						title: "尚未建立任何節點",
						message: `是否要建立初始節點`,
						color: "primary",
						ok: true,
						cancel: true,
					})
					.then(() => {
						this.open_node_dialog()
					})
					.catch(() => {
					});
			} else {
				if (_tab == "architecture_tree") {
					this.get_node_tree()
				} else {
					//點擊節點資訊時 重新撈取節點清單
					this.get_node_list();
				}
				this.$set(this, 'tab', _tab);
			}
		},
		//取得電力架構樹狀圖資料
		get_node_tree() {
			let that = this;
			that.$q.loading.show();
			var params = {
				Action: "get_node_tree",
				Datas: {},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					//先清除乾淨再渲染 防止畫面異常
					if (this.$refs.tree_chart) {
						let tree_chart = this.$refs.tree_chart;
						tree_chart.clear()
					}
					that.node_tree_data = resData;
				} else {
					that.FnNotify("錯誤", "error");
				}

				that.$q.loading.hide();
			});
		},
		//節點資訊分頁 頁面資料撈取
		async get_node_table_data(node_id) {
			let that = this;
			that.$q.loading.show();
			var params = {
				Action: 'get_node_data',
				Datas: {
					node_id: node_id
				},
			};
			await that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					let resData = res.data.data;
					that.architecture_node_data.node_select = resData.node_id
					//設定卡控清單 新增子節點用 
					that.architecture_node_data.child_ctrl_list = resData.child_ctrl_list
					//設定節點名稱
					that.architecture_node_data.node_name = resData.node_name
					//設定節點類型
					that.architecture_node_data.node_type = resData.node_type
					//設定節點類型名稱
					that.architecture_node_data.node_type_name = resData.node_type_name
					//設定節點資訊清單
					that.architecture_node_data.info = [];
					if (resData.node_info.length > 0) {
						resData.node_info.forEach(el => {
							that.architecture_node_data.info.push({
								base_info_id: el.base_info_id,
								node_info_id: el.node_info_id,
								info_name: el.info_name,
								info_value: el.info_value
							})
						})
					}
					//設定子節點清單
					that.architecture_node_data.child = [];
					if (resData.child_node_list.length > 0) {
						resData.child_node_list.forEach(el => {
							that.architecture_node_data.child.push({
								child_node_id: el.child_node_id,
								node_name: el.node_name,
								base_name: el.base_name
							})
						})
					}
				} else {
					that.FnNotify(res.data.message, 'error')
				}
			})
			that.$q.loading.hide();
		},
		//獲取節點清單
		async get_node_list() {
			let that = this
			that.$q.loading.show();
			var params = {
				Action: 'get_node_list',
				Datas: {},
			};
			await that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					let resData = res.data.data;

					if (resData.length > 0) {
						that.select_node_options = [];
						resData.forEach(el => {

							that.select_node_options.push({
								label: el.node_name,
								value: el.id
							});
						})
					}

				} else {

				}
			})
			that.$q.loading.hide();
		},
		//獲取節點類型資訊
		get_node_base() {
			let that = this
			var params = {
				Action: 'get_node_base',
				Datas: {},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					let resData = res.data.data;
					//整理節點類型清單
					if (resData.base_type && resData.base_type.length > 0) {
						resData.base_type.map(el => {
							//當節點設定彈窗為新增時、子節點卡控清單不為空時 ， 只顯示卡控清單內的節點選項
							if (that.dialog_power_architecture_node.is_create &&
								that.architecture_node_data.child_ctrl_list.length > 0
							) {
								if (that.architecture_node_data.child_ctrl_list.includes(el.base_id)) {
									that.dialog_power_architecture_node.base_option.type.push({
										label: el.base_name,
										value: el.base_id
									});
								}
							}
							//當不符合上述條件但父節點為空時，則為初始節點建立 節點類型選項為全部
							else if (that.dialog_power_architecture_node.parent_node_id == null) {
								that.dialog_power_architecture_node.base_option.type.push({
									label: el.base_name,
									value: el.base_id
								});
							}
						})
					}
					//整理各節點類型資訊
					if (resData.base_info) {
						that.dialog_power_architecture_node.base_option.info = resData.base_info;
					}
				} else {
					that.FnNotify(res.data.message, 'error')
				}
			})
		},
		//新增、修改節點彈窗 節點資訊顯示控制
		ctrl_node_base_info(base_id) {
			let that = this

			if (that.dialog_power_architecture_node.base_option.info[base_id] != undefined &&
				that.dialog_power_architecture_node.base_option.info[base_id].length > 0) {
				that.dialog_power_architecture_node.info_list = [];
				that.dialog_power_architecture_node.base_option.info[base_id].forEach(el => {
					let temp_info_value = null,
						temp_node_info_id = null;
					//當操作不為新增時 將各節點資訊設定值設定到顯示上
					if (that.dialog_power_architecture_node.is_create == false) {
						that.architecture_node_data.info.forEach((el_2) => {
							if (el_2.base_info_id == el.base_info_id) {
								temp_info_value = el_2.info_value;
								temp_node_info_id = el_2.node_info_id;
							}
						})
					}
					that.dialog_power_architecture_node.info_list.push({
						node_info_id: temp_node_info_id, //節點資訊表主鍵
						base_info_id: el.base_info_id, //節點類型資訊表主鍵
						label: el.info_name, //節點類型資訊名稱
						value: temp_info_value //節點數值
					});
				})
			}
		},
		//開啟新增、修改節點彈窗
		async open_node_dialog(set_node_id = null) {
			let that = this
			that.$q.loading.show();
			//當設定節點ID不為空時 則為修改
			if (set_node_id != null) {
				//先撈取節點類型基礎清單
				await this.get_node_base();
				this.dialog_power_architecture_node.is_create = false;
				this.dialog_power_architecture_node.node_id = set_node_id;
				this.dialog_power_architecture_node.node_type = this.architecture_node_data.node_type;
				this.dialog_power_architecture_node.node_name = this.architecture_node_data.node_name;
				//設定節點資訊
				this.ctrl_node_base_info(this.architecture_node_data.node_type);
			} else {
				//當選中節點不為空時 則設定父節點
				if (this.architecture_node_data.node_select != null) {
					this.dialog_power_architecture_node.parent_node_id = this.architecture_node_data.node_select;
				}
				//先撈取節點類型基礎清單
				await this.get_node_base();
			}
			//開啟彈窗
			this.dialog_power_architecture_node.show = true
			that.$q.loading.hide();
		},
		//關閉新增、修改節點彈窗
		close_node_dialog() {
			var that = this;
			that.$data.dialog_power_architecture_node = that.$options.data().dialog_power_architecture_node;
		},
		//節點資訊儲存
		async save_node_info() {
			let that = this
			that.$q.loading.show();
			var params = {
				Action: 'save_node_info',
				Datas: {
					parent_node_id: that.dialog_power_architecture_node.parent_node_id,
					node_id: that.dialog_power_architecture_node.node_id,
					node_name: that.dialog_power_architecture_node.node_name,
					node_type: that.dialog_power_architecture_node.node_type,
					info_list: that.dialog_power_architecture_node.info_list,
				},
			};
			await that.FnWebAPIPost(params).then((res) => {
				if (res.data.result) {
					that.FnNotify('儲存成功', 'success')
					//關閉彈窗
					that.close_node_dialog();
					//節點清單更新
					that.get_node_list();
					//節點樹狀更新
					that.get_node_tree();
					//重新撈取頁面資料
					if (that.architecture_node_data.node_select != null) {
						that.get_node_table_data(that.architecture_node_data.node_select)
					}
				} else {
					that.FnNotify(res.data.message, 'error')
				}
			})
			that.$q.loading.hide();
		},
		//刪除子節點
		async delete_child_node(child_node) {
			let that = this;
			// await this.$q
			// 	.dialog({
			// 		title: "是否刪除節點！？",
			// 		message: `此操作將會刪除 (${child_node.node_name}) 此節點，以及該節點所包含的所有子節點`,
			// 		color: "primary",
			// 		ok: true,
			// 		cancel: true,
			// 	})
			// 	.then(() => {
			if (
				await that.FnConfirm2("是否刪除節點？")
			) {
				that.$q.loading.show();
				var params = {
					Action: 'delete_node',
					Datas: {
						node_id: child_node.child_node_id
					},
				};
				return that.FnWebAPIPost(params).then((res) => {
					if (res.data.result) {
						that.FnNotify('刪除成功', 'success')
						//節點清單更新
						that.get_node_list();
						//節點樹狀更新
						that.get_node_tree();
						//重新撈取頁面資料							
						that.get_node_table_data(that.architecture_node_data.node_select)

					} else {
						that.FnNotify(res.data.message, 'error')
					}
				})
			}
			// })
			// .catch(() => {
			// });

			that.$q.loading.hide();
		}

	},
};
