var page_function = {
	components: {
		"multi-yaxis-chart": httpVueLoader("components/layout/multi_yaxis_chart.vue"),
	},
	data() {
		return {
			VarMenuPage: "trend",
			VarMenu: "area",
			VarPageContainerCss: "",

			tab: "trend",

			//  查詢條件
			search: {
				trend: {
					start_at: new Date(new Date().setDate(new Date().getDate() - 7)),
					end_at: new Date(),
					device: [],
					item: [], //選項複選用 資料範例 ['VLL_avg', 'VLN_avg', 'I_avg']
					item_single: "KWH", //選項單選用
				},
				bar: {
					data_type: "hour",
					meter_group: "1F",
					meter_group_item: [],
					time1: moment().format('YYYY-MM-DD'),
					time2: moment().format('YYYY-MM-DD'),
				},
				pie: {
					start_time: moment().subtract(7, 'days').format("YYYY-MM-DD HH:mm"),
					end_time: moment().format("YYYY-MM-DD HH:mm"),
					pie_type: "single",
					meter_group_item: [],
					meter_group: "1F",
				},

			},
			//  機台下拉選項
			deviceOptions: [],
			//  Y 軸分組的 key / value
			yAxisGroup: {
				'mwh': 'MWh',
				'kwh': 'KWh',
				'kw': 'kW',
				'mw': 'MW',
				'v': 'V',
				'a': 'A',
				'kvar': 'kVAr',
				'kva': 'kVA',
				'kvarh': 'kVArH',
				'kvah': 'kVAH',
				'pf': 'PF',
				'hz': 'Hz',
				'temp': '°C',
				'wm2': 'W/m2',
				'%': '%',
				'ms': 'm/s',
				'kgCO2e': 'kgCO2e'
			},


			"xAxisItemName": "tm", // 要成 xAxis 的資料表欄位名
			"xAxis": [], // 取出資料的X軸(日期或時間)
			"xAxisTemp": {}, // ajax 取得後根據所有資料union後的值,待確認無誤後,才會寫入xAxis
			"series": [], // 繪製 chart 的資料
			"seriesTemp": [], // ajax 取值的暫存值,待確認無誤後,才會寫入series
			"csvName": {
				"filename": null,
			},

			dataTable: {
				columns: [],
				data: [],
			},

			options: {
				data_type: [
					{ label: "月", value: "month" },
					{ label: "日", value: "day" },
					{ label: "時", value: "hour" },
				],
				meter_group: [],
				meter_group_item: {},
				meter_line: [],
				pie_type: [
					{ label: "單一電錶", value: "single" },
					{ label: "群組", value: "group" },
				],
			},
			search_bar: {},
			res_bar: {},

			//現在搜尋的項目
			//為避免computed物件受選項調整影響
			searching: {
				trend: {},
				bar: {},
				pie: {},
			},

			res: {
				trend: {},
				bar: {},
				pie: {},
			},

			date_picker_open: [false, false, false, false, false, false,],

			target: [],

		};
	},

	computed: {
		itemOptions() {
			return [ // 項目的下拉選項
				{ value: 'VLL_RS', y_axis_group: 'v', label: "線電壓_RS" },
				{ value: 'VLL_ST', y_axis_group: 'v', label: "線電壓_ST" },
				{ value: 'VLL_TR', y_axis_group: 'v', label: "線電壓_TR" },
				{ value: 'VLL_avg', y_axis_group: 'v', label: "平均線電壓" },
				{ value: 'VLN_R', y_axis_group: 'v', label: "相電壓_R" },
				{ value: 'VLN_S', y_axis_group: 'v', label: "相電壓_S" },
				{ value: 'VLN_T', y_axis_group: 'v', label: "相電壓_T" },
				{ value: 'VLN_avg', y_axis_group: 'v', label: "平均相電壓" },
				{ value: 'I_R', y_axis_group: 'a', label: "電流_R" },
				{ value: 'I_S', y_axis_group: 'a', label: "電流_S" },
				{ value: 'I_T', y_axis_group: 'a', label: "電流_T" },
				{ value: 'I_avg', y_axis_group: 'a', label: "平均電流" },
				// { value: 'I_tot', y_axis_group: '', label: "" },
				// { value: 'PF_R', y_axis_group: '', label: "" },
				// { value: 'PF_S', y_axis_group: '', label: "" },
				// { value: 'PF_T', y_axis_group: '', label: "" },
				// { value: 'PF_avg', y_axis_group: '', label: "" },
				{ value: 'KW_R', y_axis_group: 'kw', label: "有效功率_R" },
				{ value: 'KW_S', y_axis_group: 'kw', label: "有效功率_S" },
				{ value: 'KW_T', y_axis_group: 'kw', label: "有效功率_T" },
				{ value: 'KW_tot', y_axis_group: 'kw', label: "總有效功率" },
				{ value: 'Kvar_R', y_axis_group: 'kvar', label: "無效功率_R" },
				{ value: 'Kvar_S', y_axis_group: 'kvar', label: "無效功率_S" },
				{ value: 'Kvar_T', y_axis_group: 'kvar', label: "無效功率_T" },
				{ value: 'Kvar_tot', y_axis_group: 'kvar', label: "總無效功率" },
				{ value: 'KVA_R', y_axis_group: 'kva', label: "視在功率_R" },
				{ value: 'KVA_S', y_axis_group: 'kva', label: "視在功率_S" },
				{ value: 'KVA_T', y_axis_group: 'kva', label: "視在功率_T" },
				{ value: 'KVA_tot', y_axis_group: 'kva', label: "總視在功率" },
				{ value: 'Coin', y_axis_group: '%', label: "功率因數" },
				{ value: 'Hz', y_axis_group: 'hz', label: "頻率" },
				{ value: 'CO2', y_axis_group: 'kgCO2e', label: "碳排量" },
				{ value: 'KvarH', y_axis_group: 'kvarh', label: "無效電能" },
				{ value: 'KVAH', y_axis_group: 'kvah', label: "視在電能" },
				{ value: 'KWH', y_axis_group: 'kwh', label: "有效電能" },
			]
		},

		itemOptionsMap() {
			return _.reduce(this.itemOptions, (obj, val) => {
				obj[val['value']] = val['label'];
				return obj;
			}, {});
		},
		deviceOptionsMap() {
			return _.reduce(this.deviceOptions, (obj, val) => {
				obj[val['value']] = val['label'];
				return obj;
			}, {});
		},

		Trendbar() {
			var time1 = "";
			var time2 = "";

			var temp_x = [];
			var temp_1 = [];
			var temp_2 = [];

			if (Object.keys(this.res.bar).length) {
				time1 = "時段1:" + this.searching.bar.time1;
				time2 = "時段2:" + this.searching.bar.time2;
				var check =
					Object.keys(this.res.bar.data_1).length -
					Object.keys(this.res.bar.data_2).length;

				_.each(this.res.bar.data_1, (v, k) => {
					if (check >= 0) {
						temp_x.push(v.label);
					}
					temp_1.push(v.value);
				});
				_.each(this.res.bar.data_2, (v, k) => {
					if (check < 0) {
						temp_x.push(v.label);
					}
					temp_2.push(v.value);
				});
			}


			let temp = {
				tooltip: {
					trigger: "axis",
					axisPointer: {
						type: "cross",
					},
					formatter: function (item) {
						// let str = `
						// 			${item[0].seriesName} : ${item[0].value} (kwh)
						// 			<br>
						// 			${item[1].seriesName} : ${item[1].value} (kwh)
						// 			`;
						// return str;
						if (!item || item.length === 0) return ""; // 如果沒有資料，返回空字串

						let str = "";
						for (let i = 0; i < item.length; i++) {
							str += `${item[i].seriesName} : ${item[i].value} (kwh)<br>`;
						}
						return str;
					},
				},
				toolbox: {
					show: true,
					feature: {
						magicType: { show: true, type: ["line", "bar"] },
						saveAsImage: {}
					},

				},
				grid: {
					show: true,
					left: "1%",
					right: "1%",
					bottom: "3%",
					containLabel: true,
				},

				legend: {
					data: [time1, time2],
				},
				xAxis: [
					{
						type: "category",
						axisTick: {
							alignWithLabel: true,
						},
						// prettier-ignore
						data: temp_x,
					},
				],
				yAxis: [
					{
						type: "value",
						position: "left",
						alignTicks: true,
						axisLine: {
							show: true,
							lineStyle: {
								color: "black",
							},
						},
						axisLabel: {
							formatter: "{value} KWH",
						},
					},
				],
				series: [
					{
						name: time1,
						type: "bar",
						data: temp_1,
					},
					{
						name: time2,
						type: "bar",
						data: temp_2,
					},
				],
			};
			return temp;
		},
		Trendpie() {
			var temp_s = [];
			if (Object.keys(this.res.pie).length) {
				_.each(this.res.pie, (v, k) => {
					let name = null;
					if (this.searching.pie.pie_type == "group") {
						name = _.find(this.target, { value: v.item_name });
					}
					if (this.searching.pie.pie_type == "single") {
						name = _.find(this.options.meter_line, {
							value: v.item_name,
						});
					}
					if (name) {
						temp_s.push({ value: v.total_KWH, name: name.label });
					}
				});
			}


			let temp = {
				title: {
					text: "指定電錶用電比較",
					left: "start",
					textStyle: {
						fontSize: 18, // 調整標題字體大小
						fontWeight: 'bold'
					}
				},
				tooltip: {
					trigger: "item",
					formatter: "{a} <br/>{b} : {c} ({d}%)",
					textStyle: {
						fontSize: 14 // 調整提示字體大小
					}
				},
				legend: {
					type: "scroll",
					orient: "vertical",
					right: 470,
					top: 120,
					bottom: 10,
					textStyle: {
						fontSize: 18 // 調整圖例字體大小
					}
				},
				series: [
					{
						name: "用電量",
						type: "pie",
						radius: "88%",
						data: temp_s,
						emphasis: {
							itemStyle: {
								shadowBlur: 10,
								shadowOffsetX: 0,
								shadowColor: "rgba(0, 0, 0, 0.5)",
							},
						},
					},
				],
			};
			return temp;
		}
	},
	created() {
		this.loadOptions();
	},

	watch: {},

	mounted() {
		this.$set(this.WebSetup, "caption", "趨勢圖");
		this.MenuSetup.opened = false;
		this.VarMenuIsOverlay = true;
		this.loadSession();
		// if (this.tab == 'trend') {
		// 	this.singel_item_ctrl(this.search.trend.item_single)
		// };
		// this.loadDeviceOptions().then( // 取得 設備 下拉選項
		// 	this.getData() // 取得資料
		// );
		// if (this.tab == 'trend') {
		this.singel_item_ctrl(this.search.trend.item_single);
		// };
		this.getData_switch();
	},

	methods: {
		changeTab(_tab) {
			this.$set(this, 'tab', _tab);
		},
		getData_switch() {
			if (this.is_session) {
				// this.loadDeviceOptions().then( // 取得 設備 下拉選項
				// 	this.getData()// 取得資料
				// );
				this.loadbar();
				this.loadpie();
			} else {
				this.loadDeviceOptions();
				switch (this.tab) {
					case 'trend':
						// this.loadDeviceOptions().then( // 取得 設備 下拉選項
						// this.getData()// 取得資料
						// );
						this.loadDeviceOptions();
						break;
					case 'bar':
						this.loadbar();
						break;
					case 'pie':
						this.loadpie();
						break;
					default:
						break;
				}
			}
		},

		loadSession() {
			let bar = sessionStorage.getItem("bar");
			if (bar) {
				this.tab = "bar";

				this.search.bar.meter_group = bar;
				let bar2 = sessionStorage.getItem("bar2");
				this.search.bar.meter_group_item = [];
				this.search.bar.meter_group_item.push(bar2);
				setTimeout(function () {
					sessionStorage.removeItem("bar");
					sessionStorage.removeItem("bar2");
				}, 1000);
			}
			let pie = sessionStorage.getItem("pie");
			if (pie) {
				this.tab = "pie";
				this.search.pie.meter_group_item.push(pie);
				console.log(pie);
				setTimeout(function () {
					sessionStorage.removeItem("pie");
				}, 1000);
			}
		},

		//選項初始化
		loadOptions() {
			let that = this;

			var params = {
				Action: "LoadOptions",
				Datas: {},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					let meter_group = [];
					_.each(resData.meter_group, (item) => {
						let target = _.find(meterGroupOptions, { value: item.value });
						if (target) {
							meter_group.push(target);
						}
					})
					this.options.meter_group = meter_group;
					this.options.meter_line = resData.meter_line;
					this.options.meter_group_item = resData.meter_group_item;
					//長條圖日期選項初始化

					// //長條圖電表選項初始化 先判斷是否有選擇電錶(如果有電錶表示為頁面轉跳來的，就不用再預設選項)
					if (this.search.bar.meter_group_item.length == 0) {
						this.options.meter_group_item[
							this.search.bar.meter_group
						].forEach((el) => {
							this.search.bar.meter_group_item.push(el.value);
						});
					}
				} else {
					that.FnNotify("錯誤", "error");
				}
			});
		},

		//  載入各機台下拉選單
		async loadDeviceOptions() {
			let that = this;

			that.$q.loading.show();
			var params = {
				Action: "LoadDeviceOptions",
				Datas: {},
			}
			let sp = new URLSearchParams(window.location.search);
			await this.FnWebAPIGet(params).then((res) => {
				this.deviceOptions = _.map(res.data.data, (item) => {
					return {
						"value": item['ColumnTable'],
						"label": item['ColumnName']
					}
				})
				if (sp.get('ColumnTable') != undefined) {
					this.search.trend.device = [sp.get('ColumnTable')]; // 預選第一筆
				} else {
					let arr = [];
					_.each(this.deviceOptions, (item) => {
						arr.push(item.value);
					})
					this.search.trend.device = arr;
					this.getData();
				}
				that.$q.loading.hide();
				// this.searchData();
			}).catch(function (err) {
				that.$q.loading.hide();
				console.log(err);
			});
		},

		getData() {
			this.$set(this.csvName, "filename", "電力趨勢圖");
			let begDate = moment(this.search.trend.start_at).startOf('day').format("YYYY-MM-DD HH:mm:ss");
			let endDate = moment(this.search.trend.end_at).endOf('day').format("YYYY-MM-DD HH:mm:ss");
			let pList = _.map(this.search.trend.device, (val) => {
				return this.getAjaxData(begDate, endDate, val);
			});
			// 將各個設備拆成多個AJAX,再到前端來整理成series
			Promise.all(pList).then((resList) => {
				this.xAxisTemp = {};
				this.seriesTemp = [];
				let isOk = false;
				_.each(resList, (res, idx) => {
					if (res.data.result) {
						var resData = res.data.data;
						this.pushSeriesTemp(resData, idx);
						isOk = true; // 只要有值則會寫入xAxis & series
					} else {
						that.FnNotify(res.data.message, "error");
					}
				});

				if (isOk) { // 確認無誤後,才會寫入xAxis & series
					this.xAxis = _.sortBy(_.keys(this.xAxisTemp));
					this.series = this.seriesTemp;
				}
			}).catch((err) => {
				this.FnNotify(err, "error");
			})
		},

		getAjaxData(begDate, endDate, stn) { // 抓取資料
			let that = this;
			var params = {
				Action: 'Data',
				Datas: { 'beg_date': begDate, 'end_date': endDate, 'db_name': stn },
			};
			return that.FnWebAPIGet(params);
		},

		pushSeriesTemp(list, idx) { // 將取得的資料整理成series的每一個項目
			let resultMap = {};
			let deviceKey = this.search.trend['device'][idx];
			let deviceName = this.deviceOptionsMap[deviceKey];

			_.each(list, (row) => {
				let xAxisKey = row[this.xAxisItemName];
				this.xAxisTemp[xAxisKey] = true;
				_.each(this.search.trend['item'], (itemKey) => {
					let itemName = this.itemOptionsMap[itemKey];
					let seriesName = itemName + " (" + deviceName + ")";
					let mapKey = deviceKey + "_" + itemKey;
					if (_.isUndefined(resultMap[mapKey])) {
						resultMap[mapKey] = { "name": seriesName, "select_value": itemKey, "data": [] };
					}
					resultMap[mapKey]["data"].push([xAxisKey, this.FnRoundToDecimal(row[itemKey])]);
				});
			});
			_.each(resultMap, (row, key) => {
				this.seriesTemp.push(row);
			});
		},

		searchOk() {
			// this.getData();
		},

		//長條圖廠區電表控制項
		bar_meter_option_ctrl(type) {
			this.search.bar.meter_group_item = [];
			if (type == "bar") {
				let arr = this.options.meter_group_item[this.search.bar.meter_group];
				arr.forEach((el) => {
					if (arr.length == 1 || el.IsTotal != '1') {
						this.search.bar.meter_group_item.push(el.value);
					}
				});
				//長條圖時間切換 刷新日期預設值
				let time1 = this.search.bar.time1;
				let time2 = this.search.bar.time2;
				switch (this.search.bar.data_type) {
					case 'hour':
						this.search.bar.time1 = moment(time1).format('YYYY-MM-DD');
						this.search.bar.time2 = moment(time2).format('YYYY-MM-DD');
						break;
					case 'day':
						this.search.bar.time1 = moment(time1).format('YYYY-MM');
						this.search.bar.time2 = moment(time2).format('YYYY-MM');
						break;
					case 'month':
						this.search.bar.time1 = moment(time1).format('YYYY');
						this.search.bar.time2 = moment(time2).format('YYYY');
						break;
					default:
						break;
				}
			};
		},

		loadbar() {
			let that = this;
			let item_bar = [];
			that.search.bar.meter_group_item.forEach((el) => {
				item_bar.push(el);
			});
			var s_date_1 = "",
				s_date_2 = "";
			switch (this.search.bar.data_type) {
				case "hour":
					s_date_1 = this.search.bar.time1;
					s_date_2 = this.search.bar.time2;
					break;
				case "day":
					s_date_1 = `${this.search.bar.time1}-01`;
					s_date_2 = `${this.search.bar.time2}-01`;
					break;
				case "month":
					s_date_1 = `${this.search.bar.time1}-01-01`;
					s_date_2 = `${this.search.bar.time2}-01-01`;
					break;
				default:
					s_date_1 = this.search.bar.time1;
					s_date_2 = this.search.bar.time2;
					break;
			}
			var params = {
				Action: "bar_data",
				Datas: {
					date_1: s_date_1,
					date_2: s_date_2,
					item_1: item_bar, //日期1的電表資料表清單陣列
					item_2: item_bar, //日期2的電表資料表清單陣列
					data_type: this.search.bar.data_type, //資料類型 共三種 hour day month
				},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					this.searching.bar = _.cloneDeep(this.search.bar);
					this.res.bar = resData;


				} else {
					that.FnNotify("錯誤", "error");
				}
			});
		},
		loadpie() {
			let that = this;
			let item = [];

			let all_check = this.search.pie.pie_type == 'group' && this.search.pie.meter_group == '全廠' ? true : false;

			this.target = meterAreaOptions[this.search.pie.meter_group];
			if (this.search.pie.pie_type == "group") {
				_.each(this.target, (v, k) => {
					item.push(v.value);
				});
				// if (all_check) {
				// 	item = [
				// 		'ACM1',
				// 		'ACM2',
				// 		'ACM3',
				// 		'ACM4',
				// 		'ACM5',
				// 		'ACM6',
				// 		'ACM7',
				// 		'ACM8',
				// 		'ACM9',
				// 		'ACM10',
				// 		'ACM11',
				// 		'ACM12',
				// 		'ACM13',
				// 		'ACM14',
				// 		'ACM15',
				// 	]
				// }
			}

			if (this.search.pie.pie_type == "single") {
				item = _.cloneDeep(this.search.pie.meter_group_item);
			}

			var params = {
				Action: "pie_data",
				Datas: {
					start_at: this.search.pie.start_time,
					end_at: this.search.pie.end_time,
					item: item, //電表資料表清單陣列
				},
			};
			return that.FnWebAPIGet(params).then((res) => {
				if (res.data.result) {
					var resData = res.data.data;
					this.searching.pie = _.cloneDeep(this.search.pie);
					if (all_check) {
						let target = _.findIndex(resData, { item_name: 'ACM15' });

						let num = 0;

						_.each(resData, (v, k) => {
							if (target == k) {
								num += parseInt(v.total_KWH);
							} else {
								num -= parseInt(v.total_KWH);
							}
							console.log(num);
						})
						resData[target].total_KWH = num;
					}

					this.res.pie = resData;


				} else {
					that.FnNotify("錯誤", "error");
				}
			})
		},

		//電力趨勢圖 項目單選控制
		singel_item_ctrl(val) {
			this.search.trend.item = [val];
		},

		downloadMeterExcel() {
			let target_sheet = this.searching.pie.meter_group;
			let tables = meterAreaOptions[target_sheet];
			console.log(tables);
			let temp = {};
			_.each(this.Trendpie.series[0].data, (v, k) => {
				temp[v.name] = v.value;
			});
			this.$q.loading.show();
			this.FnWebAPIDownload(
				{
					Action: "MeterExcel",
					Datas: {
						beg_date: moment(this.searching.pie.start_time).format(
							"YYYY-MM-DD"
						),
						end_date: moment(this.searching.pie.end_time).format(
							"YYYY-MM-DD"
						),
						target_sheet: target_sheet,
						options: this.options.meter_group,
						tables: tables,
						data: temp,
					},
				},
				"電錶用電量.xlsx"
			)
				.then(() => {
					this.downloadConditions.visible = false;
				})
				.finally(() => {
					this.$q.loading.hide();
				});
		},

		handleChange(value, type) {
			if (type === 'minute') {
				this.date_picker_open = _.fill(this.date_picker_open, false);
			}
		},

		trend_select_all() {
			let arr = [];
			_.each(this.deviceOptions, (item) => {
				arr.push(item.value);
			})
			this.search.trend.device = arr;
		},
		trend_select_clear() {
			this.search.trend.device = [];
		},
	},
};
