<!DOCTYPE html>
<html lang="zh-tw">

<head><?php
		include_once "html_head.inc";
		?></head>
<style>
	.device_item {
		font-size: 20px;
		box-shadow: -1px 3px 3px 1px #0000002b;
		font-weight: 600;
		padding: 5px;
		margin: 5px;
		cursor: pointer;
		overflow: hidden;
		border-radius: 5px;
	}

	.device_item:hover {
		background-color: #f7f7f78f;

	}

	.device_item.active {
		background-color: #b2f5ba8f;
	}
</style>

<body>
	<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
		<?php
		include_once "html_layout_header.inc";
		?>

		<div class="container">
			<div class="row">
				<div class="bg-white q-ma-sm">
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 140px;">機台名稱</label>
						</div>
						<q-select v-model="device" hide-underline align="center" :options="device_select_option" style="min-width: 200px;" class="col search-block-input" @input="clear_legend_list()"></q-select>
					</div>
					<div style="height: 300px;">
						<echart ref="trend" class="bg-white fit" :options="chart_gauge" autoresize></echart>
					</div>
					<!-- <div class="row justify-center items-center flex-1 pointer-events-none">
						<q-btn class="" label="異常中" color="negative" size="20px" rounded></q-btn>
					</div> -->
				</div>
				<div class="row items-center col bg-white q-ma-sm">
					<div class="column q-px-sm" style="max-height: 300px;">
						<div v-for="(item,inx) in device_item_list" :class="item_class_ctrl.includes(item.label)?'active':''" class="row items-center justify-between q-mx-sm device_item" @click="add_chart_item($event,item)">
							<div class="row items-center">
								<span>{{item.icon}}</span>
								<span>{{item.label}}</span>
							</div>
							<div class="row items-center">
								<div class="row justify-center text-right bg-grey-2 w3-round-xxlarge q-mx-sm" style="width:100px;">
									<span class="text-blue-4 q-px-sm">{{item.value}}</span>
								</div>
								<span class="q-px-sm" align="right" style="width:80px;">{{item.unit}}</span>
							</div>
						</div>

					</div>
				</div>
			</div>
			<div style="height:650px" class="q-pa-sm">
				<echart ref="trend" class="bg-white fit q-py-sm" :option="chart_line" autoresize></echart>
			</div>
		</div>
	</div>

	<?php
	include_once "html_layout_footer.inc";
	?>
	</div>
	<?php
	include_once "html_loading.inc";
	?>
</body><?php
		$is_report_download = true;
		$is_googlemap = true;
		$is_echarts = true;
		include_once "html_down.inc";
		?>

</html>