<!DOCTYPE html>
<html lang="zh-tw">

<head>
	<?php
	include_once "html_head.inc";
	?>
	<link href="css/components.css" rel="stylesheet" type="text/css">
</head>

<body>
	<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
		<?php
		include_once "html_layout_header.inc";
		?>
		<div style="display: flex;" class="electricity-page">
			<div class="container cal-container">
				<div style="display: none;">
					<iframe :src="DownloadLink"></iframe>
				</div>
				<div style="height:35%;">
					<div class="electricity-border">
						<div class="electricity-block">
							<div class="ele_system_frameone">
								<span class="material-icons">flash_on</span>
								<span class="ele_system_frameone_title">高壓供電</span>
							</div>
							<div class="ele_system_frametwo">
								<span class="material-icons">●</span>
								<span style="width:320px; text-align:start">
									夏月(每瓩)
									<span style="color:#244BC3;">{{ basic.SummerStartMonth['value'] }}月{{ basic.SummerStartDay['value'] }}日至{{ basic.SummerEndMonth['value'] }}月{{ basic.SummerEndDay['value'] }}日</span>
								</span>
								<span class="ele_system_frametwo_value">{{ FnFormatNumber(basic.PerKwSummer['value'],2) }}</span>
								<span class="material-icons">●</span>
								<span class="ele_system_frametwo_title">非夏月</span>
								<span class="ele_system_frametwo_value">{{ FnFormatNumber(basic.PerKwNonSummer['value'],2) }}</span>
								<span class="material-icons">●</span>
								<span class="ele_system_frametwo_title">契約容量</span>
								<span class="ele_system_frametwo_value">{{MQTTPoints[mqtt_electricity_sidebar.electricity1_01] ? MQTTPoints[mqtt_electricity_sidebar.electricity1_01].value : 0}}</span>
								<span class="ele_system_frametwo_unit">瓩</span>
							</div>
						</div>
					</div>
					<search-item :client-width="clientWidth" :conditions="conditions" class="id-btn" search-text="報表輸出" @do_change_subitem="fnQueryChanged" @do_condition_query="fnReportDownload">
						<template slot="buttons">
							<div class="row" style="height:58px;">
								<div class="row">
									<!-- <div>
										<span>電價生效日</span>
									</div>
									<div class="flex-frcc  q-self-block">
										<q-select align="center" v-model="priceVersion.value" :options="priceVersion.options" @input="LoadPageDetail(rangeSection)" class="q-self" hide-underline style="width: 150px;"></q-select>
									</div> -->
									<div class="search-block">
										<div class="search-block-label">
											<label class="text-center" style="width: 120px;">電價生效日</label>
										</div>
										<div class="col search-block-input row items-center">
											<q-select style="width: 200px;" v-model="priceVersion.value" align="center" :options="priceVersion.options" hide-underline @input="LoadPageDetail(rangeSection)"></q-select>
										</div>
									</div>
								</div>
								<div class="row items-center">
									<div class="q-mx-xs">
										<div>
											<q-btn class="id-btn" glossy label="新增電價生效日" @click="newEffective['show'] = true;" color="primary"></q-btn>
										</div>
									</div>
									<div class="q-mx-xs">
										<div>
											<q-btn class="id-btn" glossy label="新增離峰日" @click="peakDay['show'] = true; getYearOptions()" color="blue"></q-btn>
										</div>
									</div>
									<div class="q-mx-xs">
										<div>
											<q-btn class="id-btn" glossy label="刪除電價生效日" @click="deleteEnableDay()" color="red-5"></q-btn>
										</div>
									</div>
								</div>
							</div>
						</template>
					</search-item>
				</div>
				<div class="SwitchPage Switch-btn">
					<div :style="rangeSection == '2' ? {borderBottom:'5px solid #244BC3'}: {paddingBottom:'5px'}">
						<q-btn flat :text-color="rangeSection == '2' ? 'black': 'grey-5'" label="二段式電價" @click="LoadPageDetail('2')" class="tab-btn"></q-btn>
					</div>
					<div :style="rangeSection == '3' ? {borderBottom:'5px solid #244BC3'}: {paddingBottom:'5px'}">
						<q-btn flat :text-color="rangeSection == '3' ? 'black': 'grey-5'" label="三段式電價" @click="LoadPageDetail('3')" class="tab-btn"></q-btn>
					</div>
				</div>
				<div class="w3-row main_table-border">
					<div id="main_table">
						<ve-table style="width:100%" :scroll-width="0" :border-around="false" border-y :columns="tableColumns" :cell-style-option="cellStyleOption" :table-data="tableData">
						</ve-table>
						<div class="row justify-end" style="padding: 10px 0;">
							<ve-pagination :total="totalCount" :page-index="pageIndex" :page-size="pageSize" @on-page-number-change="pageNumberChange" @on-page-size-change="pageSizeChange" />
						</div>
					</div>
				</div>


				<!--編輯電價室窗-->
				<q-modal v-model="priceEdit['show']" no-backdrop-dismiss no-esc-dismiss no-route-dismiss class="m-self">
					<!--標題-->
					<div class="q-pa-md" align="center" style="font-size: 20px; font-weight: 700; width: 100%; ">
						<span>{{ priceEdit['title'] }}</span>
					</div>
					<!--資料區塊-->
					<div class="flex-fcwfsc q-pa-md">
						<div class="flex-frwsbc" v-for="item in  priceEdit['data']" v-if="item['show']">
							<span class="q-pa-sm" style="font-size: 20px; font-weight: 700 ;width: 30%">{{ item['label'] }}</span>
							<div class="q-pa-sm" style="width: 70%">
								<q-input class="q-pa-xs" v-model="item['value']" :disable="item['enable']" :type="item['format_type']" v-if="item['show'] && item['input_format'] == 'input'" style="font-size: 1rem; font-weight: 700" :placeholder="item['placeholder']">
								</q-input>
								<q-datetime class="q-pa-xs" v-model="item['value']" :readonly="item['enable']" :type="item['format_type']" v-if="item['show'] && item['input_format'] == 'datetime'" style="font-size: 1rem; font-weight: 700">
								</q-datetime>
								<q-select class="q-pa-xs" v-model="item['value']" :options="item['options']" :readonly="item['enable']" :type="item['format_type']" v-if="item['show'] && item['input_format'] == 'select'" style="font-size: 1rem; font-weight: 700">
								</q-select>
							</div>
						</div>
					</div>
					<!--按鈕-->
					<div class="flex-frwfsc q-pa-md">
						<q-btn class="id-btn q-mx-md" :label="priceEdit['title'] == '新增電價' ? '新增' : '更新'" glossy color="green" style="width:100px;font-weight:700" @click="priceEdit['title'] == '新增電價' ? insertPrice() : updatePrice()"></q-btn>
						<q-btn class="id-btn q-mx-md" label="取消" glossy color="grey-5" style="width:100px;font-weight:700" @click="closeQWindow()"></q-btn>
					</div>

				</q-modal>

				<!--編輯離峰日室窗-->
				<q-modal v-model="peakDay['show']" no-backdrop-dismiss no-esc-dismiss no-route-dismiss class="m-self">
					<!--標題-->
					<div class="q-pa-md" align="center" style="font-size:20px; font-weight: 700; width: 100%; ">
						<span>{{ peakDay['title'] }}</span>
					</div>
					<div class="q-pa-md flex-frwsbc" style="font-size: 20px; font-weight: 700;width: 100%;">
						<span style="width: 20%;">選擇年份：</span>
						<q-select v-model="peakDay['selectYear']" :options="peakDay['yearOptions']" filter align="right" @input="loadPeakDay()" style="width: 48%;"></q-select>
						<div>
							<q-btn glossy label="新增離峰日" color="secondary" class="id-btn" @click="addPeakDayOptions()"></q-btn>
						</div>
					</div>

					<div class="flex-fcwfsc q-pa-md" style="height: 400px;overflow-y: scroll;overflow-x: clip; border-top: 1px solid #b3b3b3;">
						<div class="flex-frwsbc q-ma-sm shadow-3" v-for="item in peakDay['data']">
							<!--輸入時間-->
							<q-datetime class="q-pa-sm q-ma-sm" v-model="item['date']" type="date" :disable="item['readonly']"></q-datetime>
							<!--輸入-->
							<q-input class="q-pa-sm q-ma-sm" v-model="item['comment']" placeholder="國定假日說明"></q-input>
							<!--刪除-->
							<q-btn class="q-pa-sm q-ma-sm" icon="close" color="negative" size="sm" @click="deletePeakDayOptions(item , peakDay)"></q-btn>
						</div>
					</div>

					<!--按鈕-->
					<div class="flex-frwfsc q-pa-md " style="border-top: 1px solid #b3b3b3;">
						<q-btn class="id-btn q-mx-md" glossy label="更新離峰日" color="green" style="font-weight:700" @click="updatePeakDay()"></q-btn>
						<q-btn class="id-btn q-mx-md" glossy label="取消" color="grey-5" style="width:120px;font-weight:700" @click="closeQWindow()"></q-btn>
					</div>
				</q-modal>

				<!--新價電價本版-->
				<q-modal v-model="newEffective['show']" no-backdrop-dismiss no-esc-dismiss no-route-dismiss :content-css="{minWidth: '30vw'}" class="m-self">
					<!--標題-->
					<div class="q-pa-md" align="center" style="font-size: 20px; font-weight: 700; width: 100%; ">
						<span>{{ newEffective['title'] }}</span>
					</div>
					<!--資料區塊-->
					<div class="flex-fcwfsc q-pa-md">
						<div class="flex-frwsbc">
							<span class="q-pa-sm" style="font-size: 20px; font-weight: 700 ;width: 46%">{{ newEffective['label'] }}</span>
							<div class="q-pa-sm" style="width: 54%">
								<q-datetime class="q-pa-xs" v-model="newEffective['value']" type="date"></q-datetime>
							</div>
						</div>
						<div class="flex-frwsbc" v-for="item in  newBasic" v-if="item['show']">
							<span class="q-pa-sm" style="font-size: 20px; font-weight: 700 ;width: 46%">{{ item['label'] }}</span>
							<div class="q-pa-sm" style="width: 54%">
								<q-input class="q-pa-xs" v-model="item['value']" :disable="item['enable']" :type="item['format_type']" v-if="item['show'] && item['input_format'] == 'input'" style="font-size: 1rem; font-weight: 700" :placeholder="item['placeholder']">
								</q-input>
								<q-datetime class="q-pa-xs" v-model="item['value']" :readonly="item['enable']" :type="item['format_type']" v-if="item['show'] && item['input_format'] == 'datetime'" style="font-size: 1rem; font-weight: 700">
								</q-datetime>
								<q-select class="q-pa-xs" v-model="item['value']" :options="item['options']" :readonly="item['enable']" :type="item['format_type']" v-if="item['show'] && item['input_format'] == 'select'" style="font-size: 1rem; font-weight: 700" @input="getMonthLastDay()">
								</q-select>
							</div>
						</div>
					</div>
					<!--按鈕-->
					<div class="flex-frwfsc q-pa-md">
						<q-btn class="id-btn q-mx-md" label="新增" glossy color="primary" style="width:100px;" @click="addBasic()"></q-btn>
						<q-btn class="id-btn q-mx-md" label="取消" glossy color="grey-5" style="width:100px;" @click="closeQWindow()"></q-btn>
					</div>
				</q-modal>
			</div>
		</div>
	</div>
	<?php
	include_once "html_layout_footer.inc";
	?>
	</div>
	<?php
	include_once "html_loading.inc";
	?>
</body>
<?php
$is_report_download = true;
$is_googlemap = true;
$is_echarts = true;
include_once "html_down.inc";
?>

</html>