<!DOCTYPE html>
<html lang="zh-tw">

<head><?php
		include_once "html_head.inc";
		?></head>

<body>
	<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
		<?php
		include_once "html_layout_header.inc";
		?>

		<div class="container">
			<!-- 分頁切換項目 -->
			<div class="SwitchPage">
				<div :style="tab == 'architecture_tree' ? {borderBottom:'5px solid #244BC3'}: {paddingBottom:'5px'}">
					<q-btn flat :text-color="tab == 'architecture_tree' ? 'black': 'grey-5'" label="電力架構圖" @click="changeTab('architecture_tree')" class="tab-btn"></q-btn>
				</div>
				<div :style="tab == 'architecture_node' ? {borderBottom:'5px solid #244BC3'}: {paddingBottom:'5px'}">
					<q-btn flat :text-color="tab == 'architecture_node' ? 'black': 'grey-5'" label="節點資訊" @click="changeTab('architecture_node')" class="tab-btn"></q-btn>
				</div>
			</div>
			<!-- 電力架構圖 -->
			<div v-show="tab == 'architecture_tree'">
				<div class="column q-my-md bg-white">
					<echart ref="tree_chart" @click="node_tree_click" :option="node_tree_option" autoresize :style="{ width: '100%', height: '700px', borderRadius: '2px' }"></echart>
				</div>
			</div>
			<!-- 節點資訊 -->
			<div v-show="tab == 'architecture_node'">
				<div class="column q-my-md bg-white">
					<div class="q-px-sm">
						<div id="electricity_node_header" class="row justify-between">
							<div class="row col justify-center">
								<div class="header_right_border header_right_block row items-center">
									<div class="row items-center">
										<span class="material-icons">
											grid_view
										</span>
										當前節點：
									</div>
									<div>
										<q-select v-model="architecture_node_data.node_select" align="center" style="min-width:150px" chips-bg-color="#028fd5" placeholder="請選擇節點" hide-underline :options="select_node_options" @input="get_node_table_data($event)" />
									</div>
								</div>
							</div>
							<div class="row items-center justify-center">
								<q-btn v-if="architecture_node_data.node_select" color="primary" class="id-btn q-mx-sm" glossy label="設定節點資訊" @click="open_node_dialog(architecture_node_data.node_select)" /></q-btn>
								<q-btn v-if="btn_add_child_ctrl" color="positive" class="id-btn q-mx-sm" glossy label="新增子節點" @click="open_node_dialog()" /></q-btn>
							</div>
						</div>
						<div class="row justify-around">
							<div class="col-6">
								<div class="row justify-center q-pt-sm">
									<label for="">當前節點資訊</label>
								</div>
								<q-scroll-area class="q-mx-sm custom-dialog-data-group" style="height: 65vh">
									<div v-for="(item,inx) in architecture_node_data.info" class="row items-center justify-between custom-dialog-data">
										<div class="col row items-center ">
											<div class="col-6 row items-center justify-center">
												<label class="" for="">{{item.info_name}}</label>
											</div>
											<q-input readonly class="col-6" v-model="item.info_value" align="center"></q-input>
										</div>
									</div>
								</q-scroll-area>
							</div>
							<div class="col-6">
								<div class="row justify-center q-pt-sm">
									<label for="">子節點清單</label>
								</div>
								<q-scroll-area class="q-mx-sm custom-dialog-data-group" style="height: 65vh">
									<div v-for="(item,inx) in architecture_node_data.child" class="row items-center justify-between custom-dialog-data">
										<div class="col row items-center ">
											<div class="col-10 row item-center justify-around cursor-pointer" @click="get_node_table_data(item.child_node_id)">
												<div class="col-5 row items-center">
													<label class="cursor-pointer">{{item.node_name}}</label>
												</div>
												<div class="col-5 row items-center">
													<label class="cursor-pointer">{{item.base_name}}</label>
												</div>
											</div>
											<div class="col-2 row justify-center">
												<q-btn class="id-btn q-px-md" glossy label="刪除" color="red" @click="delete_child_node(item)"></q-btn>
											</div>

										</div>
									</div>
								</q-scroll-area>
							</div>


							<!-- <q-collapsible class="col-6" group="total" opened header-class="data_group_label" collapse-icon="none">
								<template slot="header">
									<q-item-side right>
										<q-icon name="arrow_drop_down" size="24px" />
									</q-item-side>
									<q-item-main style="font-size: 18px;" label="當前節點資訊" />
								</template>
								<div>
									<div v-for="rows in electricity_meter_data.total" :class="[rows.tooltip ? 'tooltip' : '','electricity_meter_block']" style="display: flex;">
										<div style="background-color: #294CCB; width:5px;">
											<span style="user-select:none;">&nbsp;</span>
										</div>
										<div class="block_title row items-center" style="width: 32%;">
											<div :class="['row','col-6','items-center','justify-center']">
												<span class="block_title_label">{{ rows.name }}
													<q-tooltip v-if="rows.tooltip" anchor="bottom middle" self="top left" :offset="[10, 10]">
														{{rows.tooltip}}
													</q-tooltip>
												</span>
											</div>
											<div class="row col-2 items-center justify-center ">
												<div :style="{backgroundColor:fnStatus(rows.table).color,color:'white',padding:'0 3px',borderRadius:'3px'}">
													<span style="margin: 0 2px;">{{fnStatus(rows.table).label}}</span>
												</div>
											</div>
											<div class="row col-4  items-center justify-around">
												<span class="material-icons cursor-pointer" style="color:#3D6ED7; background-color:#FFF;" @click="fnPageBar(rows.table)">
													equalizer
												</span>
												<span class="material-icons cursor-pointer" style="color:#3D6ED7; background-color:#FFF;" @click="fnPagePie(rows.table)">
													donut_small
												</span>
												<span class="material-icons cursor-pointer" style="color:#3D6ED7; background-color:#FFF;" @click="fnPageMeter(rows.table)">
													table_chart
												</span>
											</div>
										</div>
										<div class="block_body row items-center " style="width: 66%;">
											<div class="row col-4 items-center justify-around">
												<div class="items-center" style="display: flex; align-items:center">
													<div class="e-dot"></div>
													<div>
														今日用電
													</div>
												</div>
												<div class="row items-center" style="color: #3D6ED7;">
													<span>{{fnSoft(rows.soft_tag.day)}}</span>
													<span style="width:20px; text-align:right; margin: 0px 5px; color:#000;">度</span>
												</div>
											</div>
											<div class="row col-4 items-center justify-around">
												<div class="items-center" style="display: flex; align-items:center">
													<div class="e-dot"></div>
													<div>
														本月用電
													</div>
												</div>
												<div class="row items-center" style="color: #3D6ED7;">
													<span>{{fnSoft(rows.soft_tag.month)}}</span>
													<span style="width:20px; text-align:right; margin: 0px 5px; color:#000;">度</span>
												</div>
											</div>
											<div class="row col-4 items-center justify-around">
												<div class="row items-center">
													<div class="e-dot"></div>
													<div>
														即時功率
													</div>

												</div>
												<div class="row items-center" style="color: #3D6ED7;">
													<span>{{fnSoft(rows.soft_tag.now)}}</span>
													<span style="width:20px; text-align:right; margin: 0px 5px; color:#000;">kw</span>
												</div>
											</div>
										</div>
									</div>
								</div>
							</q-collapsible>
							<q-collapsible class="col-6" group="single" opened header-class="data_group_label" collapse-icon="none">
								<template slot="header">
									<q-item-side right>
										<q-icon name="arrow_drop_down" size="24px" />
									</q-item-side>
									<q-item-main style="font-size: 18px;" label="子節點資訊" />
								</template>
								<div>
									<div v-for="rows in electricity_meter_data.single" class="electricity_meter_block" style="display: flex;">
										<div style="background-color: #294CCB; width:5px;">
											<span style="user-select:none;">&nbsp;</span>
										</div>
										<div class="block_title row items-center" style="width: 32%;">
											<div class="row col-6 items-center justify-center ">
												<span class="block_title_label">{{rows.name}}
													<q-tooltip v-if="rows.tooltip" anchor="bottom middle" self="top left" :offset="[10, 10]">
														{{rows.tooltip}}
													</q-tooltip>
												</span>
											</div>
											<div class="row col-2 items-center justify-center ">
												<div :style="{backgroundColor:fnStatus(rows.table).color,color:'white',padding:'0 3px',borderRadius:'3px'}">
													<span style="margin: 0 2px;">{{fnStatus(rows.table).label}}</span>
												</div>
											</div>
											<div class="row col-4  items-center justify-around">
												<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageBar(rows.table)">
													equalizer
												</span>
												<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPagePie(rows.table)">
													donut_small
												</span>
												<span class="material-icons" style="cursor:pointer; z-index:1; color:#3D6ED7; background-color:#FFF;" @click="fnPageMeter(rows.table)">
													table_chart
												</span>
											</div>
										</div>
										<div class="block_body row items-center " style="width: 66%;">
											<div class="row col-4 items-center justify-around">
												<div class="items-center" style="display: flex; align-items:center">
													<div class="e-dot"></div>
													<div>
														今日用電
													</div>
												</div>
												<div class="row items-center" style="color: #3D6ED7;">
													<span>{{fnSoft(rows.soft_tag.day)}}</span>
													<span style="width:20px; text-align:right; margin: 0px 5px; color:#000;">度</span>
												</div>
											</div>
											<div class="row col-4 items-center justify-around">
												<div class="items-center" style="display: flex; align-items:center">
													<div class="e-dot"></div>
													<div>
														本月用電
													</div>
												</div>
												<div class="row items-center" style="color: #3D6ED7;">
													<span>{{fnSoft(rows.soft_tag.month)}}</span>
													<span style="width:20px; text-align:right; margin: 0px 5px; color:#000;">度</span>
												</div>
											</div>
											<div class="row col-4 items-center justify-around">
												<div class="row items-center">
													<div class="e-dot"></div>
													<div>
														即時功率
													</div>

												</div>
												<div class="row items-center" style="color: #3D6ED7;">
													<span>{{fnSoft(rows.soft_tag.now)}}</span>
													<span style="width:20px; text-align:right; margin: 0px 5px; color:#000;">kw</span>
												</div>
											</div>
										</div>
									</div>
								</div>
							</q-collapsible> -->
						</div>
					</div>
				</div>
			</div>

			<!-- 節點新增、修改彈窗 -->
			<template>
				<q-modal v-model="dialog_power_architecture_node.show" minimized no-route-dismiss no-esc-dismiss no-backdrop-dismiss style="z-index:2000" :content-css="{minWidth: '40vw', maxheight: '80vh'}">
					<q-modal-layout class="custom-modal column" footer-style="box-shadow: 0px 10px 20px 0px #878787;">
						<!-- header -->
						<div class="bg-primary text-white modal-title" slot="header">
							<div class="row">
								<div class="row col items-center justify-center" style="padding: 10px 10px 10px 8%;">
									<span v-if="dialog_power_architecture_node.is_create"> 新增節點 </span>
									<span v-else> 修改節點 </span>
								</div>
								<div class="row items-center">
									<span class="material-icons dialog-close" style="padding: 0px 10px; cursor:pointer" @click="close_node_dialog()">close</span>
								</div>
							</div>
						</div>
						<!-- footer -->
						<div class="row justify-end" style="margin: 10px;" slot="footer">
							<q-btn color="light" glossy label="取消" class="id-btn" style="margin:0px 10px" @click="close_node_dialog()"></q-btn>
							<q-btn color="green" glossy label="儲存" class="id-btn" style="margin:0px 10px" @click="save_node_info()"></q-btn>
						</div>
						<!-- content -->
						<div class="column items-center">
							<div class="row justify-around" style="margin: 10px 0px; width:100%">
								<div class="row items-center">
									<label for="">節點名稱：</label>
									<q-input style="width: 200px;" v-model="dialog_power_architecture_node.node_name" class="col" align="center" clearable></q-input>
								</div>
								<div class="row items-center">
									<label for="">節點類型：</label>
									<div v-if="dialog_power_architecture_node.is_create==false">
										<q-input style="width: 200px;" v-model="architecture_node_data.node_type_name" class="col" align="center" readonly></q-input>
									</div>
									<div v-else>
										<q-select style="width: 200px;" class="col " placeholder="請選擇" v-model="dialog_power_architecture_node.node_type" align="center" :options="dialog_power_architecture_node.base_option.type" @input="ctrl_node_base_info($event)" clearable></q-select>
									</div>
								</div>
							</div>
							<div class="column" style="margin: 10px; width:80%">
								<div style="padding:10px 0;  width: 100%;">
									<label class="text-grey-4" for="">節點資訊</label>
									<q-scroll-area class="custom-dialog-data-group" style="height: 300px;">
										<div v-for="(item,inx) in dialog_power_architecture_node.info_list" class="row items-center justify-between custom-dialog-data">
											<div class="col row items-center ">
												<div class="col-6 row items-center justify-center">
													<label class="" for="">{{item.label}}</label>
												</div>
												<q-input class="col-6" v-model="item.value" clearable placeholder="請輸入" align="center"></q-input>
											</div>
										</div>
									</q-scroll-area>
								</div>
							</div>
						</div>
					</q-modal-layout>

				</q-modal>
			</template>
		</div>
	</div>

	<?php
	include_once "html_layout_footer.inc";
	?>
	</div>
	<?php
	include_once "html_loading.inc";
	?>
</body><?php
		$is_report_download = true;
		$is_googlemap = true;
		$is_echarts = true;
		include_once "html_down.inc";
		?>

</html>