<!DOCTYPE html>
<html lang="zh-tw">

<head><?php
		include_once "html_head.inc";
		?></head>

<body>
	<div id="q-app" :visible="IsVueReady==true" @mousemove="FnIdleReset">
		<?php
		include_once "html_layout_header.inc";
		?>

		<div class="container">
			<div class="SwitchPage">
				<div :style="tab == 'trend' ? {borderBottom:'5px solid #244BC3'}: {paddingBottom:'5px'}">
					<q-btn flat :text-color="tab == 'trend' ? 'black': 'grey-5'" label="趨勢圖" @click="changeTab('trend')" class="tab-btn"></q-btn>
				</div>
				<div :style="tab == 'bar' ? {borderBottom:'5px solid #244BC3'}: {paddingBottom:'5px'}">
					<q-btn flat :text-color="tab == 'bar' ? 'black': 'grey-5'" label="長條圖" @click="changeTab('bar')" class="tab-btn"></q-btn>
				</div>
				<div :style="tab == 'pie' ? {borderBottom:'5px solid #244BC3'}: {paddingBottom:'5px'}">
					<q-btn flat :text-color="tab == 'pie' ? 'black': 'grey-5'" label="圓餅圖" @click="changeTab('pie')" class="tab-btn"></q-btn>
				</div>
			</div>
			<div v-show="tab == 'trend'">
				<div class="row">
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 140px;">開始日期(起)</label>
						</div>
						<date-picker style="width: 200px;" class="col search-block-input" v-model="search.trend.start_at" format="YYYY-MM-DD" type="date"></date-picker>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 140px;">開始日期(迄)</label>
						</div>
						<date-picker style="width: 200px;" class="col search-block-input" v-model="search.trend.end_at" format="YYYY-MM-DD" type="date"></date-picker>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 140px;">設備</label>
						</div>
						<q-select style="width: 220px;" class="col search-block-input" align="center" v-model="search.trend.device" :display-value="`已選 ${search.trend.device.length} 設備`" :options="deviceOptions" multiple></q-select>
					</div>
					<div class="row items-center">
						<q-btn v-if="search.trend.device.length == 0" color="primary" class="id-btn" style="margin:10px;" glossy label="全部選擇" @click="trend_select_all()" /></q-btn>
						<q-btn v-else color="red" class="id-btn" style="margin:10px;" glossy label="取消選擇" @click="trend_select_clear()" /></q-btn>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 140px;">項目</label>
						</div>
						<q-select style="width: 220px;" class="col search-block-input" align="center" v-model="search.trend.item_single" :options="itemOptions" @input="singel_item_ctrl($event)"></q-select>
					</div>
					<div class="row items-center">
						<q-btn color="primary" class="id-btn" style="margin:10px;" glossy label="查詢" @click="getData()" /></q-btn>
					</div>
				</div>
				<div class="column q-my-md">
					<multi-yaxis-chart :show-search-btn="false" :show-search-panel="false" :show-download-btn="false" title="電力趨勢圖" :x-axis="xAxis" x-axis-col-name="日期" :y-axis-group="yAxisGroup" :y-axis-select-options="itemOptions" :y-axis-selected="search.trend.item" :series="series" @search-ok="searchOk"></multi-yaxis-chart>
				</div>
			</div>
			<div v-show="tab == 'bar'">
				<div class="row">
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 70px;">時間</label>
						</div>
						<q-select style="width: 70px;" class="col search-block-input" align="center" v-model="search.bar.data_type" :options="options.data_type" @input="bar_meter_option_ctrl(tab)"></q-select>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 70px;">裝置</label>
						</div>
						<q-select style="width: 220px;" class="col search-block-input" align="center" v-model="search.bar.meter_group" :options="options.meter_group" @input="bar_meter_option_ctrl(tab)"></q-select>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 70px;">電錶</label>
						</div>
						<q-select style="width: 220px;" class="col search-block-input" align="center" v-model="search.bar.meter_group_item" :display-value="`已選 ${search.bar.meter_group_item.length} 項目`" :options="options['meter_group_item'][`${search.bar.meter_group}`]? options['meter_group_item'][`${search.bar.meter_group}`]:[]" multiple></q-select>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 70px;">日期1</label>
						</div>
						<date-picker v-show="search.bar.data_type =='hour'" style="width: 200px;" class="col search-block-input" v-model="search.bar.time1" value-type="format" type="date"></date-picker>
						<date-picker v-show="search.bar.data_type =='day'" style="width: 200px;" class="col search-block-input" v-model="search.bar.time1" value-type="format" type="month"></date-picker>
						<date-picker v-show="search.bar.data_type =='month'" style="width: 200px;" class="col search-block-input" v-model="search.bar.time1" value-type="format" type="year"></date-picker>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 70px;">日期2</label>
						</div>
						<date-picker v-show="search.bar.data_type =='hour'" style="width: 200px;" class="col search-block-input" v-model="search.bar.time2" value-type="format" type="date"></date-picker>
						<date-picker v-show="search.bar.data_type =='day'" style="width: 200px;" class="col search-block-input" v-model="search.bar.time2" value-type="format" type="month"></date-picker>
						<date-picker v-show="search.bar.data_type =='month'" style="width: 200px;" class="col search-block-input" v-model="search.bar.time2" value-type="format" type="year"></date-picker>
					</div>

					<div class="row items-center">
						<q-btn color="primary" class="id-btn" style="margin:10px;" glossy label="查詢" @click="loadbar()" /></q-btn>
						<!-- <q-btn color="light" class="id-btn" style="margin:10px;" glossy label="清除" @click="refresh()" /></q-btn>
						<q-btn color="secondary" class="id-btn" style="margin:10px;" glossy label="匯出" @click="exportData()"></q-btn> -->
					</div>
				</div>
				<div class="column q-my-md">
					<echart ref="bar" :option="Trendbar" :style="{ width: '100%', height: '700px', borderRadius: '2px' }" autoresize></echart>
				</div>
			</div>
			<div v-show="tab == 'pie'">
				<div class="row">
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 100px;">開始時間</label>
						</div>
						<date-picker style="width: 250px;" v-model="search.pie.start_time" value-type="format" format="YYYY-MM-DD HH:mm" type="datetime" class="col search-block-input" @change="handleChange" :open.sync="date_picker_open[0]"></date-picker>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 100px;">結束時間</label>
						</div>
						<date-picker style="width: 250px;" v-model="search.pie.end_time" value-type="format" format="YYYY-MM-DD HH:mm" type="datetime" class="col search-block-input" @change="handleChange" :open.sync="date_picker_open[1]"></date-picker>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 70px;">模式</label>
						</div>
						<q-select style="width: 150px;" v-model="search.pie.pie_type" hide-underline align="center" :options="options.pie_type" style="width: 150px;" class="col search-block-input"></q-select>
					</div>
					<div class="search-block">
						<div class="search-block-label">
							<label class="text-center" style="width: 70px;">電錶</label>
						</div>
						<!-- <q-select style="width: 250px;" v-model="search.pie.pie_type" hide-underline align="center" :options="options.pie_type" style="width: 150px;" class="col search-block-input"></q-select> -->
						<q-select v-if="search.pie.pie_type == 'group'" v-model="search.pie.meter_group" hide-underline align="center" class="col search-block-input" style="width: 200px;" :options="options.meter_group"></q-select>
						<q-select v-if="search.pie.pie_type == 'single'" :display-value="`選取 ${search.pie.meter_group_item.length} 電錶`" multiple v-model="search.pie.meter_group_item" hide-underline align="center" class="col search-block-input" style="width: 200px;" :options="options.meter_line"></q-select>
					</div>

					<div class="row items-center">
						<q-btn color="primary" class="id-btn" style="margin:10px;" glossy label="查詢" @click="loadpie()" /></q-btn>
						<!-- <q-btn color="light" class="id-btn" style="margin:10px;" glossy label="清除" @click="refresh()" /></q-btn> -->
						<!-- 有搜尋群組後才顯示匯出 -->
						<q-btn v-if="searching.pie.pie_type == 'group'" color="secondary" class="id-btn" style="margin:10px;" glossy label="匯出" @click="downloadMeterExcel()"></q-btn>
					</div>
				</div>
				<div class="column q-my-md">
					<echart ref="bar" :option="Trendpie" :style="{ width: '100%', height: '700px', borderRadius: '2px' }" autoresize></echart>
				</div>
			</div>
		</div>
	</div>

	<?php
	include_once "html_layout_footer.inc";
	?>
	</div>
	<?php
	include_once "html_loading.inc";
	?>
</body><?php
		$is_report_download = true;
		$is_googlemap = true;
		$is_echarts = true;
		include_once "html_down.inc";
		?>

</html>